/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.service.action;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.response.balance.BalanceDetailRespDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.response.balance.GiftConfigBaseRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.GiftInfoRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.TradeItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.biz.service.action.ActionContext;
import com.dtyunxi.yundt.cube.center.trade.biz.service.action.GiftAction;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAction
implements GiftAction<ActionContext> {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractAction.class);

    @Override
    public boolean judge(ActionContext actionContext) {
        return true;
    }

    @Override
    public void doAction(ActionContext actionContext) {
        LOGGER.info("\u6a21\u677f\u57fa\u7840" + JSON.toJSONString(actionContext.contextMap));
        LOGGER.info("\u6a21\u677f\u57fa\u7840\u7b56\u7565" + this.getClass().getSimpleName() + JSON.toJSONString((Object)actionContext));
        if (this.judge(actionContext)) {
            this.start(actionContext);
        }
    }

    protected abstract void start(ActionContext var1);

    protected BigDecimal getOfflineAmpunt(ActionContext context) {
        BigDecimal offlineAmount = context.getContentData("offline_amount", BigDecimal.class);
        this.assertObject(offlineAmount);
        return offlineAmount;
    }

    protected BigDecimal getPayAmount(ActionContext context) {
        BigDecimal payAmount = context.getContentData("pay_amount", BigDecimal.class);
        this.assertObject(payAmount);
        return payAmount;
    }

    protected GiftConfigBaseRespDto getConfigBase(ActionContext context) {
        GiftConfigBaseRespDto configBase = context.getContentData("base", GiftConfigBaseRespDto.class);
        this.assertObject(configBase);
        return configBase;
    }

    protected List<TradeItemRespDto> getItem(ActionContext context) {
        List<TradeItemRespDto> itemList = context.getContentDataList("item", TradeItemRespDto.class);
        this.assertObject(itemList);
        return itemList;
    }

    protected List<TradeItemRespDto> getGiftItem(ActionContext context) {
        List<TradeItemRespDto> itemList = context.getContentDataList("gift_items", TradeItemRespDto.class);
        return itemList;
    }

    protected BigDecimal getTotalPrice(TradeItemRespDto f) {
        return f.getItemMarketPrice().multiply(BigDecimal.valueOf(f.getItemNum().intValue())).subtract(Optional.ofNullable(f.getDiscountTotalAmount()).orElse(BigDecimal.ZERO)).subtract(Optional.ofNullable(f.getRebateAmount()).orElse(BigDecimal.ZERO));
    }

    protected BalanceDetailRespDto getAccount(ActionContext actionContext) {
        BalanceDetailRespDto account = actionContext.getContentData("account", BalanceDetailRespDto.class);
        this.assertObject(account);
        return account;
    }

    protected Long getCustomerId(ActionContext actionContext) {
        Long customerId = actionContext.getContentData("customer_id", Long.class);
        this.assertObject(customerId);
        return customerId;
    }

    protected GiftInfoRespDto getInfo(ActionContext actionContext) {
        GiftInfoRespDto info = actionContext.getContentData("info", GiftInfoRespDto.class);
        this.assertObject(info);
        return info;
    }

    private void assertObject(Object obj) {
        if (Objects.isNull(obj)) {
            throw new NullPointerException("\u6a21\u677f\u914d\u7f6e\u5931\u6548");
        }
    }
}

