/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.service.action;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.util.SpringBeanUtil;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.IGiftBalanceApi;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.constant.IncomeExpenditureEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.constant.TradeTypeEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.enums.AmountTypeEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.enums.FreezeStatusEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.enums.FreezeTypeEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.enums.GiftTypeEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.BalanceFreezeAddReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.BalanceRecordAddReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.BalanceRecordDetailAddReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.BalanceRelModifyReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.BalanceStatementAddReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.GiftBalanceModifyReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.response.balance.BalanceDetailRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.GiftInfoRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.TradeItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.biz.service.action.AbstractAction;
import com.dtyunxi.yundt.cube.center.trade.biz.service.action.ActionContext;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordAction
extends AbstractAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(RecordAction.class);
    private final IGiftBalanceApi giftBalanceApi = (IGiftBalanceApi)SpringBeanUtil.getBean(IGiftBalanceApi.class);

    @Override
    protected void start(ActionContext actionContext) {
        BalanceFreezeAddReqDto freeze;
        GiftInfoRespDto info = this.getInfo(actionContext);
        if (this.getPayAmount(actionContext).subtract(info.getDeductionAmount()).compareTo(this.getOfflineAmpunt(actionContext)) < 0) {
            throw new BizException("\u4f59\u989d\u62b5\u6263\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u5e94\u4ed8\u91d1\u989d");
        }
        GiftInfoRespDto gift = actionContext.getContentData("info", GiftInfoRespDto.class);
        LOGGER.info("info\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)gift));
        if (Objects.isNull(gift)) {
            return;
        }
        String orderNo = actionContext.getContentData("order_no", String.class);
        BalanceDetailRespDto account = this.getAccount(actionContext);
        LOGGER.info("account\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)account));
        if (gift.isDeduction() && account.getUsableBalance().compareTo(gift.getDeductionAmount().subtract(gift.getAddAmount())) < 0) {
            throw new BizException("\u514d\u8d39\u8d60\u54c1\u989d\u5ea6\u53ef\u7528\u989d\u5ea6\u4e0d\u8db3");
        }
        LOGGER.info("\u6d41\u6c34\u4fe1\u606f\u4e3a" + JSON.toJSONString((Object)actionContext));
        BalanceRelModifyReqDto dto = new BalanceRelModifyReqDto();
        GiftBalanceModifyReqDto modify = new GiftBalanceModifyReqDto();
        modify.setCustomerId(account.getCustomerId());
        BigDecimal balance = BigDecimal.ZERO;
        ArrayList list = Lists.newArrayList();
        ArrayList balanceRecordAddReqDtoList = Lists.newArrayList();
        if (gift.getAddAmount().compareTo(BigDecimal.ZERO) > 0) {
            balance = balance.add(gift.getAddAmount());
            BalanceStatementAddReqDto statement = new BalanceStatementAddReqDto();
            statement.setBalance(gift.getAccountAmount());
            statement.setCustomerId(account.getCustomerId());
            statement.setBusinessNo(orderNo);
            statement.setTradeTime(new Date());
            statement.setTradeTypeEnum(TradeTypeEnum.ORDER_REBATE);
            statement.setIncomeExpenditureEnum(IncomeExpenditureEnum.INCOME);
            statement.setTradeAmount(gift.getAddAmount());
            statement.setBalance(Objects.nonNull(account.getBalance()) ? account.getBalance().add(gift.getAddAmount()) : gift.getAddAmount());
            list.add(statement);
            BalanceRecordAddReqDto balanceRecordAddReqDto = new BalanceRecordAddReqDto();
            balanceRecordAddReqDto.setOrderNo(orderNo);
            balanceRecordAddReqDto.setAmountTypeEnum(AmountTypeEnum.fromCode((String)account.getGivePriceType()));
            balanceRecordAddReqDto.setCustomerId(account.getCustomerId());
            balanceRecordAddReqDto.setCustomerCode(account.getCustomerCode());
            balanceRecordAddReqDto.setCustomerName(account.getCustomerName());
            balanceRecordAddReqDto.setGiftTypeEnum(GiftTypeEnum.fromCode((String)account.getGiveType()));
            balanceRecordAddReqDto.setGiftTime(new Date());
            balanceRecordAddReqDto.setGiftScale(account.getGiveProportion());
            if (GiftTypeEnum.SUM_GIVE.getCode().equals(account.getGiveType())) {
                balanceRecordAddReqDto.setQuantityScaleAmount(account.getQuantityScaleAmount());
                balanceRecordAddReqDto.setQuantityScaleSum(account.getQuantityScaleSum());
            }
            ArrayList<BalanceRecordDetailAddReqDto> details = new ArrayList<BalanceRecordDetailAddReqDto>();
            List<TradeItemRespDto> itemList = this.getItem(actionContext);
            Integer productCount = 0;
            BigDecimal productRebateAmount = BigDecimal.ZERO;
            BigDecimal productAmount = BigDecimal.ZERO;
            BigDecimal discountAmount = BigDecimal.ZERO;
            BigDecimal discountProductAmount = BigDecimal.ZERO;
            BigDecimal rabateAccountProductAmount = BigDecimal.ZERO;
            for (TradeItemRespDto tradeItemRespDto : itemList) {
                BalanceRecordDetailAddReqDto balanceRecordDetailAddReqDto = new BalanceRecordDetailAddReqDto();
                balanceRecordDetailAddReqDto.setCustomerId(account.getCustomerId());
                balanceRecordDetailAddReqDto.setOrderNo(orderNo);
                balanceRecordDetailAddReqDto.setItemCode(tradeItemRespDto.getItemCode());
                balanceRecordDetailAddReqDto.setItemName(tradeItemRespDto.getItemName());
                balanceRecordDetailAddReqDto.setSkuCode(tradeItemRespDto.getSkuCode());
                balanceRecordDetailAddReqDto.setSpecValue(tradeItemRespDto.getSkuDesc());
                balanceRecordDetailAddReqDto.setProductCount(tradeItemRespDto.getItemNum());
                balanceRecordDetailAddReqDto.setProductAmount(Optional.ofNullable(tradeItemRespDto.getItemMarketPrice()).orElse(BigDecimal.ZERO));
                balanceRecordDetailAddReqDto.setGiftAmount(tradeItemRespDto.getAddAmount());
                balanceRecordDetailAddReqDto.setProductRebateAmount(tradeItemRespDto.getProductRebateAmount());
                balanceRecordDetailAddReqDto.setDiscountAmount(tradeItemRespDto.getDiscountTotalAmount());
                balanceRecordDetailAddReqDto.setDiscountProductAmount(tradeItemRespDto.getDiscountProductAmount());
                balanceRecordDetailAddReqDto.setRabateAccountProductAmount(tradeItemRespDto.getRebateAmount());
                details.add(balanceRecordDetailAddReqDto);
                productCount = productCount + tradeItemRespDto.getItemNum();
                productRebateAmount = productRebateAmount.add(Optional.ofNullable(tradeItemRespDto.getProductRebateAmount()).orElse(BigDecimal.ZERO));
                productAmount = productAmount.add(Optional.ofNullable(balanceRecordDetailAddReqDto.getProductAmount()).orElse(BigDecimal.ZERO));
                discountAmount = discountAmount.add(Optional.ofNullable(tradeItemRespDto.getDiscountTotalAmount()).orElse(BigDecimal.ZERO));
                discountProductAmount = discountProductAmount.add(Optional.ofNullable(tradeItemRespDto.getDiscountProductAmount()).orElse(BigDecimal.ZERO));
                rabateAccountProductAmount = rabateAccountProductAmount.add(Optional.ofNullable(tradeItemRespDto.getRebateAmount()).orElse(BigDecimal.ZERO));
            }
            balanceRecordAddReqDto.setDetails(details);
            balanceRecordAddReqDto.setProductCount(productCount);
            balanceRecordAddReqDto.setGiftAmount(gift.getAddAmount());
            balanceRecordAddReqDto.setProductRebateAmount(productRebateAmount);
            balanceRecordAddReqDto.setProductAmount(productAmount);
            balanceRecordAddReqDto.setDiscountAmount(discountAmount);
            balanceRecordAddReqDto.setDiscountProductAmount(discountProductAmount);
            balanceRecordAddReqDto.setRabateAccountProductAmount(rabateAccountProductAmount);
            balanceRecordAddReqDtoList.add(balanceRecordAddReqDto);
        }
        boolean isDeduction = gift.isDeduction();
        if (gift.getDeductionAmount().compareTo(BigDecimal.ZERO) > 0 && isDeduction) {
            balance = balance.subtract(gift.getDeductionAmount());
            BalanceStatementAddReqDto statement = new BalanceStatementAddReqDto();
            statement.setBalance(gift.getDeductionAmount().negate());
            statement.setCustomerId(account.getCustomerId());
            statement.setBusinessNo(orderNo);
            statement.setTradeTime(new Date());
            statement.setTradeTypeEnum(TradeTypeEnum.ORDER_DEDUCT);
            statement.setIncomeExpenditureEnum(IncomeExpenditureEnum.EXPENDITURE);
            statement.setTradeAmount(gift.getDeductionAmount());
            statement.setBalance(Objects.nonNull(account.getBalance()) ? account.getBalance().add(gift.getAddAmount()).subtract(gift.getDeductionAmount()) : gift.getAddAmount().subtract(gift.getDeductionAmount()));
            list.add(statement);
        }
        if (isDeduction) {
            if (gift.getUnableAmount().compareTo(BigDecimal.ZERO) > 0) {
                modify.setFreezeBalance(gift.getUnableAmount());
                freeze = new BalanceFreezeAddReqDto();
                freeze.setCustomerId(account.getCustomerId());
                freeze.setFreezeAmount(gift.getUnableAmount());
                freeze.setFreezeTime(new Date());
                freeze.setFreezeTypeEnum(FreezeTypeEnum.THIS_USE);
                freeze.setBusinessNo(orderNo);
                freeze.setReason("\u8ba2\u5355\u65b0\u589e\u51bb\u7ed3");
                freeze.setStatusEnum(FreezeStatusEnum.FREEZEING);
                dto.setBalanceFreezeAddReqDto(freeze);
            }
        } else if (gift.getAddAmount().compareTo(BigDecimal.ZERO) > 0) {
            modify.setFreezeBalance(gift.getAddAmount());
            freeze = new BalanceFreezeAddReqDto();
            freeze.setCustomerId(account.getCustomerId());
            freeze.setFreezeAmount(gift.getAddAmount());
            freeze.setFreezeTime(new Date());
            freeze.setFreezeTypeEnum(FreezeTypeEnum.THIS_USE);
            freeze.setBusinessNo(orderNo);
            freeze.setReason("\u8ba2\u5355\u65b0\u589e\u51bb\u7ed3");
            freeze.setStatusEnum(FreezeStatusEnum.FREEZEING);
            dto.setBalanceFreezeAddReqDto(freeze);
        }
        modify.setBalance(balance);
        if (isDeduction && gift.getDeductionAmount().compareTo(gift.getAddAmount()) > 0) {
            modify.setUsableBalance(gift.getDeductionAmount().subtract(gift.getAddAmount()).negate());
        }
        dto.setGiftBalanceModifyReqDto(modify);
        dto.setBalanceStatementAddReqDtoList((List)list);
        dto.setBalanceRecordAddReqDtoList((List)balanceRecordAddReqDtoList);
        try {
            this.giftBalanceApi.modifyBalanceRel(dto);
        }
        catch (Exception e) {
            LOGGER.error("\u6d41\u6c34\u5f02\u5e38" + e.getMessage());
        }
    }
}

