/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.service.connector.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.yundt.cube.center.data.api.query.IDictQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.WarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.enums.DeliveryStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.query.IWarehouseQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.constants.DeliveryBizTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.DeliveryCancelTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.OrderDeviceType;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.DeliveryRespDto;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.utils.TradeUtil;
import com.dtyunxi.yundt.cube.center.trade.biz.mq.producer.DeliveryProducer;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IDeliveryRouterService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IDeliverySplitService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.connector.IConDeliveryService;
import com.dtyunxi.yundt.cube.center.trade.dao.das.DeliveryItemDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.OrderAddressDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.OrderDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.OrderDeliveryDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.PackageItemDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.RefDeliveryOrderDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.TradeItemDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.DeliveryItemEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderAddressEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderDeliveryEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.PackageItemEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.RefDeliveryOrderEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.StdOrderEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.TradeItemEo;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.DeliveryOrderVo;
import com.dtyunxi.yundt.cube.connector.comm.dto.BizDataDto;
import com.dtyunxi.yundt.cube.connector.comm.dto.request.DeliveryReqDto;
import com.dtyunxi.yundt.cube.connector.comm.dto.request.DeliveryRequirementsReqDto;
import com.dtyunxi.yundt.cube.connector.comm.dto.request.ReceiverInfoReqDto;
import com.dtyunxi.yundt.cube.connector.comm.dto.request.wms.WmsUpdateDeliveryStatusReqDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="conDeliveryService")
public class ConDeliveryServiceImpl
implements IConDeliveryService {
    private static Logger logger = LoggerFactory.getLogger(ConDeliveryServiceImpl.class);
    @Autowired
    private OrderDeliveryDas orderDeliveryDas;
    @Autowired
    private RefDeliveryOrderDas refDeliveryOrderDas;
    @Autowired
    private DeliveryItemDas deliveryItemDas;
    @Autowired
    private TradeItemDas tradeItemDas;
    @Autowired
    private OrderAddressDas orderAddressDas;
    @Autowired
    private OrderDas orderDas;
    @Autowired
    private PackageItemDas packageItemDas;
    @Autowired
    private DeliveryProducer deliveryProducer;
    @Autowired
    private IWarehouseQueryApi warehouseQueryApi;
    @Autowired
    private IDeliveryRouterService deliveryRouterService;
    @Resource
    private IDictQueryApi dictQueryApi;
    @Autowired
    private IDeliverySplitService deliverySplitService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public DeliveryRespDto syncConDelivery(BizDataDto bizDataDto) {
        String deliveryNo = null;
        String oriOrderNo = null;
        String dataId = bizDataDto.getId().toString();
        DeliveryRespDto deliveryRespDto = new DeliveryRespDto();
        try {
            DeliveryReqDto deliveryReqDto = (DeliveryReqDto)JSON.parseObject((String)((String)bizDataDto.getData()), DeliveryReqDto.class);
            oriOrderNo = deliveryReqDto.getOriOrderNo();
            logger.info("1\u3001\u5f00\u59cb\u5904\u7406\u8fde\u63a5\u5668\u53d1\u8d27\u5355\u6d88\u606f,oriOrderNo:{}\uff0cdeliveryReqDto\uff1a{}", (Object)oriOrderNo, (Object)JSON.toJSONString((Object)deliveryReqDto));
            this.checkData(deliveryReqDto, dataId);
            if (!OrderDeviceType.DRP.getCode().equals(deliveryReqDto.getSaleChannel())) {
                OrderDeliveryEo record = new OrderDeliveryEo();
                record.setDeliveryOrderCode(deliveryReqDto.getDeliveryOrderCode());
                OrderDeliveryEo prePrderDelivery = (OrderDeliveryEo)this.orderDeliveryDas.selectOne((BaseEo)record);
                boolean forceUpdate = false;
                if (null != prePrderDelivery && forceUpdate) {
                    logger.info("\u53d1\u8d27\u5355\u6d88\u606f\u5728\u5e93\u4e2d\u5df2\u5b58\u5728\uff0c\u8fdb\u884c\u5f3a\u5236\u5220\u9664\u540e\u63d2\u5165\uff01");
                    this.deleteOriDataByOrderNo(prePrderDelivery);
                    logger.info("\u5220\u9664\u539f\u53d1\u8d27\u5355\u76f8\u5173\u8868\u6210\u529f!");
                } else if (null != prePrderDelivery) {
                    logger.info("\u53d1\u8d27\u5355\u6d88\u606f\u5728\u5e93\u4e2d\u5df2\u5b58\u5728\uff0c\u4e0d\u505a\u4efb\u4f55\u5904\u7406\uff0c\u76f4\u63a5\u901a\u77e5\u8fde\u63a5\u5668\u5df2\u5904\u7406\u6210\u529f\uff01");
                    deliveryRespDto.setDeliveryNo(prePrderDelivery.getDeliveryNo());
                    return deliveryRespDto;
                }
            }
            OrderEo orderSelect = OrderEo.newInstance();
            orderSelect.setThirdParentOrderNo(oriOrderNo);
            List orders = this.orderDas.select((BaseEo)orderSelect);
            if (OrderDeviceType.DRP.getCode().equals(deliveryReqDto.getSaleChannel()) && CollectionUtils.isEmpty((Collection)orders)) {
                OrderEo queryOrderEo = OrderEo.newInstance();
                queryOrderEo.setThirdOrderNo(oriOrderNo);
                orders = this.orderDas.select((BaseEo)queryOrderEo);
            }
            if (CollectionUtils.isEmpty((Collection)orders)) {
                logger.error("\u6839\u636e\u6e90\u8ba2\u5355\u53f7\u67e5\u8be2\u4e0d\u5230\u4efb\u4f55\u8ba2\u5355\u4fe1\u606f\uff0coriOrderNo:{}", (Object)oriOrderNo);
                throw new BizException("\u627e\u4e0d\u5230\u4efb\u4f55\u8ba2\u5355\u4fe1\u606f\uff0coriOrderNo\uff1a" + oriOrderNo);
            }
            OrderDeliveryEo orderDeliveryEo = OrderDeliveryEo.newInstance();
            this.handleOrderDelivery(orderDeliveryEo, deliveryReqDto, (OrderEo)orders.get(0));
            this.orderDeliveryDas.insert((BaseEo)orderDeliveryEo);
            deliveryNo = orderDeliveryEo.getDeliveryNo();
            logger.info("2\u3001\u4fdd\u5b58tr_order_delivery\u6210\u529f\uff0coriOrderNo:{},deliveryNo\uff1a{}", (Object)oriOrderNo, (Object)deliveryNo);
            ArrayList<RefDeliveryOrderEo> refDeliveryOrders = new ArrayList<RefDeliveryOrderEo>();
            this.handleRefDeliveryOrder(refDeliveryOrders, orderDeliveryEo, orders);
            this.refDeliveryOrderDas.insertBatch(refDeliveryOrders);
            logger.info("3\u3001\u4fdd\u5b58tr_ref_delivery_order\u6210\u529f\uff0coriOrderNo:{},deliveryNo\uff1a{}", (Object)oriOrderNo, (Object)deliveryNo);
            ArrayList<DeliveryItemEo> deliveryItemEos = new ArrayList<DeliveryItemEo>();
            this.handleDeliveryItems(deliveryItemEos, orders, deliveryNo);
            if (!CollectionUtils.isEmpty(deliveryItemEos)) {
                this.deliveryItemDas.insertBatch(deliveryItemEos);
            }
            logger.info("4\u3001\u4fdd\u5b58tr_delivery_item\u6210\u529f\uff0coriOrderNo:{},oriOrderNo\uff1a{}", (Object)oriOrderNo, (Object)deliveryNo);
            deliveryRespDto.setDeliveryNo(orderDeliveryEo.getDeliveryNo());
            DeliveryOrderVo deliveryOrderVo = new DeliveryOrderVo();
            deliveryOrderVo.setOrderDelivery(orderDeliveryEo);
            deliveryOrderVo.setRefDeliveryOrders(refDeliveryOrders);
            deliveryOrderVo.setDeliveryItems(deliveryItemEos);
            this.deliveryProducer.sendInventoryDelivery(deliveryOrderVo);
            logger.info("\u540c\u6b65\u8fde\u673a\u5668\u8ba2\u5355\u5230\u5e93\u5b58\u4e2d\u5fc3...");
            if (DeliveryStatusEnum.TO_CONFIRM.getStatus().equals(orderDeliveryEo.getDeliveryStatus())) {
                this.deliverySplitService.autoSplit(deliveryOrderVo);
            }
            return deliveryRespDto;
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65\u53d1\u8d27\u5355\u51fa\u73b0\u5f02\u5e38\uff0coriOrderNo\uff1a{},e\uff1a{}", new Object[]{oriOrderNo, e.getMessage(), e});
            throw new BizException("\u540c\u6b65\u53d1\u8d27\u5355\u51fa\u73b0\u5f02\u5e38\uff0coriOrderNo\uff1a" + oriOrderNo);
        }
    }

    private void checkData(DeliveryReqDto deliveryReqDto, String dataId) {
        if (StringUtils.isEmpty((CharSequence)dataId)) {
            logger.error("\u53d1\u8d27\u5355\u540c\u6b65\u5931\u8d25\uff0c\u8fde\u63a5\u5668dataId\u4e3a\u7a7a\uff01");
            throw new BizException("\u53d1\u8d27\u5355\u540c\u6b65\u5931\u8d25\uff0c\u8fde\u63a5\u5668dataId\u4e3a\u7a7a\uff01");
        }
        if (!OrderDeviceType.DRP.getCode().equals(deliveryReqDto.getSaleChannel()) && StringUtils.isEmpty((CharSequence)deliveryReqDto.getDeliveryOrderCode())) {
            logger.error("\u53d1\u8d27\u5355\u540c\u6b65\u5931\u8d25\uff0c\u51fa\u5e93\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            throw new BizException("\u51fa\u5e93\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)deliveryReqDto.getOriOrderNo())) {
            logger.error("\u53d1\u8d27\u5355\u540c\u6b65\u5931\u8d25\uff0c\u6e90\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            throw new BizException("\u6e90\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void handleRefDeliveryOrder(List<RefDeliveryOrderEo> refDeliveryOrders, OrderDeliveryEo orderDelivery, List<OrderEo> orders) {
        for (OrderEo order : orders) {
            RefDeliveryOrderEo refDeliveryOrder = RefDeliveryOrderEo.newInstance();
            refDeliveryOrder.setOrderNo(order.getOrderNo());
            refDeliveryOrder.setDeliveryNo(orderDelivery.getDeliveryNo());
            refDeliveryOrder.setOriginOrderNo(order.getThirdOrderNo());
            refDeliveryOrder.setInstanceId(orderDelivery.getInstanceId());
            refDeliveryOrder.setTenantId(orderDelivery.getTenantId());
            refDeliveryOrders.add(refDeliveryOrder);
        }
    }

    private void handleOrderDelivery(OrderDeliveryEo orderDeliveryEo, DeliveryReqDto deliveryReqDto, OrderEo orderEo) {
        DeliveryRequirementsReqDto deliveryRequirement;
        WarehouseRespDto warehouse;
        OrderAddressEo addressSelect = new OrderAddressEo();
        addressSelect.setOrderNo(deliveryReqDto.getOriOrderNo());
        OrderAddressEo orderAddress = (OrderAddressEo)this.orderAddressDas.selectOne((BaseEo)addressSelect);
        if (null == orderAddress) {
            logger.error("\u4fdd\u5b58\u53d1\u8d27\u5355\u5931\u8d25\uff0c\u627e\u4e0d\u5230\u8ba2\u5355\u5bf9\u5e94\u5730\u5740\u4fe1\u606f\uff0corderNo:{}", (Object)deliveryReqDto.getOrderNo());
            throw new BizException("\u627e\u4e0d\u5230\u8ba2\u5355\u5bf9\u5e94\u5730\u5740\u4fe1\u606f");
        }
        String deliveryNo = TradeUtil.generateTradeNo(orderEo.getOrderNo());
        orderDeliveryEo.setBizType(DeliveryBizTypeEnum.OMNI_CHANNEL.getType());
        orderDeliveryEo.setDeliveryNo(deliveryNo);
        orderDeliveryEo.setThirdPayNo(deliveryReqDto.getPayNo());
        orderDeliveryEo.setDeliveryOrderCode(deliveryReqDto.getDeliveryOrderCode());
        orderDeliveryEo.setOrderType(deliveryReqDto.getOrderType());
        orderDeliveryEo.setWarehouseCode(deliveryReqDto.getWarehouseCode());
        if (StringUtils.isNotEmpty((CharSequence)deliveryReqDto.getWarehouseCode()) && null != (warehouse = (WarehouseRespDto)this.warehouseQueryApi.queryWarehouseByCode(deliveryReqDto.getWarehouseCode(), null).getData())) {
            orderDeliveryEo.setWarehouseName(warehouse.getName());
        }
        orderDeliveryEo.setOperatorCode(deliveryReqDto.getOperatorCode());
        orderDeliveryEo.setOperatorName(deliveryReqDto.getOperatorName());
        orderDeliveryEo.setTotalAmount(deliveryReqDto.getTotalAmount());
        orderDeliveryEo.setItemAmount(deliveryReqDto.getItemAmount());
        orderDeliveryEo.setDiscountAmount(deliveryReqDto.getDiscountAmount());
        orderDeliveryEo.setFreightAmount(deliveryReqDto.getFreight());
        orderDeliveryEo.setArAmount(deliveryReqDto.getArAmount());
        orderDeliveryEo.setGotAmount(deliveryReqDto.getGotAmount());
        orderDeliveryEo.setShippingCompanyCode(deliveryReqDto.getLogisticsCode());
        orderDeliveryEo.setShippingCompany(deliveryReqDto.getLogisticsName());
        orderDeliveryEo.setExpressCode(deliveryReqDto.getExpressCode());
        orderDeliveryEo.setChannel(deliveryReqDto.getSaleChannel());
        ReceiverInfoReqDto receiverInfo = deliveryReqDto.getReceiverInfo();
        if (null != receiverInfo) {
            orderDeliveryEo.setDeliveryName(receiverInfo.getName());
            orderDeliveryEo.setAddress(this.getFullAddress(receiverInfo));
            orderDeliveryEo.setDeliveryMobile(receiverInfo.getMobile());
            orderDeliveryEo.setDeliveryPhone(receiverInfo.getTel());
            orderDeliveryEo.setProvinceName(receiverInfo.getProvince());
            orderDeliveryEo.setCityName(receiverInfo.getCity());
            orderDeliveryEo.setAreaName(receiverInfo.getArea());
            orderDeliveryEo.setStreetName(receiverInfo.getTown());
            orderDeliveryEo.setDetailed(receiverInfo.getDetailAddress());
            orderDeliveryEo.setPostcode(receiverInfo.getZipCode());
            orderDeliveryEo.setCancelType(DeliveryCancelTypeEnum.NOT_CANCLE.getType());
            orderDeliveryEo.setCompany(receiverInfo.getCompany());
            orderDeliveryEo.setIdentityType(receiverInfo.getIdType());
            orderDeliveryEo.setIdentityNo(receiverInfo.getIdNumber());
            orderDeliveryEo.setEmail(receiverInfo.getEmail());
            orderDeliveryEo.setCountryCode(receiverInfo.getCountryCode());
        }
        if (null != (deliveryRequirement = deliveryReqDto.getDeliveryRequirement())) {
            orderDeliveryEo.setScheduleType(deliveryRequirement.getScheduleType());
            orderDeliveryEo.setScheduleDay(deliveryRequirement.getScheduleDay());
            orderDeliveryEo.setScheduleStartTime(deliveryRequirement.getScheduleStartTime());
            orderDeliveryEo.setScheduleEndTime(deliveryRequirement.getScheduleEndTime());
            orderDeliveryEo.setDeliveryMethod(deliveryRequirement.getDeliveryType());
        }
        orderDeliveryEo.setInstanceId(deliveryReqDto.getInstanceId());
        orderDeliveryEo.setTenantId(deliveryReqDto.getTenantId());
        orderDeliveryEo.setOrganizationId(orderEo.getOrganizationId());
        orderDeliveryEo.setOrganizationName(orderEo.getOrganizationName());
        int deliveryConfirmMin = this.deliveryRouterService.getDeliveryConfirmMin();
        if (deliveryConfirmMin > 0) {
            logger.info("\u53d1\u8d27\u5355\u8bbe\u7f6e\u5f85\u786e\u8ba4\u65f6\u95f4\u4e3a\uff1a{}min\uff0c\u53d1\u8d27\u5355\u8bbe\u7f6e\u4e3a\u5f85\u786e\u8ba4\u72b6\u6001\u3002", (Object)deliveryConfirmMin);
            orderDeliveryEo.setDeliveryStatus(DeliveryStatusEnum.TO_CONFIRM.getStatus());
        } else {
            Boolean routerConfigOpen = this.deliveryRouterService.checkRouterConfigOpen(orderEo, orderDeliveryEo);
            if (routerConfigOpen.booleanValue()) {
                orderDeliveryEo.setDeliveryStatus(DeliveryStatusEnum.TO_ROUTE.getStatus());
            } else {
                orderDeliveryEo.setDeliveryStatus(DeliveryStatusEnum.TO_DO.getStatus());
                orderDeliveryEo.clearWarehouse();
            }
        }
    }

    private String getFullAddress(ReceiverInfoReqDto receiverInfo) {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)receiverInfo.getProvince())) {
            sb.append(receiverInfo.getProvince());
        }
        if (StringUtils.isNotBlank((CharSequence)receiverInfo.getCity())) {
            sb.append(receiverInfo.getCity());
        }
        if (StringUtils.isNotBlank((CharSequence)receiverInfo.getArea())) {
            sb.append(receiverInfo.getArea());
        }
        if (StringUtils.isNotBlank((CharSequence)receiverInfo.getTown())) {
            sb.append(receiverInfo.getTown());
        }
        if (StringUtils.isNotBlank((CharSequence)receiverInfo.getDetailAddress())) {
            sb.append(receiverInfo.getDetailAddress());
        }
        return sb.toString();
    }

    private void handleDeliveryItems(List<DeliveryItemEo> deliveryItemEos, List<OrderEo> orders, String deliveryNo) {
        List orderNos = orders.stream().map(StdOrderEo::getOrderNo).collect(Collectors.toList());
        TradeItemEo tradeItemSelect = TradeItemEo.newInstance();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"trade_no", orderNos));
        tradeItemSelect.setSqlFilters(sqlFilters);
        List tradeItems = this.tradeItemDas.select((BaseEo)tradeItemSelect);
        if (CollectionUtils.isEmpty((Collection)tradeItems)) {
            logger.error("\u53d1\u8d27\u5355\u4fdd\u5b58\u5931\u8d25\uff0c\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u8ba2\u5355\u5546\u54c1\u4fe1\u606f\uff0corderNos\uff1a{}", orderNos);
            throw new BizException("\u53d1\u8d27\u5355\u4fdd\u5b58\u5931\u8d25\uff0c\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u8ba2\u5355\u5546\u54c1\u4fe1\u606f");
        }
        for (TradeItemEo tradeItem : tradeItems) {
            DeliveryItemEo deliveryItemEo = DeliveryItemEo.newInstance();
            deliveryItemEo.setTradeNo(tradeItem.getTradeNo());
            deliveryItemEo.setDeliveryNo(deliveryNo);
            deliveryItemEo.setTrOrderItemNo(tradeItem.getId().toString());
            deliveryItemEo.setCargoSerial(tradeItem.getCargoSerial());
            deliveryItemEo.setItemNum(tradeItem.getItemNum());
            deliveryItemEo.setDeliveryType("NORMAL");
            deliveryItemEo.setDeliverySubType("NORMAL");
            deliveryItemEo.setSkuSerial(tradeItem.getSkuSerial());
            deliveryItemEo.setSkuCode(tradeItem.getSkuCode());
            deliveryItemEo.setSkuDesc(tradeItem.getSkuDesc());
            deliveryItemEo.setItemName(tradeItem.getItemName());
            deliveryItemEo.setItemCode(tradeItem.getItemCode());
            deliveryItemEo.setItemPrice(tradeItem.getItemPrice());
            deliveryItemEo.setItemOrigPrice(tradeItem.getItemOrigPrice());
            String extension = tradeItem.getExtension();
            if (StringUtils.isNotBlank((CharSequence)extension)) {
                JSONObject extensionObj = JSON.parseObject((String)extension);
                deliveryItemEo.setItemImgPath(extensionObj.getString("imgPath"));
            }
            deliveryItemEo.setInstanceId(tradeItem.getInstanceId());
            deliveryItemEo.setTenantId(tradeItem.getTenantId());
            deliveryItemEos.add(deliveryItemEo);
        }
    }

    public void deleteOriDataByOrderNo(OrderDeliveryEo prePrderDelivery) {
        String deliveryNo = prePrderDelivery.getDeliveryNo();
        DeliveryItemEo deliveryItemDelete = new DeliveryItemEo();
        deliveryItemDelete.setDeliveryNo(deliveryNo);
        this.deliveryItemDas.delete((BaseEo)deliveryItemDelete);
        RefDeliveryOrderEo refDeliveryOrderDelete = new RefDeliveryOrderEo();
        refDeliveryOrderDelete.setDeliveryNo(deliveryNo);
        this.refDeliveryOrderDas.delete((BaseEo)refDeliveryOrderDelete);
        OrderDeliveryEo orderDeliveryDelete = new OrderDeliveryEo();
        orderDeliveryDelete.setDeliveryNo(deliveryNo);
        this.orderDeliveryDas.delete((BaseEo)orderDeliveryDelete);
    }

    @Override
    public void wmsDeliverCallBack(WmsUpdateDeliveryStatusReqDto wmsUpdateDeliveryStatusReqDto) {
        String deliveryNo = wmsUpdateDeliveryStatusReqDto.getDeliveryCode();
        if (StringUtils.isEmpty((CharSequence)deliveryNo)) {
            throw new BizException("\u53d1\u8d27\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        OrderDeliveryEo select = OrderDeliveryEo.newInstance();
        select.setDeliveryNo(deliveryNo);
        OrderDeliveryEo orderDeliveryEo = (OrderDeliveryEo)this.orderDeliveryDas.selectOne((BaseEo)select);
        if (null == orderDeliveryEo) {
            logger.error("\u627e\u4e0d\u5230\u53d1\u8d27\u5355\u4fe1\u606f\uff0c\u53d1\u8d27\u5355\u53f7\uff1a{}", (Object)deliveryNo);
            throw new BizException("\u627e\u4e0d\u5230\u53d1\u8d27\u5355\u4fe1\u606f");
        }
        if (!DeliveryStatusEnum.INIT.getStatus().equals(orderDeliveryEo.getDeliveryStatus())) {
            logger.error("\u53d1\u8d27\u5355\uff1a{}\u72b6\u6001{}\u4e0d\u6b63\u786e\uff0c\u4e0d\u80fd\u66f4\u65b0\u4e3a\u5df2\u53d1\u8d27\u72b6\u6001", (Object)deliveryNo, (Object)orderDeliveryEo.getDeliveryStatus());
            throw new BizException("\u53d1\u8d27\u5355\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u4e0d\u80fd\u8fdb\u884c\u66f4\u65b0\u4e3a\u5df2\u53d1\u8d27\u72b6\u6001");
        }
        OrderDeliveryEo updateEo = OrderDeliveryEo.newInstance();
        updateEo.setDeliveryNo(deliveryNo);
        updateEo.setDeliveryStatus(DeliveryStatusEnum.DELIVERED.getStatus());
        updateEo.setShippingCompany("");
        updateEo.setShippingCompanyCode(wmsUpdateDeliveryStatusReqDto.getCompanyCode());
        updateEo.setExpressCode(wmsUpdateDeliveryStatusReqDto.getExpressNo());
        this.orderDeliveryDas.updateSelective((BaseEo)updateEo);
        ArrayList packageItemEos = new ArrayList();
        DeliveryItemEo deliveryItemSelect = new DeliveryItemEo();
        deliveryItemSelect.setDeliveryNo(deliveryNo);
        List deliveryItemEos = this.deliveryItemDas.select((BaseEo)deliveryItemSelect);
        if (CollectionUtils.isEmpty((Collection)deliveryItemEos)) {
            String packageSerial = UUID.randomUUID().toString();
            deliveryItemEos.stream().forEach(deliveryItemEo -> {
                PackageItemEo packageItemEo = new PackageItemEo();
                BeanUtils.copyProperties((Object)deliveryItemEo, (Object)packageItemEo);
                packageItemEo.setId(null);
                packageItemEo.setDeliveryNo(deliveryNo);
                packageItemEo.setActualSkuSerial(deliveryItemEo.getSkuSerial());
                packageItemEo.setDeliveryType("NORMAL");
                packageItemEo.setActualDeliveryNum(deliveryItemEo.getItemNum());
                packageItemEo.setActualDeliverySkuNum(deliveryItemEo.getItemNum());
                packageItemEo.setPackageSerial(packageSerial);
                packageItemEo.setShippingCompany(wmsUpdateDeliveryStatusReqDto.getCompanyCode());
                packageItemEo.setShippingSerial(wmsUpdateDeliveryStatusReqDto.getExpressNo());
                packageItemEos.add(packageItemEo);
            });
            this.packageItemDas.insertBatch(packageItemEos);
        }
        logger.info("WMS\u53d1\u8d27\u5355:{}\u53d1\u8d27\u4fe1\u606f\u56de\u4f20\u5904\u7406\u5b8c\u6bd5\u3002", (Object)deliveryNo);
    }
}

