/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.service.extl.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.biz.member.api.basis.dto.response.MemberInfoDetailRespDto;
import com.dtyunxi.yundt.cube.biz.member.api.basis.query.IMemberInfoExtQueryApi;
import com.dtyunxi.yundt.cube.biz.member.api.point.IPointCashOutApi;
import com.dtyunxi.yundt.cube.biz.member.api.point.dto.request.PointCashOutItemReqDto;
import com.dtyunxi.yundt.cube.biz.member.api.point.dto.response.PointCashOutItemRespDto;
import com.dtyunxi.yundt.cube.biz.member.api.point.dto.response.PointCashOutResultRespDto;
import com.dtyunxi.yundt.cube.biz.member.api.point.query.IPointCashOutQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemDetailRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.PointsDeductionInfoRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemSkuQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IShelfPointsDeductionQueryApi;
import com.dtyunxi.yundt.cube.center.member.api.common.dto.request.PointsTradeInfoReqDto;
import com.dtyunxi.yundt.cube.center.member.api.point.IPointsTradeApi;
import com.dtyunxi.yundt.cube.center.trade.api.constants.ActivityConstant;
import com.dtyunxi.yundt.cube.center.trade.api.constants.CombinationEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.ExchangeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.YesNoEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.activity.ActivityUnitEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderPreviewReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.TradeItemReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.order.activity.OrderActivityInfoJoinReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.order.activity.OrderActivityInfoReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.TradeItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.order.OrderPreviewRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.order.activity.ExchangeDisplayRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.order.activity.OrderActivityInfoRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.order.activity.ShoppingCartDisplayDto;
import com.dtyunxi.yundt.cube.center.trade.biz.mq.producer.OrderTradeStatusChangeMarketingProducer;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderActivityService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderCouponService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.ITradeItemService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.extl.IExtlItemService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.extl.IExtlOrderActivityService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.extl.bo.CountResultRespDto;
import com.dtyunxi.yundt.cube.center.trade.biz.service.extl.bo.JoinResultRespDto;
import com.dtyunxi.yundt.cube.center.trade.biz.service.extl.impl.IExtIToBRebateActivity;
import com.dtyunxi.yundt.cube.center.trade.dao.das.OrderActivityDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.TradeItemEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.OrderStatusChangeOrderDetailDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.PreviewActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.BizActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ValidType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.IEngineApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IActivityQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.ActivityCoupon;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.EngineParams;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.ItemVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="extlOrderActivityServiceImpl")
public class ExtlOrderActivityServiceImpl
implements IExtlOrderActivityService {
    private static Logger logger = LoggerFactory.getLogger(ExtlOrderActivityServiceImpl.class);
    @Resource
    private IEngineApi engineApi;
    @Resource
    private IExtlItemService extlItemService;
    @Autowired
    private IMemberInfoExtQueryApi memberInfoExtQueryApi;
    @Resource
    private ITradeItemService tradeItemService;
    @Resource
    private OrderActivityDas orderActivityDas;
    @Resource
    private IActivityQueryApi activityQueryApi;
    @Resource
    private IOrderActivityService orderActivityService;
    @Resource(name="iExtIRebateActivity")
    private IExtIToBRebateActivity iRebateActivity;
    @Autowired
    private IItemSkuQueryApi itemSkuQueryApi;
    @Autowired
    private IItemQueryApi itemQueryApi;
    @Resource
    private IPointCashOutApi pointCashOutApi;
    private String JOIN_CHECK_POINT = "JOIN_ACTIVITY";
    private String SUCCESS_JOIN_CHECK_POINT = "SUCCESS_JOIN_ACTIVITY";
    private String PREVIEW_CHECK_POINT = "REVIEW_ACTIVITY";
    private String CANCEL_CHECK_POINT = "CANCEL_JOIN_ACTIVITY";
    private String RETURN_POINTS = "RETURN_POINTS";
    @Resource
    private IOrderCouponService orderCouponService;
    @Resource
    private OrderTradeStatusChangeMarketingProducer orderTradeStatusChangeMarketingProducer;
    @Autowired
    private IPointCashOutQueryApi pointCashOutQueryApi;
    @Autowired
    private IShelfPointsDeductionQueryApi shelfPointsDeductionQueryApi;
    @Resource
    private IPointsTradeApi pointsTradeApi;

    @Override
    public void successJoinActivity(OrderEo orderEo, OrderReqDto orderReqDto) {
        if (orderReqDto.getActivity() == null || CollectionUtils.isEmpty((Collection)orderReqDto.getActivity().getActivityList())) {
            logger.info("\u8ba2\u5355\u53f7{}\u627e\u4e0d\u5230\u4efb\u4f55\u6d3b\u52a8\u4fe1\u606f", (Object)orderReqDto.getTradeNo());
            return;
        }
        List activityList = orderReqDto.getActivity().getActivityList().stream().filter(reqDto -> ActivityConstant.COUPON_ACTIVITY.equals(reqDto.getType()) || ActivityConstant.GROUP_ACTIVITY.equals(reqDto.getType()) || ActivityConstant.EXCHANGE_ACTIVITY.equals(reqDto.getType())).collect(Collectors.toList());
        for (OrderActivityInfoReqDto activity : activityList) {
            if (!ActivityConstant.COUPON_ACTIVITY.equals(activity.getType())) continue;
            List<Long> couponIds = activity.getActivityItemIds().stream().map(Long::valueOf).collect(Collectors.toList());
            this.orderCouponService.useCoupon(orderEo, couponIds);
        }
        orderReqDto.getActivity().setActivityList(activityList);
        EngineParams joinParam = this.getJoinParam(orderReqDto);
        if (CollectionUtils.isEmpty((Collection)joinParam.getActivityIds())) {
            return;
        }
        this.engineApi.execute(this.SUCCESS_JOIN_CHECK_POINT, joinParam);
    }

    private void dealJoinActivityByType(EngineParams engineParams, OrderActivityInfoJoinReqDto orderActivityInfoJoinReqDto) {
        if (null == orderActivityInfoJoinReqDto || CollectionUtils.isEmpty((Collection)orderActivityInfoJoinReqDto.getActivityList())) {
            return;
        }
        List list = orderActivityInfoJoinReqDto.getActivityList().stream().map(orderActivityInfoReqDto -> (long)orderActivityInfoReqDto.getActivityId()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        engineParams.setActivityId(((Long)list.get(0)).longValue());
        engineParams.setActivityIds(list);
        for (OrderActivityInfoReqDto orderActivityInfoReqDto2 : orderActivityInfoJoinReqDto.getActivityList()) {
            List activityItemIds;
            if (Integer.valueOf(ActivityConstant.COUPON_ACTIVITY).equals(orderActivityInfoReqDto2.getType())) {
                activityItemIds = orderActivityInfoReqDto2.getActivityItemIds();
                if (CollectionUtils.isEmpty((Collection)activityItemIds)) {
                    throw new BizException("\u4f18\u60e0\u5238id\u4e0d\u80fd\u4e3a\u7a7a");
                }
                List couponIds = activityItemIds.stream().map(activityItemId -> Long.valueOf(activityItemId)).collect(Collectors.toList());
                ActivityCoupon activityCoupon = new ActivityCoupon();
                activityCoupon.setCouponIds(couponIds);
                activityCoupon.setActivityId(orderActivityInfoReqDto2.getActivityId());
                engineParams.getActivityCouponList().add(activityCoupon);
            }
            if (!Integer.valueOf(ActivityConstant.GROUP_ACTIVITY).equals(orderActivityInfoReqDto2.getType()) || CollectionUtils.isEmpty((Collection)(activityItemIds = orderActivityInfoReqDto2.getActivityItemIds()))) continue;
            engineParams.getExtendsAttribute().put("activity_group_id", Long.valueOf((String)activityItemIds.get(0)));
        }
    }

    private EngineParams getJoinParam(OrderReqDto orderReqDto) {
        EngineParams engineParams = new EngineParams();
        this.dealJoinActivityByType(engineParams, orderReqDto.getActivity());
        engineParams.setOrderCode(orderReqDto.getTradeNo());
        if (StringUtils.isNotEmpty((CharSequence)orderReqDto.getCustomerId())) {
            engineParams.setUserId(Long.valueOf(orderReqDto.getCustomerId()));
            engineParams.setActivityFlag(Boolean.valueOf(true));
        } else {
            engineParams.setUserId(this.getMemberId(Long.valueOf(orderReqDto.getUserId())));
        }
        engineParams.getExtendsAttribute().put("pay_amount", orderReqDto.getPayAmount());
        engineParams.setOrderAmount(orderReqDto.getTotalAmount());
        engineParams.setTotalDiscountAmount(orderReqDto.getTotalAmount().subtract(orderReqDto.getPayAmount()));
        List<ItemVo> itemList = this.changeToItemVoList(orderReqDto, 0);
        List<ItemVo> gifts = this.changeToItemVoList(orderReqDto, 1);
        engineParams.setItems(itemList);
        engineParams.setGifts(gifts);
        engineParams.setTotalDiscountAmount(orderReqDto.getTotalAmount().subtract(orderReqDto.getPayAmount()));
        return engineParams;
    }

    @Override
    public OrderPreviewRespDto viewActivity(OrderPreviewReqDto orderReqDto) {
        OrderPreviewRespDto respDto;
        if (orderReqDto.getViewType() == null || orderReqDto.getViewType().equals(1)) {
            CountResultRespDto countResultRespDto = this.countActivityOrderAmount((OrderReqDto)orderReqDto);
            respDto = countResultRespDto.getOrderPreviewRespDto();
            this.converExchangeShoppingCartDisplay(orderReqDto, respDto, orderReqDto.isNoExchangeException());
        } else {
            respDto = this.previewOrderNoException(orderReqDto);
            this.converExchangeShoppingCartDisplay(orderReqDto, respDto, orderReqDto.isNoExchangeException());
        }
        return respDto;
    }

    private void converExchangeShoppingCartDisplay(OrderPreviewReqDto orderReqDto, OrderPreviewRespDto respDto, boolean noException) {
        if (CollectionUtils.isEmpty((Collection)respDto.getExchangeDisplayRespDto())) {
            return;
        }
        Map<Long, List<TradeItemRespDto>> shopExchangeGroup = respDto.getOrderItems().stream().filter(e -> Integer.valueOf(1).equals(e.getIfExchange()) && e.getExchangeActivityId() != null).collect(Collectors.groupingBy(TradeItemRespDto::getExchangeActivityId));
        logger.info("\u6362\u8d2d\u6d3b\u52a8\u6362\u8d2d\u5546\u54c1\u5206\u7ec4\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(shopExchangeGroup));
        for (ExchangeDisplayRespDto exchangeDisplayRespDto : respDto.getExchangeDisplayRespDto()) {
            if (noException) {
                exchangeDisplayRespDto.setShoppingCartDisplayDto(this.getDisplayDto(shopExchangeGroup, exchangeDisplayRespDto));
            } else {
                if (shopExchangeGroup.containsKey(exchangeDisplayRespDto.getActivityId())) {
                    BigDecimal targetValue = this.sum(shopExchangeGroup.get(exchangeDisplayRespDto.getActivityId()), exchangeDisplayRespDto.getNextDiscountUnit());
                    BigDecimal totalAvailableBalance = exchangeDisplayRespDto.getAccountAvailableBalance().add(Optional.ofNullable(exchangeDisplayRespDto.getDiscount()).orElse(BigDecimal.ZERO));
                    if (totalAvailableBalance.compareTo(targetValue) < 0) {
                        throw new BizException("\u6362\u8d2d\u5546\u54c1\u989d\u5ea6\u5927\u4e8e\u8d60\u9001\u6362\u8d2d\u989d\u5ea6");
                    }
                }
                exchangeDisplayRespDto.setShoppingCartDisplayDto(this.getDisplayDto(shopExchangeGroup, exchangeDisplayRespDto));
            }
            if (!Integer.valueOf(0).equals(exchangeDisplayRespDto.getThresholdType())) continue;
            for (TradeItemReqDto orderItem : orderReqDto.getOrderItems()) {
                if (!ExchangeEnum.YES.getType().equals(orderItem.getIfExchange()) || !Objects.equals(exchangeDisplayRespDto.getActivityId(), orderItem.getExchangeActivityId())) continue;
                orderItem.setExchangePrice(BigDecimal.ZERO);
            }
        }
    }

    private ShoppingCartDisplayDto getDisplayDto(Map<Long, List<TradeItemRespDto>> shopExchangeGroup, ExchangeDisplayRespDto exchangeDisplayRespDto) {
        String desc;
        ShoppingCartDisplayDto shoppingCartDisplayDto = new ShoppingCartDisplayDto();
        List<Object> tradeItemRespDtos = Lists.newArrayList();
        BigDecimal targetValue = BigDecimal.ZERO;
        if (shopExchangeGroup.containsKey(exchangeDisplayRespDto.getActivityId())) {
            tradeItemRespDtos = shopExchangeGroup.get(exchangeDisplayRespDto.getActivityId());
            targetValue = this.sum((List<TradeItemRespDto>)tradeItemRespDtos, exchangeDisplayRespDto.getNextDiscountUnit());
            BigDecimal totalAvailableBalance = exchangeDisplayRespDto.getAccountAvailableBalance().add(Optional.ofNullable(exchangeDisplayRespDto.getDiscount()).orElse(BigDecimal.ZERO));
            if (totalAvailableBalance.compareTo(targetValue) < 0) {
                tradeItemRespDtos.clear();
                exchangeDisplayRespDto.setClearExchangeItem(Integer.valueOf(1));
            }
        }
        logger.info("\u6362\u8d2d\u6d3b\u52a8\u5c55\u793a\uff1a{},\u6362\u8d2d\u5546\u54c1\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)exchangeDisplayRespDto), (Object)JSON.toJSONString((Object)tradeItemRespDtos));
        StringBuilder sb = new StringBuilder();
        Integer type = 1;
        String string = desc = Integer.valueOf(1).equals(exchangeDisplayRespDto.getThresholdType()) ? "\u4f18\u60e0" : "\u514d\u8d39";
        if (exchangeDisplayRespDto.getThreshold() == null) {
            sb.append("\u518d\u4e70").append(exchangeDisplayRespDto.getNextThreshold().subtract(exchangeDisplayRespDto.getTargetValue())).append(ActivityUnitEnum.getActivityUnitDesc((Integer)exchangeDisplayRespDto.getUnit())).append(",\u53ef").append(desc).append("\u6362\u8d2d\u5546\u54c1");
            type = 0;
        } else if (exchangeDisplayRespDto.getThreshold() != null) {
            if (CollectionUtils.isEmpty(tradeItemRespDtos)) {
                sb.append("\u5df2\u6ee1").append(exchangeDisplayRespDto.getThreshold()).append(ActivityUnitEnum.getActivityUnitDesc((Integer)exchangeDisplayRespDto.getUnit())).append(",\u53ef").append(desc).append("\u6362\u8d2d").append(exchangeDisplayRespDto.getDiscount()).append(ActivityUnitEnum.getActivityUnitDesc((Integer)exchangeDisplayRespDto.getDiscountUnit())).append("\u5546\u54c1");
                if (exchangeDisplayRespDto.getNextThreshold() != null) {
                    sb.append(",\u518d\u4e70").append(exchangeDisplayRespDto.getNextThreshold().subtract(exchangeDisplayRespDto.getTargetValue())).append(ActivityUnitEnum.getActivityUnitDesc((Integer)exchangeDisplayRespDto.getUnit()));
                    if (Integer.valueOf(1).equals(exchangeDisplayRespDto.getNexDiscountScale())) {
                        sb.append(",\u53ef").append(desc).append("\u6362\u8d2d").append(exchangeDisplayRespDto.getNextDiscount()).append(ActivityUnitEnum.getActivityUnitDesc((Integer)exchangeDisplayRespDto.getNextDiscountUnit()));
                    } else {
                        sb.append("\uff0c\u53ef\u4f18\u60e0\u6362\u8d2d\u66f4\u591a\u5546\u54c1");
                    }
                }
            } else {
                sb.append("\u5df2\u6ee1").append(exchangeDisplayRespDto.getThreshold()).append(ActivityUnitEnum.getActivityUnitDesc((Integer)exchangeDisplayRespDto.getUnit())).append(",\u5df2").append(desc).append("\u6362\u8d2d").append(targetValue).append(ActivityUnitEnum.getActivityUnitDesc((Integer)exchangeDisplayRespDto.getDiscountUnit())).append(",\u8fd8\u53ef").append(desc).append("\u6362\u8d2d").append(exchangeDisplayRespDto.getDiscount().subtract(targetValue)).append(ActivityUnitEnum.getActivityUnitDesc((Integer)exchangeDisplayRespDto.getDiscountUnit()));
                if (exchangeDisplayRespDto.getNextThreshold() != null) {
                    sb.append(",\u518d\u4e70").append(exchangeDisplayRespDto.getNextThreshold().subtract(exchangeDisplayRespDto.getTargetValue())).append(ActivityUnitEnum.getActivityUnitDesc((Integer)exchangeDisplayRespDto.getUnit()));
                    if (Integer.valueOf(1).equals(exchangeDisplayRespDto.getNexDiscountScale())) {
                        sb.append(",\u53ef").append(desc).append("\u6362\u8d2d").append(exchangeDisplayRespDto.getNextDiscount()).append(ActivityUnitEnum.getActivityUnitDesc((Integer)exchangeDisplayRespDto.getNextDiscountUnit()));
                    } else {
                        sb.append(",\u53ef\u4f18\u60e0\u6362\u8d2d\u66f4\u591a\u5546\u54c1");
                    }
                }
            }
        }
        shoppingCartDisplayDto.setType(type);
        shoppingCartDisplayDto.setDesc(sb.toString());
        exchangeDisplayRespDto.setUsedDiscount(targetValue);
        return shoppingCartDisplayDto;
    }

    private BigDecimal sum(List<TradeItemRespDto> tradeItemRespDtos, Integer discountUnit) {
        BigDecimal usedDiscount = BigDecimal.ZERO;
        if (CollectionUtils.isEmpty(tradeItemRespDtos)) {
            return usedDiscount;
        }
        usedDiscount = Integer.valueOf(1).equals(discountUnit) ? tradeItemRespDtos.stream().map(e -> Optional.ofNullable(e.getExchangePrice()).orElse(BigDecimal.ZERO).multiply(BigDecimal.valueOf(e.getItemNum().intValue()))).reduce(BigDecimal.ZERO, BigDecimal::add) : tradeItemRespDtos.stream().map(TradeItemRespDto::getItemNum).filter(Objects::nonNull).map(BigDecimal::valueOf).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        logger.info("\u5df2\u6362\u8d2d\u5546\u54c1\u989d\u5ea6\uff1a{}", (Object)usedDiscount);
        return usedDiscount;
    }

    public void setShopRule(OrderReqDto orderReqDto) {
        List itemIdList = orderReqDto.getOrderItems().stream().map(TradeItemReqDto::getShelfId).collect(Collectors.toList());
        String itemIds = StringUtils.join(itemIdList, (char)',');
        RestResponse pointsDeductionInfoListResponse = this.shelfPointsDeductionQueryApi.getPointsDeductionInfoList(itemIds);
        logger.info("\u5546\u54c1\u4e2d\u5fc3\u8fd4\u56de\u79ef\u5206\u62b5\u6263\u89c4\u5219:{}-{}", (Object)JSON.toJSONString((Object)itemIds), (Object)JSON.toJSONString((Object)pointsDeductionInfoListResponse));
        RestResponseHelper.checkOrThrow((RestResponse)pointsDeductionInfoListResponse);
        List pointsDeductionInfoRespDtos = (List)RestResponseHelper.extractData((RestResponse)pointsDeductionInfoListResponse);
        if (CollectionUtil.isEmpty((Collection)pointsDeductionInfoRespDtos)) {
            return;
        }
        List shelfIds = pointsDeductionInfoRespDtos.stream().map(PointsDeductionInfoRespDto::getShelfId).collect(Collectors.toList());
        List collect = orderReqDto.getOrderItems().stream().filter(o -> shelfIds.contains(Long.parseLong(o.getShelfId()))).collect(Collectors.toList());
        List shopIds = collect.stream().map(TradeItemReqDto::getShopId).distinct().collect(Collectors.toList());
        String ids = StringUtils.join(shopIds, (char)',');
        RestResponse ruleByShopIds = this.pointCashOutQueryApi.getRuleByShopIds(ids);
        logger.info("\u4f1a\u5458\u4e2d\u5fc3\u8fd4\u56de\u7684\u5e97\u94fa\u79ef\u5206\u89c4\u5219:{}-{}", (Object)JSON.toJSONString((Object)ids), (Object)JSON.toJSONString((Object)ruleByShopIds));
        RestResponseHelper.checkOrThrow((RestResponse)ruleByShopIds);
        Map pointCashOutRuleRespDtoMap = (Map)RestResponseHelper.extractData((RestResponse)ruleByShopIds);
        orderReqDto.setAlreadySetPointDeduct(true);
        if (pointCashOutRuleRespDtoMap == null || pointCashOutRuleRespDtoMap.isEmpty()) {
            return;
        }
        orderReqDto.getOrderItems().forEach(tradeItemReqDto -> {
            if (pointCashOutRuleRespDtoMap.containsKey(tradeItemReqDto.getShopId())) {
                tradeItemReqDto.setShopPointDeductRuleId(BizActivityType.POINT_DEDUCT_ACTIVITY.getId() + "");
            } else {
                tradeItemReqDto.setShopPointDeductRuleId("0");
            }
        });
        HashMap pointsDeductionInfoRespDtoMap = new HashMap();
        pointsDeductionInfoRespDtos.forEach(pointsDeductionInfoRespDto -> pointsDeductionInfoRespDtoMap.put(pointsDeductionInfoRespDto.getShelfId(), pointsDeductionInfoRespDto));
        orderReqDto.getOrderItems().forEach(tradeItemReqDto -> {
            Long shelfId = Long.parseLong(tradeItemReqDto.getShelfId());
            if (pointsDeductionInfoRespDtoMap.containsKey(shelfId)) {
                PointsDeductionInfoRespDto pointsDeductionInfoRespDto = (PointsDeductionInfoRespDto)pointsDeductionInfoRespDtoMap.get(shelfId);
                if (YesNoEnum.YES.getValue().equals(pointsDeductionInfoRespDto.getCustom())) {
                    tradeItemReqDto.setShopPointDeductRuleId("0");
                    tradeItemReqDto.setShopPointDeductRule(Integer.valueOf(1));
                    if (pointsDeductionInfoRespDto.getMinPoints() != null) {
                        tradeItemReqDto.setMinCashOutPoint(Integer.valueOf(pointsDeductionInfoRespDto.getMinPoints().intValue()));
                    } else {
                        tradeItemReqDto.setMinCashOutPoint(Integer.valueOf(0));
                    }
                    if (pointsDeductionInfoRespDto.getMaxPoints() != null) {
                        tradeItemReqDto.setMaxCashOutPoint(Integer.valueOf(pointsDeductionInfoRespDto.getMaxPoints().intValue()));
                    } else {
                        tradeItemReqDto.setMaxCashOutPoint(Integer.valueOf(0));
                    }
                } else if (YesNoEnum.NO.getValue().equals(pointsDeductionInfoRespDto.getCustom())) {
                    tradeItemReqDto.setShopPointDeductRule(Integer.valueOf(0));
                    tradeItemReqDto.setMinCashOutPoint(Integer.valueOf(1));
                    tradeItemReqDto.setMaxCashOutPoint(Integer.valueOf(Integer.MAX_VALUE));
                } else {
                    tradeItemReqDto.setShopPointDeductRule(Integer.valueOf(-1));
                }
            } else {
                tradeItemReqDto.setShopPointDeductRule(Integer.valueOf(-1));
            }
        });
    }

    public void countPointDeduct(OrderPreviewRespDto orderPreviewRespDto, Long memberId) {
        ArrayList itemReqDtoList = new ArrayList();
        orderPreviewRespDto.getOrderItems().forEach(itemVo -> {
            PointCashOutItemReqDto pointCashOutItemReqDto = new PointCashOutItemReqDto();
            pointCashOutItemReqDto.setShopId(Long.valueOf(Long.parseLong(itemVo.getShopId())));
            pointCashOutItemReqDto.setPrice(Double.valueOf(itemVo.getPayTotalAmount().doubleValue()));
            pointCashOutItemReqDto.setQuantity(itemVo.getItemNum());
            pointCashOutItemReqDto.setSku(itemVo.getSkuSerial());
            if (itemVo.getShopPointDeductRule() == 1) {
                pointCashOutItemReqDto.setMinCashOutPoint(itemVo.getMinCashOutPoint());
                pointCashOutItemReqDto.setMaxCashOutPoint(itemVo.getMaxCashOutPoint());
            }
            itemReqDtoList.add(pointCashOutItemReqDto);
        });
        RestResponse calculate = this.pointCashOutApi.calculate(memberId, itemReqDtoList);
        RestResponseHelper.checkOrThrow((RestResponse)calculate);
        PointCashOutResultRespDto pointCashOutResultRespDto = (PointCashOutResultRespDto)RestResponseHelper.extractData((RestResponse)calculate);
        if (pointCashOutResultRespDto == null) {
            return;
        }
        orderPreviewRespDto.setTotalCashOutPoint(pointCashOutResultRespDto.getTotalCashOutPoint());
        orderPreviewRespDto.setTotalCashOutAmount(BigDecimal.valueOf(pointCashOutResultRespDto.getTotalCashOutAmount()));
        if (!CollectionUtils.isEmpty((Collection)orderPreviewRespDto.getEnableActivityIds()) && orderPreviewRespDto.getEnableActivityIds().contains(BizActivityType.POINT_DEDUCT_ACTIVITY.getId())) {
            BigDecimal realPayAmount = orderPreviewRespDto.getPayAmount().subtract(orderPreviewRespDto.getTotalCashOutAmount());
            orderPreviewRespDto.setPayAmount(realPayAmount);
        }
        if (CollectionUtils.isEmpty((Collection)pointCashOutResultRespDto.getItemDetail())) {
            return;
        }
        HashMap pointCashOutItemRespDtoMap = new HashMap();
        pointCashOutResultRespDto.getItemDetail().forEach(pointCashOutItemRespDto -> pointCashOutItemRespDtoMap.put(pointCashOutItemRespDto.getSku(), pointCashOutItemRespDto));
        orderPreviewRespDto.getOrderItems().forEach(tradeItemRespDto -> {
            PointCashOutItemRespDto pointCashOutItemRespDto;
            if (pointCashOutItemRespDtoMap.containsKey(tradeItemRespDto.getSkuSerial()) && (pointCashOutItemRespDto = (PointCashOutItemRespDto)pointCashOutItemRespDtoMap.get(tradeItemRespDto.getSkuSerial())) != null) {
                tradeItemRespDto.setCashOutPoint(pointCashOutItemRespDto.getCashOutPoint());
                tradeItemRespDto.setCashOutAmount(BigDecimal.valueOf(pointCashOutItemRespDto.getCashOutAmount()));
            }
        });
    }

    public void countPointDeduct(OrderReqDto orderReqDto, Long memberId, boolean userCheck) {
        ArrayList itemReqDtoList = new ArrayList();
        orderReqDto.getOrderItems().forEach(itemVo -> {
            PointCashOutItemReqDto pointCashOutItemReqDto = new PointCashOutItemReqDto();
            pointCashOutItemReqDto.setShopId(Long.valueOf(Long.parseLong(itemVo.getShopId())));
            BigDecimal itemPric = itemVo.getPayTotalAmount().divide(BigDecimal.valueOf(itemVo.getItemNum().intValue()), 2, RoundingMode.DOWN);
            logger.info("pointDeduct_item_pric:{}", (Object)itemPric);
            if (itemPric.compareTo(BigDecimal.ZERO) > 0 && itemVo.getShopPointDeductRule() != -1) {
                pointCashOutItemReqDto.setPrice(Double.valueOf(itemPric.doubleValue()));
                pointCashOutItemReqDto.setQuantity(itemVo.getItemNum());
                pointCashOutItemReqDto.setSku(itemVo.getSkuSerial());
                if (YesNoEnum.YES.getValue().equals(itemVo.getShopPointDeductRule())) {
                    pointCashOutItemReqDto.setMinCashOutPoint(itemVo.getMinCashOutPoint());
                    pointCashOutItemReqDto.setMaxCashOutPoint(itemVo.getMaxCashOutPoint());
                } else if (YesNoEnum.NO.getValue().equals(itemVo.getShopPointDeductRule())) {
                    pointCashOutItemReqDto.setMinCashOutPoint(Integer.valueOf(1));
                    pointCashOutItemReqDto.setMaxCashOutPoint(Integer.valueOf(Integer.MAX_VALUE));
                }
                itemReqDtoList.add(pointCashOutItemReqDto);
            }
        });
        if (CollectionUtil.isEmpty(itemReqDtoList)) {
            return;
        }
        logger.info("pointCashOutApi.calculate({},{})", (Object)memberId, (Object)JSON.toJSONString(itemReqDtoList));
        RestResponse calculate = this.pointCashOutApi.calculate(memberId, itemReqDtoList);
        logger.info("pointCashOutApi.calculate(),result:{}", (Object)JSON.toJSONString((Object)calculate));
        RestResponseHelper.checkOrThrow((RestResponse)calculate);
        PointCashOutResultRespDto pointCashOutResultRespDto = (PointCashOutResultRespDto)RestResponseHelper.extractData((RestResponse)calculate);
        if (pointCashOutResultRespDto == null) {
            return;
        }
        if (CollectionUtils.isEmpty((Collection)pointCashOutResultRespDto.getItemDetail())) {
            return;
        }
        HashMap pointCashOutItemRespDtoMap = new HashMap();
        pointCashOutResultRespDto.getItemDetail().forEach(pointCashOutItemRespDto -> pointCashOutItemRespDtoMap.put(pointCashOutItemRespDto.getSku(), pointCashOutItemRespDto));
        orderReqDto.getOrderItems().forEach(tradeItemRespDto -> {
            PointCashOutItemRespDto pointCashOutItemRespDto;
            if (pointCashOutItemRespDtoMap.containsKey(tradeItemRespDto.getSkuSerial()) && (pointCashOutItemRespDto = (PointCashOutItemRespDto)pointCashOutItemRespDtoMap.get(tradeItemRespDto.getSkuSerial())) != null) {
                tradeItemRespDto.setCashOutPoint(pointCashOutItemRespDto.getCashOutPoint());
                tradeItemRespDto.setCashOutAmount(BigDecimal.valueOf(pointCashOutItemRespDto.getCashOutAmount()));
                tradeItemRespDto.getCashOutAmount().setScale(2, RoundingMode.DOWN);
                BigDecimal payAmount = BigDecimal.ZERO;
                BigDecimal discountAmount = BigDecimal.ZERO;
                if (userCheck) {
                    if (tradeItemRespDto.getDiscountTotalAmount() == null) {
                        tradeItemRespDto.setDiscountTotalAmount(BigDecimal.ZERO);
                    }
                    if ((discountAmount = tradeItemRespDto.getDiscountTotalAmount().add(tradeItemRespDto.getCashOutAmount())).compareTo(tradeItemRespDto.getPayTotalAmount()) > 0) {
                        discountAmount = tradeItemRespDto.getPayTotalAmount();
                    }
                    tradeItemRespDto.setDiscountTotalAmount(discountAmount);
                    if (tradeItemRespDto.getPayTotalAmount().compareTo(tradeItemRespDto.getCashOutAmount()) >= 0) {
                        payAmount = tradeItemRespDto.getPayTotalAmount().subtract(tradeItemRespDto.getCashOutAmount());
                        tradeItemRespDto.setPayTotalAmount(payAmount);
                    } else {
                        tradeItemRespDto.setCashOutAmount(payAmount);
                    }
                    BigDecimal unitPrice = tradeItemRespDto.getCashOutAmount().divide(BigDecimal.valueOf(tradeItemRespDto.getItemNum().intValue()), 2, 1);
                    if (tradeItemRespDto.getItemPrice().subtract(unitPrice).compareTo(BigDecimal.ZERO) < 0) {
                        tradeItemRespDto.setItemPrice(BigDecimal.ZERO);
                    } else {
                        tradeItemRespDto.setItemPrice(tradeItemRespDto.getItemPrice().subtract(unitPrice));
                    }
                    tradeItemRespDto.getItemPrice().setScale(2, RoundingMode.DOWN);
                    logger.info("itemPric:{}", (Object)tradeItemRespDto.getItemPrice());
                }
            }
        });
        orderReqDto.setTotalCashOutAmount(BigDecimal.valueOf(pointCashOutResultRespDto.getTotalCashOutAmount()));
        orderReqDto.getTotalCashOutAmount().setScale(2, RoundingMode.DOWN);
        orderReqDto.setTotalCashOutPoint(pointCashOutResultRespDto.getTotalCashOutPoint());
    }

    private OrderPreviewRespDto previewOrderNoException(OrderPreviewReqDto orderReqDto) {
        EngineParams engineParams = this.getPreRequestParam((OrderReqDto)orderReqDto);
        engineParams.setValidType(ValidType.NO_THROW_EXCEPTION);
        logger.info("\u4e0d\u629b\u5f02\u5e38\u4e0b\u5355\u9884\u89c8\u68c0\u67e5\u70b9\u53c2\u6570\uff1a{}", JSON.toJSON((Object)engineParams));
        RestResponse restResponse = this.engineApi.execute(this.PREVIEW_CHECK_POINT, engineParams);
        EngineParams result = (EngineParams)RestResponseHelper.extractData((RestResponse)restResponse);
        List activityIds = result.getActivityIds();
        logger.info("\u8425\u9500\u4e2d\u5fc3\u4e0d\u629b\u5f02\u5e38\u65b9\u5f0f\u9884\u89c8\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)restResponse));
        Map<String, ItemVo> skuMap = result.getItems().stream().filter(e -> e.getExchange() == 0 && e.getIsCombinedPackage() == 0).collect(Collectors.toMap(e -> e.getSkuId() + "#" + e.getShopId(), item -> item, (v1, v2) -> v2));
        Map<String, ItemVo> exchangeSkuMap = result.getItems().stream().filter(e -> e.getExchange() == 1).collect(Collectors.toMap(e -> e.getSkuId() + "#" + e.getShopId() + "#" + e.getExchange() + "#" + e.getExchangeActivityId(), item -> item, (v1, v2) -> v2));
        Map<String, ItemVo> combinationSkuMap = result.getItems().stream().filter(e -> e.getIsCombinedPackage() == 1).collect(Collectors.toMap(e -> e.getSkuId() + "#" + e.getShopId() + "#" + e.getIsCombinedPackage() + "#" + e.getCombinedPackageActivityId(), item -> item, (v1, v2) -> v2));
        orderReqDto.getOrderItems().forEach(item -> {
            if (!Integer.valueOf(1).equals(item.getGift())) {
                ItemVo itemVo = null;
                itemVo = item.getIfExchange() == 1 ? (ItemVo)exchangeSkuMap.get(item.getSkuSerial() + "#" + item.getShopId() + "#" + item.getIfExchange() + "#" + item.getExchangeActivityId()) : (item.getIsCombinedPackage() == 1 ? (ItemVo)combinationSkuMap.get(item.getSkuSerial() + "#" + item.getShopId() + "#" + item.getIsCombinedPackage() + "#" + item.getCombinedPackageActivityId()) : (ItemVo)skuMap.get(item.getSkuSerial() + "#" + item.getShopId()));
                if (itemVo != null) {
                    BigDecimal itemOrigPrice = item.getItemOrigPrice();
                    item.setItemPrice(itemVo.getDiscountPrice());
                    item.setItemOrigPrice(itemVo.getPrice());
                    item.setItemMarketPrice(itemVo.getOrigPrice());
                    item.setLackRemainingStockMap(itemVo.getLackRemainingStockMap());
                    BigDecimal payTotalAmount = itemVo.getOrigPrice().multiply(BigDecimal.valueOf(itemVo.getNum())).subtract(itemVo.getTotoalDiscountAmount());
                    BigDecimal discountAmount = itemVo.getTotoalDiscountAmount();
                    item.setPayTotalAmount(payTotalAmount);
                    item.setDiscountTotalAmount(discountAmount);
                    item.setExchangePrice(Optional.ofNullable(itemVo.getExchangePrice()).orElse(BigDecimal.ZERO));
                    if (ExchangeEnum.YES.getType().equals(item.getIfExchange())) {
                        logger.info("\u6362\u8d2d\u6d3b\u52a8\u5546\u54c1\uff1a{}, \u4fc3\u9500\u4e2d\u5fc3\u6362\u8d2d\u6d3b\u52a8\u5546\u54c1\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)item), (Object)JSON.toJSONString((Object)itemVo));
                        item.setSellPrice(itemVo.getPrice());
                        item.setClearExchangeItem(itemVo.getClearExchangeItem());
                    }
                    if (CombinationEnum.YES.getType().equals(item.getIsCombinedPackage())) {
                        logger.info("\u4f18\u60e0\u6d3b\u52a8\u5546\u54c1\uff1a{}, \u4fc3\u9500\u4e2d\u5fc3\u4f18\u60e0\u6d3b\u52a8\u5546\u54c1\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)item), (Object)JSON.toJSONString((Object)itemVo));
                        item.setSellPrice(itemVo.getPrice());
                        item.setItemPrice(itemVo.getPrice());
                        item.setItemMarketPrice(itemOrigPrice);
                    }
                    logger.info("\u4fee\u6539\u540e\u7684item\u4ef7\u683c:{}", (Object)JSON.toJSONString((Object)item));
                }
            }
        });
        BigDecimal totalAmount = engineParams.getItems().stream().filter(e -> Integer.valueOf(0).equals(e.getExchange())).filter(e -> Integer.valueOf(0).equals(e.getIsCombinedPackage())).map(itemVo -> itemVo.getPrice().multiply(BigDecimal.valueOf(itemVo.getNum()))).reduce(BigDecimal.ZERO, BigDecimal::add);
        logger.info("\u975e\u6362\u8d2d\u4f18\u60e0\u5957\u88c5\u91d1\u989d:{}", (Object)totalAmount);
        totalAmount = totalAmount.add(engineParams.getItems().stream().filter(e -> ExchangeEnum.YES.getType().equals(e.getExchange()) && Integer.valueOf(0).equals(e.getClearExchangeItem())).map(itemVo -> itemVo.getOrigPrice().multiply(BigDecimal.valueOf(itemVo.getNum()))).reduce(BigDecimal.ZERO, BigDecimal::add));
        logger.info("\u6362\u8d2d\u5546\u54c1\u4ef7\u683c:{}", (Object)totalAmount);
        totalAmount = totalAmount.add(engineParams.getItems().stream().filter(e -> CombinationEnum.YES.getType().equals(e.getIsCombinedPackage())).map(itemVo -> itemVo.getOrigPrice().multiply(BigDecimal.valueOf(itemVo.getNum()))).reduce(BigDecimal.ZERO, BigDecimal::add));
        logger.info("\u4f18\u60e0\u5957\u88c5\u652f\u4ed8\u91d1\u989d:{}", (Object)totalAmount);
        orderReqDto.setTotalAmount(totalAmount);
        BigDecimal discountAmount = result.getTotalDiscountAmount();
        if (discountAmount.compareTo(totalAmount) == 1) {
            discountAmount = totalAmount;
        }
        BigDecimal payAmount = totalAmount.subtract(discountAmount);
        logger.info("\u9884\u89c8\u7ed3\u679c\uff1atotalAmount={},discountAmount={},payAmount={}", new Object[]{totalAmount, discountAmount, payAmount});
        if (payAmount.compareTo(BigDecimal.ZERO) < 0) {
            payAmount = BigDecimal.ZERO;
        }
        ArrayList orderItems = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)orderItems, (Collection)orderReqDto.getOrderItems(), TradeItemRespDto.class);
        orderReqDto.setPayAmount(payAmount);
        orderReqDto.setDiscountAmount(discountAmount);
        OrderPreviewRespDto orderPreviewRespDto = new OrderPreviewRespDto();
        orderPreviewRespDto.setActivityShopMapping(result.getActivityShopsMapping());
        orderPreviewRespDto.setPayAmount(payAmount);
        orderPreviewRespDto.setTotalAmount(totalAmount);
        orderPreviewRespDto.setEnableActivityIds(activityIds);
        orderPreviewRespDto.setOrderItems((List)orderItems);
        orderPreviewRespDto.setTotalDiscountAmount(discountAmount);
        List<TradeItemRespDto> gitItems = this.getGiftItems(result);
        orderPreviewRespDto.setGiftItems(gitItems);
        orderPreviewRespDto.setActivityReasonMap(result.getActivityReasonMap());
        orderPreviewRespDto.setActivityDiscountMap(result.getActivityDiscountMap());
        List exchangeDisplayRespDtos = result.getExchangeActivityRespDtos().stream().map(e -> {
            ExchangeDisplayRespDto exchangeDisplayRespDto = new ExchangeDisplayRespDto();
            CubeBeanUtils.copyProperties((Object)exchangeDisplayRespDto, (Object)e, (String[])new String[0]);
            return exchangeDisplayRespDto;
        }).collect(Collectors.toList());
        orderPreviewRespDto.setExchangeDisplayRespDto(exchangeDisplayRespDtos);
        orderPreviewRespDto.setActivityGiftNumList(result.getActivityGiftNumList());
        return orderPreviewRespDto;
    }

    private EngineParams getPreRequestParam(OrderReqDto orderReqDto) {
        EngineParams engineParams = new EngineParams();
        this.dealJoinActivityByType(engineParams, orderReqDto.getActivity());
        if (StringUtils.isNotEmpty((CharSequence)orderReqDto.getCustomerId())) {
            engineParams.setUserId(Long.valueOf(orderReqDto.getCustomerId()));
            engineParams.setActivityFlag(Boolean.valueOf(true));
            engineParams.setActivityStockFlag(orderReqDto.getActivityStockFlag());
        } else {
            engineParams.setUserId(this.getMemberId(Long.valueOf(orderReqDto.getUserId())));
        }
        List<ItemVo> itemList = this.changeToItemVoList(orderReqDto, 0);
        engineParams.setItems(itemList);
        engineParams.setUseExchangeAccount(orderReqDto.isUseExchangeAccount());
        return engineParams;
    }

    private List<ItemVo> changeToExcItemVoList(OrderReqDto orderReqDto) {
        List<ItemVo> itemList = orderReqDto.getOrderItems().stream().filter(tradeItemReqDto -> ExchangeEnum.YES.getType().equals(tradeItemReqDto.getIfExchange())).map(tradeItemReqDto -> {
            ItemVo itemVo = new ItemVo();
            itemVo.setPrice(tradeItemReqDto.getItemOrigPrice());
            itemVo.setOrigPrice(Objects.nonNull(tradeItemReqDto.getItemMarketPrice()) ? tradeItemReqDto.getItemMarketPrice() : tradeItemReqDto.getItemOrigPrice());
            itemVo.setSkuId(tradeItemReqDto.getSkuSerial());
            itemVo.setNum(tradeItemReqDto.getItemNum().intValue());
            itemVo.setExchange(tradeItemReqDto.getIfExchange());
            itemVo.setShopId(tradeItemReqDto.getShopId());
            itemVo.setItemId(tradeItemReqDto.getItemSerial());
            itemVo.setSellerId(tradeItemReqDto.getSellerId());
            itemVo.setShelfId(tradeItemReqDto.getShelfId());
            itemVo.setShopPointDeductRuleId(tradeItemReqDto.getShopPointDeductRuleId());
            itemVo.setShopPointDeductRule(tradeItemReqDto.getShopPointDeductRule());
            itemVo.setMinCashOutPoint(tradeItemReqDto.getMinCashOutPoint());
            itemVo.setMaxCashOutPoint(tradeItemReqDto.getMaxCashOutPoint());
            ItemDetailRespDto itemDetailRespDto = (ItemDetailRespDto)JSONObject.parseObject((String)tradeItemReqDto.getItemDetail(), ItemDetailRespDto.class);
            ArrayList brands = Lists.newArrayList((Object[])new Long[]{itemDetailRespDto.getItem().getBrandId()});
            itemVo.setItemBrands((List)brands);
            List<Long> dirList = this.extlItemService.getBackAndParentDirIdList(itemDetailRespDto);
            itemVo.setItemCategory(dirList);
            itemVo.setExchangeActivityId(tradeItemReqDto.getExchangeActivityId());
            return itemVo;
        }).collect(Collectors.toList());
        return itemList;
    }

    @Override
    public Long getMemberId(Long userId) {
        try {
            MemberInfoDetailRespDto memberInfo = (MemberInfoDetailRespDto)this.memberInfoExtQueryApi.queryMemberInfoDetailByUserId(userId).getData();
            return memberInfo.getId();
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u4f1a\u5458\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            throw new BizException("\u4f1a\u5458\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
    }

    private List<ItemVo> changeToItemVoList(OrderReqDto orderReqDto, Integer gift) {
        List<ItemVo> itemList = orderReqDto.getOrderItems().stream().filter(tradeItemReqDto -> tradeItemReqDto.getGift().equals(gift)).map(tradeItemReqDto -> {
            ItemVo itemVo = new ItemVo();
            itemVo.setPrice(Objects.nonNull(tradeItemReqDto.getItemMarketPrice()) ? tradeItemReqDto.getItemMarketPrice() : tradeItemReqDto.getItemOrigPrice());
            itemVo.setOrigPrice(Objects.nonNull(tradeItemReqDto.getItemMarketPrice()) ? tradeItemReqDto.getItemMarketPrice() : tradeItemReqDto.getItemOrigPrice());
            itemVo.setSkuId(tradeItemReqDto.getSkuSerial());
            itemVo.setNum(tradeItemReqDto.getItemNum().intValue());
            itemVo.setExchange(tradeItemReqDto.getIfExchange());
            itemVo.setShopId(tradeItemReqDto.getShopId());
            itemVo.setItemId(tradeItemReqDto.getItemSerial());
            itemVo.setSellerId(tradeItemReqDto.getSellerId());
            itemVo.setShelfId(tradeItemReqDto.getShelfId());
            itemVo.setShopPointDeductRuleId(tradeItemReqDto.getShopPointDeductRuleId());
            itemVo.setShopPointDeductRule(tradeItemReqDto.getShopPointDeductRule());
            itemVo.setMinCashOutPoint(tradeItemReqDto.getMinCashOutPoint());
            itemVo.setMaxCashOutPoint(tradeItemReqDto.getMaxCashOutPoint());
            ItemDetailRespDto itemDetailRespDto = (ItemDetailRespDto)JSONObject.parseObject((String)tradeItemReqDto.getItemDetail(), ItemDetailRespDto.class);
            ArrayList brands = Lists.newArrayList((Object[])new Long[]{itemDetailRespDto.getItem().getBrandId()});
            itemVo.setItemBrands((List)brands);
            List<Long> dirList = this.extlItemService.getBackAndParentDirIdList(itemDetailRespDto);
            itemVo.setItemCategory(dirList);
            itemVo.setExchangeActivityId(tradeItemReqDto.getExchangeActivityId());
            itemVo.setIsCombinedPackage(tradeItemReqDto.getIsCombinedPackage());
            itemVo.setCombinedPackageActivityId(tradeItemReqDto.getCombinedPackageActivityId());
            return itemVo;
        }).collect(Collectors.toList());
        return itemList;
    }

    @Override
    public CountResultRespDto countActivityOrderAmount(OrderReqDto orderReqDto) {
        BigDecimal payAmount;
        if (orderReqDto.getActivity() == null || CollectionUtils.isEmpty((Collection)orderReqDto.getActivity().getActivityList())) {
            logger.info("\u8ba2\u5355\u53f7{}\u627e\u4e0d\u5230\u4efb\u4f55\u6d3b\u52a8\u4fe1\u606f", (Object)orderReqDto.getTradeNo());
            return new CountResultRespDto();
        }
        for (OrderActivityInfoReqDto orderActivityInfoReqDto : orderReqDto.getActivity().getActivityList()) {
            if (orderActivityInfoReqDto.getType() == null || !orderActivityInfoReqDto.getType().equals(ActivityConstant.SECKILL_ACTIVITY)) continue;
            return new CountResultRespDto();
        }
        if (StringUtils.isEmpty((CharSequence)orderReqDto.getCustomerId())) {
            Long memberId = this.getMemberId(Long.valueOf(orderReqDto.getUserId()));
            orderReqDto.setMemberId(memberId);
        }
        EngineParams engineParams = this.getPreRequestParam(orderReqDto);
        engineParams.setValidType(ValidType.THROW_EXCEPTION);
        logger.info("\u4e0b\u5355\u9884\u89c8\u68c0\u67e5\u70b9\u53c2\u6570\uff1a{}", JSON.toJSON((Object)engineParams));
        RestResponse count_group_activity = this.engineApi.execute(this.PREVIEW_CHECK_POINT, engineParams);
        EngineParams engineParamsResult = (EngineParams)RestResponseHelper.extractData((RestResponse)count_group_activity);
        Map<String, ItemVo> skuMap = engineParamsResult.getItems().stream().filter(e -> e.getExchange() == 0 && e.getIsCombinedPackage() == 0).collect(Collectors.toMap(e -> e.getSkuId() + "#" + e.getShopId(), item -> item, (v1, v2) -> v2));
        Map<String, ItemVo> exchangeSkuMap = engineParamsResult.getItems().stream().filter(e -> e.getExchange() == 1).collect(Collectors.toMap(e -> e.getSkuId() + "#" + e.getShopId() + "#" + e.getExchange() + "#" + e.getExchangeActivityId(), item -> item, (v1, v2) -> v2));
        Map<String, ItemVo> combinationSkuMap = engineParamsResult.getItems().stream().filter(e -> e.getIsCombinedPackage() == 1).collect(Collectors.toMap(e -> e.getSkuId() + "#" + e.getShopId() + "#" + e.getIsCombinedPackage() + "#" + e.getCombinedPackageActivityId(), item -> item, (v1, v2) -> v2));
        engineParamsResult.setGifts(engineParamsResult.getGifts() == null ? new ArrayList() : engineParamsResult.getGifts());
        Map<String, ItemVo> giftSkuMap = engineParamsResult.getGifts().stream().collect(Collectors.toMap(ItemVo::getSkuId, item -> item, (v1, v2) -> v2));
        logger.info("\u8425\u9500\u4e2d\u5fc3\u629b\u5f02\u5e38\u65b9\u5f0f\u9884\u89c8\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)engineParamsResult));
        boolean exchangeCoupon = MapUtils.getBoolean((Map)engineParamsResult.getExtendsAttribute(), (Object)"exchangeCoupon", (Boolean)false);
        logger.info("\u662f\u5426\u4f7f\u7528\u5151\u6362\u5238\uff1a{}", (Object)exchangeCoupon);
        orderReqDto.getOrderItems().forEach(item -> {
            if (!Integer.valueOf(1).equals(item.getGift())) {
                ItemVo itemVo = null;
                itemVo = item.getIfExchange() == 1 ? (ItemVo)exchangeSkuMap.get(item.getSkuSerial() + "#" + item.getShopId() + "#" + item.getIfExchange() + "#" + item.getExchangeActivityId()) : (item.getIsCombinedPackage() == 1 ? (ItemVo)combinationSkuMap.get(item.getSkuSerial() + "#" + item.getShopId() + "#" + item.getIsCombinedPackage() + "#" + item.getCombinedPackageActivityId()) : (ItemVo)skuMap.get(item.getSkuSerial() + "#" + item.getShopId()));
                if (itemVo != null) {
                    logger.info("\u975e\u6362\u8d2d\u5546\u54c1\uff1a{}", (Object)JSON.toJSONString((Object)item));
                    BigDecimal itemOrigPrice = item.getItemOrigPrice();
                    item.setItemPrice(itemVo.getDiscountPrice());
                    item.setItemOrigPrice(itemVo.getPrice());
                    item.setItemMarketPrice(itemVo.getOrigPrice());
                    item.setLackRemainingStockMap(itemVo.getLackRemainingStockMap());
                    BigDecimal payTotalAmount = itemVo.getOrigPrice().multiply(BigDecimal.valueOf(itemVo.getNum())).subtract(itemVo.getTotoalDiscountAmount());
                    BigDecimal discountAmount = itemVo.getTotoalDiscountAmount();
                    if (exchangeCoupon) {
                        discountAmount = payTotalAmount;
                        payTotalAmount = BigDecimal.ZERO;
                    }
                    item.setPayTotalAmount(payTotalAmount);
                    item.setDiscountTotalAmount(discountAmount);
                    Integer presentPoint = (Integer)MapUtils.getObject((Map)itemVo.getExtendsAttribute(), (Object)"returnPoints", (Object)0);
                    item.setPresentPoint(Integer.valueOf(presentPoint));
                    item.setGiftCost(itemVo.getGiftCost());
                    item.setExchangePrice(Optional.ofNullable(itemVo.getExchangePrice()).orElse(BigDecimal.ZERO));
                    if (ExchangeEnum.YES.getType().equals(item.getIfExchange())) {
                        logger.info("\u6362\u8d2d\u6d3b\u52a8\u5546\u54c1\uff1a{}, \u4fc3\u9500\u4e2d\u5fc3\u6362\u8d2d\u6d3b\u52a8\u5546\u54c1\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)item), (Object)JSON.toJSONString((Object)itemVo));
                        item.setSellPrice(itemVo.getPrice());
                        item.setClearExchangeItem(itemVo.getClearExchangeItem());
                    }
                    if (CombinationEnum.YES.getType().equals(item.getIsCombinedPackage())) {
                        logger.info("\u4f18\u60e0\u6d3b\u52a8\u5546\u54c1\uff1a{}, \u4fc3\u9500\u4e2d\u5fc3\u4f18\u60e0\u6d3b\u52a8\u5546\u54c1\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)item), (Object)JSON.toJSONString((Object)itemVo));
                        item.setSellPrice(itemVo.getPrice());
                        item.setItemPrice(itemVo.getPrice());
                        item.setItemMarketPrice(itemOrigPrice);
                    }
                    logger.info("\u4fee\u6539\u540e\u7684item\u4ef7\u683c:{}", (Object)JSON.toJSONString((Object)item));
                }
            } else {
                ItemVo giftItemVo = (ItemVo)giftSkuMap.get(item.getSkuSerial());
                if (Objects.nonNull(giftItemVo)) {
                    item.setGiftSkuIds(StringUtils.join((Iterable)giftItemVo.getGiftSkuList(), (String)","));
                }
            }
        });
        if (StringUtils.isEmpty((CharSequence)orderReqDto.getCustomerId()) && !orderReqDto.isAlreadySetPointDeduct()) {
            this.setShopRule(orderReqDto);
        }
        if (engineParamsResult.getActivityIds().contains(BizActivityType.POINT_DEDUCT_ACTIVITY.getId())) {
            this.countPointDeduct(orderReqDto, orderReqDto.getMemberId(), orderReqDto.getActivity().isUserCheckPointDeduction());
            if (orderReqDto.getActivity().isUserCheckPointDeduction()) {
                orderReqDto.setUsePointDeduct(true);
            }
        }
        BigDecimal totalAmount = engineParams.getItems().stream().filter(e -> ExchangeEnum.NO.getType().equals(e.getExchange())).filter(e -> CombinationEnum.NO.getType().equals(e.getIsCombinedPackage())).map(itemVo -> itemVo.getPrice().multiply(BigDecimal.valueOf(itemVo.getNum()))).reduce(BigDecimal.ZERO, BigDecimal::add);
        logger.info("\u666e\u901a\u5546\u54c1\u652f\u4ed8\u91d1\u989d:{}", (Object)totalAmount);
        BigDecimal exchangeAmount = engineParamsResult.getItems().stream().filter(e -> ExchangeEnum.YES.getType().equals(e.getExchange()) && Integer.valueOf(0).equals(e.getClearExchangeItem())).map(e -> e.getOrigPrice().multiply(BigDecimal.valueOf(e.getNum()))).reduce(BigDecimal.ZERO, BigDecimal::add);
        logger.info("\u6362\u8d2d\u5546\u54c1\u652f\u4ed8\u91d1\u989d:{}", (Object)exchangeAmount);
        BigDecimal combinationAmount = engineParams.getItems().stream().filter(e -> CombinationEnum.YES.getType().equals(e.getIsCombinedPackage())).map(itemVo -> itemVo.getOrigPrice().multiply(BigDecimal.valueOf(itemVo.getNum()))).reduce(BigDecimal.ZERO, BigDecimal::add);
        logger.info("\u4f18\u60e0\u5957\u88c5\u652f\u4ed8\u91d1\u989d:{}", (Object)combinationAmount);
        totalAmount = totalAmount.add(exchangeAmount);
        totalAmount = totalAmount.add(combinationAmount);
        BigDecimal discountAmount = engineParamsResult.getTotalDiscountAmount();
        if (discountAmount == null) {
            discountAmount = BigDecimal.ZERO;
        }
        if ((payAmount = totalAmount.subtract(discountAmount)) == null) {
            payAmount = BigDecimal.ZERO;
        }
        if (orderReqDto.isUsePointDeduct()) {
            if (orderReqDto.getTotalCashOutAmount() == null) {
                orderReqDto.setTotalCashOutAmount(BigDecimal.ZERO);
            }
            payAmount = payAmount.subtract(orderReqDto.getTotalCashOutAmount());
            discountAmount = discountAmount.add(orderReqDto.getTotalCashOutAmount());
        }
        if (discountAmount.compareTo(totalAmount) == 1) {
            discountAmount = totalAmount;
        }
        logger.info("\u9884\u89c8\u7ed3\u679c\uff1atotalAmount={},discountAmount={},payAmount={}", new Object[]{totalAmount, discountAmount, payAmount});
        if (exchangeCoupon) {
            payAmount = BigDecimal.ZERO;
            discountAmount = totalAmount;
        }
        orderReqDto.setTotalAmount(totalAmount);
        orderReqDto.setPayAmount(payAmount);
        orderReqDto.setDiscountAmount(discountAmount);
        CountResultRespDto countResultRespDto = new CountResultRespDto();
        List<TradeItemReqDto> tradeItemReqDtos = this.filterGiftItem(orderReqDto.getOrderItems(), engineParamsResult);
        logger.info("\u8fc7\u6ee4\u8ba2\u5355\u5546\u54c1\u7684\u8d60\u54c1\u53c2\u6570\u4e0e\u8425\u9500\u9884\u89c8\u7ed3\u679c\u8d60\u54c1\u4e0d\u4e00\u81f4\u7684\u8d60\u54c1\u5546\u54c1\u6570\u636e\uff1a{}", (Object)JSON.toJSONString(tradeItemReqDtos));
        tradeItemReqDtos = this.filterExchangeItem(tradeItemReqDtos, engineParamsResult);
        logger.info("\u8fc7\u6ee4\u8ba2\u5355\u5546\u54c1\u7684\u6362\u8d2d\u53c2\u6570\u4e0e\u8425\u9500\u9884\u89c8\u7ed3\u679c\u8d60\u54c1\u4e0d\u4e00\u81f4\u7684\u6362\u8d2d\u5546\u54c1\u6570\u636e\uff1a{}", (Object)JSON.toJSONString(tradeItemReqDtos));
        orderReqDto.setOrderItems(tradeItemReqDtos);
        countResultRespDto.setCountOrderReq(orderReqDto);
        ArrayList orderItems = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)orderItems, (Collection)orderReqDto.getOrderItems(), TradeItemRespDto.class);
        OrderPreviewRespDto orderPreviewRespDto = new OrderPreviewRespDto();
        if (engineParamsResult.getActivityShopsMapping() != null && !engineParamsResult.getActivityShopsMapping().isEmpty()) {
            orderPreviewRespDto.setActivityShopMapping(engineParamsResult.getActivityShopsMapping());
        }
        List<TradeItemRespDto> gitItems = this.getGiftItems(engineParamsResult);
        orderPreviewRespDto.setUsePointDeduct(orderReqDto.getUsePointDeduct());
        orderPreviewRespDto.setGiftItems(gitItems);
        orderPreviewRespDto.setExchangeCoupon(Boolean.valueOf(exchangeCoupon));
        orderPreviewRespDto.setPayAmount(payAmount);
        orderPreviewRespDto.setTotalAmount(totalAmount);
        orderPreviewRespDto.setEnableActivityIds(engineParamsResult.getActivityIds());
        orderPreviewRespDto.setOrderItems((List)orderItems);
        orderPreviewRespDto.setTotalDiscountAmount(discountAmount);
        orderPreviewRespDto.setActivityReasonMap(engineParamsResult.getActivityReasonMap());
        orderPreviewRespDto.setActivityDiscountMap(engineParamsResult.getActivityDiscountMap());
        orderPreviewRespDto.setDiscountAmount(discountAmount);
        orderPreviewRespDto.setTotalCashOutPoint(orderReqDto.getTotalCashOutPoint());
        orderPreviewRespDto.setTotalCashOutAmount(orderReqDto.getTotalCashOutAmount());
        Map<String, Long> presentPoints = this.getPresentPoints(engineParamsResult);
        orderPreviewRespDto.setPresentPoints(presentPoints);
        orderPreviewRespDto.setActivityGiftNumList(engineParamsResult.getActivityGiftNumList());
        countResultRespDto.setOrderPreviewRespDto(orderPreviewRespDto);
        List exchangeDisplayRespDtos = engineParamsResult.getExchangeActivityRespDtos().stream().map(e -> {
            ExchangeDisplayRespDto exchangeDisplayRespDto = new ExchangeDisplayRespDto();
            CubeBeanUtils.copyProperties((Object)exchangeDisplayRespDto, (Object)e, (String[])new String[0]);
            return exchangeDisplayRespDto;
        }).collect(Collectors.toList());
        orderPreviewRespDto.setExchangeDisplayRespDto(exchangeDisplayRespDtos);
        return countResultRespDto;
    }

    private Map<String, Long> getPresentPoints(EngineParams result) {
        HashMap presentPoints = Maps.newHashMap();
        Map<String, List<ItemVo>> groupByShop = result.getItems().stream().collect(Collectors.groupingBy(ItemVo::getShopId));
        groupByShop.forEach((shopId, itemList) -> {
            Integer point = itemList.stream().mapToInt(itemVo -> {
                Map extendsAttribute = itemVo.getExtendsAttribute();
                return (Integer)MapUtils.getObject((Map)extendsAttribute, (Object)"returnPoints", (Object)0);
            }).sum();
            presentPoints.put(shopId, point.longValue());
        });
        return presentPoints;
    }

    private List<TradeItemReqDto> filterGiftItem(List<TradeItemReqDto> orderItems, EngineParams result) {
        List<TradeItemReqDto> tradeItemReqDtos = orderItems.stream().filter(orderItem -> {
            if (!Integer.valueOf(1).equals(orderItem.getGift())) {
                return true;
            }
            if (CollectionUtils.isEmpty((Collection)result.getGifts())) {
                return false;
            }
            boolean contain = result.getGifts().stream().anyMatch(itemVo -> orderItem.getShopId().equals(itemVo.getShopId()) && orderItem.getSkuSerial().equals(itemVo.getSkuId()));
            return contain;
        }).collect(Collectors.toList());
        return tradeItemReqDtos;
    }

    private List<TradeItemReqDto> filterExchangeItem(List<TradeItemReqDto> orderItems, EngineParams result) {
        List<TradeItemReqDto> tradeItemReqDtos = orderItems.stream().filter(orderItem -> {
            if (YesNoEnum.NO.getValue().equals(orderItem.getIfExchange())) {
                return true;
            }
            boolean contain = result.getItems().stream().anyMatch(itemVo -> orderItem.getShopId().equals(itemVo.getShopId()) && orderItem.getSkuSerial().equals(itemVo.getSkuId()) && orderItem.getIfExchange().equals(itemVo.getExchange()) && Objects.equals(orderItem.getExchangeActivityId(), itemVo.getExchangeActivityId()));
            return contain;
        }).collect(Collectors.toList());
        return tradeItemReqDtos;
    }

    private List<TradeItemRespDto> getGiftItems(EngineParams result) {
        List resultGifts = result.getGifts();
        if (CollectionUtils.isEmpty((Collection)resultGifts)) {
            return Collections.EMPTY_LIST;
        }
        List collect = resultGifts.stream().map(itemVo1 -> Long.valueOf(itemVo1.getSkuId())).collect(Collectors.toList());
        RestResponse listRestResponse = this.itemSkuQueryApi.queryBySkuId(collect);
        Map group = ((List)listRestResponse.getData()).stream().collect(Collectors.groupingBy(ItemSkuRespDto::getId, Collectors.toList()));
        logger.info("\u6839\u636e\u5f15\u64ce\u9884\u89c8\u7ed3\u679c\u83b7\u53d6\u8d60\u54c1\uff0c\u67e5\u8be2\u5355\u4f4d\u7b49\u4fe1\u606f:{}", (Object)JSONObject.toJSONString(group));
        List collectByItemIds = resultGifts.stream().map(itemVo1 -> Long.valueOf(itemVo1.getItemId())).collect(Collectors.toList());
        RestResponse itemList = this.itemQueryApi.queryByItemIds(StringUtils.join(collectByItemIds, (String)","));
        Map itemGroup = ((List)itemList.getData()).stream().collect(Collectors.groupingBy(ItemRespDto::getId, Collectors.toList()));
        logger.info("[\u83b7\u53d6\u5546\u54c1\u4fe1\u606f]\uff0citemRespsGroup:{}", (Object)JSONObject.toJSONString(itemGroup));
        if (!CollectionUtils.isEmpty((Collection)resultGifts)) {
            return resultGifts.stream().map(itemVo -> {
                TradeItemRespDto tradeItem = new TradeItemRespDto();
                tradeItem.setShopId(itemVo.getShopId());
                tradeItem.setSkuSerial(itemVo.getSkuId());
                tradeItem.setItemSerial(itemVo.getItemId());
                tradeItem.setItemPrice(BigDecimal.ZERO);
                tradeItem.setItemNum(Integer.valueOf(itemVo.getNum()));
                List itemSkuRespDtos = (List)group.get(Long.valueOf(itemVo.getSkuId()));
                List items = (List)itemGroup.get(Long.valueOf(itemVo.getItemId()));
                tradeItem.setUnit(CollectionUtils.isEmpty((Collection)itemSkuRespDtos) ? "" : ((ItemSkuRespDto)itemSkuRespDtos.get(0)).getUnit());
                tradeItem.setSubType(CollectionUtils.isEmpty((Collection)items) ? null : ((ItemRespDto)items.get(0)).getSubType());
                tradeItem.setGiftSkuIds(StringUtils.join((Iterable)itemVo.getGiftSkuList(), (String)","));
                return tradeItem;
            }).collect(Collectors.toList());
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public void cancelActivity(OrderReqDto orderReqDto) {
    }

    @Override
    public JoinResultRespDto preJoinActivity(OrderReqDto orderReqDto) {
        if (orderReqDto.getActivity() == null || CollectionUtils.isEmpty((Collection)orderReqDto.getActivity().getActivityList())) {
            logger.info("\u8ba2\u5355\u53f7{}\u627e\u4e0d\u5230\u4efb\u4f55\u6d3b\u52a8\u4fe1\u606f", (Object)orderReqDto.getTradeNo());
            return new JoinResultRespDto();
        }
        EngineParams joinParam = this.getJoinParam(orderReqDto);
        logger.info("\u4e0b\u5355\u53c2\u4e0e\u6d3b\u52a8\u68c0\u67e5\u70b9\u53c2\u6570\uff1a{}", JSON.toJSON((Object)joinParam));
        RestResponse count_group_activity = this.engineApi.execute(this.JOIN_CHECK_POINT, joinParam);
        RestResponseHelper.extractData((RestResponse)count_group_activity);
        JoinResultRespDto joinResult = new JoinResultRespDto();
        List<OrderActivityInfoRespDto> orderActivityInfoRespDtos = orderReqDto.getActivity().getActivityList().stream().map(activity -> {
            OrderActivityInfoRespDto orderActivityInfoRespDto = new OrderActivityInfoRespDto();
            BeanUtils.copyProperties((Object)activity, (Object)orderActivityInfoRespDto);
            return orderActivityInfoRespDto;
        }).collect(Collectors.toList());
        joinResult.setActivityList(orderActivityInfoRespDtos);
        return joinResult;
    }

    private void buildAndOrderStatusChangeToMarket(OrderEo orderEo) {
        OrderReqDto orderBo = this.orderActivityService.getActivityOrder(orderEo);
        if (orderBo.getActivity() == null || CollectionUtils.isEmpty((Collection)orderBo.getActivity().getActivityList())) {
            logger.info("\u8ba2\u5355\u53f7{}\u627e\u4e0d\u5230\u4efb\u4f55\u6d3b\u52a8\u4fe1\u606f", (Object)orderBo.getTradeNo());
            return;
        }
        this.buildAndOrderStatusChangeToMarket(orderEo, orderBo);
    }

    private boolean checkIfSkill(OrderReqDto orderBo) {
        for (OrderActivityInfoReqDto activity : orderBo.getActivity().getActivityList()) {
            if (!ActivityConstant.SECKILL_ACTIVITY.equals(activity.getType())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void buildAndOrderStatusChangeToMarket(OrderEo orderEo, OrderReqDto orderBo) {
        for (OrderActivityInfoReqDto activity : orderBo.getActivity().getActivityList()) {
            if (!ActivityConstant.COUPON_ACTIVITY.equals(activity.getType()) || !org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)activity.getActivityItemIds())) continue;
            List<Long> couponIds = activity.getActivityItemIds().stream().map(Long::valueOf).collect(Collectors.toList());
            this.orderCouponService.releaseCoupon(orderEo, couponIds);
        }
        OrderStatusChangeOrderDetailDto orderStatusChangeOrderDetailDto = new OrderStatusChangeOrderDetailDto();
        List orderItems = orderBo.getOrderItems().stream().map(tradeItemReqDto -> {
            OrderStatusChangeOrderDetailDto.TradeItem item = new OrderStatusChangeOrderDetailDto.TradeItem();
            BeanUtils.copyProperties((Object)tradeItemReqDto, (Object)item);
            return item;
        }).collect(Collectors.toList());
        orderStatusChangeOrderDetailDto.setOrderTradeStatus("CANCEL");
        orderStatusChangeOrderDetailDto.setOrderItems(orderItems);
        List activityList = orderBo.getActivity().getActivityList().stream().map(orderActivityInfoReqDto -> {
            OrderStatusChangeOrderDetailDto.OrderActivityInfoReqDto activityInfoReqDto = new OrderStatusChangeOrderDetailDto.OrderActivityInfoReqDto();
            BeanUtils.copyProperties((Object)orderActivityInfoReqDto, (Object)activityInfoReqDto);
            return activityInfoReqDto;
        }).collect(Collectors.toList());
        orderStatusChangeOrderDetailDto.setActivitys(activityList);
        orderStatusChangeOrderDetailDto.setOrderCode(orderEo.getOrderNo());
        orderStatusChangeOrderDetailDto.setBizType(orderEo.getBizType());
        if (this.checkIfSkill(orderBo)) {
            orderStatusChangeOrderDetailDto.setBizType("3");
            if (StringUtils.isNotEmpty((CharSequence)orderEo.getCustomerId())) {
                orderStatusChangeOrderDetailDto.setBizType("tob_seckill");
            }
        }
        orderStatusChangeOrderDetailDto.setUserId(Long.valueOf(orderEo.getUserId()));
        if (StringUtils.isNotEmpty((CharSequence)orderEo.getCustomerId())) {
            orderStatusChangeOrderDetailDto.setCustomerId(Long.valueOf(orderEo.getCustomerId()));
        }
        this.orderTradeStatusChangeMarketingProducer.sendMqMessage(orderStatusChangeOrderDetailDto);
    }

    @Override
    public void handleOrderStatusChangeAndSendMessage(OrderEo orderEo, Object inputParam, Object returnParam) {
        logger.info("\u8ba2\u5355\u53f7{}\u6536\u5230\u8ba2\u5355\u72b6\u6001\u53d8\u66f4\u6d88\u606f\uff0c\u53d8\u66f4\u72b6\u6001\u4e3a{}", (Object)orderEo.getOrderNo(), (Object)orderEo.getOrderTradeStatus());
        if (orderEo.getOrderTradeStatus().equals("CANCEL") || orderEo.getOrderTradeStatus().equals("CLOSE")) {
            this.buildAndOrderStatusChangeToMarket(orderEo);
        } else {
            logger.info("\u8ba2\u5355\u53f7{}\u6536\u5230\u8ba2\u5355\u72b6\u6001\u53d8\u66f4\u6d88\u606f\uff0c\u53d8\u66f4\u72b6\u6001\u4e3a{}\uff0c\u4e0d\u4f5c\u5904\u7406", (Object)orderEo.getOrderNo(), (Object)orderEo.getOrderTradeStatus());
        }
    }

    @Override
    public void returnPoints(OrderEo orderEo) {
        if (null != orderEo.getPresentPoint() && orderEo.getPresentPoint() > 0) {
            PointsTradeInfoReqDto pointsTradeInfoReqDto = new PointsTradeInfoReqDto();
            Long memberId = this.getMemberId(Long.valueOf(orderEo.getUserId()));
            pointsTradeInfoReqDto.setMemberId(memberId);
            pointsTradeInfoReqDto.setPoints(orderEo.getPresentPoint().intValue());
            pointsTradeInfoReqDto.setTradeSource("\u5c0f\u7a0b\u5e8f");
            pointsTradeInfoReqDto.setRemark("\u6ee1\u8d60\u6d3b\u52a8\u8d60\u9001\u79ef\u5206");
            String tradeNo = (String)this.pointsTradeApi.increase(pointsTradeInfoReqDto).getData();
            logger.info("\u6ee1\u8d60\u6ee1\u8fd4\u6d3b\u52a8\u8fd4\u79ef\u5206\u6210\u529f\uff0c\u5bf9\u5e94\u7684tradeNo:{}\uff0cmemberId\uff1a{}", (Object)tradeNo, (Object)memberId);
        }
    }

    private EngineParams getReturnPointsParam(OrderEo orderEo, Long activityId) {
        EngineParams engineParams = new EngineParams();
        engineParams.setActivityId(activityId.longValue());
        engineParams.setOrderCode(orderEo.getOrderNo());
        engineParams.setUserId(this.getMemberId(Long.valueOf(orderEo.getUserId())));
        engineParams.setOrderAmount(orderEo.getTotalAmount());
        List<TradeItemEo> tradeItems = this.tradeItemService.queryByTradeNo(orderEo.getOrderNo());
        List itemList = tradeItems.stream().filter(tradeItem -> tradeItem.getGift().equals(0)).map(tradeItemReqDto -> {
            ItemVo itemVo = new ItemVo();
            itemVo.setPrice(tradeItemReqDto.getItemOrigPrice());
            itemVo.setSkuId(tradeItemReqDto.getSkuSerial());
            itemVo.setNum(tradeItemReqDto.getItemNum().intValue());
            itemVo.setShopId(tradeItemReqDto.getShopId());
            itemVo.setItemId(tradeItemReqDto.getItemSerial());
            return itemVo;
        }).collect(Collectors.toList());
        engineParams.setItems(itemList);
        return engineParams;
    }

    @Override
    public PreviewActivityRespDto previewActivity(OrderPreviewReqDto orderReqDto) {
        if (Boolean.TRUE.equals(orderReqDto.getPreviewActivity())) {
            EngineParams engineParams = this.getPreRequestParam((OrderReqDto)orderReqDto);
            List itemVos = engineParams.getItems().stream().filter(e -> ExchangeEnum.NO.getType().equals(e.getExchange())).collect(Collectors.toList());
            engineParams.setItems(itemVos);
            engineParams.setValidType(ValidType.NO_THROW_EXCEPTION);
            logger.info("\u4e0b\u5355\u9884\u89c8\u53ef\u7528\u6d3b\u52a8\u53c2\u6570\uff1a{}", JSON.toJSON((Object)engineParams));
            RestResponse restResponse = this.activityQueryApi.previewActivity(engineParams);
            logger.info("\u4e0b\u5355\u9884\u89c8\u53ef\u7528\u6d3b\u52a8\u7ed3\u679c\uff1a{}", JSON.toJSON((Object)restResponse));
            return (PreviewActivityRespDto)RestResponseHelper.extractData((RestResponse)restResponse);
        }
        return null;
    }
}

