/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.service.extl.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ITcbjInventoryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.IItemStorageApi;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.BatchItemStorageReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemStorageReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.TradeItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.biz.service.ITradeItemService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.extl.IExtlOrderStockService;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderEo;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ExtlOrderStockServiceImpl
implements IExtlOrderStockService {
    private static Logger logger = LoggerFactory.getLogger(ExtlOrderStockServiceImpl.class);
    @Resource
    private IItemStorageApi itemStorageApi;
    @Resource
    private ITradeItemService tradeItemService;
    @Value(value="${item.storage.userItemCenter:true}")
    private boolean userItemCenter;
    @Resource
    private ITcbjInventoryApi iTcbjInventoryApi;

    @Override
    public void rollbackVirStock(OrderEo orderEo) {
        if (this.userItemCenter) {
            this.rollbackForVirStock(orderEo);
        } else {
            logger.info("\u53d6\u6d88\u5360\u7528\u63a5\u53e3\u5c40\u8bf7\u6c42\u53c2\u6570,reqDto----:" + JSONObject.toJSONString((Object)orderEo.getOrderNo()));
            logger.info("[\u53d6\u6d88\u5360\u7528\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570],reqDto----:" + JSONObject.toJSONString((Object)orderEo.getOrderNo()));
        }
    }

    private void rollbackForVirStock(OrderEo orderEo) {
        String orderNo = orderEo.getOrderNo();
        List<TradeItemRespDto> orderItemList = this.tradeItemService.queryDtoByTradeNo(orderNo);
        List storageReqDtos = orderItemList.stream().map(tradeItem -> {
            ItemStorageReqDto itemStorageReqDto = new ItemStorageReqDto();
            itemStorageReqDto.setBalance(Long.valueOf(tradeItem.getItemNum().intValue()));
            itemStorageReqDto.setOrderNo(orderNo);
            itemStorageReqDto.setShopId(Long.valueOf(tradeItem.getShopId()));
            itemStorageReqDto.setItemType(tradeItem.getItemType());
            itemStorageReqDto.setSkuId(Long.valueOf(tradeItem.getSkuSerial()));
            return itemStorageReqDto;
        }).collect(Collectors.toList());
        BatchItemStorageReqDto batchItemStorageReqDto = new BatchItemStorageReqDto();
        batchItemStorageReqDto.setItemStorageReqDtoList(storageReqDtos);
        batchItemStorageReqDto.setOpt(BatchItemStorageReqDto.ADD);
        logger.info("\u8ba2\u5355\u53f7{},\u56de\u6eda\u865a\u62df\u5e93\u5b58{}", (Object)orderEo.getOrderNo(), (Object)JSON.toJSONString((Object)batchItemStorageReqDto));
        RestResponse batchItemStorageRespDtoRestResponse = this.itemStorageApi.batchOperatingItemStorage(batchItemStorageReqDto);
        RestResponseHelper.checkOrThrow((RestResponse)batchItemStorageRespDtoRestResponse);
    }

    @Override
    public void rollbackVirStockByActivity(OrderEo orderEo) {
        String orderNo = orderEo.getOrderNo();
        List<TradeItemRespDto> orderItemList = this.tradeItemService.queryDtoByTradeNo(orderNo);
        List storageReqDtos = orderItemList.stream().filter(o -> StringUtils.isEmpty((CharSequence)o.getActivityIds())).map(tradeItem -> {
            ItemStorageReqDto itemStorageReqDto = new ItemStorageReqDto();
            itemStorageReqDto.setBalance(Long.valueOf(tradeItem.getItemNum().intValue()));
            itemStorageReqDto.setOrderNo(orderNo);
            itemStorageReqDto.setShopId(Long.valueOf(tradeItem.getShopId()));
            itemStorageReqDto.setItemType(tradeItem.getItemType());
            itemStorageReqDto.setSkuId(Long.valueOf(tradeItem.getSkuSerial()));
            return itemStorageReqDto;
        }).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(storageReqDtos)) {
            return;
        }
        BatchItemStorageReqDto batchItemStorageReqDto = new BatchItemStorageReqDto();
        batchItemStorageReqDto.setItemStorageReqDtoList(storageReqDtos);
        batchItemStorageReqDto.setOpt(BatchItemStorageReqDto.ADD);
        logger.info("\u8ba2\u5355\u53f7{},\u56de\u6eda\u865a\u62df\u5e93\u5b58{}", (Object)orderEo.getOrderNo(), (Object)JSON.toJSONString((Object)batchItemStorageReqDto));
        RestResponse batchItemStorageRespDtoRestResponse = this.itemStorageApi.batchOperatingItemStorage(batchItemStorageReqDto);
        RestResponseHelper.checkOrThrow((RestResponse)batchItemStorageRespDtoRestResponse);
    }

    @Override
    public void rollbackVirStock(OrderReqDto orderReqDto) {
        List storageReqDtos = orderReqDto.getOrderItems().stream().map(tradeItem -> {
            ItemStorageReqDto itemStorageReqDto = new ItemStorageReqDto();
            itemStorageReqDto.setBalance(Long.valueOf(tradeItem.getItemNum().intValue()));
            itemStorageReqDto.setOrderNo(orderReqDto.getOrderNo());
            itemStorageReqDto.setShopId(Long.valueOf(tradeItem.getShopId()));
            itemStorageReqDto.setItemType(tradeItem.getItemType());
            itemStorageReqDto.setSkuId(Long.valueOf(tradeItem.getSkuSerial()));
            return itemStorageReqDto;
        }).collect(Collectors.toList());
        BatchItemStorageReqDto batchItemStorageReqDto = new BatchItemStorageReqDto();
        batchItemStorageReqDto.setItemStorageReqDtoList(storageReqDtos);
        batchItemStorageReqDto.setOpt(BatchItemStorageReqDto.ADD);
        logger.info("\u8ba2\u5355\u53f7{},\u56de\u6eda\u865a\u62df\u5e93\u5b58{}", (Object)orderReqDto.getOrderNo(), (Object)JSON.toJSONString((Object)batchItemStorageReqDto));
        RestResponse batchItemStorageRespDtoRestResponse = this.itemStorageApi.batchOperatingItemStorage(batchItemStorageReqDto);
        RestResponseHelper.checkOrThrow((RestResponse)batchItemStorageRespDtoRestResponse);
    }

    @Override
    public void subVirStock(OrderReqDto orderReqDto) {
        List storageReqDtos = orderReqDto.getOrderItems().stream().map(tradeItem -> {
            ItemStorageReqDto itemStorageReqDto = new ItemStorageReqDto();
            itemStorageReqDto.setBalance(Long.valueOf(-Long.valueOf(tradeItem.getItemNum().intValue()).longValue()));
            itemStorageReqDto.setOrderNo(orderReqDto.getOrderNo());
            itemStorageReqDto.setShopId(Long.valueOf(tradeItem.getShopId()));
            itemStorageReqDto.setItemType(tradeItem.getItemType());
            itemStorageReqDto.setSkuId(Long.valueOf(tradeItem.getSkuSerial()));
            return itemStorageReqDto;
        }).collect(Collectors.toList());
        BatchItemStorageReqDto batchItemStorageReqDto = new BatchItemStorageReqDto();
        batchItemStorageReqDto.setItemStorageReqDtoList(storageReqDtos);
        batchItemStorageReqDto.setOpt(BatchItemStorageReqDto.SUB);
        RestResponse batchItemStorageRespDtoRestResponse = this.itemStorageApi.batchOperatingItemStorage(batchItemStorageReqDto);
        RestResponseHelper.checkOrThrow((RestResponse)batchItemStorageRespDtoRestResponse);
    }
}

