/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.service.imkevent;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.biz.marketing.api.davinci.dto.request.EventTriggerReqDto;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IMemberService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.imkevent.AbstractMktEventService;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderEo;
import com.dtyunxi.yundt.imkt.bundle.eventpool.center.member.api.IEventTriggerApi;
import com.dtyunxi.yundt.imkt.bundle.eventpool.center.member.api.dto.request.EventTriggerDto;
import java.util.UUID;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PaidOrderEvent
extends AbstractMktEventService {
    private static final Logger logger = LoggerFactory.getLogger(PaidOrderEvent.class);
    @Resource
    private IMemberService memberService;
    @Resource
    private IEventTriggerApi eventTriggerApi;
    private static final String EVENT_CODE = "paid_order";

    @Override
    Boolean meetCondition(Object object) {
        return true;
    }

    @Override
    void doTriggerEvent(Object object) {
        OrderEo orderEo = (OrderEo)object;
        Long memberId = this.memberService.getMemberId(Long.valueOf(orderEo.getUserId()));
        EventTriggerReqDto eventTriggerReqDto = EventTriggerReqDto.init((String)EVENT_CODE, (Long)memberId, (String)UUID.randomUUID().toString());
        EventTriggerDto eventTriggerDto = new EventTriggerDto();
        eventTriggerDto.setMemberId(memberId);
        eventTriggerDto.setEventCode(EVENT_CODE);
        eventTriggerDto.getExtFields().put("eventMarketingExecDto", JSONObject.toJSONString((Object)eventTriggerReqDto));
        logger.info("\u4f1a\u5458\u4e2d\u5fc3\u4e8b\u4ef6\u6c60 ---> \u5f00\u59cb\u8c03\u7528\u53d1\u9001\u4e8b\u4ef6\u63a5\u53e3\uff0c\u5165\u53c2eventTriggerDto\uff1a{}", (Object)JSONObject.toJSONString((Object)eventTriggerDto));
        RestResponse result = this.eventTriggerApi.handle(eventTriggerDto);
        logger.info("\u4f1a\u5458\u4e2d\u5fc3\u4e8b\u4ef6\u6c60 ---> \u7ed3\u675f\u8c03\u7528\u53d1\u9001\u4e8b\u4ef6\u63a5\u53e3\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)result));
    }
}

