/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.AchievementDetailQueryReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.AchievementDetailReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.AchievementDetailRespDto;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IAchievementDetailService;
import com.dtyunxi.yundt.cube.center.trade.biz.util.BeanUtil;
import com.dtyunxi.yundt.cube.center.trade.dao.das.AchievementDetailDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.AchievementDetailEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AchievementDetailServiceImpl
implements IAchievementDetailService {
    @Resource
    private AchievementDetailDas achievementDetailDas;

    @Override
    public Long addAchievementDetail(AchievementDetailReqDto addReqDto) {
        AchievementDetailEo achievementDetailEo = new AchievementDetailEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)achievementDetailEo);
        this.achievementDetailDas.insert((BaseEo)achievementDetailEo);
        return achievementDetailEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addAchievementDetailList(List<AchievementDetailReqDto> list) {
        List<AchievementDetailEo> eoList = BeanUtil.copyList(list, AchievementDetailEo.class);
        this.achievementDetailDas.insertBatch(eoList);
    }

    @Override
    public void modifyAchievementDetail(AchievementDetailReqDto modifyReqDto) {
        AchievementDetailEo achievementDetailEo = new AchievementDetailEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)achievementDetailEo);
        this.achievementDetailDas.updateSelective((BaseEo)achievementDetailEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeAchievementDetail(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.achievementDetailDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public AchievementDetailRespDto queryById(Long id) {
        AchievementDetailEo achievementDetailEo = (AchievementDetailEo)this.achievementDetailDas.selectByPrimaryKey(id);
        AchievementDetailRespDto achievementDetailRespDto = new AchievementDetailRespDto();
        DtoHelper.eo2Dto((BaseEo)achievementDetailEo, (BaseVo)achievementDetailRespDto);
        return achievementDetailRespDto;
    }

    @Override
    public PageInfo<AchievementDetailRespDto> queryByPage(AchievementDetailQueryReqDto dto, Integer pageNum, Integer pageSize) {
        AchievementDetailEo achievementDetailEo = new AchievementDetailEo();
        DtoHelper.dto2Eo((BaseVo)dto, (BaseEo)achievementDetailEo);
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        if (StringUtils.isNotBlank((CharSequence)dto.getOrderNo())) {
            sqlFilters.add(SqlFilter.like((String)"order_no", (Object)("%" + dto.getOrderNo() + "%")));
        }
        if (StringUtils.isNotBlank((CharSequence)String.valueOf(dto.getAchievementType()))) {
            sqlFilters.add(SqlFilter.eq((String)"achievement_type", (Object)dto.getAchievementType()));
        }
        if (dto.getStartTime() != null) {
            sqlFilters.add(SqlFilter.ge((String)"update_time", (Object)dto.getStartTime()));
        }
        if (dto.getEndTime() != null) {
            sqlFilters.add(SqlFilter.le((String)"update_time", (Object)dto.getEndTime()));
        }
        if (StringUtils.isNotBlank((CharSequence)String.valueOf(dto.getSourceOrderType()))) {
            sqlFilters.add(SqlFilter.eq((String)"source_order_type", (Object)dto.getSourceOrderType()));
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getShopName())) {
            sqlFilters.add(SqlFilter.eq((String)"shop_name", (Object)dto.getShopName()));
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getOrgCode())) {
            sqlFilters.add(SqlFilter.eq((String)"org_code", (Object)dto.getOrgCode()));
        }
        achievementDetailEo.setSqlFilters(sqlFilters);
        achievementDetailEo.setOrderByDesc("update_time");
        PageInfo eoPageInfo = this.achievementDetailDas.selectPage((BaseEo)achievementDetailEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, AchievementDetailRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }
}

