/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.constants.ComConstants;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.data.api.dto.DictDto;
import com.dtyunxi.yundt.cube.center.data.api.query.IDictQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.CargoRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.enums.DeliveryStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.query.ICargoQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.constants.DeliverMergeTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.IfMergeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.OnOffEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.OrderSettingEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.DeliveryMergeReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderSettingRespDto;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.utils.TradeUtil;
import com.dtyunxi.yundt.cube.center.trade.biz.mq.producer.DeliveryProducer;
import com.dtyunxi.yundt.cube.center.trade.biz.mq.vo.DeliveryMergeVo;
import com.dtyunxi.yundt.cube.center.trade.biz.mq.vo.DeliveryVo;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IDeliveryMergeService;
import com.dtyunxi.yundt.cube.center.trade.dao.das.DeliveryItemDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.OrderDeliveryDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.RefDeliveryOrderDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.DeliveryItemEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderDeliveryEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.RefDeliveryOrderEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.StdDeliveryItemEo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DeliveryMergeServiceImpl
implements IDeliveryMergeService {
    private static Logger logger = LoggerFactory.getLogger(DeliveryMergeServiceImpl.class);
    @Autowired
    private IDictQueryApi dictQueryApi;
    @Autowired
    private OrderDeliveryDas orderDeliveryDas;
    @Autowired
    private DeliveryItemDas deliveryItemDas;
    @Autowired
    private RefDeliveryOrderDas refDeliveryOrderDas;
    @Autowired
    private ICargoQueryApi cargoQueryApi;
    @Autowired
    private DeliveryProducer deliveryProducer;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void manualMerge(DeliveryMergeReqDto deliveryMergeReqDto) {
        DeliverMergeTypeEnum deliverMergeTypeEnum = DeliverMergeTypeEnum.getDeliverMergeTypeEnum((Integer)deliveryMergeReqDto.getMergeType());
        logger.info("\u5f00\u59cb\u8fdb\u884c\u53d1\u8d27\u5355\u5408\u5e76\uff0c\u5408\u5e76\u7c7b\u578b\uff1a{}\uff0c\u8bf7\u6c42\u5165\u53c2\uff1a{}", (Object)deliverMergeTypeEnum.getDesc(), (Object)JSONObject.toJSONString((Object)deliveryMergeReqDto));
        DeliveryMergeVo deliveryMergeVo = new DeliveryMergeVo();
        DeliveryVo deliveryVo = new DeliveryVo();
        ArrayList<DeliveryItemEo> deliveryItems = new ArrayList<DeliveryItemEo>();
        ArrayList<RefDeliveryOrderEo> refDeliveryOrders = new ArrayList<RefDeliveryOrderEo>();
        ArrayList<DeliveryMergeVo.DeliveryOld> deliveryOlds = new ArrayList<DeliveryMergeVo.DeliveryOld>();
        List deliverNos = deliveryMergeReqDto.getDeliverNos();
        List<OrderDeliveryEo> orderDeliveryEos = deliverNos.stream().map(no -> {
            OrderDeliveryEo eo = new OrderDeliveryEo();
            eo.setDeliveryNo(no);
            return (OrderDeliveryEo)this.orderDeliveryDas.selectOne((BaseEo)eo);
        }).collect(Collectors.toList());
        boolean res = this.checkMergeData(orderDeliveryEos);
        if (!res) {
            logger.info("\u68c0\u9a8c\u5408\u5e76\u6570\u636e\u4e0d\u5408\u89c4\u5219\uff0c\u4e0d\u8fdb\u884c\u5408\u5e76\u3002");
            return;
        }
        OrderDeliveryEo mergeOrderDeliveryEo = new OrderDeliveryEo();
        CubeBeanUtils.copyProperties((Object)mergeOrderDeliveryEo, (Object)orderDeliveryEos.get(0), (String[])new String[]{"id", "createTime", "updateTime"});
        mergeOrderDeliveryEo.setIfMerge(IfMergeEnum.YES_MERGE.getCode());
        mergeOrderDeliveryEo.setDeliveryNo(TradeUtil.generateTradeNo());
        this.buildPriceSum(orderDeliveryEos, mergeOrderDeliveryEo);
        mergeOrderDeliveryEo.setDeliveryStatus(DeliveryStatusEnum.TO_CONFIRM.getStatus());
        this.orderDeliveryDas.insert((BaseEo)mergeOrderDeliveryEo);
        orderDeliveryEos.stream().forEach(eo -> {
            DeliveryItemEo deliveryItemEo = new DeliveryItemEo();
            deliveryItemEo.setDeliveryNo(eo.getDeliveryNo());
            List mergeDeliveryItemEos = this.deliveryItemDas.select((BaseEo)deliveryItemEo);
            mergeDeliveryItemEos.stream().forEach(mergeEo -> {
                mergeEo.setDeliveryNo(mergeOrderDeliveryEo.getDeliveryNo());
                mergeEo.setDeliveryType("MERGE");
                mergeEo.setId(null);
                deliveryItems.add((DeliveryItemEo)mergeEo);
                this.deliveryItemDas.insert((BaseEo)mergeEo);
            });
            RefDeliveryOrderEo mergeRefDeliveryOrderEo = new RefDeliveryOrderEo();
            mergeRefDeliveryOrderEo.setDeliveryNo(eo.getDeliveryNo());
            List mergeRefDeliveryOrderEos = this.refDeliveryOrderDas.select((BaseEo)mergeRefDeliveryOrderEo);
            mergeRefDeliveryOrderEos.stream().forEach(mergeEo -> {
                mergeEo.setDeliveryNo(mergeOrderDeliveryEo.getDeliveryNo());
                mergeEo.setId(null);
                refDeliveryOrders.add((RefDeliveryOrderEo)mergeEo);
                this.refDeliveryOrderDas.insert((BaseEo)mergeEo);
            });
            OrderDeliveryEo orderDeliveryUpdate = OrderDeliveryEo.newInstance();
            orderDeliveryUpdate.setId(eo.getId());
            orderDeliveryUpdate.setDeliveryStatus(DeliveryStatusEnum.CANCELED.getStatus());
            orderDeliveryUpdate.setCancelDesc("\u53d1\u8d27\u5355\u5408\u5355\u53d6\u6d88");
            this.orderDeliveryDas.updateSelective((BaseEo)orderDeliveryUpdate);
            logger.info("\u53d6\u6d88\u7236\u53d1\u8d27\u5355\uff1a{}", (Object)eo.getDeliveryNo());
            DeliveryMergeVo.DeliveryOld deliveryOld = new DeliveryMergeVo.DeliveryOld();
            CubeBeanUtils.copyProperties((Object)deliveryOld, (Object)eo, (String[])new String[0]);
            deliveryOlds.add(deliveryOld);
        });
        deliveryVo.setOrderDelivery(mergeOrderDeliveryEo);
        deliveryVo.setDeliveryItems(deliveryItems);
        deliveryVo.setRefDeliveryOrders(refDeliveryOrders);
        deliveryMergeVo.setDeliveryMerge(deliveryVo);
        deliveryMergeVo.setDeliveryOlds(deliveryOlds);
        this.deliveryProducer.sendInventoryDeliveryMerge(deliveryMergeVo);
        logger.info("\u53d1\u8d27\u5355\u5408\u5e76\u53d1\u9001\u5230\u5e93\u5b58\u4e2d\u5fc3\uff0cdeliveryMergeVo\uff1a{}", (Object)JSON.toJSONString((Object)deliveryMergeVo));
    }

    private boolean checkMergeData(List<OrderDeliveryEo> deliveryList) {
        String deliveryName = deliveryList.get(0).getDeliveryName();
        String deliveryMobile = deliveryList.get(0).getDeliveryMobile();
        String address = deliveryList.get(0).getAddress();
        String shopCode = deliveryList.get(0).getShopCode();
        for (OrderDeliveryEo orderDeliveryEo : deliveryList) {
            if (StringUtils.isEmpty((String)orderDeliveryEo.getDeliveryName())) {
                logger.info("\u6536\u8d27\u4eba\u540d\u5b57\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u4e0d\u8fdb\u884c\u5408\u5355");
                return false;
            }
            if (StringUtils.isEmpty((String)orderDeliveryEo.getDeliveryMobile())) {
                logger.info("\u6536\u8d27\u4eba\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u4e0d\u8fdb\u884c\u5408\u5355");
                return false;
            }
            if (StringUtils.isEmpty((String)orderDeliveryEo.getAddress())) {
                logger.info("\u6536\u8d27\u4eba\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u4e0d\u8fdb\u884c\u5408\u5355");
                return false;
            }
            if (StringUtils.isEmpty((String)orderDeliveryEo.getShopCode())) {
                logger.info("\u53d1\u8d27\u5355\u6240\u5c5e\u5e97\u94fa\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u4e0d\u8fdb\u884c\u5408\u5355");
                return false;
            }
            if (!deliveryName.equals(orderDeliveryEo.getDeliveryName())) {
                logger.info("\u53d1\u8d27\u5355\u6536\u8d27\u4eba\u540d\u79f0\u4e0d\u4e00\u81f4\uff0c\u4e0d\u8fdb\u884c\u5408\u5355");
                return false;
            }
            if (!deliveryMobile.equals(orderDeliveryEo.getDeliveryMobile())) {
                logger.info("\u53d1\u8d27\u5355\u6536\u8d27\u4eba\u624b\u673a\u53f7\u4e0d\u4e00\u81f4\uff0c\u4e0d\u8fdb\u884c\u5408\u5355");
                return false;
            }
            if (!address.equals(orderDeliveryEo.getAddress())) {
                logger.info("\u53d1\u8d27\u5355\u6536\u8d27\u4eba\u5730\u5740\u4e0d\u4e00\u81f4\uff0c\u4e0d\u8fdb\u884c\u5408\u5355");
                return false;
            }
            if (shopCode.equals(orderDeliveryEo.getShopCode())) continue;
            logger.info("\u53d1\u8d27\u5355\u6536\u8d27\u4eba\u5730\u5740\u4e0d\u4e00\u81f4\uff0c\u4e0d\u8fdb\u884c\u5408\u5355");
            return false;
        }
        return true;
    }

    @Override
    public void autoMerge(DeliveryMergeReqDto deliveryMergeReqDto) {
        boolean flag = this.checkValidate(this.getDeliveryAutoMergeSetting(), deliveryMergeReqDto);
        if (!flag) {
            logger.info("\u4e0d\u7b26\u5408\u81ea\u52a8\u5408\u5e76\u53d1\u8d27\u5355\u8bbe\u7f6e\uff0c\u4e0d\u8fdb\u884c\u5408\u5e76\u53d1\u8d27\u5355");
        } else {
            this.manualMerge(deliveryMergeReqDto);
        }
    }

    private boolean checkValidate(OrderSettingRespDto.DeliveryAutoMergeSettingDto deliveryAutoMergeSetting, DeliveryMergeReqDto deliveryMergeReqDto) {
        List mergeDeliveryItemEos;
        DeliveryItemEo deliveryItemEo;
        List deliverNos = deliveryMergeReqDto.getDeliverNos();
        if (OnOffEnum.ON.getValue().equalsIgnoreCase(deliveryAutoMergeSetting.getMergeItemNumLimitSwitch())) {
            BigDecimal itemNumSum = new BigDecimal(0);
            for (String no : deliverNos) {
                deliveryItemEo = new DeliveryItemEo();
                deliveryItemEo.setDeliveryNo(no);
                mergeDeliveryItemEos = this.deliveryItemDas.select((BaseEo)deliveryItemEo);
                for (DeliveryItemEo mergeDeliveryItemEo : mergeDeliveryItemEos) {
                    itemNumSum = itemNumSum.add(BigDecimal.valueOf(mergeDeliveryItemEo.getItemNum().intValue()));
                }
            }
            if (0 > deliveryAutoMergeSetting.getMergeItemNumLimit().compareTo(itemNumSum)) {
                return false;
            }
        }
        if (OnOffEnum.ON.getValue().equalsIgnoreCase(deliveryAutoMergeSetting.getMergeWeightLimitSwitch())) {
            BigDecimal weightLimitSum = new BigDecimal(0);
            for (String no : deliverNos) {
                deliveryItemEo = new DeliveryItemEo();
                deliveryItemEo.setDeliveryNo(no);
                mergeDeliveryItemEos = this.deliveryItemDas.select((BaseEo)deliveryItemEo);
                for (DeliveryItemEo mergeDeliveryItemEo : mergeDeliveryItemEos) {
                    CargoRespDto cargoRespDto;
                    String cargoCode = mergeDeliveryItemEo.getCargoSerial();
                    if (!StringUtils.isNotBlank((String)cargoCode) || null == (cargoRespDto = (CargoRespDto)RestResponseHelper.extractData((RestResponse)this.cargoQueryApi.queryByCode(cargoCode, null))).getQuantity()) continue;
                    weightLimitSum = weightLimitSum.add(cargoRespDto.getQuantity());
                }
            }
            if (0 > deliveryAutoMergeSetting.getMergeWeightLimit().compareTo(weightLimitSum)) {
                return false;
            }
        }
        if (OnOffEnum.ON.getValue().equalsIgnoreCase(deliveryAutoMergeSetting.getNotMergeSkuSwitch())) {
            String[] skuCodeArr = deliveryAutoMergeSetting.getNotMergeSkuCodes().split(",");
            for (String deliverNo : deliverNos) {
                deliveryItemEo = new DeliveryItemEo();
                deliveryItemEo.setDeliveryNo(deliverNo);
                List skuCodes = this.deliveryItemDas.select((BaseEo)deliveryItemEo).stream().map(StdDeliveryItemEo::getSkuCode).collect(Collectors.toList());
                if (Collections.disjoint(Arrays.asList(skuCodeArr), skuCodes)) continue;
                logger.info("\u5305\u542b\u4e86\u8bbe\u7f6e\u4e0d\u5408\u5e76\u7684sku\u7f16\u7801\uff0c\u4e0d\u8fdb\u884c\u5408\u5e76\u53d1\u8d27\u5355");
                return false;
            }
        }
        return true;
    }

    private void buildPriceSum(List<OrderDeliveryEo> orderDeliveryEos, OrderDeliveryEo mergeOrderDeliveryEo) {
        orderDeliveryEos.stream().skip(1L).forEach(eo -> {
            mergeOrderDeliveryEo.setTotalAmount((null != mergeOrderDeliveryEo.getTotalAmount() ? mergeOrderDeliveryEo.getTotalAmount() : BigDecimal.ZERO).add(null != eo.getTotalAmount() ? eo.getTotalAmount() : BigDecimal.ZERO));
            mergeOrderDeliveryEo.setItemAmount((null != mergeOrderDeliveryEo.getItemAmount() ? mergeOrderDeliveryEo.getItemAmount() : BigDecimal.ZERO).add(null != eo.getItemAmount() ? eo.getItemAmount() : BigDecimal.ZERO));
            mergeOrderDeliveryEo.setDiscountAmount((null != mergeOrderDeliveryEo.getDiscountAmount() ? mergeOrderDeliveryEo.getDiscountAmount() : BigDecimal.ZERO).add(null != eo.getDiscountAmount() ? eo.getDiscountAmount() : BigDecimal.ZERO));
            mergeOrderDeliveryEo.setFreightAmount((null != mergeOrderDeliveryEo.getFreightAmount() ? mergeOrderDeliveryEo.getFreightAmount() : BigDecimal.ZERO).add(null != eo.getFreightAmount() ? eo.getFreightAmount() : BigDecimal.ZERO));
            mergeOrderDeliveryEo.setArAmount((null != mergeOrderDeliveryEo.getArAmount() ? mergeOrderDeliveryEo.getArAmount() : BigDecimal.ZERO).add(null != eo.getArAmount() ? eo.getArAmount() : BigDecimal.ZERO));
            mergeOrderDeliveryEo.setGotAmount((null != mergeOrderDeliveryEo.getGotAmount() ? mergeOrderDeliveryEo.getGotAmount() : BigDecimal.ZERO).add(null != eo.getGotAmount() ? eo.getGotAmount() : BigDecimal.ZERO));
        });
    }

    @Override
    public OrderSettingRespDto.DeliveryAutoMergeSettingDto getDeliveryAutoMergeSetting() {
        DictDto dictDto = (DictDto)this.dictQueryApi.queryByGroupCodeAndCode(ComConstants.TENANT, OrderSettingEnum.DELIVERY_AUTO_MERGE_SETTING.getGroupCode(), OrderSettingEnum.DELIVERY_AUTO_MERGE_SETTING.getCode()).getData();
        if (null == dictDto) {
            logger.info("\u53d1\u8d27\u5355\u81ea\u52a8\u5408\u5e76\u672a\u8bbe\u7f6e\uff01");
            return null;
        }
        String autoMergeSettingJson = dictDto.getValue();
        if (StringUtils.isBlank((String)autoMergeSettingJson)) {
            logger.info("\u53d1\u8d27\u5355\u81ea\u52a8\u5408\u5e76\u672a\u8bbe\u7f6e\uff0c\u83b7\u53d6\u7684json\u6570\u636e\u4e3a\u7a7a\uff01");
            return null;
        }
        OrderSettingRespDto.DeliveryAutoMergeSettingDto deliveryAutoMergeSettingDto = (OrderSettingRespDto.DeliveryAutoMergeSettingDto)JSON.parseObject((String)autoMergeSettingJson, OrderSettingRespDto.DeliveryAutoMergeSettingDto.class);
        return deliveryAutoMergeSettingDto;
    }
}

