/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.delivery.FactoryDeliveryOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IDeliveryOrderService;
import com.dtyunxi.yundt.cube.center.trade.dao.das.DeliveryOrderDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.DeliveryOrderEo;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeliveryOrderServiceImpl
implements IDeliveryOrderService {
    @Resource
    private DeliveryOrderDas deliveryOrderDas;
    @Autowired
    private ICacheService cacheService;

    @Override
    public FactoryDeliveryOrderRespDto queryDeliveryByOrderNo(String orderNo) {
        FactoryDeliveryOrderRespDto factoryDeliveryOrderRespDto = null;
        if (StringUtils.isBlank((CharSequence)orderNo)) {
            return factoryDeliveryOrderRespDto;
        }
        factoryDeliveryOrderRespDto = (FactoryDeliveryOrderRespDto)this.cacheService.getCache("FACTORY_DELIVERY:" + orderNo, FactoryDeliveryOrderRespDto.class);
        if (factoryDeliveryOrderRespDto == null) {
            DeliveryOrderEo deliveryOrderEo = new DeliveryOrderEo();
            deliveryOrderEo.setOrderNo(orderNo);
            deliveryOrderEo = (DeliveryOrderEo)this.deliveryOrderDas.selectOne((BaseEo)deliveryOrderEo);
            if (deliveryOrderEo != null) {
                factoryDeliveryOrderRespDto = new FactoryDeliveryOrderRespDto();
                DtoHelper.eo2Dto((BaseEo)deliveryOrderEo, (BaseVo)factoryDeliveryOrderRespDto);
                this.cacheService.setCache("FACTORY_DELIVERY:" + orderNo, (Object)factoryDeliveryOrderRespDto, 86400);
            }
        }
        return factoryDeliveryOrderRespDto;
    }
}

