/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.constants.ComConstants;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.data.api.dto.DictDto;
import com.dtyunxi.yundt.cube.center.data.api.query.IDictQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.DeliveryChangeReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.OrderRouteRuleRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.WarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.enums.DeliveryRouteOptEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.enums.DeliveryStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.enums.WarehouseSubTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.query.DeliveryRouteQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.query.IWarehouseQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemBusTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.CycleBuyEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.EnableEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.OrderSettingEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.ShippingTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderSettingRespDto;
import com.dtyunxi.yundt.cube.center.trade.biz.mq.producer.DeliveryProducer;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IDeliveryRouterService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IDeliveryService;
import com.dtyunxi.yundt.cube.center.trade.dao.das.OrderDeliveryDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderDeliveryEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderEo;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.OrderDeliveryCreateBo;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.OrderDeliveryStatusBo;
import java.util.Arrays;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeliveryRouterServiceImpl
implements IDeliveryRouterService {
    private static Logger logger = LoggerFactory.getLogger(DeliveryRouterServiceImpl.class);
    @Autowired
    private DeliveryRouteQueryApi deliveryRouteQueryApi;
    @Resource
    private IWarehouseQueryApi warehouseQueryApi;
    @Autowired
    private IDictQueryApi dictQueryApi;
    @Resource
    private IDeliveryService deliveryService;
    @Resource
    private DeliveryProducer deliveryProducer;
    @Resource
    private OrderDeliveryDas orderDeliveryDas;

    @Override
    public OrderDeliveryStatusBo reRouterDelivery(OrderDeliveryStatusBo orderDeliveryBo) {
        OrderDeliveryEo orderDeliveryEo = orderDeliveryBo.getOrderDeliveryEo();
        orderDeliveryBo.setPreStatus(orderDeliveryEo.getDeliveryStatus());
        logger.info("\u8def\u7531\u5931\u8d25\uff08\u7cfb\u7edf\u539f\u56e0\uff0c\u5176\u4ed6\u539f\u56e0\uff09\uff0c\u8fd0\u8425\u91cd\u65b0\u8def\u7531,deliveryNo:{}", (Object)orderDeliveryEo.getOrderNo());
        orderDeliveryEo.clearWarehouse();
        orderDeliveryBo.setOptCode(DeliveryRouteOptEnum.RE_ROUTE.getOptCode());
        logger.info("\u53d1\u8d27\u5355\u8fd0\u8425\u91cd\u65b0\u8def\u7531\u6210\u529f\uff0c\u72b6\u6001\u66f4\u65b0\u4e3a\u5f85\u8def\u7531\u72b6\u6001,deliveryNo:{}, warehouseCode:{}", (Object)orderDeliveryEo.getDeliveryNo(), (Object)orderDeliveryEo.getWarehouseCode());
        return orderDeliveryBo;
    }

    @Override
    public void forceReRouterDelivery(String deliveryNo) {
        logger.info("\u5f3a\u5236\u8fdb\u884c\u53d1\u8d27\u5355\u8def\u7531\uff0cdeliveryNo\uff1a{}", (Object)deliveryNo);
        OrderDeliveryEo orderDeliveryEo = this.deliveryService.getOrderDeliveryByDeliveryNo(deliveryNo);
        OrderDeliveryEo orderDeliveryUpdate = OrderDeliveryEo.newInstance();
        orderDeliveryUpdate.setId(orderDeliveryEo.getId());
        orderDeliveryUpdate.setDeliveryStatus(DeliveryStatusEnum.TO_ROUTE.getStatus());
        this.orderDeliveryDas.updateSelective((BaseEo)orderDeliveryUpdate);
        DeliveryChangeReqDto deliveryChangeReqDto = new DeliveryChangeReqDto();
        deliveryChangeReqDto.setDeliveryNo(orderDeliveryEo.getDeliveryNo());
        deliveryChangeReqDto.setDeliveryStatus(orderDeliveryEo.getDeliveryStatus());
        deliveryChangeReqDto.setOptCode(DeliveryRouteOptEnum.RE_ROUTE.getOptCode());
        deliveryChangeReqDto.setWarehouseCode(orderDeliveryEo.getWarehouseCode());
        deliveryChangeReqDto.setWarehouseName(orderDeliveryEo.getWarehouseName());
        deliveryChangeReqDto.setPreDeliveryStatus(orderDeliveryEo.getDeliveryStatus());
        deliveryChangeReqDto.setPreWarehouseCode("");
        deliveryChangeReqDto.setPreWarehouseName("");
        deliveryChangeReqDto.setDetailDesc("\u5f3a\u5236\u91cd\u65b0\u8def\u7531");
        logger.info("\u53d1\u8d27\u5355\u5f3a\u5236\u91cd\u65b0\u8def\u7531\uff0c\u540c\u6b65\u6d88\u606f\u7ed9\u5e93\u5b58\u4e2d\u5fc3{}\u5f53\u524d\u64cd\u4f5c{},\u72b6\u6001{}", new Object[]{orderDeliveryEo.getDeliveryNo(), DeliveryRouteOptEnum.RE_ROUTE.getOptDesc(), orderDeliveryEo.getDeliveryStatus()});
        this.deliveryProducer.sendInventoryDeliveryChange(deliveryChangeReqDto);
        logger.info("\u53d1\u9001\u64cd\u4f5c{}\uff0c\u6210\u529f\uff0cDeliveryChangeReqDto:{}", (Object)JSON.toJSONString((Object)deliveryChangeReqDto));
    }

    @Override
    public Boolean checkIfNeedRoute(OrderDeliveryCreateBo orderDeliveryBo) {
        OrderEo orderEo = orderDeliveryBo.getOrderEo();
        OrderDeliveryEo orderDeliveryEo = orderDeliveryBo.getOrderDeliveryEo();
        return this.checkRouterConfigOpen(orderEo, orderDeliveryEo);
    }

    @Override
    public Boolean checkRouterConfigOpen(OrderEo orderEo, OrderDeliveryEo orderDeliveryEo) {
        DictDto dictDto = (DictDto)this.dictQueryApi.queryByGroupCodeAndCode(ComConstants.TENANT, "DELIVERY_SETTING", "DELIVERY_IF_ROUTE_SETTING").getData();
        if (null == dictDto) {
            logger.info("\u8ba2\u5355\u8def\u7531\u672a\u914d\u7f6e\uff0c\u4e0d\u9700\u8981\u8def\u7531\u3002");
            return false;
        }
        if (!EnableEnum.ENABLE.getCodeEn().equals(dictDto.getValue())) {
            logger.info("\u8ba2\u5355\u8def\u7531\u5df2\u914d\u7f6e\uff0c\u4f46\u672a\u542f\u7528\uff0c\u4e0d\u9700\u8981\u8def\u7531\u3002");
            return false;
        }
        if (ItemBusTypeEnum.COMMUNITY_GROUP_BY.getType().equals(orderEo.getBusType()) || ItemBusTypeEnum.INTEGRAL.getType().equals(orderEo.getBusType())) {
            logger.info("\u4e1a\u52a1\u7c7b\u578b\u4e3a\u793e\u533a\u56e2\u8d2d\u3001\u79ef\u5206\u8d2d\uff0c\u4e0d\u9700\u8981\u8def\u7531\u3002");
            return false;
        }
        if (CycleBuyEnum.IS_CYCLE_BUY.getType().equals(orderEo.getIsCycleBuy())) {
            logger.info("\u5468\u671f\u8d2d\u8ba2\u5355\u4e0d\u9700\u8981\u8def\u7531\u3002");
            return false;
        }
        if (ShippingTypeEnum.PICKUP.getType().equals(orderDeliveryEo.getShippingType())) {
            logger.info("\u8ba2\u5355\u914d\u9001\u65b9\u5f0f\u4e3a\u4e0a\u95e8\u81ea\u63d0\uff0c\u4e0d\u9700\u8981\u8def\u7531\u3002");
            return false;
        }
        OrderRouteRuleRespDto orderRouteRule = (OrderRouteRuleRespDto)this.deliveryRouteQueryApi.queryOrderRouteRule(orderDeliveryEo.getChannel()).getData();
        if (null == orderRouteRule) {
            logger.info("\u8ba2\u5355\u8def\u7531\u89c4\u5219\u6ca1\u914d\u7f6e\uff0c\u4e0d\u9700\u8981\u8def\u7531\u3002");
            return false;
        }
        return true;
    }

    @Override
    public Boolean checkIfNeedReceive(OrderDeliveryCreateBo orderDeliveryBo) {
        String shippingType = orderDeliveryBo.getShippingType();
        if (Arrays.asList(ShippingTypeEnum.INTRA_CITY.getType(), ShippingTypeEnum.PICKUP.getType()).contains(shippingType)) {
            if (orderDeliveryBo.getAutoReceive().booleanValue()) {
                return false;
            }
            return true;
        }
        String warehouseCode = orderDeliveryBo.getOrderDeliveryEo().getWarehouseCode();
        if (StringUtils.isEmpty((CharSequence)warehouseCode)) {
            logger.warn("\u53d1\u8d27\u5355\u627e\u4e0d\u5bf9\u5e94\u7684\u4ed3\u5e93\u4fe1\u606f\uff0c\u4e0d\u8fdb\u884c\u63a5\u5355\u64cd\u4f5c\u3002");
            return false;
        }
        WarehouseRespDto warehouse = (WarehouseRespDto)this.warehouseQueryApi.queryWarehouseByCode(warehouseCode, null).getData();
        if (null == warehouse) {
            logger.warn("\u53d1\u8d27\u5355\u6839\u636e\u4ed3\u5e93\u7f16\u7801\uff1a{}\u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u7684\u4ed3\u5e93\u4fe1\u606f\uff0c\u4e0d\u8fdb\u884c\u63a5\u5355\u64cd\u4f5c\u3002", (Object)warehouseCode);
            return false;
        }
        if (Integer.valueOf(WarehouseSubTypeEnum.LOGICAL_SHOP_WAREHOUSE.getCode()).equals(warehouse.getSubType())) {
            return true;
        }
        return false;
    }

    @Override
    public int getDeliveryConfirmMin() {
        DictDto dictDto = (DictDto)this.dictQueryApi.queryByGroupCodeAndCode(ComConstants.TENANT, OrderSettingEnum.DELIVERY_SETTING.getGroupCode(), OrderSettingEnum.DELIVERY_SETTING.getCode()).getData();
        if (null == dictDto || StringUtils.isEmpty((CharSequence)dictDto.getValue()) || "null".equalsIgnoreCase(dictDto.getValue())) {
            logger.info("\u53d1\u8d27\u5355\u8bbe\u7f6e\u672a\u914d\u7f6e\u786e\u8ba4\u65f6\u95f4\uff0c\u9ed8\u8ba430\u5206\u949f\u3002");
            return 30;
        }
        OrderSettingRespDto.DeliverySettingDto deliverySettingDto = (OrderSettingRespDto.DeliverySettingDto)JSON.parseObject((String)dictDto.getValue(), OrderSettingRespDto.DeliverySettingDto.class);
        Integer weightConfirmMinute = deliverySettingDto.getWeightConfirmMinute();
        logger.info("\u53d1\u8d27\u5355\u8bbe\u7f6e\u914d\u7f6e\u786e\u8ba4\u65f6\u95f4\u4e3a\uff1a{}min", (Object)weightConfirmMinute);
        return null == weightConfirmMinute ? 30 : weightConfirmMinute;
    }
}

