/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.enhance.flow.IFlowEntity;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.connector.core.api.dto.LogisticsOfflineReqDto;
import com.dtyunxi.yundt.connector.core.api.dto.response.LogisticsCompanyRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.DeliveryRouteApi;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.CargoStorageCheckItemReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.CargoStorageCheckReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.DeliveryChangeReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.DeliveryRouteCountReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.CargoRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.OrderRouteRuleRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.WarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.enums.DeliveryRouteOptEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.enums.DeliveryStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.enums.RouteTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.enums.WarehouseSubTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.enums.WarehouseTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.query.DeliveryRouteQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.query.ICargoQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.query.IWarehouseCargoQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.query.IWarehouseQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopTransportPartnerDto;
import com.dtyunxi.yundt.cube.center.shop.api.enums.TransportPartnerEnum;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.constants.DeliverStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.DeliveryCancelTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.DeliveryRejectReasonEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.EnableEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.NumberConstant;
import com.dtyunxi.yundt.cube.center.trade.api.constants.SaleChannelEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.ShippingChannelEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.ShippingCompanyEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.ShippingTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.YesNoEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.DeliveryAssignReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.DeliveryRedistributeReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.DeliveryStoreReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.DeliveryWarehouseReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.DeliverysReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.DistributeSapReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.DistributeWmsReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.ShippingReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.dada.DaDaAddOrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.dada.DaDaFormalCancelReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.dada.DaDaMessageConfirmReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.dada.DaDaOrderCallbackReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.dada.DaDaOrderConfirmGoodsReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.dada.DaDaReAddOrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.dada.DadaCancelOrderDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.dada.PartnerDeliveryLogisticsDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.delivery.DeliveryAddReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.delivery.DeliveryBasicReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.delivery.DeliveryItemBasicReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.delivery.DeliveryPackageAddReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.delivery.DeliveryPackageReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.sf.SfCreateOrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.CancelPartnerDeliveryReasonRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.DeliveryCargoRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.DeliveryLogisticRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.DeliveryOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.DeliveryRecordRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.DeliveryRejectReasonRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.DeliveryRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.DeliverySellerRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.DeliveryShippingRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.DeliverysItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderAddressRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.ShippingRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.dada.DaDaCancelReasonsRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.dada.DaDaCityCodeListRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.dada.DaDaResponse;
import com.dtyunxi.yundt.cube.center.trade.api.utils.SqlFilterBuilder;
import com.dtyunxi.yundt.cube.center.trade.api.vo.OrderDeliverMessageVo;
import com.dtyunxi.yundt.cube.center.trade.api.vo.SalePersonMessageVo;
import com.dtyunxi.yundt.cube.center.trade.biz.constants.OrderDeliveryStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.action.IOrderAction;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.dto.DadaDeliveryBo;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.dto.DeliveryAssignBo;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.dto.OrderDeliveryConfirmBo;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.dto.RecDeliveryStoreBo;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.dto.RedistributePartnerDeliveryStoreBo;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.dto.RejectDeliveryStoreBo;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.dto.UnDeliveryStoreBo;
import com.dtyunxi.yundt.cube.center.trade.biz.mq.producer.ConnectorDeliveryProducer;
import com.dtyunxi.yundt.cube.center.trade.biz.mq.producer.DeliveryProducer;
import com.dtyunxi.yundt.cube.center.trade.biz.mq.producer.PerformanceProducer;
import com.dtyunxi.yundt.cube.center.trade.biz.mq.vo.DeliveryVo;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IChannelService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IDeliveryItemService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IDeliveryRecordService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IDeliveryRouterService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IDeliveryService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderAddressService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderDeliveryService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IShippingService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.ITradeConfQueryService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.dada.IDaDaLogisticsService;
import com.dtyunxi.yundt.cube.center.trade.biz.util.BeanUtil;
import com.dtyunxi.yundt.cube.center.trade.biz.util.DaDaLogisticsUtils;
import com.dtyunxi.yundt.cube.center.trade.dao.das.DeliveryItemDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.DeliveryLogisticsDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.DeliverySellerDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.DeliverySenderDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.OrderDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.OrderDeliveryDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.PackageItemDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.RefDeliveryOrderDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.ChannelEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.DeliveryItemEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.DeliverySellerEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.DeliverySenderEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderDeliveryEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.PackageItemEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.RefDeliveryOrderEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.StdChannelEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.StdDeliveryItemEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.StdOrderDeliveryEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.StdRefDeliveryOrderEo;
import com.dtyunxi.yundt.cube.center.trade.engine.TradeEngine;
import com.dtyunxi.yundt.cube.center.trade.ext.api.dto.request.OrderDeliveryExtReqDto;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.OrderDeliveryStatusBo;
import com.dtyunxi.yundt.cube.connector.api.ILogisticsCompanyApi;
import com.dtyunxi.yundt.cube.connector.api.IOrderApi;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DeliveryServiceImpl
implements IDeliveryService {
    private static Logger logger = LoggerFactory.getLogger(DeliveryServiceImpl.class);
    @Resource
    private IChannelService channelService;
    @Autowired
    private OrderDeliveryDas orderDeliveryDas;
    @Autowired
    private RefDeliveryOrderDas refDeliveryOrderDas;
    @Autowired
    private DeliveryItemDas deliveryItemDas;
    @Autowired
    private DeliverySellerDas deliverySellerDas;
    @Autowired
    private DeliverySenderDas deliverySenderDas;
    @Autowired
    private PackageItemDas packageItemDas;
    @Resource
    private IOrderService orderService;
    @Autowired
    private IShippingService shippingService;
    @Autowired
    private ConnectorDeliveryProducer connectorDeliveryProducer;
    @Resource
    private IWarehouseQueryApi warehouseQueryApi;
    @Resource
    private ICacheService commonCacheService;
    @Resource
    private IOrderAction orderAction;
    @Autowired
    private DeliveryProducer deliveryProducer;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private PerformanceProducer performanceProducer;
    @Resource
    private DeliveryRouteQueryApi deliveryRouteQueryApi;
    @Autowired
    private IDeliveryItemService deliveryItemService;
    @Resource
    private IWarehouseCargoQueryApi warehouseCargoQueryApi;
    @Resource
    private ICargoQueryApi cargoQueryApi;
    @Resource
    private IDeliveryRecordService deliveryRecordService;
    @Resource
    private IDaDaLogisticsService daDaLogisticsService;
    @Resource
    private IShopQueryApi shopQueryApi;
    @Resource
    private DeliveryLogisticsDas deliveryLogisticsDas;
    @Resource
    private IOrderAddressService orderAddressService;
    @Resource
    private IOrderApi connectorOrderApi;
    @Resource
    private OrderDas orderDas;
    @Resource
    private ILogisticsCompanyApi logisticsCompanyApi;
    @Resource
    private Environment environment;
    @Resource
    private IOrderDeliveryService orderDeliveryService;
    @Resource
    private ITradeConfQueryService tradeConfQueryService;
    @Resource
    private DeliveryRouteApi deliveryRouteApi;
    @Resource
    private IDeliveryRouterService deliveryRouterService;

    @Override
    public PageInfo<DeliveryRespDto> queryByPage(DeliverysReqDto deliverysReqDto, Integer pageNum, Integer pageSize) {
        List warehouseCodes;
        PageInfo pageInfoDto = new PageInfo();
        pageInfoDto.setPageNum(pageNum.intValue());
        pageInfoDto.setPageSize(pageSize.intValue());
        OrderDeliveryEo record = new OrderDeliveryEo();
        BeanUtils.copyProperties((Object)deliverysReqDto, (Object)record, (String[])new String[]{"orderNo"});
        com.dtyunxi.yundt.cube.center.trade.biz.util.SqlFilterBuilder sqlFilterBuilder = com.dtyunxi.yundt.cube.center.trade.biz.util.SqlFilterBuilder.newInstance();
        if (StringUtils.isNotBlank((CharSequence)deliverysReqDto.getCreateTimeStart()) && StringUtils.isNotBlank((CharSequence)deliverysReqDto.getCreateTimeEnd())) {
            sqlFilterBuilder.buildBetweenSqlFilter("createTime", deliverysReqDto.getCreateTimeStart(), deliverysReqDto.getCreateTimeEnd());
        }
        if (StringUtils.isNotBlank((CharSequence)deliverysReqDto.getDeliveryTimeStart()) && StringUtils.isNotBlank((CharSequence)deliverysReqDto.getDeliveryTimeEnd())) {
            sqlFilterBuilder.buildBetweenSqlFilter("deliveryTime", deliverysReqDto.getDeliveryTimeStart(), deliverysReqDto.getDeliveryTimeEnd());
        }
        if (deliverysReqDto.getArrivalDateStart() != null || deliverysReqDto.getArrivalDateEnd() != null) {
            sqlFilterBuilder.buildNotNullSqlFilter("arrivalDate");
            sqlFilterBuilder.buildBetweenSqlFilter("arrivalDate", deliverysReqDto.getArrivalDateStart(), deliverysReqDto.getArrivalDateEnd());
        }
        if (StringUtils.isNotBlank((CharSequence)deliverysReqDto.getOrderNo()) || StringUtils.isNotBlank((CharSequence)deliverysReqDto.getOriginOrderNo())) {
            List<String> deliveryNoList = this.getDeliveryNos(deliverysReqDto.getOrderNo(), deliverysReqDto.getOriginOrderNo());
            if (CollectionUtils.isEmpty(deliveryNoList)) {
                return pageInfoDto;
            }
            if (StringUtils.isNotBlank((CharSequence)deliverysReqDto.getDeliveryNo()) && !deliveryNoList.contains(deliverysReqDto.getDeliveryNo())) {
                return pageInfoDto;
            }
            sqlFilterBuilder.buildInSqlFilter("deliveryNo", deliveryNoList);
        }
        record.setSqlFilters(sqlFilterBuilder.get());
        record.setOrderByDesc("createTime");
        PageInfo pageInfo = this.orderDeliveryDas.selectPage((BaseEo)record, pageNum, pageSize);
        List list = pageInfo.getList();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return pageInfoDto;
        }
        BeanUtils.copyProperties((Object)pageInfo, (Object)pageInfoDto, (String[])new String[]{"list"});
        ArrayList<DeliveryRespDto> deliveryRespDtos = new ArrayList<DeliveryRespDto>();
        DtoHelper.eoList2DtoList((Collection)list, deliveryRespDtos, DeliveryRespDto.class);
        List<ChannelEo> channelEos = this.channelService.queryByCondition((ChannelEo)SqlFilterBuilder.create(ChannelEo.class).in("code", (Object)StringUtils.join((Iterable)list.stream().map(StdOrderDeliveryEo::getChannel).collect(Collectors.toList()), (String)",")).eo());
        if (CollectionUtils.isNotEmpty(channelEos)) {
            Map<String, String> channelMap = channelEos.stream().collect(Collectors.toMap(StdChannelEo::getCode, StdChannelEo::getName));
            for (DeliveryRespDto deliveryRespDto : deliveryRespDtos) {
                deliveryRespDto.setChannelName(channelMap.get(deliveryRespDto.getChannel()));
            }
        }
        if (CollectionUtils.isNotEmpty(warehouseCodes = deliveryRespDtos.stream().map(DeliveryRespDto::getWarehouseCode).collect(Collectors.toList()))) {
            // empty if block
        }
        this.setItemAndOrder(deliveryRespDtos);
        this.setIfCanSplit(deliveryRespDtos);
        pageInfoDto.setList(deliveryRespDtos);
        return pageInfoDto;
    }

    private void setIfCanSplit(List<DeliveryRespDto> deliveryRespDtos) {
        if (CollectionUtils.isEmpty(deliveryRespDtos)) {
            return;
        }
        deliveryRespDtos.stream().forEach(deliveryRespDto -> {
            List items = deliveryRespDto.getItems();
            deliveryRespDto.setIfCanSplit(YesNoEnum.NO.getValue());
            if (!DeliveryStatusEnum.TO_CONFIRM.getStatus().equals(deliveryRespDto.getDeliveryStatus())) {
                return;
            }
            if (CollectionUtils.isEmpty((Collection)items) || items.size() == 1 && ((DeliverysItemRespDto)items.get(0)).getItemNum() == 1) {
                return;
            }
            if (YesNoEnum.YES.getValue().equals(deliveryRespDto.getIfMerge())) {
                return;
            }
            if (StringUtils.isNotBlank((CharSequence)deliveryRespDto.getParentDeliveryNo()) && !"0".equals(deliveryRespDto.getParentDeliveryNo())) {
                OrderDeliveryEo deliverySelect = OrderDeliveryEo.newInstance();
                deliverySelect.setParentDeliveryNo(deliveryRespDto.getParentDeliveryNo());
                OrderDeliveryEo rootDelivery = this.getRootDelivery(deliverySelect);
                if (rootDelivery.getSplitCount() >= 3) {
                    return;
                }
            }
            deliveryRespDto.setIfCanSplit(YesNoEnum.YES.getValue());
        });
    }

    @Override
    public OrderDeliveryEo getRootDelivery(OrderDeliveryEo orderDelivery) {
        if (StringUtils.isBlank((CharSequence)orderDelivery.getParentDeliveryNo()) || "0".equals(orderDelivery.getParentDeliveryNo())) {
            orderDelivery.setSplitCount(NumberConstant.ZERO_INTEGER);
            return orderDelivery;
        }
        OrderDeliveryEo orderDeliverySelect = OrderDeliveryEo.newInstance();
        orderDeliverySelect.setDeliveryNo(orderDelivery.getParentDeliveryNo());
        OrderDeliveryEo orderDeliveryEo = (OrderDeliveryEo)this.orderDeliveryDas.selectOne((BaseEo)orderDeliverySelect);
        while (StringUtils.isNotBlank((CharSequence)orderDeliveryEo.getParentDeliveryNo()) && !"0".equals(orderDeliveryEo.getParentDeliveryNo())) {
            orderDeliverySelect = OrderDeliveryEo.newInstance();
            orderDeliverySelect.setDeliveryNo(orderDeliveryEo.getParentDeliveryNo());
            orderDeliveryEo = (OrderDeliveryEo)this.orderDeliveryDas.selectOne((BaseEo)orderDeliverySelect);
        }
        if (null == orderDeliveryEo.getSplitCount()) {
            orderDeliveryEo.setSplitCount(NumberConstant.ZERO_INTEGER);
        }
        return orderDeliveryEo;
    }

    private List<String> getDeliveryNos(String orderNo, String originOrderNo) {
        RefDeliveryOrderEo select = new RefDeliveryOrderEo();
        select.setOrderNo(orderNo);
        select.setOriginOrderNo(originOrderNo);
        List refDeliveryOrders = this.refDeliveryOrderDas.select((BaseEo)select);
        if (CollectionUtils.isEmpty((Collection)refDeliveryOrders)) {
            return null;
        }
        List<String> deliveryNos = refDeliveryOrders.stream().map(StdRefDeliveryOrderEo::getDeliveryNo).collect(Collectors.toList());
        return deliveryNos;
    }

    private void setItemAndOrder(List<DeliveryRespDto> deliveryRespDtos) {
        List cargos;
        List deliveryNos = deliveryRespDtos.stream().map(obj -> obj.getDeliveryNo()).collect(Collectors.toList());
        DeliveryItemEo deliveryItemSelect = new DeliveryItemEo();
        ArrayList<SqlFilter> deliveryItemSqlFilters = new ArrayList<SqlFilter>();
        deliveryItemSqlFilters.add(SqlFilter.in((String)"deliveryNo", deliveryNos));
        deliveryItemSelect.setSqlFilters(deliveryItemSqlFilters);
        List deliveryItemEos = this.deliveryItemDas.select((BaseEo)deliveryItemSelect);
        Map<String, List<DeliveryItemEo>> deliveryItemEoMap = deliveryItemEos.stream().collect(Collectors.groupingBy(StdDeliveryItemEo::getDeliveryNo));
        Map<Object, Object> cargoMap = new HashMap();
        List cargoCodes = deliveryItemEos.stream().map(StdDeliveryItemEo::getCargoSerial).filter(Objects::nonNull).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(cargoCodes) && CollectionUtils.isNotEmpty((Collection)(cargos = (List)this.cargoQueryApi.listByCodes(cargoCodes).getData()))) {
            cargoMap = cargos.stream().collect(Collectors.toMap(CargoRespDto::getCode, o -> o));
        }
        RefDeliveryOrderEo refSelect = new RefDeliveryOrderEo();
        ArrayList<SqlFilter> refDeliveryOrderSqlFilters = new ArrayList<SqlFilter>();
        refDeliveryOrderSqlFilters.add(SqlFilter.in((String)"deliveryNo", deliveryNos));
        refSelect.setSqlFilters(refDeliveryOrderSqlFilters);
        List refDeliveryOrderEos = this.refDeliveryOrderDas.select((BaseEo)refSelect);
        Map<String, List<RefDeliveryOrderEo>> refDeliveryOrderEoMap = refDeliveryOrderEos.stream().collect(Collectors.groupingBy(StdRefDeliveryOrderEo::getDeliveryNo));
        for (DeliveryRespDto delivery : deliveryRespDtos) {
            String deliveryNo = delivery.getDeliveryNo();
            List<DeliveryRecordRespDto> deliveryRecordRespDtos = this.deliveryRecordService.getDeliveryRecordsByDeliveryNo(deliveryNo);
            delivery.setDeliveryRecords(deliveryRecordRespDtos);
            Map<Object, Object> finalCargoMap = cargoMap;
            List<DeliveryItemEo> itemEos = deliveryItemEoMap.get(deliveryNo);
            ArrayList deliverysItemDtos = new ArrayList();
            DtoHelper.eoList2DtoList(itemEos, deliverysItemDtos, DeliverysItemRespDto.class);
            deliverysItemDtos.forEach(dto -> {
                CargoRespDto cargoRespDto;
                int deliveredNum = dto.getDeliveredNum() != null ? dto.getDeliveredNum() : 0;
                dto.setUndeliveredNum(Integer.valueOf(dto.getItemNum() - deliveredNum));
                String cargoCode = dto.getCargoSerial();
                if (StringUtils.isNotEmpty((CharSequence)cargoCode) && null != (cargoRespDto = (CargoRespDto)finalCargoMap.get(cargoCode))) {
                    DeliveryCargoRespDto cargo = new DeliveryCargoRespDto();
                    BeanUtils.copyProperties((Object)cargoRespDto, (Object)cargo);
                    dto.setCargo(cargo);
                }
            });
            delivery.setItems(deliverysItemDtos);
            ArrayList deliveryOrderDtos = new ArrayList();
            List<RefDeliveryOrderEo> orderEos = refDeliveryOrderEoMap.get(deliveryNo);
            DtoHelper.eoList2DtoList(orderEos, deliveryOrderDtos, DeliveryOrderRespDto.class);
            for (DeliveryOrderRespDto deliveryOrderDto : deliveryOrderDtos) {
                OrderEo orderEo = this.orderService.getByOrderNo(deliveryOrderDto.getOrderNo());
                BeanUtils.copyProperties((Object)orderEo, (Object)deliveryOrderDto);
                if (!StringUtils.isNotEmpty((CharSequence)orderEo.getDeliveryAddress())) continue;
                deliveryOrderDto.setOrderAddress((OrderAddressRespDto)JSONObject.parseObject((String)orderEo.getDeliveryAddress(), OrderAddressRespDto.class));
            }
            delivery.setOrders(deliveryOrderDtos);
            delivery.setShippingTypeName(ShippingTypeEnum.getShippingTypeName((String)delivery.getShippingType()));
        }
    }

    @Override
    public DeliveryRespDto getDetailByDeliveryNo(String deliveryNo) {
        List deliveryLogisticsEoList;
        OrderDeliveryEo orderDeliverySelect = new OrderDeliveryEo();
        orderDeliverySelect.setDeliveryNo(deliveryNo);
        OrderDeliveryEo orderDelivery = (OrderDeliveryEo)this.orderDeliveryDas.selectOne((BaseEo)orderDeliverySelect);
        if (null == orderDelivery) {
            logger.error("\u627e\u4e0d\u5230\u53d1\u8d27\u5355\u4fe1\u606f\uff0cdeliveryNo:{}", (Object)deliveryNo);
            throw new BizException("\u627e\u4e0d\u5230\u53d1\u8d27\u5355\u4fe1\u606f");
        }
        DeliveryRespDto delivery = new DeliveryRespDto();
        BeanUtils.copyProperties((Object)orderDelivery, (Object)delivery);
        if (StringUtils.isNotBlank((CharSequence)delivery.getPickUpTime()) && delivery.getCreateTime() != null) {
            String pickUpTime = DateUtil.getDateFormat((Date)delivery.getCreateTime(), (String)"yyyy-MM-dd") + " " + delivery.getPickUpTime();
            delivery.setPickUpTime(pickUpTime);
        }
        ArrayList<DeliveryRespDto> deliveryResps = new ArrayList<DeliveryRespDto>();
        deliveryResps.add(delivery);
        this.setItemAndOrder(deliveryResps);
        DeliveryRespDto deliveryResp = (DeliveryRespDto)deliveryResps.get(0);
        DeliverySellerEo deliverySellerSelect = new DeliverySellerEo();
        deliverySellerSelect.setDeliveryNo(deliveryNo);
        List deliverySellerEos = this.deliverySellerDas.select((BaseEo)deliverySellerSelect);
        if (CollectionUtils.isNotEmpty((Collection)deliverySellerEos)) {
            ArrayList sellers = new ArrayList();
            CubeBeanUtils.copyCollection(sellers, (Collection)deliverySellerEos, DeliverySellerRespDto.class);
            deliveryResp.setSellers(sellers);
        }
        List<Object> deliveryLogistics = new ArrayList();
        if (ShippingTypeEnum.EXPRESS.getType().equals(orderDelivery.getShippingType()) && StringUtils.isNotBlank((CharSequence)orderDelivery.getShippingCompanyCode()) && StringUtils.isNotBlank((CharSequence)orderDelivery.getExpressCode())) {
            ShippingReqDto shippingReqDto = new ShippingReqDto();
            shippingReqDto.setShippingNo(orderDelivery.getShippingCompanyCode());
            shippingReqDto.setShippingCode(orderDelivery.getExpressCode());
            if (ShippingCompanyEnum.SF.getCode().equals(orderDelivery.getShippingCompanyCode())) {
                shippingReqDto.setCustomerName(orderDelivery.getDeliveryMobile().substring(orderDelivery.getDeliveryMobile().length() - 4));
            }
            if (ShippingCompanyEnum.JD.getCode().equals(orderDelivery.getShippingCompanyCode())) {
                shippingReqDto.setCustomerName("");
            }
            deliveryLogistics = this.listDeliveryLogistics(shippingReqDto);
        }
        if (ShippingTypeEnum.INTRA_CITY.getType().equals(orderDelivery.getShippingType()) && CollectionUtils.isNotEmpty((Collection)(deliveryLogisticsEoList = this.deliveryLogisticsDas.listByDeliveryNoDesc(deliveryNo)))) {
            deliveryLogistics = deliveryLogisticsEoList.stream().map(deliveryLogisticEo -> {
                DeliveryLogisticRespDto deliveryLogisticRespDto = new DeliveryLogisticRespDto();
                DtoHelper.eo2Dto((BaseEo)deliveryLogisticEo, (BaseVo)deliveryLogisticRespDto);
                return deliveryLogisticRespDto;
            }).collect(Collectors.toList());
        }
        deliveryResp.setLogistics(deliveryLogistics);
        if (DeliveryStatusEnum.TO_RECEIVING.getStatus().equals(orderDelivery.getDeliveryStatus()) && StringUtils.isNotEmpty((CharSequence)deliveryResp.getShippingType()) && ShippingTypeEnum.INTRA_CITY.getType().equals(deliveryResp.getShippingType())) {
            ArrayList<DeliveryShippingRespDto> deliveryShippings = new ArrayList<DeliveryShippingRespDto>();
            for (ShippingChannelEnum shippingChannelEnum : ShippingChannelEnum.values()) {
                DeliveryShippingRespDto deliveryShippingRespDto = new DeliveryShippingRespDto();
                deliveryShippingRespDto.setCode(Integer.valueOf(shippingChannelEnum.getCode()));
                deliveryShippingRespDto.setName(shippingChannelEnum.getName());
                deliveryShippings.add(deliveryShippingRespDto);
            }
            deliveryResp.setDeliveryShippings(deliveryShippings);
        }
        SfCreateOrderReqDto ffCreateOrder = (SfCreateOrderReqDto)this.commonCacheService.getCache("DELIVERY_SF_CACHE_" + deliveryNo, SfCreateOrderReqDto.class);
        deliveryResp.setSfCreateOrder(ffCreateOrder);
        return deliveryResp;
    }

    @Override
    public OrderDeliveryEo getOrderDeliveryByDeliveryNo(String deliveryNo) {
        OrderDeliveryEo select = OrderDeliveryEo.newInstance();
        select.setDeliveryNo(deliveryNo);
        return (OrderDeliveryEo)this.orderDeliveryDas.selectOne((BaseEo)select);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RecDeliveryStoreBo receive(RecDeliveryStoreBo recDeliveryStoreBo) {
        OrderDeliveryEo orderDeliveryEo = recDeliveryStoreBo.getOrderDeliveryEo();
        recDeliveryStoreBo.setPreStatus(orderDeliveryEo.getDeliveryStatus());
        DeliveryStoreReqDto deliveryStoreReqDto = recDeliveryStoreBo.getDeliveryStoreReqDto();
        logger.info("\u95e8\u5e97\u63a5\u5355\uff0c\u5165\u53c2\uff1adeliveryStoreReqDto\uff1a{}", (Object)JSON.toJSONString((Object)deliveryStoreReqDto));
        String deliveryNo = deliveryStoreReqDto.getDeliveryNo();
        if (StringUtils.isEmpty((CharSequence)deliveryNo)) {
            logger.error("\u53d1\u8d27\u5355\u63a5\u5355\u5931\u8d25\uff0c\u53d1\u8d27\u5355\u53f7\u4e3a\u7a7a\uff01");
            throw new BizException("\u53d1\u8d27\u5355\u63a5\u5355\u5931\u8d25\uff0c\u53d1\u8d27\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (!SaleChannelEnum.SALECHANNEL_ZYSC.getCode().equals(orderDeliveryEo.getChannel()) && StringUtils.isBlank((CharSequence)orderDeliveryEo.getWarehouseCode())) {
            logger.error("\u53d1\u8d27\u5355\u63a5\u5355\u5931\u8d25\uff0c\u53d1\u8d27\u5355\u672a\u6307\u5b9a\u4ed3\u5e93\u7f16\u53f7\uff0c\u4e0d\u80fd\u8fdb\u884c\u63a5\u5355\u64cd\u4f5c\uff0cdeliveryNo\uff1a{}", (Object)deliveryNo);
            throw new BizException("\u8be5\u53d1\u8d27\u5355\u672a\u6307\u5b9a\u4ed3\u5e93\u7f16\u53f7\uff0c\u4e0d\u80fd\u8fdb\u884c\u63a5\u5355\u64cd\u4f5c\uff01");
        }
        orderDeliveryEo.setReceiveTime(new Date());
        if (ShippingTypeEnum.INTRA_CITY.getType().equals(orderDeliveryEo.getShippingType())) {
            orderDeliveryEo.setShippingCompanyCode(deliveryStoreReqDto.getShippingCompanyCode());
            orderDeliveryEo.setShippingCompany(deliveryStoreReqDto.getShippingCompany());
            if (StringUtils.isNotBlank((CharSequence)deliveryStoreReqDto.getExpressCode())) {
                orderDeliveryEo.setExpressCode(deliveryStoreReqDto.getExpressCode());
            } else {
                orderDeliveryEo.setExpressCode(DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss") + RandomStringUtils.random((int)4, (String)"0123456789"));
            }
            if (TransportPartnerEnum.SELF.getCode() != Integer.parseInt(deliveryStoreReqDto.getShippingCompanyCode())) {
                recDeliveryStoreBo.setCreatePartnerOrder("TRUE");
            } else {
                recDeliveryStoreBo.setCreatePartnerOrder("FALSE");
            }
        } else {
            recDeliveryStoreBo.setCreatePartnerOrder("TRUE");
        }
        recDeliveryStoreBo.setOptDesc("\u95e8\u5e97\uff08" + orderDeliveryEo.getWarehouseCode() + "-" + orderDeliveryEo.getWarehouseName() + "\uff09\u63a5\u5355\uff0c\u53d1\u8d27\u5355\u72b6\u6001\u66f4\u65b0\u4e3a\u5f85\u53d1\u8d27");
        recDeliveryStoreBo.setOptCode(DeliveryRouteOptEnum.RECEIVE_ORDER.getOptCode());
        return recDeliveryStoreBo;
    }

    @Override
    public RedistributePartnerDeliveryStoreBo redistribute(RedistributePartnerDeliveryStoreBo redistributePartnerDeliveryStoreBo) {
        DeliveryRedistributeReqDto deliveryRedistributeReqDto = redistributePartnerDeliveryStoreBo.getDeliveryRedistributeReqDto();
        OrderDeliveryEo orderDeliveryEo = redistributePartnerDeliveryStoreBo.getOrderDeliveryEo();
        redistributePartnerDeliveryStoreBo.setShippingChannel(Integer.parseInt(orderDeliveryEo.getShippingCompanyCode()));
        redistributePartnerDeliveryStoreBo.setShippingCompanyCode(deliveryRedistributeReqDto.getShippingCompanyCode());
        if (StringUtils.isNotBlank((CharSequence)orderDeliveryEo.getShippingCompanyCode()) && Integer.parseInt(orderDeliveryEo.getShippingCompanyCode()) == deliveryRedistributeReqDto.getShippingCompanyCode()) {
            redistributePartnerDeliveryStoreBo.setRedistribute("TRUE");
        } else {
            redistributePartnerDeliveryStoreBo.setRedistribute("fail");
        }
        if (ShippingChannelEnum.DADA.getCode() == redistributePartnerDeliveryStoreBo.getShippingChannel().intValue()) {
            DaDaFormalCancelReqDto daDaFormalCancelReqDto = new DaDaFormalCancelReqDto();
            daDaFormalCancelReqDto.setOrder_id(redistributePartnerDeliveryStoreBo.getDeliveryNo());
            daDaFormalCancelReqDto.setCancel_reason_id(Integer.valueOf(deliveryRedistributeReqDto.getReasonCode()));
            daDaFormalCancelReqDto.setCancel_reason(deliveryRedistributeReqDto.getReasonDesc());
            redistributePartnerDeliveryStoreBo.setDaDaFormalCancelReqDto(daDaFormalCancelReqDto);
        }
        PartnerDeliveryLogisticsDto partnerDeliveryLogisticsDto = new PartnerDeliveryLogisticsDto();
        partnerDeliveryLogisticsDto.setDeliveryNo(orderDeliveryEo.getDeliveryNo());
        partnerDeliveryLogisticsDto.setStatus("0");
        this.commonsMqService.sendSingleMessage(this.environment.resolvePlaceholders("DADA_DELIVERY_ORDER_NOTIFY_TAG"), (Object)JSON.toJSONString((Object)partnerDeliveryLogisticsDto));
        return redistributePartnerDeliveryStoreBo;
    }

    @Override
    public DadaDeliveryBo handleDadaNotify(DadaDeliveryBo dadaDeliveryNotifyBo) {
        DaDaOrderCallbackReqDto daDaOrderCallbackReqDto = dadaDeliveryNotifyBo.getDaDaOrderCallbackReqDto();
        OrderDeliveryEo orderDeliveryEo = dadaDeliveryNotifyBo.getOrderDeliveryEo();
        dadaDeliveryNotifyBo.setOrderNo(orderDeliveryEo.getOrderNo());
        if (daDaOrderCallbackReqDto != null) {
            orderDeliveryEo.setExpressCode(daDaOrderCallbackReqDto.getClient_id());
            orderDeliveryEo.setPartnerDeliveryStatus(String.valueOf(daDaOrderCallbackReqDto.getOrder_status()));
            dadaDeliveryNotifyBo.setDadaDeliveryStatus(String.valueOf(daDaOrderCallbackReqDto.getOrder_status()));
            PartnerDeliveryLogisticsDto partnerDeliveryLogisticsDto = this.createPartnerLogistics(daDaOrderCallbackReqDto);
            logger.info("\u56de\u8c03\u901a\u77e5\u751f\u6210\u8fbe\u8fbe\u7269\u6d41\u4fe1\u606f\u8bb0\u5f55: {}", (Object)JSON.toJSONString((Object)partnerDeliveryLogisticsDto));
            this.commonsMqService.sendSingleMessage(this.environment.resolvePlaceholders("DADA_DELIVERY_ORDER_NOTIFY_TAG"), (Object)JSON.toJSONString((Object)partnerDeliveryLogisticsDto));
        }
        return dadaDeliveryNotifyBo;
    }

    @Override
    public DadaDeliveryBo handleDadaMessage(DadaDeliveryBo dadaDeliveryMessageBo) {
        DadaCancelOrderDto dadaCancelOrderDto = dadaDeliveryMessageBo.getDadaCancelOrderDto();
        OrderDeliveryEo orderDeliveryEo = dadaDeliveryMessageBo.getOrderDeliveryEo();
        if (dadaCancelOrderDto != null) {
            orderDeliveryEo.setCancelDesc(dadaCancelOrderDto.getCancelReason());
            orderDeliveryEo.setCancelTime(dadaCancelOrderDto.getCancelTime());
            orderDeliveryEo.setCancelType(DeliveryCancelTypeEnum.DELIVERY_CANCLE.getType());
            DaDaMessageConfirmReqDto daDaMessageConfirmReqDto = new DaDaMessageConfirmReqDto();
            daDaMessageConfirmReqDto.setMessageType(Integer.valueOf(1));
            JSONObject messageBody = new JSONObject();
            messageBody.put("orderId", (Object)orderDeliveryEo.getDeliveryNo());
            messageBody.put("isConfirm", (Object)1);
            daDaMessageConfirmReqDto.setMessageBody(JSON.toJSONString((Object)messageBody));
            if (DaDaLogisticsUtils.checkSuccess(this.daDaLogisticsService.confirmMessage(daDaMessageConfirmReqDto))) {
                dadaDeliveryMessageBo.setCancelResult("success");
            }
        }
        return dadaDeliveryMessageBo;
    }

    @Override
    public DadaDeliveryBo addDadaOrder(DadaDeliveryBo dadaDeliveryBo) {
        logger.info("\u65b0\u589e\u8fbe\u8fbe\u914d\u9001\u5355: {}", (Object)JSON.toJSONString((Object)dadaDeliveryBo.getDeliveryNo()));
        try {
            DaDaAddOrderReqDto daDaAddOrderReqDto = this.assembleDadaAddOrderParam(dadaDeliveryBo.getOrderDeliveryEo());
            if (daDaAddOrderReqDto != null && DaDaLogisticsUtils.checkSuccess(this.daDaLogisticsService.addOrder(daDaAddOrderReqDto))) {
                dadaDeliveryBo.setCreateResult("success");
            } else {
                dadaDeliveryBo.setCreateResult("fail");
            }
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u8fbe\u8fbe\u914d\u9001\u5355\u5931\u8d25: {}", (Object)dadaDeliveryBo.getDeliveryNo(), (Object)e);
            dadaDeliveryBo.setCreateResult("fail");
        }
        return dadaDeliveryBo;
    }

    @Override
    public DadaDeliveryBo retryDadaAddOrder(DadaDeliveryBo dadaDeliveryBo) {
        logger.info("\u91cd\u53d1\u8fbe\u8fbe\u914d\u9001\u5355: {}", (Object)JSON.toJSONString((Object)dadaDeliveryBo.getDeliveryNo()));
        try {
            DaDaAddOrderReqDto daDaAddOrderReqDto = this.assembleDadaAddOrderParam(dadaDeliveryBo.getOrderDeliveryEo());
            DaDaReAddOrderReqDto daDaReAddOrderReqDto = new DaDaReAddOrderReqDto();
            CubeBeanUtils.copyProperties((Object)daDaReAddOrderReqDto, (Object)daDaAddOrderReqDto, (String[])new String[0]);
            if (daDaReAddOrderReqDto != null && DaDaLogisticsUtils.checkSuccess(this.daDaLogisticsService.reAddOrder(daDaReAddOrderReqDto))) {
                dadaDeliveryBo.setRetryResult("success");
            } else {
                dadaDeliveryBo.setRetryResult("fail");
            }
        }
        catch (Exception e) {
            logger.error("\u91cd\u53d1\u8fbe\u8fbe\u914d\u9001\u5355\u5931\u8d25\uff1a{}", (Object)dadaDeliveryBo.getDeliveryNo(), (Object)e);
            dadaDeliveryBo.setRetryResult("fail");
        }
        return dadaDeliveryBo;
    }

    @Override
    public DadaDeliveryBo cancelDadaOrder(DadaDeliveryBo dadaDeliveryBo) {
        if (dadaDeliveryBo.getDaDaFormalCancelReqDto() == null) {
            DaDaFormalCancelReqDto daDaFormalCancelReqDto = new DaDaFormalCancelReqDto();
            daDaFormalCancelReqDto.setOrder_id(dadaDeliveryBo.getOrderDeliveryEo().getDeliveryNo());
            daDaFormalCancelReqDto.setCancel_reason_id(Integer.valueOf(1000));
            daDaFormalCancelReqDto.setCancel_reason("\u5176\u5b83\u539f\u56e0");
            dadaDeliveryBo.setDaDaFormalCancelReqDto(daDaFormalCancelReqDto);
        }
        if (DaDaLogisticsUtils.checkSuccess(this.daDaLogisticsService.formalCancel(dadaDeliveryBo.getDaDaFormalCancelReqDto()))) {
            OrderDeliveryEo orderDeliveryEo = dadaDeliveryBo.getOrderDeliveryEo();
            orderDeliveryEo.setCancelType(DeliveryCancelTypeEnum.SELLER_CANCLE.getType());
            orderDeliveryEo.setCancelTime(new Date());
            orderDeliveryEo.setCancelDesc(dadaDeliveryBo.getDaDaFormalCancelReqDto().getCancel_reason());
            dadaDeliveryBo.setFormalCancelResult("success");
        }
        return dadaDeliveryBo;
    }

    @Override
    public DadaDeliveryBo confirmDadaOrderAbnormal(DadaDeliveryBo dadaDeliveryBo) {
        DaDaOrderConfirmGoodsReqDto daDaOrderConfirmGoodsReqDto = new DaDaOrderConfirmGoodsReqDto();
        daDaOrderConfirmGoodsReqDto.setOrder_id(dadaDeliveryBo.getDeliveryNo());
        dadaDeliveryBo.setDaDaOrderConfirmGoodsReqDto(daDaOrderConfirmGoodsReqDto);
        if (DaDaLogisticsUtils.checkSuccess(this.daDaLogisticsService.confirmGoods(dadaDeliveryBo.getDaDaOrderConfirmGoodsReqDto()))) {
            dadaDeliveryBo.setConfirmResult("success");
        }
        return dadaDeliveryBo;
    }

    @Override
    public DaDaAddOrderReqDto assembleDadaAddOrderParam(OrderDeliveryEo orderDeliveryEo) {
        List transportPartnerDtoList = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)orderDeliveryEo.getShopId())) {
            RestResponse restResponse = this.shopQueryApi.queryShopTransportPartner(Long.valueOf(orderDeliveryEo.getShopId()));
            transportPartnerDtoList = (List)RestResponseHelper.extractData((RestResponse)restResponse);
        }
        logger.info("\u5e97\u94fa{}\u652f\u6301\u914d\u9001\u65b9\u5f0f\uff1a{}", (Object)orderDeliveryEo.getShopCode(), (Object)JSON.toJSONString(transportPartnerDtoList));
        Optional<ShopTransportPartnerDto> optional = transportPartnerDtoList.stream().filter(shopTransportPartnerDto -> TransportPartnerEnum.DADA.getCode() == shopTransportPartnerDto.getPartnerCode().intValue()).findFirst();
        DaDaAddOrderReqDto daDaAddOrderReqDto = new DaDaAddOrderReqDto();
        if (TransportPartnerEnum.DADA.getCode() == Integer.parseInt(orderDeliveryEo.getShippingCompanyCode()) && optional.isPresent()) {
            daDaAddOrderReqDto.setShop_no(optional.get().getpShopNo());
            daDaAddOrderReqDto.setOrigin_id(orderDeliveryEo.getDeliveryNo());
            daDaAddOrderReqDto.setCargo_price(orderDeliveryEo.getTotalAmount());
            daDaAddOrderReqDto.setIs_prepay(Integer.valueOf(0));
            daDaAddOrderReqDto.setReceiver_name(orderDeliveryEo.getDeliveryName());
            daDaAddOrderReqDto.setReceiver_address(orderDeliveryEo.getAddress());
            List<OrderAddressRespDto> orderAddressRespDtos = this.orderAddressService.queryDtoByTradeNo(orderDeliveryEo.getOrderNo());
            if (CollectionUtils.isNotEmpty(orderAddressRespDtos)) {
                OrderAddressRespDto orderAddressRespDto = orderAddressRespDtos.get(0);
                if (StringUtils.isNotBlank((CharSequence)orderAddressRespDto.getCityName())) {
                    String cityCode = this.getDadaCityCode(StringUtils.substring((String)orderAddressRespDto.getCityName(), (int)0, (int)(orderAddressRespDto.getCityName().length() - 1)));
                    daDaAddOrderReqDto.setCity_code(cityCode);
                }
                if (StringUtils.isNotBlank((CharSequence)orderAddressRespDto.getLongitude()) && StringUtils.isNotBlank((CharSequence)orderAddressRespDto.getLatitude())) {
                    daDaAddOrderReqDto.setReceiver_lng(new BigDecimal(orderAddressRespDto.getLongitude()));
                    daDaAddOrderReqDto.setReceiver_lat(new BigDecimal(orderAddressRespDto.getLatitude()));
                }
            }
            daDaAddOrderReqDto.setReceiver_phone(orderDeliveryEo.getDeliveryMobile());
            daDaAddOrderReqDto.setReceiver_tel(orderDeliveryEo.getDeliveryMobile());
            daDaAddOrderReqDto.setCargo_type(Integer.valueOf(19));
            daDaAddOrderReqDto.setCargo_weight(BigDecimal.ONE);
        }
        return daDaAddOrderReqDto;
    }

    private String getDadaCityCode(String cityName) {
        String key = "area_dada_" + cityName;
        String areaCode = (String)this.commonCacheService.getCache(key, String.class);
        if (StringUtils.isBlank((CharSequence)areaCode)) {
            DaDaCityCodeListRespDto daDaCityCodeListRespDto = this.daDaLogisticsService.cityCodeList();
            if (daDaCityCodeListRespDto != null && CollectionUtils.isNotEmpty((Collection)daDaCityCodeListRespDto.getResult())) {
                daDaCityCodeListRespDto.getResult().forEach(city -> this.commonCacheService.setCache("area_dada_" + city.getCityName(), (Object)city.getCityCode()));
            }
            areaCode = (String)this.commonCacheService.getCache(key, String.class);
        }
        return areaCode;
    }

    private PartnerDeliveryLogisticsDto createPartnerLogistics(DaDaOrderCallbackReqDto daDaOrderCallbackReqDto) {
        PartnerDeliveryLogisticsDto logisticsDto = new PartnerDeliveryLogisticsDto();
        logisticsDto.setPartnerDeliveryNo(daDaOrderCallbackReqDto.getClient_id());
        logisticsDto.setDeliveryNo(daDaOrderCallbackReqDto.getOrder_id());
        logisticsDto.setStatus(String.valueOf(daDaOrderCallbackReqDto.getOrder_status()));
        JSONObject detailInfo = new JSONObject();
        detailInfo.put("dm_id", (Object)daDaOrderCallbackReqDto.getDm_id());
        detailInfo.put("dm_name", (Object)daDaOrderCallbackReqDto.getDm_name());
        detailInfo.put("dm_mobile", (Object)daDaOrderCallbackReqDto.getDm_mobile());
        logisticsDto.setDetailInfo(detailInfo.toJSONString());
        logisticsDto.setUpdateTime(new Date());
        return logisticsDto;
    }

    @Override
    public void sendMessageToInv(OrderDeliveryStatusBo orderDeliveryBo) {
        OrderDeliveryEo orderDeliveryEo = orderDeliveryBo.getOrderDeliveryEo();
        DeliveryChangeReqDto deliveryChangeReqDto = new DeliveryChangeReqDto();
        deliveryChangeReqDto.setDeliveryNo(orderDeliveryEo.getDeliveryNo());
        deliveryChangeReqDto.setDeliveryStatus(orderDeliveryEo.getDeliveryStatus());
        deliveryChangeReqDto.setOptCode(orderDeliveryBo.getOptCode());
        deliveryChangeReqDto.setWarehouseCode(orderDeliveryEo.getWarehouseCode());
        deliveryChangeReqDto.setWarehouseName(orderDeliveryEo.getWarehouseName());
        deliveryChangeReqDto.setPreDeliveryStatus(orderDeliveryBo.getPreStatus());
        deliveryChangeReqDto.setPreWarehouseCode(orderDeliveryBo.getPreWarehouseCode());
        deliveryChangeReqDto.setPreWarehouseName(orderDeliveryBo.getPreWarehouseName());
        deliveryChangeReqDto.setDetailDesc(orderDeliveryBo.getOptDesc());
        logger.info("\u53d1\u8d27\u5355\u540c\u6b65\u6d88\u606f\u7ed9\u5e93\u5b58\u4e2d\u5fc3{}\u5f53\u524d\u64cd\u4f5c{},\u72b6\u6001{}", new Object[]{orderDeliveryEo.getDeliveryNo(), orderDeliveryBo.getOptDesc(), orderDeliveryEo.getDeliveryStatus()});
        this.deliveryProducer.sendInventoryDeliveryChange(deliveryChangeReqDto);
        logger.info("\u53d1\u9001\u64cd\u4f5c{}\uff0c\u6210\u529f\uff0cDeliveryChangeReqDto:{}", (Object)JSON.toJSONString((Object)deliveryChangeReqDto));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RejectDeliveryStoreBo reject(RejectDeliveryStoreBo rejectDeliveryStoreBo) {
        OrderDeliveryEo orderDeliveryEo = rejectDeliveryStoreBo.getOrderDeliveryEo();
        String deliveryNo = orderDeliveryEo.getDeliveryNo();
        DeliveryStoreReqDto deliveryStoreReqDto = rejectDeliveryStoreBo.getDeliveryStoreReqDto();
        rejectDeliveryStoreBo.setOptCode(DeliveryRouteOptEnum.REJECT_ORDER.getOptCode());
        rejectDeliveryStoreBo.setPreStatus(orderDeliveryEo.getDeliveryStatus());
        rejectDeliveryStoreBo.setPreWarehouseCode(orderDeliveryEo.getWarehouseCode());
        rejectDeliveryStoreBo.setPreWarehouseName(orderDeliveryEo.getWarehouseName());
        logger.info("\u95e8\u5e97\u62d2\u5355\uff0c\u5165\u53c2\uff1adeliveryStoreReqDto:{},orderDeliveryEo:{}", (Object)JSON.toJSONString((Object)deliveryStoreReqDto), (Object)JSON.toJSONString((Object)orderDeliveryEo));
        if (null == orderDeliveryEo) {
            logger.error("\u53d1\u8d27\u5355\u62d2\u5355\u5931\u8d25\uff0c\u627e\u4e0d\u5230\u5bf9\u5e94\u53d1\u8d27\u5355\u4fe1\u606f\uff0cdeliveryNo:{}", (Object)deliveryNo);
            throw new BizException("\u627e\u4e0d\u5230\u5bf9\u5e94\u53d1\u8d27\u5355\u4fe1\u606f\uff0c\u8bf7\u786e\u8ba4\u53d1\u8d27\u5355\u662f\u5426\u6b63\u786e\uff01");
        }
        if (SaleChannelEnum.SALECHANNEL_ZYSC.getCode().equals(orderDeliveryEo.getChannel())) {
            rejectDeliveryStoreBo.setOptDesc("\u95e8\u5e97\uff08" + orderDeliveryEo.getWarehouseCode() + "-" + orderDeliveryEo.getWarehouseName() + "\uff09\u62d2\u5355\uff0c\u53d1\u8d27\u5355\u72b6\u6001\u66f4\u65b0\u4e3a\u5df2\u53d6\u6d88\u3002");
            rejectDeliveryStoreBo.setToOperate(DeliveryStatusEnum.CANCELED.getStatus());
            rejectDeliveryStoreBo.setShippingType(orderDeliveryEo.getShippingType());
            rejectDeliveryStoreBo.setOrderNo(this.getOrderNo(orderDeliveryEo));
            return rejectDeliveryStoreBo;
        }
        String channel = orderDeliveryEo.getChannel();
        OrderRouteRuleRespDto orderRouteRule = (OrderRouteRuleRespDto)this.deliveryRouteQueryApi.queryOrderRouteRule(channel).getData();
        Object omniRouterOpen = this.tradeConfQueryService.queryByCode("omniRouterOpen");
        int failByDeliveryCount = this.countFailByDeliveryNo(deliveryNo);
        if (null == orderRouteRule) {
            logger.info("\u53d1\u8d27\u5355\u53f7\uff1a{}\uff0c\u95e8\u5e97\u62d2\u5355\uff0c\u8def\u7531\u89c4\u5219\u672a\u5f00\u542f\uff0c\u53d1\u8d27\u5355\u66f4\u65b0\u4e3a\u5f85\u6307\u6d3e\u72b6\u6001\uff01", (Object)deliveryNo);
            rejectDeliveryStoreBo.setOptDesc("\u95e8\u5e97\uff08" + orderDeliveryEo.getWarehouseCode() + "-" + orderDeliveryEo.getWarehouseName() + "\uff09\u62d2\u5355\uff0c\u8def\u7531\u89c4\u5219\u914d\u7f6e\u672a\u5f00\u542f\uff0c\u53d1\u8d27\u5355\u72b6\u6001\u66f4\u65b0\u4e3a\u5f85\u6307\u6d3e\u3002");
            rejectDeliveryStoreBo.setToOperate(RouteTypeEnum.ASSIGN.getType());
        } else if (RouteTypeEnum.ASSIGN.getType().equals(orderRouteRule.getRouteType())) {
            logger.info("\u53d1\u8d27\u5355\u53f7\uff1a{}\uff0c\u95e8\u5e97\u62d2\u5355\uff0c\u8def\u7531\u89c4\u5219\u914d\u7f6e\u7c7b\u578b\u4e3a\u6307\u5b9a\u8def\u5f84\uff0c\u53d1\u8d27\u5355\u66f4\u65b0\u4e3a\u5f85\u6307\u6d3e\u72b6\u6001\uff01", (Object)deliveryNo);
            rejectDeliveryStoreBo.setOptDesc("\u95e8\u5e97\uff08" + orderDeliveryEo.getWarehouseCode() + "-" + orderDeliveryEo.getWarehouseName() + "\uff09\u62d2\u5355\uff0c\u8def\u7531\u89c4\u5219\u914d\u7f6e\u7c7b\u578b\u4e3a\u6307\u5b9a\u8def\u5f84\uff0c\u53d1\u8d27\u5355\u72b6\u6001\u66f4\u65b0\u4e3a\u5f85\u6307\u6d3e\u3002");
            rejectDeliveryStoreBo.setToOperate(RouteTypeEnum.ASSIGN.getType());
        } else if (!EnableEnum.ENABLE.getCodeEn().equals(String.valueOf(omniRouterOpen))) {
            logger.info("\u53d1\u8d27\u5355\u53f7\uff1a{}\uff0c\u95e8\u5e97\u62d2\u5355\uff0c\u5168\u6e20\u9053\u8def\u7531\u914d\u7f6e\u672a\u5f00\u542f\uff0c\u53d1\u8d27\u5355\u66f4\u65b0\u4e3a\u5f85\u5904\u7406\u72b6\u6001\uff01", (Object)deliveryNo);
            rejectDeliveryStoreBo.setOptDesc("\u95e8\u5e97\uff08" + orderDeliveryEo.getWarehouseCode() + "-" + orderDeliveryEo.getWarehouseName() + "\uff09\u62d2\u5355\uff0c\u5168\u6e20\u9053\u8def\u7531\u914d\u7f6e\u672a\u5f00\u542f\uff0c\u53d1\u8d27\u5355\u72b6\u6001\u66f4\u65b0\u4e3a\u5f85\u5904\u7406\u3002");
            rejectDeliveryStoreBo.setToOperate(DeliveryStatusEnum.TO_DO.getStatus());
        } else {
            if (failByDeliveryCount == 0) {
                logger.info("\u53d1\u8d27\u5355\u53f7\uff1a{}\uff0c\u7b2c\u4e00\u6b21\u95e8\u5e97\u62d2\u5355\uff0c\u53d1\u8d27\u5355\u91cd\u65b0\u53d8\u66f4\u4e3a\u5f85\u8def\u7531\u72b6\u6001\uff01", (Object)deliveryNo);
                rejectDeliveryStoreBo.setOptDesc("\u95e8\u5e97\uff08" + orderDeliveryEo.getWarehouseCode() + "-" + orderDeliveryEo.getWarehouseName() + "\uff09\u62d2\u5355\uff0c\u53d1\u8d27\u5355\u88ab\u7b2c\u4e00\u6b21\u62d2\u5355\uff0c\u53d1\u8d27\u5355\u72b6\u6001\u66f4\u65b0\u4e3a\u5f85\u8def\u7531\u3002");
            } else {
                logger.info("\u53d1\u8d27\u5355\u53f7\uff1a{}\uff0cfailByDeliveryCount\uff1a{}\uff0c\u975e\u7b2c\u4e00\u6b21\u95e8\u5e97\u62d2\u5355\u6216\u8005\u65e0\u6cd5\u53d1\u8d27\uff0c\u53d1\u8d27\u5355\u53d8\u66f4\u4e3a\u5f85\u5904\u7406\u72b6\u6001\uff01", (Object)failByDeliveryCount, (Object)deliveryNo);
                rejectDeliveryStoreBo.setOptDesc("\u95e8\u5e97\uff08" + orderDeliveryEo.getWarehouseCode() + "-" + orderDeliveryEo.getWarehouseName() + "\uff09\u62d2\u5355\uff0c\u975e\u7b2c\u4e00\u6b21\u95e8\u5e97\u62d2\u5355\u6216\u8005\u65e0\u6cd5\u53d1\u8d27\uff0c\u53d1\u8d27\u5355\u72b6\u6001\u66f4\u65b0\u4e3a\u5f85\u5904\u7406\u3002");
            }
            rejectDeliveryStoreBo.setToOperate(RouteTypeEnum.COMBINE.getType());
        }
        rejectDeliveryStoreBo.setFailCount(failByDeliveryCount);
        orderDeliveryEo.clearWarehouse();
        return rejectDeliveryStoreBo;
    }

    @Override
    public List<DeliveryRejectReasonRespDto> listRejectReasons() {
        DeliveryRejectReasonEnum[] values;
        ArrayList<DeliveryRejectReasonRespDto> deliveryRejectReasonRespDtos = new ArrayList<DeliveryRejectReasonRespDto>();
        for (DeliveryRejectReasonEnum rejectReason : values = DeliveryRejectReasonEnum.values()) {
            DeliveryRejectReasonRespDto deliveryRejectReasonRespDto = new DeliveryRejectReasonRespDto();
            deliveryRejectReasonRespDto.setCode(rejectReason.getCode());
            deliveryRejectReasonRespDto.setReason(rejectReason.getReason());
            deliveryRejectReasonRespDtos.add(deliveryRejectReasonRespDto);
        }
        return deliveryRejectReasonRespDtos;
    }

    @Override
    public int countFailByDeliveryNo(String deliveryNo) {
        DeliveryRouteCountReqDto deliveryRouteCountReqDto = new DeliveryRouteCountReqDto();
        deliveryRouteCountReqDto.setDeliveryNo(deliveryNo);
        deliveryRouteCountReqDto.setOptCodes(Arrays.asList(DeliveryRouteOptEnum.REJECT_ORDER.getOptCode(), DeliveryRouteOptEnum.UNABLE_DELIVER.getOptCode()));
        int count = 0;
        try {
            count = (Integer)this.deliveryRouteQueryApi.countRouteRecord(deliveryRouteCountReqDto).getData();
        }
        catch (Exception e) {
            logger.error("\u7edf\u8ba1\u6b21\u6570\u51fa\u73b0\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
        }
        return count;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean deliver(DeliveryStoreReqDto deliveryStoreReqDto, String curActionNode) {
        logger.info("\u95e8\u5e97\u53d1\u8d27\u64cd\u4f5c\uff0c\u5165\u53c2deliveryStoreReqDto\uff1a{}", (Object)JSON.toJSONString((Object)deliveryStoreReqDto));
        this.deliverCheck(deliveryStoreReqDto);
        String deliveryNo = deliveryStoreReqDto.getDeliveryNo();
        OrderDeliveryEo orderDeliverySelect = OrderDeliveryEo.newInstance();
        orderDeliverySelect.setDeliveryNo(deliveryNo);
        OrderDeliveryEo orderDeliveryEo = (OrderDeliveryEo)this.orderDeliveryDas.selectOne((BaseEo)orderDeliverySelect);
        if (null == orderDeliveryEo) {
            logger.error("\u53d1\u8d27\u5355\u53d1\u8d27\u5931\u8d25\uff0c\u627e\u4e0d\u5230\u5bf9\u5e94\u53d1\u8d27\u5355\u4fe1\u606f\uff0cdeliveryNo:{}", (Object)deliveryNo);
            throw new BizException("\u627e\u4e0d\u5230\u5bf9\u5e94\u53d1\u8d27\u5355\u4fe1\u606f\uff0c\u8bf7\u786e\u8ba4\u53d1\u8d27\u5355\u662f\u5426\u6b63\u786e\uff01");
        }
        if (StringUtils.isNotEmpty((CharSequence)curActionNode) && null != orderDeliveryEo.getFlowDefId()) {
            TradeEngine.validate((IFlowEntity)orderDeliveryEo, curActionNode);
        }
        if (ShippingTypeEnum.INTRA_CITY.getType().equals(orderDeliveryEo.getShippingType())) {
            logger.info("\u540c\u57ce\u914d\u9001\u7684\u53d1\u8d27\u5355\u8fdb\u884c\u53d1\u8d27\uff0c\u4e0d\u751f\u6210\u7269\u6d41\u5355\u53f7!");
            deliveryStoreReqDto.setExpressCode(null);
        } else if (ShippingTypeEnum.EXPRESS.getType().equals(orderDeliveryEo.getShippingType())) {
            if (StringUtils.isEmpty((CharSequence)deliveryStoreReqDto.getExpressCode())) {
                throw new BizException("\u5feb\u9012\u914d\u9001\uff0c\u7269\u6d41\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            logger.info("\u5feb\u9012\u914d\u9001\u7684\u53d1\u8d27\u5355\u8fdb\u884c\u53d1\u8d27\uff0c\u8bbe\u7f6e\u5feb\u9012\u5355\u53f7\u4e3a\uff1a{}", (Object)deliveryStoreReqDto.getExpressCode());
            deliveryStoreReqDto.setExpressCode(deliveryStoreReqDto.getExpressCode());
        } else if (ShippingTypeEnum.PICKUP.getType().equals(orderDeliveryEo.getShippingType())) {
            OrderDeliveryEo orderDeliveryUpdate = OrderDeliveryEo.newInstance();
            orderDeliveryUpdate.setId(orderDeliveryEo.getId());
            this.orderDeliveryService.setOrderDeliveryPickUpCode(orderDeliveryUpdate);
            this.orderDeliveryDas.updateSelective((BaseEo)orderDeliveryUpdate);
            logger.info("\u53d1\u7684\u8d27\u5355\u81ea\u63d0\u65b9\u5f0f\uff0c\u8bbe\u7f6e\u81ea\u63d0\u7801\uff0cdeliveryNo:{}\uff0cpickUpCode:{}", (Object)deliveryNo, (Object)orderDeliveryUpdate.getPickUpCode());
        }
        OrderDeliveryEo orderDeliveryUpdateEo = OrderDeliveryEo.newInstance();
        orderDeliveryUpdateEo.setId(orderDeliveryEo.getId());
        orderDeliveryUpdateEo.setFlowDefId(orderDeliveryEo.getFlowDefId());
        orderDeliveryUpdateEo.setDeliveryStatus(DeliveryStatusEnum.DELIVERED.getStatus());
        if (StringUtils.isNotEmpty((CharSequence)curActionNode) && null != orderDeliveryEo.getFlowDefId()) {
            TradeEngine.setFlowStatus(orderDeliveryUpdateEo, "succ", curActionNode);
        }
        orderDeliveryUpdateEo.setShippingCompanyCode(deliveryStoreReqDto.getShippingCompanyCode());
        orderDeliveryUpdateEo.setShippingCompany(deliveryStoreReqDto.getShippingCompany());
        orderDeliveryUpdateEo.setExpressCode(deliveryStoreReqDto.getExpressCode());
        orderDeliveryUpdateEo.setDeliveryTime(new Date());
        this.orderDeliveryDas.updateSelective((BaseEo)orderDeliveryUpdateEo);
        if (CollectionUtils.isNotEmpty((Collection)deliveryStoreReqDto.getSellers())) {
            ArrayList deliverySellerEos = new ArrayList();
            CubeBeanUtils.copyCollection(deliverySellerEos, (Collection)deliveryStoreReqDto.getSellers(), DeliverySellerEo.class);
            deliverySellerEos.stream().forEach(deliverySellerEo -> deliverySellerEo.setDeliveryNo(deliveryNo));
            this.deliverySellerDas.insertBatch(deliverySellerEos);
        }
        if (CollectionUtils.isNotEmpty((Collection)deliveryStoreReqDto.getSellers())) {
            RefDeliveryOrderEo queryDeliveryOrderEo = RefDeliveryOrderEo.newInstance();
            queryDeliveryOrderEo.setDeliveryNo(deliveryNo);
            RefDeliveryOrderEo refDeliveryOrderEo = (RefDeliveryOrderEo)this.refDeliveryOrderDas.selectOne((BaseEo)queryDeliveryOrderEo);
            if (StringUtils.isNotEmpty((CharSequence)refDeliveryOrderEo.getOrderNo())) {
                List salePersonMessageVos = deliveryStoreReqDto.getSellers().stream().map(bean -> {
                    SalePersonMessageVo salePersonMessageVo = new SalePersonMessageVo();
                    CubeBeanUtils.copyProperties((Object)salePersonMessageVo, (Object)bean, (String[])new String[0]);
                    salePersonMessageVo.setEmployeeNo(bean.getSellerCode());
                    salePersonMessageVo.setSellerName(bean.getSellerName());
                    return salePersonMessageVo;
                }).collect(Collectors.toList());
                OrderEo orderEo = this.orderService.queryByOrderNo(refDeliveryOrderEo.getOrderNo());
                OrderDeliverMessageVo messageVo = new OrderDeliverMessageVo();
                messageVo.setOrderNo(orderEo.getOrderNo());
                messageVo.setDeliverStatus(DeliverStatusEnum.DELIVER_SUCCESS.getCode());
                messageVo.setActualMoney(orderEo.getPayAmount());
                messageVo.setSalePersonMessageVoList(salePersonMessageVos);
                this.performanceProducer.sendPerformance(messageVo);
            }
        }
        if (null != deliveryStoreReqDto.getSender() && StringUtils.isNotBlank((CharSequence)deliveryStoreReqDto.getSender().getPhone())) {
            DeliverySenderEo deliverySenderEo = new DeliverySenderEo();
            CubeBeanUtils.copyProperties((Object)deliverySenderEo, (Object)deliveryStoreReqDto.getSender(), (String[])new String[0]);
            this.deliverySenderDas.insert((BaseEo)deliverySenderEo);
        }
        ArrayList packageItemEos = new ArrayList();
        DeliveryItemEo deliveryItemSelect = new DeliveryItemEo();
        deliveryItemSelect.setDeliveryNo(deliveryNo);
        List deliveryItemEos = this.deliveryItemDas.select((BaseEo)deliveryItemSelect);
        if (CollectionUtils.isEmpty((Collection)deliveryItemEos)) {
            String packageSerial = UUID.randomUUID().toString();
            deliveryItemEos.stream().forEach(deliveryItemEo -> {
                PackageItemEo packageItemEo = new PackageItemEo();
                BeanUtils.copyProperties((Object)deliveryItemEo, (Object)packageItemEo);
                packageItemEo.setId(null);
                packageItemEo.setDeliveryNo(deliveryNo);
                packageItemEo.setActualSkuSerial(deliveryItemEo.getSkuSerial());
                packageItemEo.setDeliveryType("NORMAL");
                packageItemEo.setActualDeliverySkuNum(deliveryItemEo.getItemNum());
                packageItemEo.setActualDeliveryNum(deliveryItemEo.getItemNum());
                packageItemEo.setPackageSerial(packageSerial);
                packageItemEo.setShippingCompany(deliveryStoreReqDto.getShippingCompany());
                packageItemEo.setShippingSerial(deliveryStoreReqDto.getExpressCode());
                packageItemEos.add(packageItemEo);
            });
            this.packageItemDas.insertBatch(packageItemEos);
        }
        if (orderDeliveryEo.getCycleBuy() != null && orderDeliveryEo.getCycleBuy().booleanValue() && orderDeliveryEo.getDeliveryPlanId() != null) {
            logger.info("\u5468\u671f\u8d2d\u53d1\u8d27\u5355\u53d1\u8d27: {}", (Object)deliveryNo);
            this.commonsMqService.sendSingleMessage(this.environment.resolvePlaceholders("DELIVERY_ORDER_DELIVERY_TAG"), (Object)deliveryNo);
        }
        RefDeliveryOrderEo refDeliveryOrderEo = RefDeliveryOrderEo.newInstance();
        refDeliveryOrderEo.setDeliveryNo(deliveryNo);
        List refDeliveryOrders = this.refDeliveryOrderDas.select((BaseEo)refDeliveryOrderEo);
        RefDeliveryOrderEo refDeliveryOrder = (RefDeliveryOrderEo)refDeliveryOrders.get(0);
        String orderTradeStatus = this.getOrderStatusByDeliver(refDeliveryOrder.getOrderNo());
        OrderDeliveryExtReqDto orderDeliveryExtReqDto = new OrderDeliveryExtReqDto();
        orderDeliveryExtReqDto.setOrderNo(refDeliveryOrder.getOrderNo());
        orderDeliveryExtReqDto.setTradeNo(refDeliveryOrder.getOrderNo());
        orderDeliveryExtReqDto.setOrderTradeStatus(orderTradeStatus);
        this.orderAction.deliverOrder(orderDeliveryExtReqDto);
        logger.info("\u66f4\u65b0\u8ba2\u5355\u53f7\uff1a{}\u72b6\u6001\u4e3a\uff1a{}", (Object)refDeliveryOrder.getOrderNo(), (Object)orderTradeStatus);
        try {
            this.commonCacheService.delCache("DELIVERY_SF_CACHE_" + deliveryNo);
        }
        catch (Exception exception) {
            // empty catch block
        }
        DeliveryChangeReqDto deliveryChangeReqDto = new DeliveryChangeReqDto();
        deliveryChangeReqDto.setDeliveryNo(deliveryNo);
        deliveryChangeReqDto.setPreDeliveryStatus(orderDeliveryEo.getDeliveryStatus());
        deliveryChangeReqDto.setDeliveryStatus(DeliveryStatusEnum.DELIVERED.getStatus());
        deliveryChangeReqDto.setOptCode(DeliveryRouteOptEnum.DELIVER.getOptCode());
        deliveryChangeReqDto.setWarehouseCode(orderDeliveryEo.getWarehouseCode());
        deliveryChangeReqDto.setWarehouseName(orderDeliveryEo.getWarehouseName());
        deliveryChangeReqDto.setDeliveryTime(orderDeliveryUpdateEo.getDeliveryTime());
        deliveryChangeReqDto.setDetailDesc("\u95e8\u5e97\uff08" + orderDeliveryEo.getWarehouseCode() + "-" + orderDeliveryEo.getWarehouseName() + "\uff09\u53d1\u8d27\uff0c\u53d1\u8d27\u5355\u72b6\u6001\u66f4\u65b0\u4e3a\u5df2\u53d1\u8d27");
        this.deliveryProducer.sendInventoryDeliveryChange(deliveryChangeReqDto);
        logger.info("\u53d1\u8d27\u5355\u53d1\u8d27\u64cd\u4f5c\u6210\u529f\uff0c\u8ba2\u5355\uff1a{}\u66f4\u65b0\u4e3a\uff1a{}\u72b6\u6001\uff01deliveryNo:{}, expressCode:{}, shopCode:{}", new Object[]{refDeliveryOrderEo.getOrderNo(), orderTradeStatus, deliveryStoreReqDto.getDeliveryNo(), deliveryStoreReqDto.getExpressCode(), orderDeliveryEo.getShopCode()});
        return true;
    }

    @Override
    public void assembleMessage2Inventory(OrderDeliveryEo orderDeliveryEo, String deliveryStatus, String optCode, String desc) {
        DeliveryChangeReqDto deliveryChangeReqDto = new DeliveryChangeReqDto();
        deliveryChangeReqDto.setDeliveryNo(orderDeliveryEo.getDeliveryNo());
        deliveryChangeReqDto.setPreDeliveryStatus(orderDeliveryEo.getDeliveryStatus());
        deliveryChangeReqDto.setDeliveryStatus(deliveryStatus);
        deliveryChangeReqDto.setOptCode(optCode);
        deliveryChangeReqDto.setWarehouseCode(orderDeliveryEo.getWarehouseCode());
        deliveryChangeReqDto.setWarehouseName(orderDeliveryEo.getWarehouseName());
        deliveryChangeReqDto.setDeliveryTime(new Date());
        deliveryChangeReqDto.setDetailDesc(desc);
        this.deliveryProducer.sendInventoryDeliveryChange(deliveryChangeReqDto);
        logger.info(desc);
    }

    @Override
    public String getOrderStatusByDeliver(String orderNo) {
        RefDeliveryOrderEo refDeliveryOrderSelect = RefDeliveryOrderEo.newInstance();
        refDeliveryOrderSelect.setOrderNo(orderNo);
        List refDeliveryOrderEos = this.refDeliveryOrderDas.select((BaseEo)refDeliveryOrderSelect);
        List deliveryNos = refDeliveryOrderEos.stream().map(StdRefDeliveryOrderEo::getDeliveryNo).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(deliveryNos)) {
            logger.error("\u627e\u4e0d\u53d1\u8d27\u5355\u8ba2\u5355\u5173\u8054\u4fe1\u606f,orderNo:{}", (Object)orderNo);
            throw new BizException("\u627e\u4e0d\u53d1\u8d27\u5355\u8ba2\u5355\u5173\u8054\u4fe1\u606f");
        }
        OrderDeliveryEo orderDeliverySelect = OrderDeliveryEo.newInstance();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"deliveryNo", deliveryNos));
        orderDeliverySelect.setSqlFilters(sqlFilters);
        List orderDeliverys = this.orderDeliveryDas.select((BaseEo)orderDeliverySelect);
        if (CollectionUtils.isEmpty((Collection)orderDeliverys)) {
            logger.error("\u627e\u4e0d\u53d1\u8d27\u5355\u4fe1\u606f,orderNo:{}", (Object)orderNo);
            throw new BizException("\u627e\u4e0d\u53d1\u8d27\u5355\u4fe1\u606f");
        }
        boolean allIntraCity = orderDeliverys.stream().allMatch(orderDeliveryEo -> ShippingTypeEnum.INTRA_CITY.getType().equals(orderDeliveryEo.getShippingType()));
        boolean allCancel = orderDeliverys.stream().allMatch(orderDeliveryEo -> DeliveryStatusEnum.CANCELED.getStatus().equals(orderDeliveryEo.getDeliveryStatus()));
        if (allIntraCity && allCancel) {
            return "default";
        }
        for (OrderDeliveryEo orderDeliveryEo2 : orderDeliverys) {
            if (StringUtils.isNotEmpty((CharSequence)orderDeliveryEo2.getParentDeliveryNo()) && !"0".equals(orderDeliveryEo2.getParentDeliveryNo()) || DeliveryStatusEnum.DELIVERED.getStatus().equals(orderDeliveryEo2.getDeliveryStatus())) continue;
            logger.info("\u8ba2\u5355\uff1a{}\u5bf9\u5e94\u7684\u53d1\u8d27\u5355\uff1a{}\u72b6\u6001\u4e3a\u975e\u5df2\u53d1\u8d27\u72b6\u6001\uff0c\u6807\u8bb0\u8ba2\u5355\u4e3a\u90e8\u5206\u53d1\u8d27\u72b6\u6001\uff1a{}", new Object[]{orderNo, orderDeliveryEo2.getDeliveryNo(), "PARTIALSHIPMENT"});
            return "PARTIALSHIPMENT";
        }
        return "DELIVERY";
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean cancleByOrderNo(List<String> orderNos) {
        if (CollectionUtils.isEmpty(orderNos)) {
            throw new BizException("\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        RefDeliveryOrderEo refSelect = RefDeliveryOrderEo.newInstance();
        ArrayList<SqlFilter> refSqlFilters = new ArrayList<SqlFilter>();
        refSqlFilters.add(SqlFilter.in((String)"orderNo", orderNos));
        refSelect.setSqlFilters(refSqlFilters);
        List refs = this.refDeliveryOrderDas.select((BaseEo)refSelect);
        if (CollectionUtils.isEmpty((Collection)refs)) {
            throw new BizException("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u53d1\u8d27\u5355\u4fe1\u606f\uff01");
        }
        Set deliveryNos = refs.stream().map(ref -> ref.getDeliveryNo()).collect(Collectors.toSet());
        OrderDeliveryEo orderDeliverySelect = OrderDeliveryEo.newInstance();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"deliveryNo", new ArrayList(deliveryNos)));
        orderDeliverySelect.setSqlFilters(sqlFilters);
        List deliverys = this.orderDeliveryDas.select((BaseEo)orderDeliverySelect);
        if (CollectionUtils.isEmpty((Collection)deliverys)) {
            throw new BizException("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u53d1\u8d27\u5355\u4fe1\u606f\uff01");
        }
        ArrayList<OrderDeliveryEo> warehouseDeliverys = new ArrayList<OrderDeliveryEo>();
        ArrayList<OrderDeliveryEo> storeDeliverys = new ArrayList<OrderDeliveryEo>();
        for (OrderDeliveryEo orderDeliveryEo : deliverys) {
            if (StringUtils.isNotEmpty((CharSequence)orderDeliveryEo.getShopCode())) {
                storeDeliverys.add(orderDeliveryEo);
                continue;
            }
            if (!StringUtils.isNotEmpty((CharSequence)orderDeliveryEo.getWarehouseCode())) continue;
            warehouseDeliverys.add(orderDeliveryEo);
        }
        if (CollectionUtils.isNotEmpty(warehouseDeliverys)) {
            // empty if block
        }
        if (CollectionUtils.isNotEmpty(storeDeliverys)) {
            this.checkCancleStoreDeliverys(storeDeliverys);
        }
        for (OrderDeliveryEo orderDeliveryEo : deliverys) {
            OrderDeliveryEo orderDeliveryUpdate = OrderDeliveryEo.newInstance();
            orderDeliveryUpdate.setId(orderDeliveryEo.getId());
            orderDeliveryUpdate.setDeliveryStatus(DeliveryStatusEnum.CANCELED.getStatus());
            this.orderDeliveryDas.updateSelective((BaseEo)orderDeliveryUpdate);
        }
        return true;
    }

    public Boolean checkCancleStoreDeliverys(List<OrderDeliveryEo> orderDeliveryEos) {
        for (OrderDeliveryEo orderDeliveryEo : orderDeliveryEos) {
            if (DeliveryStatusEnum.TO_ROUTE.getStatus().equals(orderDeliveryEo.getDeliveryStatus()) || DeliveryStatusEnum.TO_DO.getStatus().equals(orderDeliveryEo.getDeliveryStatus()) || DeliveryStatusEnum.TO_ASSIGN.getStatus().equals(orderDeliveryEo.getDeliveryStatus()) || DeliveryStatusEnum.TO_RECEIVING.getStatus().equals(orderDeliveryEo.getDeliveryStatus())) continue;
            logger.info("\u53d6\u6d88\u53d1\u8d27\u5355\u5931\u8d25\uff0c\u53d1\u8d27\u5355\u72b6\u6001\u4e0d\u80fd\u53d6\u6d88\uff0c\u53d1\u8d27\u5355\u53f7\uff1a{}\uff0c\u53d1\u8d27\u5355\u4fe1\u606f\uff1a{}", (Object)orderDeliveryEo.getDeliveryNo(), (Object)JSON.toJSONString((Object)orderDeliveryEo));
            throw new BizException("\u8be5\u53d1\u8d27\u5355\u72b6\u6001\u4e0d\u80fd\u53d6\u6d88\uff01");
        }
        return true;
    }

    @Override
    public Boolean distributeWms(DistributeWmsReqDto distributeWmsReqDto) {
        if (StringUtils.isEmpty((CharSequence)distributeWmsReqDto.getDeliveryNo())) {
            throw new BizException("\u53d1\u8d27\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        OrderDeliveryEo select = OrderDeliveryEo.newInstance();
        select.setDeliveryNo(distributeWmsReqDto.getDeliveryNo());
        OrderDeliveryEo orderDeliveryEo = (OrderDeliveryEo)this.orderDeliveryDas.selectOne((BaseEo)select);
        if (null == orderDeliveryEo) {
            logger.error("\u53d1\u8d27\u5355\u4e0b\u53d1wms\u5931\u8d25\uff0c\u627e\u4e0d\u5bf9\u5e94\u7684\u53d1\u8d27\u5355\uff1a{}\u4fe1\u606f", (Object)distributeWmsReqDto.getDeliveryNo());
            throw new BizException("\u627e\u4e0d\u5230\u53d1\u8d27\u5355\u4fe1\u606f");
        }
        this.connectorDeliveryProducer.distributeWms(distributeWmsReqDto);
        return true;
    }

    @Override
    public Boolean distributeSap(DistributeSapReqDto distributeSapReqDto) {
        if (StringUtils.isEmpty((CharSequence)distributeSapReqDto.getDeliveryNo())) {
            throw new BizException("\u53d1\u8d27\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        OrderDeliveryEo select = OrderDeliveryEo.newInstance();
        select.setDeliveryNo(distributeSapReqDto.getDeliveryNo());
        OrderDeliveryEo orderDeliveryEo = (OrderDeliveryEo)this.orderDeliveryDas.selectOne((BaseEo)select);
        if (null == orderDeliveryEo) {
            logger.error("\u53d1\u8d27\u5355\u4e0b\u53d1sap\u8d22\u52a1\u7cfb\u7edf\u5931\u8d25\uff0c\u627e\u4e0d\u5bf9\u5e94\u7684\u53d1\u8d27\u5355\uff1a{}\u4fe1\u606f", (Object)distributeSapReqDto.getDeliveryNo());
            throw new BizException("\u627e\u4e0d\u5230\u53d1\u8d27\u5355\u4fe1\u606f\uff01");
        }
        this.connectorDeliveryProducer.distributeSap(distributeSapReqDto);
        return true;
    }

    @Override
    public Boolean warehouseDeliver(DeliveryWarehouseReqDto deliveryWarehouseReqDto) {
        this.warehouseDeliverCheck(deliveryWarehouseReqDto);
        String deliveryNo = deliveryWarehouseReqDto.getDeliveryNo();
        OrderDeliveryEo orderDeliverySelect = OrderDeliveryEo.newInstance();
        orderDeliverySelect.setDeliveryNo(deliveryNo);
        OrderDeliveryEo orderDeliveryEo = (OrderDeliveryEo)this.orderDeliveryDas.selectOne((BaseEo)orderDeliverySelect);
        if (null == orderDeliveryEo) {
            logger.error("\u4ed3\u5e93\u53d1\u8d27\u56de\u8c03\u5904\u7406\u5931\u8d25\uff0c\u627e\u4e0d\u5230\u5bf9\u5e94\u53d1\u8d27\u5355\u4fe1\u606f\uff0cdeliveryNo:{}", (Object)deliveryNo);
            throw new BizException("\u627e\u4e0d\u5230\u5bf9\u5e94\u53d1\u8d27\u5355\u4fe1\u606f\uff0c\u8bf7\u786e\u8ba4\u53d1\u8d27\u5355\u662f\u5426\u6b63\u786e\uff01");
        }
        if (!DeliveryStatusEnum.INIT.getStatus().equals(orderDeliveryEo.getDeliveryStatus())) {
            logger.error("\u4ed3\u5e93\u53d1\u8d27\u56de\u8c03\u5904\u7406\u5931\u8d25\uff0c\u72b6\u6001\u4e0d\u6b63\u786e\uff0cdeliveryNo:{},deliveryStatus:{}", (Object)deliveryNo, (Object)orderDeliveryEo.getDeliveryStatus());
            throw new BizException("\u8be5\u53d1\u8d27\u5355\u72b6\u6001\u4e0d\u662f\u5f85\u53d1\u8d27\u72b6\u6001\uff0c\u4ed3\u5e93\u4e0d\u80fd\u8fdb\u884c\u53d1\u8d27\u64cd\u4f5c\uff01");
        }
        OrderDeliveryEo orderDeliveryUpdateEo = OrderDeliveryEo.newInstance();
        orderDeliveryUpdateEo.setId(orderDeliveryEo.getId());
        orderDeliveryUpdateEo.setDeliveryStatus(DeliveryStatusEnum.DELIVERED.getStatus());
        orderDeliveryUpdateEo.setShippingCompanyCode(deliveryWarehouseReqDto.getShippingCompanyCode());
        orderDeliveryUpdateEo.setExpressCode(deliveryWarehouseReqDto.getExpressCode());
        orderDeliveryUpdateEo.setShippingCompany(deliveryWarehouseReqDto.getShippingCompany());
        this.orderDeliveryDas.updateSelective((BaseEo)orderDeliveryUpdateEo);
        if (null != deliveryWarehouseReqDto.getSender() && StringUtils.isNotBlank((CharSequence)deliveryWarehouseReqDto.getSender().getPhone())) {
            DeliverySenderEo deliverySenderEo = new DeliverySenderEo();
            CubeBeanUtils.copyProperties((Object)deliverySenderEo, (Object)deliveryWarehouseReqDto.getSender(), (String[])new String[0]);
            this.deliverySenderDas.insert((BaseEo)deliverySenderEo);
        }
        DeliveryChangeReqDto deliveryChangeReqDto = new DeliveryChangeReqDto();
        deliveryChangeReqDto.setDeliveryNo(deliveryNo);
        deliveryChangeReqDto.setPreDeliveryStatus(orderDeliveryEo.getDeliveryStatus());
        deliveryChangeReqDto.setDeliveryStatus(DeliveryStatusEnum.DELIVERED.getStatus());
        deliveryChangeReqDto.setOptCode(DeliveryRouteOptEnum.DELIVER.getOptCode());
        deliveryChangeReqDto.setWarehouseCode(orderDeliveryEo.getWarehouseCode());
        deliveryChangeReqDto.setWarehouseName(orderDeliveryEo.getWarehouseName());
        deliveryChangeReqDto.setDetailDesc("\u4ed3\u5e93\uff08" + orderDeliveryEo.getWarehouseCode() + "-" + orderDeliveryEo.getWarehouseName() + "\uff09\u53d1\u8d27\uff0c\u53d1\u8d27\u5355\u72b6\u6001\u66f4\u65b0\u4e3a\u5df2\u53d1\u8d27");
        this.deliveryProducer.sendInventoryDeliveryChange(deliveryChangeReqDto);
        logger.info("\u4ed3\u5e93\u53d1\u8d27\u56de\u8c03\u5904\u7406\u64cd\u4f5c\u6210\u529f\uff01deliveryNo:{}, expressCode:{}, warehouseCode:{}", new Object[]{deliveryWarehouseReqDto.getDeliveryNo(), deliveryWarehouseReqDto.getExpressCode(), orderDeliveryEo.getWarehouseCode()});
        return true;
    }

    private void warehouseDeliverCheck(DeliveryWarehouseReqDto deliveryWarehouseReqDto) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{deliveryWarehouseReqDto.getDeliveryNo(), deliveryWarehouseReqDto.getShippingCompanyCode(), deliveryWarehouseReqDto.getExpressCode()})) {
            throw new BizException("\u8bf7\u6c42\u53c2\u6570\u4e0d\u5168\uff0c\u8bf7\u68c0\u67e5\u7f3a\u5c11\u7684\u53c2\u6570\uff01");
        }
    }

    private void deliverCheck(DeliveryStoreReqDto deliveryStoreReqDto) {
        if (StringUtils.isEmpty((CharSequence)deliveryStoreReqDto.getDeliveryNo())) {
            throw new BizException("\u53d1\u8d27\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)deliveryStoreReqDto.getShippingCompanyCode())) {
            throw new BizException("\u7269\u6d41\u516c\u53f8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    @Override
    public UnDeliveryStoreBo unableDeliver(UnDeliveryStoreBo unDeliveryStoreBo) {
        OrderDeliveryEo orderDeliveryEo = unDeliveryStoreBo.getOrderDeliveryEo();
        logger.info("\u95e8\u5e97\u65e0\u6cd5\u53d1\u8d27\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)((Object)unDeliveryStoreBo)));
        unDeliveryStoreBo.setOptCode(DeliveryRouteOptEnum.UNABLE_DELIVER.getOptCode());
        unDeliveryStoreBo.setOptDesc(DeliveryRouteOptEnum.UNABLE_DELIVER.getOptDesc());
        unDeliveryStoreBo.setPreStatus(orderDeliveryEo.getDeliveryStatus());
        unDeliveryStoreBo.setPreWarehouseCode(orderDeliveryEo.getWarehouseCode());
        unDeliveryStoreBo.setPreWarehouseName(orderDeliveryEo.getWarehouseName());
        String deliveryNo = unDeliveryStoreBo.getOrderDeliveryEo().getDeliveryNo();
        if (ShippingTypeEnum.INTRA_CITY.getType().equals(orderDeliveryEo.getShippingType())) {
            unDeliveryStoreBo.setRouteType(DeliveryStatusEnum.TO_RECEIVING.getStatus());
            PartnerDeliveryLogisticsDto partnerDeliveryLogisticsDto = new PartnerDeliveryLogisticsDto();
            partnerDeliveryLogisticsDto.setDeliveryNo(deliveryNo);
            partnerDeliveryLogisticsDto.setStatus("1001");
            JSONObject detailInfo = new JSONObject();
            detailInfo.put("reason", (Object)unDeliveryStoreBo.getDeliveryStoreReqDto().getReason());
            partnerDeliveryLogisticsDto.setDetailInfo(detailInfo.toJSONString());
            partnerDeliveryLogisticsDto.setUpdateTime(new Date());
            this.commonsMqService.sendSingleMessage(this.environment.resolvePlaceholders("DADA_DELIVERY_ORDER_NOTIFY_TAG"), (Object)JSON.toJSONString((Object)partnerDeliveryLogisticsDto));
        } else if (ShippingTypeEnum.EXPRESS.getType().equals(orderDeliveryEo.getShippingType())) {
            String channel = orderDeliveryEo.getChannel();
            OrderRouteRuleRespDto orderRouteRule = (OrderRouteRuleRespDto)this.deliveryRouteQueryApi.queryOrderRouteRule(channel).getData();
            Object omniRouterOpen = this.tradeConfQueryService.queryByCode("omniRouterOpen");
            int failByDeliveryCount = this.countFailByDeliveryNo(deliveryNo);
            if (!EnableEnum.ENABLE.getCodeEn().equals(String.valueOf(omniRouterOpen))) {
                logger.info("\u53d1\u8d27\u5355\u53f7\uff1a{}\uff0c\u95e8\u5e97\u65e0\u6cd5\u53d1\u8d27\uff0c\u5168\u6e20\u9053\u8def\u7531\u914d\u7f6e\u672a\u5f00\u542f\uff0c\u53d1\u8d27\u5355\u66f4\u65b0\u4e3a\u5f85\u5904\u7406\u72b6\u6001\uff01", (Object)deliveryNo);
                unDeliveryStoreBo.setOptDesc("\u95e8\u5e97\uff08" + orderDeliveryEo.getWarehouseCode() + "-" + orderDeliveryEo.getWarehouseName() + "\uff09\u62d2\u5355\uff0c\u5168\u6e20\u9053\u8def\u7531\u914d\u7f6e\u672a\u5f00\u542f\uff0c\u53d1\u8d27\u5355\u72b6\u6001\u66f4\u65b0\u4e3a\u5f85\u5904\u7406\u3002");
                unDeliveryStoreBo.setRouteType(DeliveryStatusEnum.TO_DO.getStatus());
            } else if (null == orderRouteRule) {
                logger.info("\u53d1\u8d27\u5355\u53f7\uff1a{}\uff0c\u95e8\u5e97\u65e0\u6cd5\u53d1\u8d27\uff0c\u8def\u7531\u89c4\u5219\u672a\u5f00\u542f\uff0c\u53d1\u8d27\u5355\u66f4\u65b0\u4e3a\u5f85\u5904\u7406\u72b6\u6001\uff01", (Object)deliveryNo);
                unDeliveryStoreBo.setOptDesc("\u95e8\u5e97\uff08" + orderDeliveryEo.getWarehouseCode() + "-" + orderDeliveryEo.getWarehouseName() + "\uff09\u62d2\u5355\uff0c\u8def\u7531\u89c4\u5219\u914d\u7f6e\u672a\u5f00\u542f\uff0c\u53d1\u8d27\u5355\u72b6\u6001\u66f4\u65b0\u4e3a\u5f85\u5904\u7406\u3002");
                unDeliveryStoreBo.setRouteType(DeliveryStatusEnum.TO_DO.getStatus());
            } else if (RouteTypeEnum.ASSIGN.getType().equals(orderRouteRule.getRouteType())) {
                logger.info("\u53d1\u8d27\u5355\u53f7\uff1a{}\uff0c\u95e8\u5e97\u65e0\u6cd5\u53d1\u8d27\uff0c\u8def\u7531\u89c4\u5219\u914d\u7f6e\u7c7b\u578b\u4e3a\u6307\u5b9a\u8def\u5f84\uff0c\u53d1\u8d27\u5355\u66f4\u65b0\u4e3a\u5f85\u6307\u6d3e\u72b6\u6001\uff01", (Object)deliveryNo);
                unDeliveryStoreBo.setOptDesc("\u95e8\u5e97\uff08" + orderDeliveryEo.getWarehouseCode() + "-" + orderDeliveryEo.getWarehouseName() + "\uff09\u62d2\u5355\uff0c\u8def\u7531\u89c4\u5219\u914d\u7f6e\u7c7b\u578b\u4e3a\u6307\u5b9a\u8def\u5f84\uff0c\u53d1\u8d27\u5355\u72b6\u6001\u66f4\u65b0\u4e3a\u5f85\u6307\u6d3e\u3002");
                unDeliveryStoreBo.setRouteType(RouteTypeEnum.ASSIGN.getType());
            } else {
                logger.info("\u53d1\u8d27\u5355\u53f7\uff1a{}\uff0c\u68c0\u67e5\u662f\u5426\u4e3a\u7b2c\u4e00\u6b21\u65e0\u6cd5\u53d1\u8d27\uff0c\u62d2\u5355\u6216\u65e0\u6cd5\u53d1\u8d27\u6b21\u6570\uff1a{}", (Object)orderDeliveryEo.getDeliveryNo(), (Object)failByDeliveryCount);
                unDeliveryStoreBo.setRouteType(RouteTypeEnum.COMBINE.getType());
            }
        } else {
            logger.info("\u53d1\u8d27\u5355\u53f7\uff1a{}\uff0c\u4e0a\u95e8\u81ea\u63d0\u65e0\u6cd5\u53d1\u8d27\uff0c\u53d6\u6d88\u53d1\u8d27\u5355", (Object)orderDeliveryEo.getDeliveryNo());
            unDeliveryStoreBo.setRouteType("CANCEL");
        }
        unDeliveryStoreBo.setOrderNo(orderDeliveryEo.getOrderNo());
        return unDeliveryStoreBo;
    }

    @Override
    public List<DeliveryLogisticRespDto> listDeliveryLogistics(ShippingReqDto shippingReqDto) {
        List<DeliveryLogisticRespDto> deliveryLogistics = new ArrayList<DeliveryLogisticRespDto>();
        try {
            List<ShippingRespDto> shippingRespDtos = this.shippingService.listLogistics(shippingReqDto);
            if (CollectionUtils.isNotEmpty(shippingRespDtos)) {
                deliveryLogistics = BeanUtil.copyList(shippingRespDtos, DeliveryLogisticRespDto.class);
            }
            return deliveryLogistics;
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u7269\u6d41\u8f68\u8ff9\u51fa\u73b0\u5f02\u5e38,shippingReqDto\uff1a{},e:{}", new Object[]{JSON.toJSONString((Object)shippingReqDto), e.getMessage(), e});
            return deliveryLogistics;
        }
    }

    @Override
    public DeliveryAssignBo assign(DeliveryAssignBo deliveryAssignBo) {
        DeliveryAssignReqDto deliveryAssignReqDto = deliveryAssignBo.getDeliveryAssignReqDto();
        logger.info("\u53d1\u8d27\u5355\u6307\u6d3e\u64cd\u4f5c\uff0c\u5165\u53c2DeliveryAssignReqDto\uff1a{}", (Object)JSON.toJSONString((Object)deliveryAssignReqDto));
        if (StringUtils.isBlank((CharSequence)deliveryAssignReqDto.getWarehouseCode())) {
            throw new BizException("\u6307\u6d3e\u4ed3\u5e93\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String deliveryNo = deliveryAssignReqDto.getDeliveryNo();
        OrderDeliveryEo orderDeliveryEo = deliveryAssignBo.getOrderDeliveryEo();
        deliveryAssignBo.setPreStatus(orderDeliveryEo.getDeliveryStatus());
        WarehouseRespDto warehouse = (WarehouseRespDto)this.warehouseQueryApi.queryWarehouseByCode(deliveryAssignReqDto.getWarehouseCode(), null).getData();
        if (null == warehouse) {
            logger.error("\u8fd0\u8425\u4eba\u5458\u6307\u6d3e\u53d1\u8d27\u5355\u5931\u8d25\uff0c\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u4ed3\u5e93\u4fe1\u606f\uff0cdeliveryNo:{}, warehouseCode:{}", (Object)deliveryNo, (Object)deliveryAssignReqDto.getWarehouseCode());
            throw new BizException("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u4ed3\u5e93\u4fe1\u606f\uff01");
        }
        if (!String.valueOf(WarehouseTypeEnum.LOGICAL.getCode()).equals(warehouse.getType())) {
            logger.error("\u8fd0\u8425\u4eba\u5458\u6307\u6d3e\u53d1\u8d27\u5355\u5931\u8d25\uff0c\u4ed3\u5e93\u4e0d\u4e3a\u903b\u8f91\u4ed3\uff0cdeliveryNo:{}, warehouseCode:{}\uff0cwarehouseType:{}", new Object[]{deliveryNo, deliveryAssignReqDto.getWarehouseCode(), warehouse.getType()});
            throw new BizException("\u53ea\u80fd\u6307\u6d3e\u5230\u903b\u8f91\u4ed3\uff01");
        }
        if (!SaleChannelEnum.SALECHANNEL_ZYSC.getCode().equals(orderDeliveryEo.getChannel())) {
            this.checkCargoStorage(deliveryNo, warehouse.getCode());
        }
        orderDeliveryEo.setWarehouseCode(warehouse.getCode());
        orderDeliveryEo.setWarehouseName(warehouse.getName());
        orderDeliveryEo.setOrganizationId(warehouse.getOrganizationId());
        orderDeliveryEo.setOrganizationName(warehouse.getOrganizationName());
        if (Integer.valueOf(WarehouseSubTypeEnum.LOGICAL_SHOP_WAREHOUSE.getCode()).equals(warehouse.getSubType())) {
            deliveryAssignBo.setWarehouseSubType("shop");
            logger.info("\u53d1\u8d27\u5355\u6307\u6d3e\u5230\u95e8\u5e97\u4ed3:{}-{}\uff0c\u53d1\u8d27\u5355\u72b6\u6001\u66f4\u65b0\u4e3a\u5f85\u63a5\u5355\u72b6\u6001\u2026\u2026", (Object)warehouse.getCode(), (Object)warehouse.getName());
            deliveryAssignBo.setOptDesc("\u8fd0\u8425\u4eba\u5458\u6307\u6d3e\u53d1\u8d27\u5355\u5230\u95e8\u5e97\u4ed3\u5e93\uff08" + orderDeliveryEo.getWarehouseCode() + "-" + orderDeliveryEo.getWarehouseName() + "\uff09\uff0c\u53d1\u8d27\u5355\u72b6\u6001\u66f4\u65b0\u4e3a\u5f85\u63a5\u5355\u3002");
        } else {
            deliveryAssignBo.setWarehouseSubType("other");
            logger.info("\u53d1\u8d27\u5355\u6307\u6d3e\u5230\u975e\u95e8\u5e97\u4ed3:{}-{}\uff0c\u53d1\u8d27\u5355\u72b6\u6001\u66f4\u65b0\u4e3a\u5f85\u53d1\u8d27\u72b6\u6001\u2026\u2026", (Object)warehouse.getCode(), (Object)warehouse.getName());
            deliveryAssignBo.setOptDesc("\u8fd0\u8425\u4eba\u5458\u6307\u6d3e\u53d1\u8d27\u5355\u5230\u975e\u95e8\u5e97\u4ed3\u5e93\uff08" + orderDeliveryEo.getWarehouseCode() + "-" + orderDeliveryEo.getWarehouseName() + "\uff09\uff0c\u53d1\u8d27\u5355\u72b6\u6001\u66f4\u65b0\u4e3a\u5f85\u53d1\u8d27\u3002");
            try {
                OrderDeliveryEo orderDeliveryUpdate = OrderDeliveryEo.newInstance();
                orderDeliveryUpdate.setId(orderDeliveryEo.getId());
                orderDeliveryUpdate.setExtension("1");
                this.orderDeliveryDas.updateSelective((BaseEo)orderDeliveryUpdate);
                logger.info("\u6307\u6d3e\u53d1\u8d27\u5355\u540c\u6b65wms\u5f00\u59cb");
                logger.info("\u6307\u6d3e\u53d1\u8d27\u5355\u540c\u6b65wms\u5b8c\u6210");
            }
            catch (Exception e) {
                logger.info("\u6307\u6d3e\u53d1\u8d27\u5355\u540c\u6b65wms\u5f02\u5e38\uff1a{}\uff0c{}", (Object)e.getStackTrace(), (Object)e.getMessage());
            }
        }
        logger.info("\u8fd0\u8425\u4eba\u5458\u6307\u6d3e\u53d1\u8d27\u5355\u6210\u529f\uff0cdeliveryNo\uff1a{}\uff0cwarehouseCode\uff1a{}", (Object)deliveryNo, (Object)deliveryAssignReqDto.getWarehouseCode());
        deliveryAssignBo.setOptCode(DeliveryRouteOptEnum.ASSIGN.getOptCode());
        return deliveryAssignBo;
    }

    private void checkCargoStorage(String deliveryNo, String warehouseCode) {
        List<DeliveryItemEo> deliveryItemEos = this.deliveryItemService.listByDeliveryNo(deliveryNo);
        Map<String, Integer> deliveryItemMap = deliveryItemEos.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getCargoSerial())).collect(Collectors.groupingBy(StdDeliveryItemEo::getCargoSerial, Collectors.summingInt(StdDeliveryItemEo::getItemNum)));
        ArrayList<CargoStorageCheckItemReqDto> cargos = new ArrayList<CargoStorageCheckItemReqDto>();
        for (Map.Entry<String, Integer> entry : deliveryItemMap.entrySet()) {
            String cargoCode = entry.getKey();
            Integer cargoNum = entry.getValue();
            CargoStorageCheckItemReqDto cargoStorageCheckItemReqDto = new CargoStorageCheckItemReqDto();
            cargoStorageCheckItemReqDto.setCargoCode(cargoCode);
            cargoStorageCheckItemReqDto.setCargoNum(cargoNum);
            cargos.add(cargoStorageCheckItemReqDto);
        }
        CargoStorageCheckReqDto cargoStorageCheckReqDto = new CargoStorageCheckReqDto();
        cargoStorageCheckReqDto.setWarehouseCode(warehouseCode);
        cargoStorageCheckReqDto.setCargos(cargos);
        RestResponse response = this.warehouseCargoQueryApi.checkCargoStorage(cargoStorageCheckReqDto);
        if (!"0".equals(response.getResultCode())) {
            logger.error("\u6821\u9a8c\u53d1\u8d27\u4ed3\u5e93\u5e93\u5b58\u6570\u51fa\u73b0\u5f02\u5e38\uff1a{}", (Object)response.getResultMsg());
            throw new BizException(response.getResultMsg());
        }
    }

    public static void main(String[] args) {
        ArrayList<DeliveryItemEo> deliveryItemEos = new ArrayList<DeliveryItemEo>();
        DeliveryItemEo item1 = DeliveryItemEo.newInstance();
        DeliveryItemEo item2 = DeliveryItemEo.newInstance();
        DeliveryItemEo item3 = DeliveryItemEo.newInstance();
        item1.setCargoSerial("001");
        item1.setItemNum(Integer.valueOf(1));
        item2.setCargoSerial("002");
        item2.setItemNum(Integer.valueOf(2));
        item3.setItemNum(Integer.valueOf(3));
        deliveryItemEos.add(item1);
        deliveryItemEos.add(item2);
        deliveryItemEos.add(item3);
        Map<String, Integer> deliveryItemMap = deliveryItemEos.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getCargoSerial())).collect(Collectors.groupingBy(StdDeliveryItemEo::getCargoSerial, Collectors.summingInt(StdDeliveryItemEo::getItemNum)));
        System.out.println(JSON.toJSONString(deliveryItemMap));
    }

    @Override
    public void confirmReceipt(String orderNo) {
        RefDeliveryOrderEo select = RefDeliveryOrderEo.newInstance();
        select.setOrderNo(orderNo);
        List refDeliveryOrderEos = this.refDeliveryOrderDas.select((BaseEo)select);
        if (CollectionUtils.isEmpty((Collection)refDeliveryOrderEos)) {
            logger.warn("\u627e\u4e0d\u5230\u8ba2\u5355\u53f7{}\u5bf9\u5e94\u7684\u53d1\u8d27\u5355\u4fe1\u606f", (Object)orderNo);
            return;
        }
        List deliveryNos = refDeliveryOrderEos.stream().map(StdRefDeliveryOrderEo::getDeliveryNo).collect(Collectors.toList());
        OrderDeliveryEo orderDeliverySelect = OrderDeliveryEo.newInstance();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"deliveryNo", deliveryNos));
        orderDeliverySelect.setSqlFilters(sqlFilters);
        List orderDeliverys = this.orderDeliveryDas.select((BaseEo)orderDeliverySelect);
        if (CollectionUtils.isEmpty((Collection)orderDeliverys)) {
            logger.warn("\u627e\u4e0d\u5230\u8ba2\u5355\u53f7{}\u5bf9\u5e94\u7684\u53d1\u8d27\u5355\u4fe1\u606f.", (Object)orderNo);
            return;
        }
        for (OrderDeliveryEo orderDeliveryEo : orderDeliverys) {
            OrderDeliveryEo orderDeliveryUpdateEo = OrderDeliveryEo.newInstance();
            orderDeliveryUpdateEo.setId(orderDeliveryEo.getId());
            orderDeliveryUpdateEo.setDeliveryStatus(DeliveryStatusEnum.SIGNED.getStatus());
            this.orderDeliveryDas.updateSelective((BaseEo)orderDeliveryUpdateEo);
            DeliveryChangeReqDto deliveryChangeReqDto = new DeliveryChangeReqDto();
            deliveryChangeReqDto.setDeliveryNo(orderDeliveryEo.getDeliveryNo());
            deliveryChangeReqDto.setPreDeliveryStatus(orderDeliveryEo.getDeliveryStatus());
            deliveryChangeReqDto.setDeliveryStatus(orderDeliveryUpdateEo.getDeliveryStatus());
            deliveryChangeReqDto.setOptCode(DeliveryRouteOptEnum.SIGNED.getOptCode());
            deliveryChangeReqDto.setWarehouseCode(orderDeliveryEo.getWarehouseCode());
            deliveryChangeReqDto.setWarehouseName(orderDeliveryEo.getWarehouseName());
            deliveryChangeReqDto.setDetailDesc("\u7528\u6237\u786e\u8ba4\u6536\u8d27\uff0c\u53d1\u8d27\u5355\u72b6\u6001\u66f4\u65b0\u4e3a\u5df2\u7b7e\u6536");
            this.deliveryProducer.sendInventoryDeliveryChange(deliveryChangeReqDto);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public OrderDeliveryConfirmBo confirm(OrderDeliveryConfirmBo orderDeliveryBo) {
        RefDeliveryOrderEo refDeliveryOrderEo = new RefDeliveryOrderEo();
        refDeliveryOrderEo.setDeliveryNo(orderDeliveryBo.getOrderDeliveryEo().getDeliveryNo());
        List refDeliveryOrderEos = this.refDeliveryOrderDas.select((BaseEo)refDeliveryOrderEo);
        if (CollectionUtils.isEmpty((Collection)refDeliveryOrderEos)) {
            throw new BizException("\u53d1\u8d27\u5355" + orderDeliveryBo.getDeliveryNo() + "\u67e5\u8be2\u4e0d\u5230\u5f15\u7528\u8bb0\u5f55");
        }
        if (refDeliveryOrderEos.size() > 1) {
            throw new BizException("\u53d1\u8d27\u5355" + orderDeliveryBo.getDeliveryNo() + "\u786e\u8ba4\u6536\u8d27\u9519\u8bef\uff0c\u4ec5\u4ec5\u53ea\u652f\u6301\u5173\u8054\u4e00\u4e2a\u8ba2\u5355\u53f7\u786e\u8ba4\u6536\u8d27");
        }
        OrderDeliveryEo orderDeliveryEo = orderDeliveryBo.getOrderDeliveryEo();
        orderDeliveryBo.setOrderNo(orderDeliveryEo.getOrderNo());
        if (orderDeliveryEo.getDeliveryPlanId() != null) {
            logger.info("\u5468\u671f\u8d2d\u8ba2\u5355\u786e\u8ba4\u6536\u8d27\uff1a{}", (Object)orderDeliveryEo.getDeliveryNo());
            this.commonsMqService.sendSingleMessage(this.environment.resolvePlaceholders("CONFIRM_ORDER_DELIVERY_TAG"), (Object)orderDeliveryEo.getDeliveryNo());
        } else {
            RefDeliveryOrderEo refDeliveryOrder = (RefDeliveryOrderEo)refDeliveryOrderEos.get(0);
            orderDeliveryBo.setOrderNo(refDeliveryOrder.getOrderNo());
            orderDeliveryBo.setDeliveryType("orderConfirm");
        }
        return orderDeliveryBo;
    }

    @Override
    public void confirmByOrderNo(String orderNo) {
        RefDeliveryOrderEo refDeliveryOrderSelect = RefDeliveryOrderEo.newInstance();
        refDeliveryOrderSelect.setOrderNo(orderNo);
        List refDeliveryOrders = this.refDeliveryOrderDas.select((BaseEo)refDeliveryOrderSelect);
        if (CollectionUtils.isEmpty((Collection)refDeliveryOrders)) {
            logger.warn("\u8ba2\u5355\u7b7e\u6536\u627e\u4e0d\u5bf9\u5e94\u7684\u53d1\u8d27\u5355\u4fe1\u606f\uff0corderNo\uff1a{}", (Object)orderNo);
            return;
        }
        List deliveryNos = refDeliveryOrders.stream().map(StdRefDeliveryOrderEo::getDeliveryNo).collect(Collectors.toList());
        OrderDeliveryEo orderDeliverySelect = OrderDeliveryEo.newInstance();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"deliveryNo", deliveryNos));
        orderDeliverySelect.setSqlFilters(sqlFilters);
        List orderDeliverys = this.orderDeliveryDas.select((BaseEo)orderDeliverySelect);
        orderDeliverys.forEach(orderDeliveryEo -> {
            OrderDeliveryEo orderDeliveryUpdate = OrderDeliveryEo.newInstance();
            orderDeliveryUpdate.setId(orderDeliveryEo.getId());
            orderDeliveryUpdate.setDeliveryStatus(OrderDeliveryStatusEnum.SIGNED.getStatus());
            this.orderDeliveryDas.updateSelective((BaseEo)orderDeliveryUpdate);
            logger.info("\u66f4\u65b0\u53d1\u8d27\u5355\u72b6\u6001\u4e3a\u5df2\u7b7e\u6536\u72b6\u6001\uff0corderNo\uff1a{}\uff0cdeliveryNo\uff1a{}", (Object)orderNo, (Object)orderDeliveryEo.getDeliveryNo());
        });
    }

    private String getOrderNo(OrderDeliveryEo orderDeliveryEo) {
        if (StringUtils.isNotBlank((CharSequence)orderDeliveryEo.getOrderNo())) {
            return orderDeliveryEo.getOrderNo();
        }
        RefDeliveryOrderEo refDeliveryOrderEo = new RefDeliveryOrderEo();
        refDeliveryOrderEo.setDeliveryNo(orderDeliveryEo.getDeliveryNo());
        RefDeliveryOrderEo refDeliveryOrder = (RefDeliveryOrderEo)this.refDeliveryOrderDas.selectOne((BaseEo)refDeliveryOrderEo);
        return refDeliveryOrder.getOrderNo();
    }

    @Override
    public List<CancelPartnerDeliveryReasonRespDto> listCancelReason(Integer shippingCompanyCode) {
        List daDaCancelReasonsRespDtoList;
        DaDaResponse daDaResponse;
        ArrayList<CancelPartnerDeliveryReasonRespDto> list = new ArrayList<CancelPartnerDeliveryReasonRespDto>();
        if (shippingCompanyCode == null || ShippingChannelEnum.SELF.getCode() == shippingCompanyCode.intValue()) {
            list.add(new CancelPartnerDeliveryReasonRespDto("10000", "\u5176\u4ed6"));
        }
        if (shippingCompanyCode != null && ShippingChannelEnum.DADA.getCode() == shippingCompanyCode.intValue() && DaDaLogisticsUtils.checkSuccess(daDaResponse = this.daDaLogisticsService.cancelReasons()) && daDaResponse.getResult() != null && CollectionUtils.isNotEmpty((Collection)(daDaCancelReasonsRespDtoList = JSON.parseArray((String)JSON.toJSONString((Object)daDaResponse.getResult()), DaDaCancelReasonsRespDto.class)))) {
            daDaCancelReasonsRespDtoList.forEach(dto -> list.add(new CancelPartnerDeliveryReasonRespDto(String.valueOf(dto.getId()), dto.getReason())));
        }
        return list;
    }

    @Override
    public DeliveryVo getDeliveryByDeliveryNo(String deliveryNo) {
        DeliveryVo deliveryVo = new DeliveryVo();
        OrderDeliveryEo orderDeliverySelect = OrderDeliveryEo.newInstance();
        orderDeliverySelect.setDeliveryNo(deliveryNo);
        OrderDeliveryEo orderDelivery = (OrderDeliveryEo)this.orderDeliveryDas.selectOne((BaseEo)orderDeliverySelect);
        if (null == orderDelivery) {
            return null;
        }
        RefDeliveryOrderEo refDeliveryOrderSelect = RefDeliveryOrderEo.newInstance();
        refDeliveryOrderSelect.setDeliveryNo(deliveryNo);
        List refDeliveryOrders = this.refDeliveryOrderDas.select((BaseEo)refDeliveryOrderSelect);
        DeliveryItemEo deliveryItemSelect = DeliveryItemEo.newInstance();
        deliveryItemSelect.setDeliveryNo(deliveryNo);
        List deliveryItems = this.deliveryItemDas.select((BaseEo)deliveryItemSelect);
        deliveryVo.setOrderDelivery(orderDelivery);
        deliveryVo.setRefDeliveryOrders(refDeliveryOrders);
        deliveryVo.setDeliveryItems(deliveryItems);
        return deliveryVo;
    }

    @Override
    public String updateExpressCode(OrderDeliveryEo orderDeliveryEo) {
        OrderDeliveryEo select = OrderDeliveryEo.newInstance();
        select.setDeliveryNo(orderDeliveryEo.getDeliveryNo());
        OrderDeliveryEo deliveryEo = (OrderDeliveryEo)this.orderDeliveryDas.selectOne((BaseEo)select);
        deliveryEo.setShippingType(orderDeliveryEo.getShippingType());
        deliveryEo.setShippingCompany(orderDeliveryEo.getShippingCompany());
        deliveryEo.setExpressCode(orderDeliveryEo.getExpressCode());
        int updateSelective = this.orderDeliveryDas.updateSelective((BaseEo)deliveryEo);
        if (updateSelective < 0) {
            throw new BizException("\u4fee\u6539\u7269\u6d41\u4fe1\u606f\u5931\u8d25");
        }
        return deliveryEo.getExpressCode();
    }

    @Override
    public RestResponse<Void> deliverThird(DeliveryStoreReqDto deliveryStoreReqDto) {
        String deliveryNo = deliveryStoreReqDto.getDeliveryNo();
        logger.info("\u53d1\u8d27\u5355\uff1a{}\u5f00\u59cb\u64cd\u4f5c\u7b2c\u4e09\u65b9\u53d1\u8d27\u2026\u2026", (Object)deliveryNo);
        RefDeliveryOrderEo refDeliveryOrderSelect = RefDeliveryOrderEo.newInstance();
        refDeliveryOrderSelect.setDeliveryNo(deliveryNo);
        List refDeliveryOrderEos = this.refDeliveryOrderDas.select((BaseEo)refDeliveryOrderSelect);
        if (CollectionUtils.isEmpty((Collection)refDeliveryOrderEos)) {
            logger.error("\u53d1\u8d27\u5355\u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u53d1\u8d27\u5355\u8ba2\u5355\u5173\u8054\u4fe1\u606f\uff0cdeliveryNo\uff1a{}", (Object)deliveryNo);
            throw new BizException("\u53d1\u8d27\u5355\u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u53d1\u8d27\u5355\u8ba2\u5355\u5173\u8054\u4fe1\u606f");
        }
        for (RefDeliveryOrderEo refDeliveryOrder : refDeliveryOrderEos) {
            if (null == refDeliveryOrder) {
                logger.error("\u53d1\u8d27\u5355\u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u53d1\u8d27\u5355\u8ba2\u5355\u5173\u8054\u4fe1\u606f\uff0cdeliveryNo\uff1a{}", (Object)deliveryNo);
                continue;
            }
            String orderNo = refDeliveryOrder.getOrderNo();
            OrderEo orderSelect = OrderEo.newInstance();
            orderSelect.setOrderNo(orderNo);
            OrderEo order = (OrderEo)this.orderDas.selectOne((BaseEo)orderSelect);
            String channelCode = order.getSaleChannel();
            if (!this.ifNeedDeliveryThird(channelCode)) {
                logger.info("\u6e20\u9053\uff1a{}\u53d1\u8d27\u5355\u4e0d\u9700\u8981\u7b2c\u4e09\u65b9\u53d1\u8d27", (Object)channelCode);
                continue;
            }
            logger.info("\u6e20\u9053\uff1a{}\u53d1\u8d27\u5355\u9700\u8981\u7b2c\u4e09\u65b9\u53d1\u8d27\u2026\u2026", (Object)channelCode);
            String shippingCompany = deliveryStoreReqDto.getShippingCompany();
            String expressCode = deliveryStoreReqDto.getExpressCode();
            logger.info("\u6839\u636e\u6e20\u9053\u7f16\u7801\u548c\u7269\u6d41\u516c\u53f8\u540d\u79f0\u83b7\u53d6\u7b2c\u4e09\u65b9\u53d1\u8d27\u7269\u6d41\u4fe1\u606f\uff1a{}\uff0c{}", (Object)channelCode, (Object)shippingCompany);
            LogisticsCompanyRespDto logisticsCompany = (LogisticsCompanyRespDto)this.logisticsCompanyApi.queryByName(channelCode, shippingCompany).getData();
            logger.info("\u6839\u636e\u6e20\u9053\u7f16\u7801\u548c\u7269\u6d41\u516c\u53f8\u540d\u79f0\u83b7\u53d6\u7b2c\u4e09\u65b9\u53d1\u8d27\u7269\u6d41\u4fe1\u606f\u8fd4\u56de\uff1a{}", (Object)logisticsCompany);
            if (null == logisticsCompany) {
                logger.info("\u6e20\u9053\uff1a{}\u53d1\u8d27\u5355\u4e0d\u9700\u8981\u7b2c\u4e09\u65b9\u53d1\u8d27", (Object)channelCode);
                continue;
            }
            LogisticsOfflineReqDto logisticsOfflineReqDto = new LogisticsOfflineReqDto();
            logisticsOfflineReqDto.setCompanyCode(logisticsCompany.getCode());
            logisticsOfflineReqDto.setOutSid(expressCode);
            logisticsOfflineReqDto.setTid(order.getThirdOrderNo());
            logisticsOfflineReqDto.setShopCode(order.getShopCode());
            logger.info("\u5f00\u59cb\u8c03\u7528\u7b2c\u4e09\u65b9\u53d1\u8d27\u63a5\u53e3\uff0c\u5165\u53c2channelCode\uff1a{}\uff0clogisticsOfflineReqDto\uff1a{}", (Object)channelCode, (Object)JSON.toJSONString((Object)logisticsOfflineReqDto));
            try {
                RestResponse response = this.connectorOrderApi.logisticsOffline(channelCode, logisticsOfflineReqDto);
                logger.info("\u64cd\u4f5c\u7b2c\u4e09\u65b9\u53d1\u8d27\u6210\u529f\uff0c\u8fd4\u56de\u54cd\u5e94\u4fe1\u606f\uff0cresponse:{}", (Object)JSON.toJSONString((Object)response));
                if ("0".equals(response.getResultCode())) continue;
                throw new BizException("\u8c03\u7528\u7b2c\u4e09\u65b9\u53d1\u8d27\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u7269\u6d41\u5355\u4fe1\u606f\u662f\u5426\u6709\u6548\uff01");
            }
            catch (Exception e) {
                logger.error("\u8c03\u7528\u7b2c\u4e09\u65b9\u53d1\u8d27\u5931\u8d25\uff0c\u53d1\u8d27\u5355\u53f7\uff1a{}\uff0ce:{}", new Object[]{deliveryNo, e.getMessage(), e});
            }
        }
        return RestResponse.VOID;
    }

    private boolean ifNeedDeliveryThird(String channelCode) {
        return SaleChannelEnum.TMALL.getCode().equalsIgnoreCase(channelCode) || SaleChannelEnum.JD.getCode().equalsIgnoreCase(channelCode) || SaleChannelEnum.TB.getCode().equalsIgnoreCase(channelCode) || SaleChannelEnum.DOUYIN.getCode().equalsIgnoreCase(channelCode);
    }

    @Override
    @Transactional
    public void addDelivery(DeliveryAddReqDto deliveryAddReqDto) {
        DeliveryBasicReqDto deliveryDto = deliveryAddReqDto.getDelivery();
        List deliveryOrders = deliveryAddReqDto.getDeliveryOrders();
        List deliveryItems = deliveryAddReqDto.getDeliveryItems();
        String deliveryNo = deliveryDto.getDeliveryNo();
        OrderDeliveryEo select = OrderDeliveryEo.newInstance();
        select.setDeliveryNo(deliveryNo);
        int count = this.orderDeliveryDas.count((BaseEo)select);
        if (count > 0) {
            throw new BizException("\u53d1\u8d27\u5355\u53f7" + deliveryNo + "\u5df2\u5b58\u5728");
        }
        OrderDeliveryEo orderDeliveryEo = new OrderDeliveryEo();
        BeanUtils.copyProperties((Object)deliveryDto, (Object)orderDeliveryEo);
        orderDeliveryEo.setOrderNo(((DeliveryItemBasicReqDto)deliveryItems.get(0)).getOrderNo());
        orderDeliveryEo.setTradeNo(((DeliveryItemBasicReqDto)deliveryItems.get(0)).getOrderNo());
        orderDeliveryEo.setDeliveryType(Integer.valueOf(null != orderDeliveryEo.getDeliveryType() ? orderDeliveryEo.getDeliveryType() : 1));
        this.orderDeliveryDas.insert((BaseEo)orderDeliveryEo);
        ArrayList deliveryItemEos = new ArrayList();
        deliveryItems.forEach(deliveryItem -> {
            deliveryItem.setDeliveryNo(deliveryNo);
            String orderNo = deliveryItem.getOrderNo();
            DeliveryItemEo deliveryItemEo = new DeliveryItemEo();
            BeanUtils.copyProperties((Object)deliveryItem, (Object)deliveryItemEo);
            deliveryItemEo.setTradeNo(StringUtils.isNotBlank((CharSequence)orderNo) ? orderNo : "");
            deliveryItemEo.setDeliveryType(StringUtils.isNotBlank((CharSequence)deliveryItemEo.getDeliveryType()) ? deliveryItemEo.getDeliveryType() : "");
            deliveryItemEo.setDeliverySubType(StringUtils.isNotBlank((CharSequence)deliveryItemEo.getDeliverySubType()) ? deliveryItemEo.getDeliverySubType() : "");
            deliveryItemEo.setSkuSerial(StringUtils.isNotBlank((CharSequence)deliveryItemEo.getSkuSerial()) ? deliveryItemEo.getSkuSerial() : "");
            deliveryItemEo.setSkuCode(StringUtils.isNotBlank((CharSequence)deliveryItemEo.getSkuCode()) ? deliveryItemEo.getSkuCode() : "");
            deliveryItemEos.add(deliveryItemEo);
        });
        this.deliveryItemDas.insertBatch(deliveryItemEos);
        ArrayList refDeliveryOrderEos = new ArrayList();
        deliveryOrders.forEach(deliveryOrder -> {
            RefDeliveryOrderEo refDeliveryOrderEo = RefDeliveryOrderEo.newInstance();
            refDeliveryOrderEo.setDeliveryNo(deliveryNo);
            refDeliveryOrderEo.setOrderNo(deliveryOrder.getOrderNo());
            refDeliveryOrderEos.add(refDeliveryOrderEo);
        });
        this.refDeliveryOrderDas.insertBatch(refDeliveryOrderEos);
    }

    @Override
    @Transactional
    public void addDeliveryPackage(DeliveryPackageAddReqDto deliveryPackageAddReqDto) {
        DeliveryPackageReqDto packageReqDto = deliveryPackageAddReqDto.getPackageReqDto();
        String packageSerial = packageReqDto.getPackageSerial();
        PackageItemEo select = PackageItemEo.newInstance();
        select.setPackageSerial(packageSerial);
        int count = this.packageItemDas.count((BaseEo)select);
        if (count > 0) {
            throw new BizException("\u5305\u88f9" + packageSerial + "\u5df2\u5b58\u5728");
        }
        ArrayList packageItems = new ArrayList();
        List packageItemDtos = deliveryPackageAddReqDto.getPackageItems();
        packageItemDtos.stream().forEach(packageItemDto -> {
            PackageItemEo packageItem = PackageItemEo.newInstance();
            BeanUtils.copyProperties((Object)packageItemDto, (Object)packageItem);
            packageItem.setDeliveryNo(packageReqDto.getDeliveryNo());
            packageItem.setPackageSrc(packageReqDto.getPackageSrc());
            packageItem.setPackageSerial(packageReqDto.getPackageSerial());
            packageItem.setShippingCompany(packageReqDto.getShippingCompany());
            packageItem.setShippingCompanyCode(packageReqDto.getShippingCompanyCode());
            packageItem.setShippingSerial(packageReqDto.getShippingSerial());
            packageItem.setTradeNo(StringUtils.isNotBlank((CharSequence)packageItem.getTradeNo()) ? packageItem.getTradeNo() : "");
            packageItem.setDeliveryType(StringUtils.isNotBlank((CharSequence)packageItem.getDeliveryType()) ? packageItem.getDeliveryType() : "");
            packageItem.setDeliverySubType(StringUtils.isNotBlank((CharSequence)packageItem.getDeliverySubType()) ? packageItem.getDeliverySubType() : "");
            packageItem.setActualSkuSerial(StringUtils.isNotBlank((CharSequence)packageItem.getActualSkuSerial()) ? packageItem.getActualSkuSerial() : "");
            packageItem.setActualDeliveryNum(Integer.valueOf(null != packageItem.getActualDeliverySkuNum() ? packageItem.getActualDeliverySkuNum() : 0));
            packageItem.setActualDeliverySkuNum(Integer.valueOf(null != packageItem.getActualDeliverySkuNum() ? packageItem.getActualDeliverySkuNum() : 0));
            packageItems.add(packageItem);
        });
        this.packageItemDas.insertBatch(packageItems);
    }

    @Override
    public void confirmDelivery(Long deliveryId) {
        OrderDeliveryEo deliveryEo = new OrderDeliveryEo();
        deliveryEo.setId(deliveryId);
        List select = this.orderDeliveryDas.select((BaseEo)deliveryEo, Integer.valueOf(1), Integer.valueOf(1));
        if (select.size() <= 0) {
            throw new BizException("\u53d1\u8d27\u5355\u4e0d\u5b58\u5728[id=" + deliveryId + "]");
        }
        this.confirmDelivery((OrderDeliveryEo)select.get(0));
    }

    @Override
    public void confirmDelivery(OrderDeliveryEo orderDeliveryEo) {
        try {
            RefDeliveryOrderEo refDeliveryOrderSelect = RefDeliveryOrderEo.newInstance();
            refDeliveryOrderSelect.setDeliveryNo(orderDeliveryEo.getDeliveryNo());
            RefDeliveryOrderEo refDeliveryOrderEo = (RefDeliveryOrderEo)this.refDeliveryOrderDas.selectOne((BaseEo)refDeliveryOrderSelect);
            if (null == refDeliveryOrderEo) {
                logger.warn("\u53d1\u8d27\u5355\u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u627e\u4e0d\u5230\u5bf9\u5e94\u53d1\u8d27\u5355\u8ba2\u5355\u5173\u8054\u4fe1\u606f\u3002deliveryNo:{}", (Object)orderDeliveryEo.getDeliveryNo());
                return;
            }
            OrderEo orderSelect = OrderEo.newInstance();
            orderSelect.setOrderNo(refDeliveryOrderEo.getOrderNo());
            OrderEo orderEo = (OrderEo)this.orderDas.selectOne((BaseEo)orderSelect);
            if (null == orderEo) {
                logger.warn("\u53d1\u8d27\u5355\u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u8ba2\u5355\u4fe1\u606f\u3002deliveryNo:{}, orderNo:{}", (Object)orderDeliveryEo.getDeliveryNo(), (Object)refDeliveryOrderEo.getOrderNo());
                return;
            }
            Boolean routerConfigOpen = this.deliveryRouterService.checkRouterConfigOpen(orderEo, orderDeliveryEo);
            if (routerConfigOpen.booleanValue()) {
                orderDeliveryEo.setDeliveryStatus(DeliveryStatusEnum.TO_ROUTE.getStatus());
            } else {
                orderDeliveryEo.setDeliveryStatus(DeliveryStatusEnum.TO_DO.getStatus());
                orderDeliveryEo.clearWarehouse();
            }
            this.orderDeliveryDas.updateSelective((BaseEo)orderDeliveryEo);
            DeliveryChangeReqDto deliveryChangeReqDto = new DeliveryChangeReqDto();
            deliveryChangeReqDto.setDeliveryNo(orderDeliveryEo.getDeliveryNo());
            deliveryChangeReqDto.setPreDeliveryStatus(DeliveryStatusEnum.TO_CONFIRM.getStatus());
            deliveryChangeReqDto.setDeliveryStatus(orderDeliveryEo.getDeliveryStatus());
            deliveryChangeReqDto.setOptCode(DeliveryRouteOptEnum.CONFIRM.getOptCode());
            deliveryChangeReqDto.setDetailDesc("\u786e\u8ba4\u53d1\u8d27\u5355\uff0c\u53d1\u8d27\u5355\u72b6\u6001\u66f4\u65b0\u4e3a" + DeliveryStatusEnum.getMsg((String)orderDeliveryEo.getDeliveryStatus()));
            this.deliveryProducer.sendInventoryDeliveryChange(deliveryChangeReqDto);
        }
        catch (Exception e) {
            logger.info("\u5904\u7406\u5f85\u786e\u8ba4\u7684\u53d1\u8d27\u5355\u51fa\u73b0\u5f02\u5e38\uff0cdeliveryNo:{},e:{}", new Object[]{orderDeliveryEo.getDeliveryNo(), e.getMessage(), e});
        }
    }
}

