/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.SpringBeanUtil;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.data.api.dto.DictDto;
import com.dtyunxi.yundt.cube.center.data.api.query.IDictQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.constants.ExtOrderSelectStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.ExtlOrderModifyReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.ExtlOrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.TradeItemReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.ExtlOrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.ExtlOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.exception.TradeExceptionCode;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.utils.TradeUtil;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IExtlOrderService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.ITradeItemService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.extl.IExtlOrderQueryService;
import com.dtyunxi.yundt.cube.center.trade.biz.util.Assert;
import com.dtyunxi.yundt.cube.center.trade.dao.das.ExtlOrderDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.OrderDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.TradeItemDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.ExtlOrderEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.TradeItemEo;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ExtlOrderServiceImpl
implements IExtlOrderService {
    private static Logger logger = LoggerFactory.getLogger(ExtlOrderServiceImpl.class);
    @Resource
    private ExtlOrderDas extlOrderDas;
    @Resource
    private TradeItemDas tradeItemDas;
    @Resource
    private ITradeItemService tradeItemService;
    @Resource
    private OrderDas orderDas;
    @Resource
    private IDictQueryApi dictQueryApi;
    @Value(value="${spring.application.name}")
    private String applicationName;
    @Resource
    private ICacheService cacheService;

    @Override
    public Long add(ExtlOrderReqDto extlOrderReqDto) {
        ExtlOrderEo extlOrderEo = ExtlOrderEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)extlOrderReqDto, (BaseEo)extlOrderEo);
        this.extlOrderDas.insert((BaseEo)extlOrderEo);
        return extlOrderEo.getId();
    }

    @Override
    public void modify(ExtlOrderModifyReqDto extlOrderReqDto) {
        ExtlOrderEo extlOrderEo = ExtlOrderEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)extlOrderReqDto, (BaseEo)extlOrderEo);
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.eq((String)"trade_no", (Object)extlOrderEo.getTradeNo()));
        extlOrderEo.setSqlFilters(sqlFilters);
        this.extlOrderDas.updateSelectiveSqlFilter((BaseEo)extlOrderEo);
    }

    @Override
    public List<ExtlOrderRespDto> queryList(ExtlOrderReqDto extlOrderReqDto) {
        ExtlOrderEo extlOrderEo = ExtlOrderEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)extlOrderReqDto, (BaseEo)extlOrderEo);
        List resultList = this.extlOrderDas.select((BaseEo)extlOrderEo);
        ArrayList<ExtlOrderRespDto> extlOrderRespDtos = new ArrayList<ExtlOrderRespDto>();
        if (CollectionUtils.isNotEmpty((Collection)resultList)) {
            DtoHelper.eoList2DtoList((Collection)resultList, extlOrderRespDtos, ExtlOrderRespDto.class);
        }
        return extlOrderRespDtos;
    }

    @Override
    public PageInfo<ExtlOrderRespDto> queryList(ExtlOrderReqDto extlOrderReqDto, Integer pageNum, Integer pageSize) {
        ExtlOrderEo extlOrderEo = ExtlOrderEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)extlOrderReqDto, (BaseEo)extlOrderEo);
        PageInfo pageInfo = this.extlOrderDas.selectPage((BaseEo)extlOrderEo, pageNum, pageSize);
        List resultList = pageInfo.getList();
        ArrayList extlOrderRespDtos = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)resultList)) {
            DtoHelper.eoList2DtoList((Collection)resultList, extlOrderRespDtos, ExtlOrderRespDto.class);
        }
        PageInfo pageInfoDto = new PageInfo();
        BeanUtils.copyProperties((Object)pageInfo, (Object)pageInfoDto);
        pageInfoDto.setList(extlOrderRespDtos);
        return pageInfoDto;
    }

    @Override
    public ExtlOrderRespDto queryById(Long instanceId, Long tenantId, Long id) {
        ExtlOrderEo extlOrderEo = ExtlOrderEo.newInstance();
        extlOrderEo.setId(id);
        ExtlOrderEo result = (ExtlOrderEo)this.extlOrderDas.selectOne((BaseEo)extlOrderEo);
        ExtlOrderRespDto extlOrderRespDto = new ExtlOrderRespDto();
        DtoHelper.eo2Dto((BaseEo)result, (BaseVo)extlOrderRespDto);
        return extlOrderRespDto;
    }

    @Override
    public List<ExtlOrderDetailRespDto> queryByOrderSerial(String orderSerial, String extlChannel, String selectType) {
        Assert.notNull((Object)orderSerial, "\u5916\u90e8\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        ExtlOrderEo extlOrderEo = ExtlOrderEo.newInstance();
        extlOrderEo.setExtlOrderSerial(orderSerial);
        extlOrderEo.setExtlChannel(extlChannel);
        List eoList = this.extlOrderDas.select((BaseEo)extlOrderEo);
        ArrayList<ExtlOrderDetailRespDto> dtoList = new ArrayList<ExtlOrderDetailRespDto>();
        DtoHelper.eoList2DtoList((Collection)eoList, dtoList, ExtlOrderDetailRespDto.class);
        for (ExtlOrderDetailRespDto dto : dtoList) {
            this.queryOrderDetail(selectType, dto);
        }
        return dtoList;
    }

    @Override
    public ExtlOrderDetailRespDto queryByIdAndSelectType(Long id, String selectType) {
        ExtlOrderEo extlOrderEo = ExtlOrderEo.newInstance();
        extlOrderEo.setId(id);
        ExtlOrderEo result = (ExtlOrderEo)this.extlOrderDas.selectOne((BaseEo)extlOrderEo);
        ExtlOrderDetailRespDto respDto = new ExtlOrderDetailRespDto();
        DtoHelper.eo2Dto((BaseEo)result, (BaseVo)respDto);
        this.queryOrderDetail(selectType, respDto);
        return respDto;
    }

    private void queryOrderDetail(String selectType, ExtlOrderDetailRespDto respDto) {
        ArrayList<String> beanNames = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)selectType)) {
            String[] split;
            selectType = selectType.trim();
            for (String s : split = selectType.split(",")) {
                String beanName = ExtOrderSelectStatusEnum.getBeanName((String)s);
                if (beanName == null) {
                    throw new BizException("\u5916\u90e8\u8ba2\u5355\u67e5\u8be2\u7c7b\u578b\u4e0d\u6b63\u786e");
                }
                beanNames.add(beanName);
            }
        }
        for (String beanName : beanNames) {
            IExtlOrderQueryService extlOrderQueryService = (IExtlOrderQueryService)SpringBeanUtil.getBean((String)beanName);
            if (extlOrderQueryService == null) {
                throw new BizException("\u901a\u8fc7name\u67e5\u8be2\u4e0d\u5230bean");
            }
            extlOrderQueryService.select(respDto, respDto.getTradeNo());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addBatch(List<ExtlOrderReqDto> list) {
        HashMap<String, String> orderSerialChannelMap = new HashMap<String, String>(list.size());
        try {
            for (ExtlOrderReqDto extlOrderReqDto : list) {
                boolean success = this.cacheService.add(extlOrderReqDto.getExtlOrderSerial() + "_" + extlOrderReqDto.getExtlChannel(), (Object)"1");
                if (!success) {
                    throw new BizException(TradeExceptionCode.EXTL_ORDER_INSERT_FAIL.getCode(), TradeExceptionCode.EXTL_ORDER_INSERT_FAIL.getMsg());
                }
                orderSerialChannelMap.put(extlOrderReqDto.getExtlOrderSerial(), extlOrderReqDto.getExtlChannel());
            }
            this.excludeOwnOrder(list);
            List<ExtlOrderEo> extlOrderEoList = this.selectExistExtlOrder(list);
            String tradeNo = TradeUtil.generateTradeNo();
            for (ExtlOrderReqDto extlOrderReqDto : list) {
                List insertItems = extlOrderReqDto.getTradeItemReqDtos();
                Long oldId = null;
                BigDecimal payment = new BigDecimal(0);
                BigDecimal discountFee = new BigDecimal(0);
                BigDecimal platDiscountFee = new BigDecimal(0);
                BigDecimal totalAmount = new BigDecimal(0);
                Integer totalItemNum = 0;
                String oldStatus = "";
                for (ExtlOrderEo extlOrderEo : extlOrderEoList) {
                    if (!extlOrderEo.getExtlChannel().equals(extlOrderReqDto.getExtlChannel()) || !extlOrderEo.getExtlOrderSerial().equals(extlOrderReqDto.getExtlOrderSerial())) continue;
                    oldId = extlOrderEo.getId();
                    tradeNo = extlOrderEo.getTradeNo();
                    payment = payment.add(extlOrderEo.getPayAmount());
                    oldStatus = extlOrderEo.getTradeOrderStatus();
                    discountFee = discountFee.add(extlOrderEo.getShopDiscountAmount());
                    platDiscountFee = platDiscountFee.add(extlOrderEo.getPlatformDiscountAmount());
                    totalAmount = totalAmount.add(extlOrderEo.getTotalAmount());
                    totalItemNum = extlOrderEo.getTotalItemNum();
                    break;
                }
                ExtlOrderEo extlOrderEo = ExtlOrderEo.newInstance();
                DtoHelper.dto2Eo((BaseVo)extlOrderReqDto, (BaseEo)extlOrderEo);
                if (!oldStatus.equals("CONFIRM")) {
                    String tradeOrderStatus = this.convertData(extlOrderEo.getTenantId(), "orderStatus", extlOrderEo.getTradeOrderStatus());
                    extlOrderEo.setTradeOrderStatus(tradeOrderStatus);
                }
                if (oldId != null) {
                    List tradeItemReqDtoList = extlOrderReqDto.getTradeItemReqDtos();
                    List<TradeItemEo> tradeItemEos = this.tradeItemService.queryByTradeNo(tradeNo);
                    insertItems = tradeItemReqDtoList.stream().filter(tradeItemReqDto -> CollectionUtils.isEmpty((Collection)tradeItemEos.stream().filter(tradeItemEo -> StringUtils.equals((CharSequence)tradeItemEo.getSkuSerial(), (CharSequence)tradeItemReqDto.getSkuSerial()) && StringUtils.equals((CharSequence)tradeItemEo.getItemSerial(), (CharSequence)tradeItemReqDto.getItemSerial())).collect(Collectors.toList()))).collect(Collectors.toList());
                }
                if (CollectionUtils.isNotEmpty((Collection)insertItems)) {
                    for (TradeItemReqDto tradeItemReqDto2 : insertItems) {
                        payment = payment.add(tradeItemReqDto2.getPayTotalAmount());
                        discountFee = discountFee.add(null == tradeItemReqDto2.getShopDiscountPrice() ? BigDecimal.ZERO : tradeItemReqDto2.getShopDiscountPrice());
                        platDiscountFee = platDiscountFee.add(null == tradeItemReqDto2.getPlatformDiscountPrice() ? BigDecimal.ZERO : tradeItemReqDto2.getPlatformDiscountPrice());
                        totalItemNum = totalItemNum + tradeItemReqDto2.getItemNum();
                        if (null != tradeItemReqDto2.getItemOrigPrice() && null != tradeItemReqDto2.getItemNum()) {
                            totalAmount = totalAmount.add(tradeItemReqDto2.getItemOrigPrice().multiply(new BigDecimal(tradeItemReqDto2.getItemNum())));
                            continue;
                        }
                        totalAmount = totalAmount.add(tradeItemReqDto2.getPayTotalAmount());
                    }
                }
                extlOrderEo.setTotalItemNum(totalItemNum);
                extlOrderEo.setShopDiscountAmount(discountFee);
                extlOrderEo.setPayAmount(payment);
                extlOrderEo.setPlatformDiscountAmount(platDiscountFee);
                extlOrderEo.setTotalAmount(totalAmount);
                extlOrderEo.setTradeNo(tradeNo);
                extlOrderEo.setLocalOrderNo(tradeNo);
                if (oldId != null) {
                    extlOrderEo.setId(oldId);
                    if (StringUtils.isBlank((CharSequence)extlOrderEo.getTradeOrderStatus()) && StringUtils.isNotBlank((CharSequence)oldStatus)) {
                        extlOrderEo.setTradeOrderStatus(oldStatus);
                    }
                    this.extlOrderDas.updateSelective((BaseEo)extlOrderEo);
                } else {
                    extlOrderEo.setTotalAmount(totalAmount.add(extlOrderReqDto.getFreightAmount()));
                    this.extlOrderDas.insert((BaseEo)extlOrderEo);
                }
                if (!CollectionUtils.isNotEmpty(insertItems)) continue;
                ArrayList tradeItemEoList = new ArrayList();
                DtoHelper.dtoList2EoList(insertItems, tradeItemEoList, TradeItemEo.class);
                for (TradeItemEo tradeItemEo : tradeItemEoList) {
                    tradeItemEo.setTradeNo(tradeNo);
                    tradeItemEo.setTradeItemNo(TradeUtil.generateTradeNo(tradeNo));
                    this.tradeItemService.setCatalogName(tradeItemEo);
                    this.tradeItemDas.insert((BaseEo)tradeItemEo);
                }
            }
        }
        finally {
            orderSerialChannelMap.forEach((key, value) -> this.cacheService.delCache(key + "_" + value));
        }
    }

    private void excludeOwnOrder(List<ExtlOrderReqDto> list) {
        ArrayList<String> tradeNoList = new ArrayList<String>();
        for (ExtlOrderReqDto extlOrderReqDto : list) {
            tradeNoList.add(extlOrderReqDto.getExtlOrderSerial());
        }
        if (CollectionUtils.isEmpty(tradeNoList)) {
            return;
        }
        OrderEo orderEo = OrderEo.newInstance();
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        sqlFilterList.add(SqlFilter.in((String)"order_no", (Object)("'" + StringUtils.join(tradeNoList, (String)"','") + "'")));
        orderEo.setSqlFilters(sqlFilterList);
        List orderEoList = this.orderDas.select((BaseEo)orderEo);
        if (CollectionUtils.isNotEmpty((Collection)orderEoList)) {
            Iterator<ExtlOrderReqDto> iterator = list.iterator();
            block1: while (iterator.hasNext()) {
                ExtlOrderReqDto extlOrderReqDto = iterator.next();
                for (OrderEo eo : orderEoList) {
                    if (!eo.getOrderNo().equals(extlOrderReqDto.getExtlOrderSerial())) continue;
                    iterator.remove();
                    continue block1;
                }
            }
        }
    }

    private List<ExtlOrderEo> selectExistExtlOrder(List<ExtlOrderReqDto> list) {
        HashMap<String, ArrayList<String>> mapChannelOrderSerial = new HashMap<String, ArrayList<String>>();
        for (ExtlOrderReqDto extlOrderReqDto : list) {
            ArrayList<String> orderSerialList = (ArrayList<String>)mapChannelOrderSerial.get(extlOrderReqDto.getExtlChannel());
            if (CollectionUtils.isEmpty((Collection)orderSerialList)) {
                orderSerialList = new ArrayList<String>();
                String orderChannel = this.convertData(extlOrderReqDto.getTenantId(), "orderChannel", extlOrderReqDto.getExtlChannel());
                extlOrderReqDto.setExtlChannel(orderChannel);
                mapChannelOrderSerial.put(extlOrderReqDto.getExtlChannel(), orderSerialList);
            }
            orderSerialList.add(extlOrderReqDto.getExtlOrderSerial());
        }
        ArrayList<ExtlOrderEo> extlOrderEoList = new ArrayList<ExtlOrderEo>();
        for (Map.Entry entry : mapChannelOrderSerial.entrySet()) {
            ExtlOrderEo extlOrderEo = ExtlOrderEo.newInstance();
            ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
            sqlFilters.add(SqlFilter.in((String)"extl_order_serial", (Object)("'" + StringUtils.join((Iterable)((Iterable)entry.getValue()), (String)"','") + "'")));
            sqlFilters.add(SqlFilter.eq((String)"extl_channel", entry.getKey()));
            extlOrderEo.setSqlFilters(sqlFilters);
            List extlOrderEos = this.extlOrderDas.select((BaseEo)extlOrderEo);
            if (!CollectionUtils.isNotEmpty((Collection)extlOrderEos)) continue;
            extlOrderEoList.addAll(extlOrderEos);
        }
        return extlOrderEoList;
    }

    private String convertData(Long tenantId, String dataType, String origData) {
        RestResponse restResponse = this.dictQueryApi.queryByGroupCodeAndCode(tenantId, this.applicationName, dataType);
        DictDto dictDto = (DictDto)restResponse.getData();
        if (dictDto == null) {
            return "";
        }
        String convertJsonString = dictDto.getValue();
        JSONObject convertJson = JSON.parseObject((String)convertJsonString);
        for (Map.Entry entry : convertJson.entrySet()) {
            String[] keys;
            String key = (String)entry.getKey();
            for (String s : keys = key.split(",")) {
                if (!s.equals(origData)) continue;
                return String.valueOf(entry.getValue());
            }
        }
        return "";
    }
}

