/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.item.api.omnichannel.dto.request.ChannelItemReqDto;
import com.dtyunxi.yundt.cube.center.item.api.omnichannel.dto.response.ChannelItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.omnichannel.query.IChannelItemQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopQueryReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.constants.FullGiftStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.ItemRangeTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.FullGiftForChannelReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.FullGiftOperateReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.FullGiftReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.FullGiftForChannelRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.FullGiftItemRangeRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.FullGiftPromotionSettingRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.FullGiftRespDto;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IFullGiftService;
import com.dtyunxi.yundt.cube.center.trade.dao.das.FullGiftDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.FullGiftForChannelDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.FullGiftItemRangeDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.FullGiftPromotionSettingDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.FullGiftEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.FullGiftForChannelEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.FullGiftItemRangeEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.FullGiftPromotionSettingEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FullGiftServiceImpl
implements IFullGiftService {
    private Logger logger = LoggerFactory.getLogger(IFullGiftService.class);
    @Resource
    private ICacheService cacheService;
    @Resource
    private FullGiftDas fullGiftDas;
    @Resource
    private FullGiftPromotionSettingDas fullGiftPromotionSettingDas;
    @Resource
    private FullGiftItemRangeDas fullGiftItemRangeDas;
    @Resource
    private FullGiftForChannelDas fullGiftForChannelDas;
    @Resource
    private IShopQueryApi shopQueryApi;
    @Resource
    private IChannelItemQueryApi channelItemQueryApi;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long saveFullGift(FullGiftReqDto addReqDto) {
        this.logger.info("\u65b0\u589e\u6ee1\u8d60\u7ba1\u7406\uff0c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)addReqDto));
        Long fullGifId = addReqDto.getId();
        FullGiftEo fullGiftCheck = new FullGiftEo();
        fullGiftCheck.setActivityLevel(addReqDto.getActivityLevel());
        FullGiftEo exists = this.fullGiftDas.exists(addReqDto.getActivityLevel(), addReqDto.getStartTime(), addReqDto.getEndTime());
        if (null != exists && !exists.getId().equals(fullGifId)) {
            throw new BizException("\u8be5\u4e8b\u4ef6\u6bb5\u5185\u7684\u6d3b\u52a8\u4f18\u5148\u7ea7\u5df2\u5b58\u5728\uff0c\u8bf7\u66f4\u6539\u65f6\u95f4\u6bb5\u6216\u8005\u6d3b\u52a8\u4f18\u5148\u7ea7\uff01");
        }
        if (!FullGiftStatusEnum.DRAFT.getStatus().equals(addReqDto.getStatus()) && !FullGiftStatusEnum.WAIT_AUDIT.getStatus().equals(addReqDto.getStatus())) {
            throw new BizException("\u63d0\u4ea4\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u53ea\u80fd\u4e3a\u8349\u7a3f\u3001\u5f85\u5ba1\u6838\u72b6\u6001\uff01");
        }
        if (null == fullGifId) {
            FullGiftEo fullGiftEo = new FullGiftEo();
            String activityCode = "MZ" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmssSSS") + Math.round((Math.random() + 1.0) * 1000.0);
            String cacheCode = (String)this.cacheService.getCache(activityCode, String.class);
            while (StringUtils.isNotBlank((CharSequence)cacheCode)) {
                cacheCode = (String)this.cacheService.getCache(activityCode, String.class);
            }
            this.cacheService.setCache(activityCode, (Object)1, 2000);
            DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)fullGiftEo);
            fullGiftEo.setActivityCode(activityCode);
            this.fullGiftDas.insert((BaseEo)fullGiftEo);
            fullGifId = fullGiftEo.getId();
        } else {
            FullGiftEo fullGiftUpdate = new FullGiftEo();
            BeanUtils.copyProperties((Object)addReqDto, (Object)fullGiftUpdate, (String[])new String[]{"activityCode"});
            this.fullGiftDas.updateSelective((BaseEo)fullGiftUpdate);
            FullGiftPromotionSettingEo fullGiftPromotionSetting = new FullGiftPromotionSettingEo();
            fullGiftPromotionSetting.setFullGiftId(addReqDto.getId());
            this.fullGiftPromotionSettingDas.deleteByExample((BaseEo)fullGiftPromotionSetting);
            FullGiftItemRangeEo fullGiftItemRangeEo = new FullGiftItemRangeEo();
            fullGiftItemRangeEo.setFullGiftId(addReqDto.getId());
            this.fullGiftItemRangeDas.deleteByExample((BaseEo)fullGiftItemRangeEo);
            FullGiftForChannelEo fullGiftForChannelEo = new FullGiftForChannelEo();
            fullGiftForChannelEo.setFullGiftId(addReqDto.getId());
            this.fullGiftForChannelDas.deleteByExample((BaseEo)fullGiftForChannelEo);
        }
        Long fullGifTempId = fullGifId;
        List promotionSettings = addReqDto.getPromotionSettings();
        if (CollectionUtils.isNotEmpty((Collection)promotionSettings)) {
            ArrayList fullGiftPromotionSettingEos = new ArrayList();
            promotionSettings.stream().forEach(fullGiftPromotionSettingReqDto -> {
                FullGiftPromotionSettingEo fullGiftPromotionSetting = new FullGiftPromotionSettingEo();
                BeanUtils.copyProperties((Object)fullGiftPromotionSettingReqDto, (Object)fullGiftPromotionSetting, (String[])new String[]{"id"});
                fullGiftPromotionSetting.setFullGiftId(fullGifTempId);
                fullGiftPromotionSettingEos.add(fullGiftPromotionSetting);
            });
            this.fullGiftPromotionSettingDas.insertBatch(fullGiftPromotionSettingEos);
        }
        if (ItemRangeTypeEnum.ALL.getType().equals(addReqDto.getItemRangeType())) {
            List<Long> shopIds;
            List<ChannelItemRespDto> channelItems;
            List shopCodes = addReqDto.getForChannels().stream().map(FullGiftForChannelReqDto::getShopCode).collect(Collectors.toList());
            ShopQueryReqDto shopQueryReqDto = new ShopQueryReqDto();
            shopQueryReqDto.setCodes(shopCodes);
            List shops = (List)this.shopQueryApi.queryShopByCode(shopQueryReqDto).getData();
            if (CollectionUtils.isNotEmpty((Collection)shops) && CollectionUtils.isNotEmpty(channelItems = this.listChannelItemByShopIds(shopIds = shops.stream().map(ShopDto::getId).collect(Collectors.toList())))) {
                ArrayList fullGiftItemRangeEos = new ArrayList();
                channelItems.stream().forEach(channelItemRespDto -> {
                    FullGiftItemRangeEo fullGiftItemRangeEo = new FullGiftItemRangeEo();
                    fullGiftItemRangeEo.setFullGiftId(fullGifTempId);
                    fullGiftItemRangeEo.setShopCode(channelItemRespDto.getShopCode());
                    fullGiftItemRangeEo.setItemCode(channelItemRespDto.getItemCode());
                    fullGiftItemRangeEo.setSkuCode(channelItemRespDto.getSkuCode());
                    fullGiftItemRangeEo.setItemName(channelItemRespDto.getItemName());
                    fullGiftItemRangeEo.setDirId(channelItemRespDto.getDirId());
                    fullGiftItemRangeEo.setDirName(channelItemRespDto.getDirName());
                    fullGiftItemRangeEo.setRetailPrice(channelItemRespDto.getRetallPrice());
                    fullGiftItemRangeEos.add(fullGiftItemRangeEo);
                });
                this.fullGiftItemRangeDas.insertBatch(fullGiftItemRangeEos);
            }
        } else {
            List fullGiftItemRanges = addReqDto.getItemRanges();
            if (CollectionUtils.isNotEmpty((Collection)fullGiftItemRanges)) {
                ArrayList fullGiftItemRangeEos = new ArrayList();
                fullGiftItemRanges.stream().forEach(fullGiftItemRangeRespDto -> {
                    FullGiftItemRangeEo fullGiftItemRangeEo = new FullGiftItemRangeEo();
                    BeanUtils.copyProperties((Object)fullGiftItemRangeRespDto, (Object)fullGiftItemRangeEo, (String[])new String[]{"id"});
                    fullGiftItemRangeEo.setFullGiftId(fullGifTempId);
                    fullGiftItemRangeEos.add(fullGiftItemRangeEo);
                });
                this.fullGiftItemRangeDas.insertBatch(fullGiftItemRangeEos);
            }
        }
        List forChannels = addReqDto.getForChannels();
        if (CollectionUtils.isNotEmpty((Collection)forChannels)) {
            ArrayList fullGiftForChannelEos = new ArrayList();
            forChannels.stream().forEach(fullGiftForChannelReqDto -> {
                FullGiftForChannelEo fullGiftForChannelEo = new FullGiftForChannelEo();
                BeanUtils.copyProperties((Object)fullGiftForChannelReqDto, (Object)fullGiftForChannelEo, (String[])new String[]{"id"});
                fullGiftForChannelEo.setFullGiftId(fullGifTempId);
                fullGiftForChannelEos.add(fullGiftForChannelEo);
            });
            this.fullGiftForChannelDas.insertBatch(fullGiftForChannelEos);
        }
        return fullGifTempId;
    }

    private List<ChannelItemRespDto> listChannelItemByShopIds(List<Long> shopIds) {
        ChannelItemReqDto channelItemReqDto = new ChannelItemReqDto();
        String filter = JSON.toJSONString((Object)channelItemReqDto);
        int pageNum = 1;
        int pageSize = 1000;
        ArrayList<ChannelItemRespDto> channelItems = new ArrayList<ChannelItemRespDto>();
        PageInfo pageInfo = (PageInfo)this.channelItemQueryApi.queryByPage(filter, Integer.valueOf(pageNum), Integer.valueOf(pageSize)).getData();
        if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
            channelItems.addAll(pageInfo.getList());
        }
        while (pageNum < pageInfo.getPages()) {
            pageInfo = (PageInfo)this.channelItemQueryApi.queryByPage(filter, Integer.valueOf(pageNum + 1), Integer.valueOf(pageSize)).getData();
            if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
                channelItems.addAll(pageInfo.getList());
            }
            ++pageNum;
        }
        return channelItems;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchAudit(FullGiftOperateReqDto fullGiftOperateReqDto) {
        this.logger.info("\u6279\u91cf\u5ba1\u6838\u6ee1\u8d60\u7ba1\u7406\uff0c\u5165\u53c2fullGiftOperateDto\uff1a{}", (Object)JSON.toJSONString((Object)fullGiftOperateReqDto));
        List ids = fullGiftOperateReqDto.getIds();
        if (CollectionUtils.isEmpty((Collection)ids)) {
            throw new BizException("\u5ba1\u6838id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        FullGiftEo fullGiftEo = new FullGiftEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"id", (Object)ids));
        fullGiftEo.setSqlFilters(sqlFilters);
        List fullGifts = this.fullGiftDas.select((BaseEo)fullGiftEo, Integer.valueOf(1), Integer.valueOf(ids.size()));
        Date now = new Date();
        for (FullGiftEo fullGift2 : fullGifts) {
            if (!FullGiftStatusEnum.WAIT_AUDIT.getStatus().equals(fullGift2.getStatus())) {
                throw new BizException("\u6570\u636e\u4e0d\u4e3a\u5f85\u5ba1\u6838\u72b6\u6001\uff0c\u4e0d\u80fd\u901a\u8fc7\u5ba1\u6838\uff01");
            }
            if (!FullGiftStatusEnum.PASS.getStatus().equals(fullGiftOperateReqDto.getStatus())) continue;
            if (now.before(fullGift2.getStartTime())) {
                fullGift2.setStatus(FullGiftStatusEnum.WAIT_RUN.getStatus());
                continue;
            }
            if (now.before(fullGift2.getEndTime())) {
                fullGift2.setStatus(FullGiftStatusEnum.RUNNING.getStatus());
                continue;
            }
            if (!now.after(fullGift2.getEndTime())) continue;
            throw new BizException("\u7ed3\u675f\u65f6\u95f4\u65e9\u4e8e\u5f53\u524d\u65f6\u95f4\uff0c\u4e0d\u80fd\u5ba1\u6838\u901a\u8fc7\uff01");
        }
        if (FullGiftStatusEnum.PASS.getStatus().equals(fullGiftOperateReqDto.getStatus())) {
            fullGifts.stream().forEach(fullGift -> {
                FullGiftEo fullGiftUpdate = new FullGiftEo();
                fullGiftUpdate.setId(fullGift.getId());
                fullGiftUpdate.setStatus(fullGift.getStatus());
                this.fullGiftDas.updateSelective((BaseEo)fullGiftUpdate);
                this.logger.info("\u6ee1\u8d60\u6d3b\u52a8\u5ba1\u6838\u901a\u8fc7\uff0cid:{}.status:{}", (Object)fullGift.getId(), (Object)fullGift.getStatus());
            });
        } else if (FullGiftStatusEnum.REJECT.getStatus().equals(fullGiftOperateReqDto.getStatus())) {
            this.logger.info("\u6ee1\u8d60\u6d3b\u52a8\u5ba1\u6838\u4e0d\u901a\u8fc7\uff0cids:{}", (Object)JSON.toJSONString((Object)ids));
            fullGiftEo.setStatus(FullGiftStatusEnum.REJECT.getStatus());
            fullGiftEo.setRejectReason(fullGiftOperateReqDto.getRejectReason());
            this.fullGiftDas.updateSelectiveSqlFilter((BaseEo)fullGiftEo);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchDelete(FullGiftOperateReqDto fullGiftOperateReqDto) {
        this.logger.info("\u6279\u91cf\u5220\u9664\u6ee1\u8d60\u7ba1\u7406\uff0c\u5165\u53c2fullGiftOperateDto\uff1a{}", (Object)JSON.toJSONString((Object)fullGiftOperateReqDto));
        List ids = fullGiftOperateReqDto.getIds();
        if (CollectionUtils.isEmpty((Collection)ids)) {
            throw new BizException("\u5220\u9664id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a.");
        }
        FullGiftEo fullGiftEo = new FullGiftEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"id", (Object)ids));
        fullGiftEo.setSqlFilters(sqlFilters);
        List fullGifts = this.fullGiftDas.select((BaseEo)fullGiftEo, Integer.valueOf(1), Integer.valueOf(ids.size()));
        for (FullGiftEo fullGift : fullGifts) {
            if (FullGiftStatusEnum.WAIT_AUDIT.getStatus().equals(fullGift.getStatus())) continue;
            throw new BizException(fullGift.getId() + "\u6b64\u6570\u636e\u4e0d\u4e3a\u8349\u7a3f\u6570\u636e\uff0c\u4e0d\u80fd\u8fdb\u884c\u5220\u9664\uff01");
        }
        this.fullGiftDas.deleteByExample((BaseEo)fullGiftEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchStop(FullGiftOperateReqDto fullGiftOperateReqDto) {
        this.logger.info("\u6279\u91cf\u7ec8\u6b62\u6ee1\u8d60\u7ba1\u7406\uff0c\u5165\u53c2fullGiftOperateDto\uff1a{}", (Object)JSON.toJSONString((Object)fullGiftOperateReqDto));
        List ids = fullGiftOperateReqDto.getIds();
        if (CollectionUtils.isEmpty((Collection)ids)) {
            throw new BizException("\u5ba1\u6838id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        FullGiftEo fullGiftEo = new FullGiftEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"id", (Object)ids));
        fullGiftEo.setSqlFilters(sqlFilters);
        List fullGifts = this.fullGiftDas.select((BaseEo)fullGiftEo, Integer.valueOf(1), Integer.valueOf(ids.size()));
        for (FullGiftEo fullGift : fullGifts) {
            if (FullGiftStatusEnum.WAIT_RUN.getStatus().equals(fullGift.getStatus()) || FullGiftStatusEnum.RUNNING.getStatus().equals(fullGift.getStatus())) continue;
            throw new BizException("\u53ea\u6709\u5f85\u6267\u884c\u3001\u6267\u884c\u4e2d\u7684\u72b6\u6001\u7684\u6570\u636e\u624d\u80fd\u8fdb\u884c\u7ec8\u6b62\u64cd\u4f5c\uff01");
        }
        fullGiftEo.setStatus(FullGiftStatusEnum.STOP.getStatus());
        fullGiftEo.setRejectReason(fullGiftOperateReqDto.getRejectReason());
        this.fullGiftDas.updateSelectiveSqlFilter((BaseEo)fullGiftEo);
    }

    @Override
    public PageInfo<FullGiftRespDto> queryByPage(FullGiftReqDto fullGiftReqDto, Integer pageNum, Integer pageSize) {
        FullGiftEo fullGiftEo = new FullGiftEo();
        DtoHelper.dto2Eo((BaseVo)fullGiftReqDto, (BaseEo)fullGiftEo, (String[])new String[]{"activityName"});
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        if (StringUtils.isNotBlank((CharSequence)fullGiftReqDto.getActivityName())) {
            sqlFilters.add(SqlFilter.like((String)"activityName", (Object)("%" + fullGiftReqDto.getActivityName() + "%")));
        }
        if (StringUtils.isNotBlank((CharSequence)fullGiftReqDto.getStartTimeBegin())) {
            sqlFilters.add(SqlFilter.ge((String)"startTime", (Object)fullGiftReqDto.getStartTimeBegin()));
        }
        if (StringUtils.isNotBlank((CharSequence)fullGiftReqDto.getStartTimeEnd())) {
            sqlFilters.add(SqlFilter.le((String)"startTime", (Object)fullGiftReqDto.getStartTimeEnd()));
        }
        if (StringUtils.isNotBlank((CharSequence)fullGiftReqDto.getEndTimeBegin())) {
            sqlFilters.add(SqlFilter.ge((String)"endTime", (Object)fullGiftReqDto.getEndTimeBegin()));
        }
        if (StringUtils.isNotBlank((CharSequence)fullGiftReqDto.getEndTimeEnd())) {
            sqlFilters.add(SqlFilter.le((String)"endTime", (Object)fullGiftReqDto.getEndTimeEnd()));
        }
        if (StringUtils.isNotBlank((CharSequence)fullGiftReqDto.getCreateTimeBegin())) {
            sqlFilters.add(SqlFilter.ge((String)"createTime", (Object)fullGiftReqDto.getCreateTimeBegin()));
        }
        if (StringUtils.isNotBlank((CharSequence)fullGiftReqDto.getCreateTimeEnd())) {
            sqlFilters.add(SqlFilter.le((String)"createTime", (Object)fullGiftReqDto.getCreateTimeEnd()));
        }
        if (StringUtils.isNotBlank((CharSequence)fullGiftReqDto.getAuditTimeBegin())) {
            sqlFilters.add(SqlFilter.ge((String)"auditTime", (Object)fullGiftReqDto.getAuditTimeBegin()));
        }
        if (StringUtils.isNotBlank((CharSequence)fullGiftReqDto.getAuditTimeEnd())) {
            sqlFilters.add(SqlFilter.le((String)"auditTime", (Object)fullGiftReqDto.getAuditTimeEnd()));
        }
        PageInfo eoPageInfo = this.fullGiftDas.selectPage((BaseEo)fullGiftEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, FullGiftRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public FullGiftRespDto queryById(Long id) {
        FullGiftEo fullGiftEo = (FullGiftEo)this.fullGiftDas.selectByPrimaryKey(id);
        FullGiftRespDto fullGiftRespDto = new FullGiftRespDto();
        DtoHelper.eo2Dto((BaseEo)fullGiftEo, (BaseVo)fullGiftRespDto);
        ArrayList promotionSettings = new ArrayList();
        FullGiftPromotionSettingEo settingSelect = new FullGiftPromotionSettingEo();
        settingSelect.setFullGiftId(id);
        List fullGiftPromotionSettings = this.fullGiftPromotionSettingDas.select((BaseEo)settingSelect, Integer.valueOf(1), Integer.valueOf(1000));
        DtoHelper.eoList2DtoList((Collection)fullGiftPromotionSettings, promotionSettings, FullGiftPromotionSettingRespDto.class);
        fullGiftRespDto.setPromotionSettings(promotionSettings);
        ArrayList itemRanges = new ArrayList();
        FullGiftItemRangeEo itemRangeSelect = new FullGiftItemRangeEo();
        itemRangeSelect.setFullGiftId(id);
        List fullGiftItemRanges = this.fullGiftItemRangeDas.select((BaseEo)itemRangeSelect, Integer.valueOf(1), Integer.valueOf(1000));
        DtoHelper.eoList2DtoList((Collection)fullGiftItemRanges, itemRanges, FullGiftItemRangeRespDto.class);
        fullGiftRespDto.setItemRanges(itemRanges);
        ArrayList forChannels = new ArrayList();
        FullGiftForChannelEo forChannelSelect = new FullGiftForChannelEo();
        forChannelSelect.setFullGiftId(id);
        List fullGiftForChannels = this.fullGiftForChannelDas.select((BaseEo)forChannelSelect, Integer.valueOf(1), Integer.valueOf(1000));
        DtoHelper.eoList2DtoList((Collection)fullGiftForChannels, forChannels, FullGiftForChannelRespDto.class);
        List shopCodes = forChannels.stream().map(FullGiftForChannelRespDto::getShopCode).distinct().collect(Collectors.toList());
        ShopQueryReqDto shopQueryReqDto = new ShopQueryReqDto();
        shopQueryReqDto.setCodes(shopCodes);
        List shops = (List)this.shopQueryApi.queryShopByCode(shopQueryReqDto).getData();
        if (CollectionUtils.isNotEmpty((Collection)shops)) {
            Map<String, String> shopNameMap = shops.stream().collect(Collectors.toMap(ShopDto::getCode, ShopDto::getName));
            forChannels.stream().forEach(fullGiftForChannelRespDto -> {
                String shopName = (String)shopNameMap.get(fullGiftForChannelRespDto.getShopCode());
                fullGiftForChannelRespDto.setShopName(shopName);
            });
            itemRanges.stream().forEach(fullGiftItemRangeRespDto -> {
                String shopName = (String)shopNameMap.get(fullGiftItemRangeRespDto.getShopCode());
                fullGiftItemRangeRespDto.setShopName(shopName);
            });
        }
        fullGiftRespDto.setForChannels(forChannels);
        return fullGiftRespDto;
    }
}

