/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.IGiftBalanceApi;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.constant.IncomeExpenditureEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.constant.TradeTypeEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.BalanceFreezeModifyReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.BalanceQueryReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.BalanceRelModifyReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.BalanceStatementAddReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.GiftBalanceModifyReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.response.balance.BalanceDetailRespDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.response.balance.GiftConfigBaseRespDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.query.IGiftBalanceQueryApi;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.query.IGiftConfigQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopBaseDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.GiftInfoRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.TradeItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.order.OrderPreviewRespDto;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IHelpService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.action.ActionContext;
import com.dtyunxi.yundt.cube.center.trade.biz.service.action.TemplateList;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderEo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="helpService")
public class HelpServiceImpl
implements IHelpService {
    @Resource
    private IGiftBalanceQueryApi giftBalanceQueryApi;
    @Resource
    private IGiftConfigQueryApi giftConfigQueryApi;
    @Resource
    private IGiftBalanceApi giftBalanceApi;
    @Autowired
    private IShopQueryApi shopQueryApi;
    @Autowired
    private ISellerQueryApi sellerQueryApi;
    private static final Logger LOGGER = LoggerFactory.getLogger(HelpServiceImpl.class);

    @Override
    public GiftInfoRespDto doAction(OrderPreviewRespDto orderInfoDto) {
        ActionContext context = this.setContext(orderInfoDto);
        TemplateList.PREVIEW.forEach(x -> x.doAction(context));
        return Optional.ofNullable(context.getContentData("info", GiftInfoRespDto.class)).orElse(new GiftInfoRespDto());
    }

    private ActionContext setContext(OrderPreviewRespDto orderInfoDto) {
        LOGGER.info("\u9884\u89c8\u4fe1\u606f\u4e3a" + JSON.toJSONString((Object)orderInfoDto));
        if (Objects.isNull(orderInfoDto.getCustomerId())) {
            throw new BizException("\u5ba2\u6237id\u4e3a\u7a7a");
        }
        BalanceQueryReqDto balanceQueryReqDto = new BalanceQueryReqDto();
        balanceQueryReqDto.setCustomerId(orderInfoDto.getCustomerId());
        BalanceDetailRespDto balanceDetailRespDto = (BalanceDetailRespDto)RestResponseHelper.extractData((RestResponse)this.giftBalanceQueryApi.queryByCustomerId(balanceQueryReqDto));
        LOGGER.info("\u8d26\u6237\u4fe1\u606f\u4e3a" + JSON.toJSONString((Object)balanceDetailRespDto));
        if (Objects.isNull(balanceDetailRespDto)) {
            throw new BizException("\u5ba2\u6237" + orderInfoDto.getCustomerId() + "\u989d\u5ea6\u8d26\u6237id\u4e0d\u5b58\u5728");
        }
        GiftConfigBaseRespDto giftConfigBaseRespDto = new GiftConfigBaseRespDto();
        if (!CollectionUtils.isEmpty((Collection)orderInfoDto.getOrderItems()) && ((TradeItemRespDto)orderInfoDto.getOrderItems().get(0)).getShopId() != null) {
            ShopBaseDto shopBaseDto = (ShopBaseDto)RestResponseHelper.extractData((RestResponse)this.shopQueryApi.queryBaseById(Long.valueOf(((TradeItemRespDto)orderInfoDto.getOrderItems().get(0)).getShopId())));
            SellerRespDto sellerRespDto = (SellerRespDto)RestResponseHelper.extractData((RestResponse)this.sellerQueryApi.queryById(shopBaseDto.getSellerId()));
            giftConfigBaseRespDto = (GiftConfigBaseRespDto)RestResponseHelper.extractData((RestResponse)this.giftConfigQueryApi.queryByOrganizationId(sellerRespDto.getOrganizationId()));
        }
        LOGGER.info("\u914d\u7f6e\u4fe1\u606f\u4e3a" + JSON.toJSONString((Object)giftConfigBaseRespDto));
        if (Objects.isNull(giftConfigBaseRespDto)) {
            throw new BizException("\u8d60\u54c1\u8d26\u6237\u4e0d\u5b58\u5728" + orderInfoDto.getCustomerId());
        }
        List orderItems = orderInfoDto.getOrderItems();
        if (CollectionUtils.isEmpty((Collection)orderItems)) {
            throw new BizException("\u5546\u54c1\u5217\u8868\u4e3a\u7a7a");
        }
        List giftItems = orderInfoDto.getGiftItems();
        ActionContext context = new ActionContext();
        context.addContentData("gift_items", giftItems);
        context.addContentData("item", orderItems);
        context.addContentData("account", balanceDetailRespDto);
        context.addContentData("base", giftConfigBaseRespDto);
        GiftInfoRespDto giftInfoRespDto = new GiftInfoRespDto();
        giftInfoRespDto.setAccountAmount(balanceDetailRespDto.getUsableBalance());
        giftInfoRespDto.setDeduction(orderInfoDto.isDeduction());
        context.addContentData("info", giftInfoRespDto);
        context.addContentData("order_no", orderInfoDto.getOrderNo());
        context.addContentData("pay_amount", orderInfoDto.getPayAmount());
        context.addContentData("offline_amount", orderInfoDto.getOfflineAmount());
        context.addContentData("customer_id", orderInfoDto.getCustomerId());
        return context;
    }

    @Override
    public GiftInfoRespDto addOrderAction(OrderPreviewRespDto orderInfoDto) {
        ActionContext context = this.setContext(orderInfoDto);
        context.addContentData("discount", orderInfoDto.isGiftAccount());
        TemplateList.ORDER.forEach(x -> x.doAction(context));
        return context.getContentData("info", GiftInfoRespDto.class);
    }

    @Override
    public void cancelOrder(OrderEo orderEo) {
        try {
            LOGGER.info("\u53d6\u6d88\u8ba2\u5355\u5165\u53c2\u4e3a" + JSON.toJSONString((Object)orderEo));
            if (Objects.isNull(orderEo.getGiftFreezeAmount()) && Objects.isNull(orderEo.getDiscountAmount())) {
                LOGGER.info("\u8ba2\u5355\u65e0\u51bb\u7ed3\u548c\u62b5\u6263\u989d\u5ea6");
            }
            if (Objects.nonNull(orderEo.getGiftDeductionAmount())) {
                BalanceRelModifyReqDto deductionRollBackDto = new BalanceRelModifyReqDto();
                GiftBalanceModifyReqDto deductionAmountRollBack = new GiftBalanceModifyReqDto();
                deductionAmountRollBack.setCustomerId(Long.valueOf(orderEo.getCustomerId()));
                deductionAmountRollBack.setBalance(orderEo.getGiftDeductionAmount().add(orderEo.getGiftFreezeAmount()));
                if (orderEo.getGiftAddAmount().compareTo(orderEo.getGiftDeductionAmount()) <= 0) {
                    deductionAmountRollBack.setUsableBalance(orderEo.getGiftDeductionAmount().add(orderEo.getGiftFreezeAmount()));
                }
                deductionRollBackDto.setGiftBalanceModifyReqDto(deductionAmountRollBack);
                if (BigDecimal.ZERO.compareTo(orderEo.getGiftDeductionAmount()) < 0) {
                    ArrayList list = Lists.newArrayList();
                    BalanceStatementAddReqDto statement = new BalanceStatementAddReqDto();
                    statement.setTradeTime(new Date());
                    statement.setCustomerId(Long.valueOf(orderEo.getCustomerId()));
                    statement.setBusinessNo(orderEo.getOrderNo());
                    statement.setTradeAmount(orderEo.getGiftDeductionAmount());
                    statement.setTradeTypeEnum(TradeTypeEnum.ORDER_RETUNN);
                    statement.setIncomeExpenditureEnum(IncomeExpenditureEnum.INCOME);
                    list.add(statement);
                    deductionRollBackDto.setBalanceStatementAddReqDtoList((List)list);
                }
                RestResponseHelper.extractData((RestResponse)this.giftBalanceApi.modifyBalanceRel(deductionRollBackDto));
            }
            BalanceRelModifyReqDto dto = new BalanceRelModifyReqDto();
            if (Objects.nonNull(orderEo.getGiftFreezeAmount())) {
                BalanceFreezeModifyReqDto freeze = new BalanceFreezeModifyReqDto();
                freeze.setCustomerId(Long.valueOf(orderEo.getCustomerId()));
                freeze.setBusinessNo(orderEo.getOrderNo());
                dto.setBalanceFreezeModifyReqDto(freeze);
            }
            if (Objects.nonNull(orderEo.getGiftFreezeAmount())) {
                GiftBalanceModifyReqDto freeModifyRollBack = new GiftBalanceModifyReqDto();
                freeModifyRollBack.setCustomerId(Long.valueOf(orderEo.getCustomerId()));
                freeModifyRollBack.setFreezeBalance(orderEo.getGiftFreezeAmount().negate());
                freeModifyRollBack.setBalance(orderEo.getGiftFreezeAmount().negate());
                dto.setGiftBalanceModifyReqDto(freeModifyRollBack);
            }
            RestResponseHelper.extractData((RestResponse)this.giftBalanceApi.modifyBalanceRel(dto));
            if (Objects.nonNull(orderEo.getGiftAddAmount())) {
                BalanceRelModifyReqDto addRollBackDto = new BalanceRelModifyReqDto();
                GiftBalanceModifyReqDto addAmountModifyRollBack = new GiftBalanceModifyReqDto();
                addAmountModifyRollBack.setCustomerId(Long.valueOf(orderEo.getCustomerId()));
                addAmountModifyRollBack.setBalance(orderEo.getGiftAddAmount().negate());
                if (orderEo.getGiftAddAmount().compareTo(orderEo.getGiftDeductionAmount()) <= 0) {
                    addAmountModifyRollBack.setUsableBalance(orderEo.getGiftAddAmount().negate());
                }
                addRollBackDto.setGiftBalanceModifyReqDto(addAmountModifyRollBack);
                if (BigDecimal.ZERO.compareTo(orderEo.getGiftAddAmount()) < 0) {
                    ArrayList list = Lists.newArrayList();
                    BalanceStatementAddReqDto statement = new BalanceStatementAddReqDto();
                    statement.setTradeTime(new Date());
                    statement.setCustomerId(Long.valueOf(orderEo.getCustomerId()));
                    statement.setBusinessNo(orderEo.getOrderNo());
                    statement.setTradeAmount(orderEo.getGiftAddAmount());
                    statement.setTradeTypeEnum(TradeTypeEnum.GIVE_RETURN);
                    statement.setIncomeExpenditureEnum(IncomeExpenditureEnum.EXPENDITURE);
                    list.add(statement);
                    addRollBackDto.setBalanceStatementAddReqDtoList((List)list);
                }
                RestResponseHelper.extractData((RestResponse)this.giftBalanceApi.modifyBalanceRel(addRollBackDto));
            }
        }
        catch (Exception e) {
            LOGGER.error("\u8d60\u54c1\u989d\u5ea6\u5904\u7406\u5931\u8d25" + e.getMessage());
        }
    }

    @Override
    public void closeOrder(OrderEo orderEo) {
        try {
            LOGGER.info("\u5173\u95ed\u8ba2\u5355\u5165\u53c2\u4e3a" + JSON.toJSONString((Object)orderEo));
            if (Objects.isNull(orderEo.getGiftFreezeAmount()) && Objects.isNull(orderEo.getDiscountAmount())) {
                LOGGER.info("\u8ba2\u5355\u65e0\u51bb\u7ed3\u548c\u62b5\u6263\u989d\u5ea6");
            }
            if (Objects.nonNull(orderEo.getGiftDeductionAmount())) {
                BalanceRelModifyReqDto deductionRollBackDto = new BalanceRelModifyReqDto();
                GiftBalanceModifyReqDto deductionAmountRollBack = new GiftBalanceModifyReqDto();
                deductionAmountRollBack.setCustomerId(Long.valueOf(orderEo.getCustomerId()));
                deductionAmountRollBack.setBalance(orderEo.getGiftDeductionAmount().add(orderEo.getGiftFreezeAmount()));
                if (orderEo.getGiftAddAmount().compareTo(orderEo.getGiftDeductionAmount()) <= 0) {
                    deductionAmountRollBack.setUsableBalance(orderEo.getGiftDeductionAmount().add(orderEo.getGiftFreezeAmount()));
                }
                deductionRollBackDto.setGiftBalanceModifyReqDto(deductionAmountRollBack);
                if (BigDecimal.ZERO.compareTo(orderEo.getGiftDeductionAmount()) < 0) {
                    ArrayList list = Lists.newArrayList();
                    BalanceStatementAddReqDto statement = new BalanceStatementAddReqDto();
                    statement.setTradeTime(new Date());
                    statement.setCustomerId(Long.valueOf(orderEo.getCustomerId()));
                    statement.setBusinessNo(orderEo.getOrderNo());
                    statement.setTradeAmount(orderEo.getGiftDeductionAmount());
                    statement.setTradeTypeEnum(TradeTypeEnum.ORDER_RETUNN);
                    statement.setIncomeExpenditureEnum(IncomeExpenditureEnum.INCOME);
                    list.add(statement);
                    deductionRollBackDto.setBalanceStatementAddReqDtoList((List)list);
                }
                RestResponseHelper.extractData((RestResponse)this.giftBalanceApi.modifyBalanceRel(deductionRollBackDto));
            }
            BalanceRelModifyReqDto dto = new BalanceRelModifyReqDto();
            if (Objects.nonNull(orderEo.getGiftFreezeAmount())) {
                BalanceFreezeModifyReqDto freeze = new BalanceFreezeModifyReqDto();
                freeze.setCustomerId(Long.valueOf(orderEo.getCustomerId()));
                freeze.setBusinessNo(orderEo.getOrderNo());
                dto.setBalanceFreezeModifyReqDto(freeze);
            }
            if (Objects.nonNull(orderEo.getGiftFreezeAmount())) {
                GiftBalanceModifyReqDto freeModifyRollBack = new GiftBalanceModifyReqDto();
                freeModifyRollBack.setCustomerId(Long.valueOf(orderEo.getCustomerId()));
                freeModifyRollBack.setFreezeBalance(orderEo.getGiftFreezeAmount().negate());
                freeModifyRollBack.setBalance(orderEo.getGiftFreezeAmount().negate());
                dto.setGiftBalanceModifyReqDto(freeModifyRollBack);
            }
            RestResponseHelper.extractData((RestResponse)this.giftBalanceApi.modifyBalanceRel(dto));
            if (Objects.nonNull(orderEo.getGiftAddAmount())) {
                BalanceRelModifyReqDto addRollBackDto = new BalanceRelModifyReqDto();
                GiftBalanceModifyReqDto addAmountModifyRollBack = new GiftBalanceModifyReqDto();
                addAmountModifyRollBack.setCustomerId(Long.valueOf(orderEo.getCustomerId()));
                addAmountModifyRollBack.setBalance(orderEo.getGiftAddAmount().negate());
                if (orderEo.getGiftAddAmount().compareTo(orderEo.getGiftDeductionAmount()) <= 0) {
                    addAmountModifyRollBack.setUsableBalance(orderEo.getGiftAddAmount().negate());
                }
                addRollBackDto.setGiftBalanceModifyReqDto(addAmountModifyRollBack);
                if (BigDecimal.ZERO.compareTo(orderEo.getGiftAddAmount()) < 0) {
                    ArrayList list = Lists.newArrayList();
                    BalanceStatementAddReqDto statement = new BalanceStatementAddReqDto();
                    statement.setTradeTime(new Date());
                    statement.setCustomerId(Long.valueOf(orderEo.getCustomerId()));
                    statement.setBusinessNo(orderEo.getOrderNo());
                    statement.setTradeAmount(orderEo.getGiftAddAmount());
                    statement.setTradeTypeEnum(TradeTypeEnum.GIVE_RETURN);
                    statement.setIncomeExpenditureEnum(IncomeExpenditureEnum.EXPENDITURE);
                    list.add(statement);
                    addRollBackDto.setBalanceStatementAddReqDtoList((List)list);
                }
                RestResponseHelper.extractData((RestResponse)this.giftBalanceApi.modifyBalanceRel(addRollBackDto));
            }
        }
        catch (Exception e) {
            LOGGER.error("\u8d60\u54c1\u989d\u5ea6\u5904\u7406\u5931\u8d25" + e.getMessage());
        }
    }

    public static void main(String[] args) {
        System.out.println(BigDecimal.ZERO.compareTo(new BigDecimal("0.00")));
    }
}

