/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.trade.api.constants.ActivityConstant;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.activity.OrderActivityAddReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.activity.OrderActivityModifyReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.activity.OrderActivityReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.order.activity.OrderActivityInfoJoinReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.order.activity.OrderActivityInfoReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.activity.OrderActivityRespDto;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderActivityService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderService;
import com.dtyunxi.yundt.cube.center.trade.dao.das.OrderActivityDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderActivityEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponCategoryEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponExtRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.service.query.ICouponExtQueryApi;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="orderActivityService")
public class OrderActivityServiceImpl
implements IOrderActivityService {
    private static Logger logger = LoggerFactory.getLogger(OrderActivityServiceImpl.class);
    @Resource
    private OrderActivityDas orderActivityDas;
    @Resource
    private IOrderService orderService;
    @Resource
    private ICouponExtQueryApi couponExtQueryApi;

    @Override
    public Long add(OrderActivityAddReqDto orderActivityReqDto) {
        OrderActivityEo orderActivityEo = OrderActivityEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)orderActivityReqDto, (BaseEo)orderActivityEo);
        this.orderActivityDas.insert((BaseEo)orderActivityEo);
        return orderActivityEo.getId();
    }

    @Override
    public void modify(OrderActivityModifyReqDto orderActivityReqDto) {
        OrderActivityEo orderActivityEo = OrderActivityEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)orderActivityReqDto, (BaseEo)orderActivityEo);
        this.orderActivityDas.update((BaseEo)orderActivityEo);
    }

    @Override
    public PageInfo<OrderActivityRespDto> queryList(OrderActivityReqDto orderActivityReqDto, Integer pageNum, Integer pageSize) {
        OrderActivityEo orderActivityEo = OrderActivityEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)orderActivityReqDto, (BaseEo)orderActivityEo);
        PageInfo pageInfo = this.orderActivityDas.selectPage((BaseEo)orderActivityEo, pageNum, pageSize);
        List resultList = pageInfo.getList();
        ArrayList orderActivityRespDtos = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)resultList)) {
            DtoHelper.eoList2DtoList((Collection)resultList, orderActivityRespDtos, OrderActivityRespDto.class);
        }
        PageInfo pageInfoDto = new PageInfo();
        BeanUtils.copyProperties((Object)pageInfo, (Object)pageInfoDto);
        pageInfoDto.setList(orderActivityRespDtos);
        return pageInfoDto;
    }

    @Override
    public List<OrderActivityEo> queryActivityByOrderNo(String orderNo) {
        OrderActivityEo orderActivityEo = OrderActivityEo.newInstance();
        orderActivityEo.setOrderNo(orderNo);
        return this.orderActivityDas.select((BaseEo)orderActivityEo);
    }

    @Override
    public OrderReqDto getActivityOrder(OrderEo orderEo) {
        OrderActivityReqDto orderActivityReqDto = new OrderActivityReqDto();
        orderActivityReqDto.setOrderNo(orderEo.getOrderNo());
        OrderReqDto orderReqDto = this.orderService.recoverOrderReq(orderEo);
        List<OrderActivityRespDto> orderActivityRespDtos = this.queryList(orderActivityReqDto);
        if (CollectionUtils.isNotEmpty(orderActivityRespDtos)) {
            List orderActivityInfoReqDtos = orderActivityRespDtos.stream().map(activity -> {
                if (StringUtils.isNotEmpty((CharSequence)activity.getExtension())) {
                    OrderActivityInfoReqDto orderActivityInfoReqDto = (OrderActivityInfoReqDto)JSON.parseObject((String)activity.getExtension(), OrderActivityInfoReqDto.class);
                    return orderActivityInfoReqDto;
                }
                OrderActivityInfoReqDto orderActivityInfoReqDto = new OrderActivityInfoReqDto();
                return orderActivityInfoReqDto;
            }).collect(Collectors.toList());
            OrderActivityInfoJoinReqDto activity2 = new OrderActivityInfoJoinReqDto();
            activity2.setActivityList(orderActivityInfoReqDtos);
            orderReqDto.setActivity(activity2);
        }
        orderReqDto.setTradeNo(orderEo.getTradeNo());
        return orderReqDto;
    }

    @Override
    public OrderReqDto getActivityOrder(String tradeNo) {
        OrderEo orderEo = this.orderService.queryByOrderNo(tradeNo);
        return this.getActivityOrder(orderEo);
    }

    @Override
    public List<OrderActivityRespDto> queryList(OrderActivityReqDto orderActivityReqDto) {
        OrderActivityEo orderActivityEo = OrderActivityEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)orderActivityReqDto, (BaseEo)orderActivityEo);
        List resultList = this.orderActivityDas.select((BaseEo)orderActivityEo);
        ArrayList<OrderActivityRespDto> orderActivityRespDtos = new ArrayList<OrderActivityRespDto>();
        if (CollectionUtils.isNotEmpty((Collection)resultList)) {
            DtoHelper.eoList2DtoList((Collection)resultList, orderActivityRespDtos, OrderActivityRespDto.class);
            return orderActivityRespDtos;
        }
        return null;
    }

    @Override
    public OrderActivityRespDto queryById(Long id, String filter) {
        OrderActivityEo orderActivityEo = OrderActivityEo.newInstance();
        orderActivityEo.setId(id);
        OrderActivityEo result = (OrderActivityEo)this.orderActivityDas.selectOne((BaseEo)orderActivityEo);
        OrderActivityRespDto orderActivityRespDto = new OrderActivityRespDto();
        DtoHelper.eo2Dto((BaseEo)result, (BaseVo)orderActivityRespDto);
        return orderActivityRespDto;
    }

    @Override
    public List<Long> queryByOrderNo(String orderNo) {
        OrderActivityEo orderActivityEo = OrderActivityEo.newInstance();
        orderActivityEo.setOrderNo(orderNo);
        List orderActivityEos = this.orderActivityDas.select((BaseEo)orderActivityEo);
        if (CollectionUtils.isEmpty((Collection)orderActivityEos)) {
            return Collections.EMPTY_LIST;
        }
        List<Long> activityIds = orderActivityEos.stream().map(orderActivity -> {
            if (StringUtils.isNotBlank((CharSequence)orderActivity.getActivityId())) {
                return Long.valueOf(orderActivity.getActivityId());
            }
            return 0L;
        }).collect(Collectors.toList());
        return activityIds;
    }

    @Override
    public boolean useExchangeCoupon(String orderNo) {
        CouponExtRespDto coupon;
        OrderActivityInfoReqDto orderActivityInfoReqDto;
        OrderActivityReqDto reqDto = new OrderActivityReqDto();
        reqDto.setType(ActivityConstant.COUPON_ACTIVITY);
        reqDto.setOrderNo(orderNo);
        List<OrderActivityRespDto> activities = this.queryList(reqDto);
        return CollectionUtils.isNotEmpty(activities) && StringUtils.isNotBlank((CharSequence)activities.get(0).getExtension()) && CollectionUtils.isNotEmpty((Collection)(orderActivityInfoReqDto = (OrderActivityInfoReqDto)JSON.parseObject((String)activities.get(0).getExtension(), OrderActivityInfoReqDto.class)).getActivityItemIds()) && null != (coupon = (CouponExtRespDto)this.couponExtQueryApi.queryById(Long.valueOf((String)orderActivityInfoReqDto.getActivityItemIds().get(0))).getData()) && CouponCategoryEnum.EXTRACT.getCategory().equals(coupon.getCouponTemplate().getCouponCategory());
    }
}

