/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.service.impl;

import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderAddressRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderAddressSimpleRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.utils.SqlFilterBuilder;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderAddressService;
import com.dtyunxi.yundt.cube.center.trade.dao.das.OrderAddressDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.RefDeliveryOrderDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderAddressEo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OrderAddressServiceImpl
implements IOrderAddressService {
    private static Logger logger = LoggerFactory.getLogger(OrderAddressServiceImpl.class);
    @Resource
    private OrderAddressDas orderAddressDas;
    @Resource
    private ICacheService cacheService;
    @Resource
    private RefDeliveryOrderDas refDeliveryOrderDas;

    @Override
    public List<OrderAddressRespDto> queryDtoByTradeNo(String orderNo) {
        ArrayList list = this.cacheService.getList("order_address" + orderNo, OrderAddressRespDto.class);
        if (CollectionUtils.isEmpty((Collection)list)) {
            list = new ArrayList();
            List addressEos = this.orderAddressDas.select(SqlFilterBuilder.create(OrderAddressEo.class).eq("order_no", (Object)orderNo).eo());
            if (CollectionUtils.isNotEmpty((Collection)addressEos)) {
                CubeBeanUtils.copyCollection(list, (Collection)addressEos, OrderAddressRespDto.class);
                this.cacheService.lpush("order_address" + orderNo, list, 1800);
            }
        }
        return list;
    }

    @Override
    public void updatePickupCodeByOrderNo(String orderNo, String pickupCode) {
        if (StringUtils.isEmpty((CharSequence)orderNo)) {
            return;
        }
        OrderAddressEo orderAddressSelect = OrderAddressEo.newInstance();
        orderAddressSelect.setOrderNo(orderNo);
        OrderAddressEo orderAddressEo = (OrderAddressEo)this.orderAddressDas.selectOne((BaseEo)orderAddressSelect);
        if (null == orderAddressEo) {
            return;
        }
        OrderAddressEo orderAddressUpdate = OrderAddressEo.newInstance();
        orderAddressUpdate.setId(orderAddressEo.getId());
        orderAddressUpdate.setPickUpCode(pickupCode);
        this.orderAddressDas.updateSelective((BaseEo)orderAddressUpdate);
        logger.info("\u66f4\u65b0\u8ba2\u5355\uff1a{}\u6536\u8d27\u5730\u5740\u4e2d\u7684\u63d0\u8d27\u7801\u4e3a\uff1a{}", (Object)orderNo, (Object)pickupCode);
    }

    @Override
    public List<OrderAddressSimpleRespDto> queryByOrderNos(Set<String> orderNoSet) {
        ArrayList<OrderAddressSimpleRespDto> respDtoList = new ArrayList<OrderAddressSimpleRespDto>();
        orderNoSet.forEach(e -> {
            List<OrderAddressRespDto> list = this.queryDtoByTradeNo((String)e);
            if (CollectionUtils.isNotEmpty(list)) {
                OrderAddressSimpleRespDto simpleRespDto = new OrderAddressSimpleRespDto();
                OrderAddressRespDto respDto = list.get(0);
                simpleRespDto.setAddress(respDto.getAddress());
                simpleRespDto.setDeliveryMobile(respDto.getDeliveryMobile());
                simpleRespDto.setDeliveryName(respDto.getDeliveryName());
                simpleRespDto.setOrderNo(e);
                respDtoList.add(simpleRespDto);
            }
        });
        return respDtoList;
    }
}

