/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.trade.api.constants.YesNoEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderCompareDiffReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderCompareDiffRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.utils.SqlFilterBuilder;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderCompareDiffService;
import com.dtyunxi.yundt.cube.center.trade.biz.util.Assert;
import com.dtyunxi.yundt.cube.center.trade.dao.das.OrderCompareDiffDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderCompareDiffEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrderCompareDiffServiceImpl
implements IOrderCompareDiffService {
    @Resource
    private OrderCompareDiffDas orderCompareDiffDas;

    @Override
    public Long addOrderCompareDiff(OrderCompareDiffReqDto addReqDto) {
        OrderCompareDiffEo orderCompareDiffEo = new OrderCompareDiffEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)orderCompareDiffEo);
        this.orderCompareDiffDas.insert((BaseEo)orderCompareDiffEo);
        return orderCompareDiffEo.getId();
    }

    @Override
    public void modifyOrderCompareDiff(OrderCompareDiffReqDto modifyReqDto) {
        OrderCompareDiffEo orderCompareDiffEo = new OrderCompareDiffEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)orderCompareDiffEo);
        this.orderCompareDiffDas.updateSelective((BaseEo)orderCompareDiffEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeOrderCompareDiff(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.orderCompareDiffDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public OrderCompareDiffRespDto queryById(Long id) {
        OrderCompareDiffEo orderCompareDiffEo = (OrderCompareDiffEo)this.orderCompareDiffDas.selectByPrimaryKey(id);
        OrderCompareDiffRespDto orderCompareDiffRespDto = new OrderCompareDiffRespDto();
        DtoHelper.eo2Dto((BaseEo)orderCompareDiffEo, (BaseVo)orderCompareDiffRespDto);
        return orderCompareDiffRespDto;
    }

    @Override
    public PageInfo<OrderCompareDiffRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        OrderCompareDiffReqDto orderCompareDiffReqDto = (OrderCompareDiffReqDto)JSON.parseObject((String)filter, OrderCompareDiffReqDto.class);
        OrderCompareDiffEo orderCompareDiffEo = new OrderCompareDiffEo();
        DtoHelper.dto2Eo((BaseVo)orderCompareDiffReqDto, (BaseEo)orderCompareDiffEo);
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>(2);
        if (orderCompareDiffReqDto.getPayTimeStart() != null) {
            sqlFilters.add(SqlFilter.ge((String)"pay_time", (Object)orderCompareDiffReqDto.getPayTimeStart()));
        }
        if (orderCompareDiffReqDto.getPayTimeEnd() != null) {
            sqlFilters.add(SqlFilter.le((String)"pay_time", (Object)orderCompareDiffReqDto.getPayTimeEnd()));
        }
        if (orderCompareDiffReqDto.getShopName() != null) {
            sqlFilters.add(SqlFilter.le((String)"shop_name", (Object)("%" + orderCompareDiffReqDto.getShopName() + "%")));
        }
        if (sqlFilters.size() > 0) {
            orderCompareDiffEo.setSqlFilters(sqlFilters);
        }
        PageInfo eoPageInfo = this.orderCompareDiffDas.selectPage((BaseEo)orderCompareDiffEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, OrderCompareDiffRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public void checkConfirm(List<Long> ids) {
        Assert.isTrue(CollectionUtil.isEmpty(ids), "ids\u4e0d\u80fd\u4e3a\u7a7a");
        OrderCompareDiffEo orderCompareDiffEo = (OrderCompareDiffEo)this.orderCompareDiffDas.selectByPrimaryKey(ids.get(0));
        Assert.isTrue(orderCompareDiffEo != null && orderCompareDiffEo.getId() != null, "\u8bf7\u4f20\u9012\u6b63\u786e\u7684\u53c2\u6570");
        this.orderCompareDiffDas.updateSelective(SqlFilterBuilder.create(OrderCompareDiffEo.class).in("id", ids.stream().filter(Objects::nonNull).collect(Collectors.toList())).eq("status", (Object)YesNoEnum.YES.getValue().toString()).eo());
    }

    @Override
    public void checkRemark(OrderCompareDiffReqDto modifyReqDto) {
        Assert.isTrue(modifyReqDto != null && modifyReqDto.getId() != null, "id\u4e0d\u80fd\u4e3a\u7a7a");
        OrderCompareDiffEo orderCompareDiffEo = (OrderCompareDiffEo)this.orderCompareDiffDas.selectByPrimaryKey(modifyReqDto.getId());
        Assert.isTrue(orderCompareDiffEo != null && orderCompareDiffEo.getId() != null, "\u8bf7\u4f20\u9012\u6b63\u786e\u7684\u53c2\u6570");
        OrderCompareDiffEo recordEo = new OrderCompareDiffEo();
        recordEo.setId(modifyReqDto.getId());
        recordEo.setRemark(modifyReqDto.getRemark());
        this.orderCompareDiffDas.updateSelective((BaseEo)recordEo);
    }
}

