/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.service.impl;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.bean.ObjectHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderSplitReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.TradeItemReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.exception.TradeExceptionCode;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IExtlDataService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IMemberService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderCouponService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.ITradeItemService;
import com.dtyunxi.yundt.cube.center.trade.biz.util.CouponCalcUtil;
import com.dtyunxi.yundt.cube.center.trade.dao.das.OrderCouponDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.OrderDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.TradeItemDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderCouponEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.TradeItemEo;
import com.dtyunxi.yundt.cube.center.trade.ext.api.constants.CouponRangeEnum;
import com.dtyunxi.yundt.cube.center.trade.ext.api.dto.request.CalcItemVo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.IEngineApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponExtRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.service.query.ICouponExtQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.ActivityResultMessage;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.EngineParams;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.ItemVo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service
public class OrderCouponServiceImpl
implements IOrderCouponService {
    private static Logger logger = LoggerFactory.getLogger(OrderCouponServiceImpl.class);
    @Autowired
    private OrderCouponDas orderCouponDas;
    @Autowired
    private IEngineApi engineApi;
    @Autowired
    private ICommonsMqService commonsMqService;
    @Autowired
    private IExtlDataService extlDataService;
    @Autowired
    private OrderDas orderDas;
    @Autowired
    private TradeItemDas tradeItemDas;
    @Autowired
    private ICouponExtQueryApi iCouponExtQueryApi;
    @Resource
    private IMemberService memberService;
    @Resource
    private ITradeItemService tradeItemService;
    @Resource
    private Environment environment;

    @Override
    public OrderCouponEo getByCoupon(String couponId) {
        OrderCouponEo orderCouponEo = new OrderCouponEo();
        return (OrderCouponEo)this.orderCouponDas.selectOne((BaseEo)orderCouponEo);
    }

    @Override
    public EngineParams lockCoupon(OrderReqDto orderReqDto) {
        return this.lockCoupon(orderReqDto.getCouponString());
    }

    @Override
    public EngineParams lockCoupon(String coupDetail) {
        if (ObjectHelper.isEmpty((Object)coupDetail)) {
            return null;
        }
        logger.info("\u53d1\u8d77\u9501\u5b9a\u4f18\u60e0\u5238:" + coupDetail);
        EngineParams engineParams = (EngineParams)ObjectHelper.Json2Bean((String)coupDetail, EngineParams.class);
        return this.lockCoupon(engineParams);
    }

    @Override
    public EngineParams lockCoupon(EngineParams engineParams) {
        RestResponse restResponse = this.engineApi.execute("JOIN_IN", engineParams);
        logger.info("\u9501\u5b9a\u4f18\u60e0\u5238\u7ed3\u679c:" + restResponse.toString());
        if (!restResponse.getResultCode().equals("0")) {
            throw new BizException(restResponse.getResultCode(), restResponse.getResultMsg());
        }
        return (EngineParams)restResponse.getData();
    }

    @Override
    public EngineParams lockNewCoupon(EngineParams engineParams) {
        RestResponse restResponse = this.engineApi.execute("IC_CONSUME_COUPON", engineParams);
        logger.info("\u9501\u5b9a\u4f18\u60e0\u5238\u7ed3\u679c:" + restResponse.toString());
        if (!restResponse.getResultCode().equals("0")) {
            throw new BizException(restResponse.getResultCode(), restResponse.getResultMsg());
        }
        return (EngineParams)restResponse.getData();
    }

    @Override
    public OrderReqDto resolveCouponData(OrderReqDto orderReqDto, EngineParams engineParams) {
        orderReqDto.setCouponString(ObjectHelper.bean2Json((Object)engineParams));
        BigDecimal payAmount = orderReqDto.getTotalAmount().subtract(engineParams.getTotalDiscountAmount()).subtract(engineParams.getTotalDiscountFreight());
        if (payAmount.compareTo(BigDecimal.ZERO) < 1) {
            logger.info("payAmount:" + payAmount.toString() + "orderReqDto.getTotalAmount():" + orderReqDto.getTotalAmount().toString() + " - engineParams.getTotalDiscountAmount():" + engineParams.getTotalDiscountAmount().toString() + " - engineParams.getTotalDiscountFreight():" + engineParams.getTotalDiscountFreight().toString());
            throw new BizException(TradeExceptionCode.ORDER_PAY_AMOUNT_DIFFER.getCode(), TradeExceptionCode.ORDER_PAY_AMOUNT_DIFFER.getMsg());
        }
        if (orderReqDto.getPayAmount().setScale(2, RoundingMode.UP).compareTo(payAmount) != 0) {
            logger.info("orderReqDto.getPayAmount():" + orderReqDto.getPayAmount().toString() + "|payAmount:" + payAmount.toString());
            throw new BizException(TradeExceptionCode.ORDER_PAY_AMOUNT_DIFFER.getCode(), TradeExceptionCode.ORDER_PAY_AMOUNT_DIFFER.getMsg());
        }
        BigDecimal sumDiscountAmount = BigDecimal.ZERO;
        for (ItemVo itemVo : engineParams.getItems()) {
            orderReqDto.getOrderItems().forEach(tradeItemReqDto -> {
                if (String.valueOf(itemVo.getSkuId()).equals(tradeItemReqDto.getSkuSerial()) && "1".equals(tradeItemReqDto.getItemType())) {
                    if (itemVo.getNum() != tradeItemReqDto.getItemNum().intValue()) {
                        throw new BizException(TradeExceptionCode.ORDER_TRADE_ITEM_ERROR.getCode(), TradeExceptionCode.ORDER_TRADE_ITEM_ERROR.getMsg());
                    }
                    tradeItemReqDto.setItemPrice(itemVo.getDiscountPrice());
                    tradeItemReqDto.setPlatformDiscountPrice(itemVo.getPrice().subtract(itemVo.getDiscountPrice()));
                    tradeItemReqDto.setPayTotalAmount(itemVo.getDiscountPrice().multiply(new BigDecimal(itemVo.getNum())));
                }
            });
            sumDiscountAmount = sumDiscountAmount.add(itemVo.getPrice().subtract(itemVo.getDiscountPrice()).multiply(new BigDecimal(itemVo.getNum())));
        }
        orderReqDto.setPlatformDiscountAmount(engineParams.getTotalDiscountAmount());
        orderReqDto.setDiscountMargin(engineParams.getTotalDiscountAmount().subtract(sumDiscountAmount));
        return orderReqDto;
    }

    @Override
    public OrderReqDto calculatePrice(OrderReqDto orderReqDto, List<EngineParams> engineParamsList) {
        orderReqDto.setCouponString(ObjectHelper.bean2Json(engineParamsList));
        orderReqDto.getOrderItems().forEach(tradeItemReqDto -> tradeItemReqDto.setPayOrigTotalAmount(tradeItemReqDto.getItemOrigPrice().multiply(BigDecimal.valueOf(tradeItemReqDto.getItemNum().intValue()))));
        this.calculate(orderReqDto, engineParamsList);
        return orderReqDto;
    }

    @Override
    public void updateOrderCouponData(OrderReqDto orderReqDto) {
        OrderEo orderEo = new OrderEo();
        orderEo.setTradeNo(orderReqDto.getTradeNo());
        orderEo = (OrderEo)this.orderDas.selectOne((BaseEo)orderEo);
        orderEo.setPlatformDiscountAmount(orderReqDto.getPlatformDiscountAmount());
        orderEo.setShopDiscountAmount(orderReqDto.getShopDiscountAmount());
        orderEo.setDiscountMargin(orderReqDto.getDiscountMargin());
        this.orderDas.updateSelective((BaseEo)orderEo);
        orderReqDto.getOrderItems().forEach(tradeItemReqDto -> {
            TradeItemEo tradeItemEo = new TradeItemEo();
            tradeItemEo.setTradeItemNo(tradeItemReqDto.getTradeItemNo());
            tradeItemEo = (TradeItemEo)this.tradeItemDas.selectOne((BaseEo)tradeItemEo);
            if (null != tradeItemEo) {
                tradeItemEo.setItemPrice(tradeItemReqDto.getItemPrice());
                tradeItemEo.setPlatformDiscountPrice(tradeItemReqDto.getPlatformDiscountPrice());
                tradeItemEo.setPayTotalAmount(tradeItemReqDto.getPayTotalAmount().compareTo(BigDecimal.ZERO) == -1 ? BigDecimal.ZERO : tradeItemReqDto.getPayTotalAmount());
                tradeItemEo.setShopDiscountPrice(tradeItemReqDto.getShopDiscountPrice());
                this.tradeItemService.setCatalogName(tradeItemEo);
                this.tradeItemDas.updateSelective((BaseEo)tradeItemEo);
            }
        });
    }

    @Override
    public void useCoupon(OrderEo orderEo, List<Long> couponIds) {
        this.sendCouponMQ(orderEo, true, couponIds);
    }

    @Override
    public void releaseCoupon(OrderEo orderEo, List<Long> couponIds) {
        this.sendCouponMQ(orderEo, false, couponIds);
    }

    private void sendCouponMQ(OrderEo orderEo, Boolean status, List<Long> couponIds) {
        EngineParams engineParams = new EngineParams();
        engineParams.setOrderCode(orderEo.getOrderNo());
        if (StringUtils.isNotEmpty((CharSequence)orderEo.getCustomerId())) {
            engineParams.setUserId(Long.valueOf(orderEo.getCustomerId()));
            engineParams.setActivityFlag(Boolean.valueOf(true));
        } else {
            Long memberId = this.memberService.getMemberId(Long.valueOf(orderEo.getUserId()));
            engineParams.setUserId(memberId);
        }
        engineParams.setCouponIds(couponIds);
        ActivityResultMessage activityResultMessage = new ActivityResultMessage();
        activityResultMessage.setOrderCode(orderEo.getOrderNo());
        activityResultMessage.setSuccess(status);
        activityResultMessage.setParams(engineParams);
        logger.info("\u53d1\u9001\u4f18\u60e0\u5238" + (status != false ? "\u6838\u9500" : "\u91ca\u653e") + "\u6d88\u606f:" + ObjectHelper.bean2Json((Object)activityResultMessage));
        this.commonsMqService.sendSingleMessage(this.environment.resolvePlaceholders("JOIN_IN_ACTIVITY_RESULT"), (Object)activityResultMessage);
        logger.info("\u53d1\u9001\u4f18\u60e0\u5238" + (status != false ? "\u6838\u9500" : "\u91ca\u653e") + "\u6d88\u606f\u6210\u529f");
    }

    @Override
    public void updateSubOrderCouponData(OrderReqDto orderReqDto, OrderSplitReqDto orderSplitReqDto) {
        OrderEo orderEo = new OrderEo();
        orderEo.setTradeNo(orderReqDto.getTradeNo());
        orderEo = (OrderEo)this.orderDas.selectOne((BaseEo)orderEo);
        orderEo.setPlatformDiscountAmount(orderReqDto.getPlatformDiscountAmount());
        orderEo.setShopDiscountAmount(orderReqDto.getShopDiscountAmount());
        orderEo.setDiscountMargin(orderReqDto.getDiscountMargin());
        orderEo.setPayAmount(orderReqDto.getPayAmount());
        this.orderDas.updateSelective((BaseEo)orderEo);
        for (OrderReqDto childrenOrder : orderSplitReqDto.getChildrenOrderList()) {
            BigDecimal payAmount = BigDecimal.ZERO;
            BigDecimal platformDiscountAmount = BigDecimal.ZERO;
            BigDecimal shopDiscountAmount = BigDecimal.ZERO;
            for (TradeItemReqDto childTradeItemReqDto : childrenOrder.getOrderItems()) {
                TradeItemReqDto parentTradeItemReqDto = orderReqDto.getOrderItems().stream().filter(tradeItemReqDto -> tradeItemReqDto.getSkuSerial().equals(childTradeItemReqDto.getSkuSerial()) && tradeItemReqDto.getShopId().equals(childTradeItemReqDto.getShopId())).findFirst().orElseGet(() -> null);
                if (null == parentTradeItemReqDto) continue;
                childTradeItemReqDto.setItemPrice(parentTradeItemReqDto.getItemPrice());
                childTradeItemReqDto.setPlatformDiscountPrice(parentTradeItemReqDto.getPlatformDiscountPrice());
                childTradeItemReqDto.setShopDiscountPrice(parentTradeItemReqDto.getShopDiscountPrice());
                childTradeItemReqDto.setPayTotalAmount(parentTradeItemReqDto.getPayTotalAmount());
                payAmount = payAmount.add(parentTradeItemReqDto.getPayTotalAmount());
                if (null != parentTradeItemReqDto.getPlatformDiscountPrice()) {
                    platformDiscountAmount = platformDiscountAmount.add(parentTradeItemReqDto.getPlatformDiscountPrice());
                }
                if (null == parentTradeItemReqDto.getShopDiscountPrice()) continue;
                shopDiscountAmount = shopDiscountAmount.add(parentTradeItemReqDto.getShopDiscountPrice());
            }
            childrenOrder.setPayAmount(payAmount);
            childrenOrder.setPlatformDiscountAmount(platformDiscountAmount);
            childrenOrder.setShopDiscountAmount(shopDiscountAmount);
        }
    }

    private void calculate(OrderReqDto orderReqDto, List<EngineParams> engineParamsList) {
        LinkedHashMap<Long, CouponExtRespDto> couponMap = this.sortConpon(engineParamsList);
        Map<Long, EngineParams> engineParamsMap = engineParamsList.stream().collect(Collectors.toMap(engineParams -> (Long)engineParams.getCouponIds().get(0), e -> e, (param, paramNext) -> param));
        ArrayList disccountedItems = Lists.newArrayList();
        couponMap.forEach((couponId, coupon) -> {
            List<CalcItemVo> itemVos = ((EngineParams)engineParamsMap.get(couponId)).getItems().stream().map(itemVo -> {
                CalcItemVo calcItemVo = new CalcItemVo();
                CubeBeanUtils.copyProperties((Object)calcItemVo, (Object)itemVo, (String[])new String[0]);
                calcItemVo.setItemTotalAmount(itemVo.getPrice().multiply(BigDecimal.valueOf(itemVo.getNum())));
                return calcItemVo;
            }).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty((Collection)disccountedItems)) {
                itemVos.forEach(itemVo -> disccountedItems.forEach(disaccountedItemVo -> {
                    if (itemVo.getSkuId().equals(disaccountedItemVo.getSkuId()) && itemVo.getShopId().equals(disaccountedItemVo.getShopId())) {
                        itemVo.setPrice(disaccountedItemVo.getDiscountPrice());
                        itemVo.setShopDiscountAmount(disaccountedItemVo.getShopDiscountAmount());
                        itemVo.setPlatformDiscountAmount(disaccountedItemVo.getPlatformDiscountAmount());
                        itemVo.setItemTotalAmount(itemVo.getPrice().multiply(BigDecimal.valueOf(itemVo.getNum())));
                    }
                }));
            }
            CouponCalcUtil.calculate(itemVos, coupon.getCouponTemplate());
            this.resetOrderReqDto(orderReqDto, itemVos);
            disccountedItems.addAll(itemVos);
        });
        if (BigDecimal.ZERO.compareTo(orderReqDto.getPayAmount()) == 0) {
            orderReqDto.setPayAmount(BigDecimal.valueOf(0.01));
        }
    }

    private LinkedHashMap<Long, CouponExtRespDto> sortConpon(List<EngineParams> engineParamsList) {
        LinkedHashMap<Long, CouponExtRespDto> couponMap = new LinkedHashMap<Long, CouponExtRespDto>();
        CouponExtRespDto platformCoupon = null;
        for (EngineParams engineParams : engineParamsList) {
            RestResponse restResponse = this.iCouponExtQueryApi.queryByIds(engineParams.getCouponIds());
            CouponExtRespDto coupon = (CouponExtRespDto)((List)restResponse.getData()).get(0);
            if (null == coupon || null == coupon.getCouponTemplate()) {
                throw new BizException("\u4f18\u60e0\u5238\u4fe1\u606f\u9519\u8bef");
            }
            if (CouponRangeEnum.PLATFORM.getKey().equals(coupon.getCouponTemplate().getCouponRange())) {
                platformCoupon = coupon;
                continue;
            }
            if (!CouponRangeEnum.SELLER.getKey().equals(coupon.getCouponTemplate().getCouponRange())) continue;
            couponMap.put((Long)engineParams.getCouponIds().get(0), coupon);
        }
        if (null != platformCoupon) {
            couponMap.put(platformCoupon.getId(), platformCoupon);
        }
        return couponMap;
    }

    private void resetOrderReqDto(OrderReqDto orderReqDto, List<CalcItemVo> itemVoList) {
        BigDecimal payAmount = BigDecimal.ZERO;
        BigDecimal platformDiscountAmount = BigDecimal.ZERO;
        BigDecimal shopDiscountAmount = BigDecimal.ZERO;
        for (TradeItemReqDto tradeItemReqDto : orderReqDto.getOrderItems()) {
            CalcItemVo itemVo = itemVoList.stream().filter(item -> tradeItemReqDto.getShopId().equals(item.getShopId()) && tradeItemReqDto.getSkuSerial().equals(item.getSkuId())).findFirst().orElseGet(() -> null);
            if (null != itemVo) {
                BigDecimal platformDiscountPrice = itemVo.getPlatformDiscountAmount() == null ? BigDecimal.ZERO : itemVo.getPlatformDiscountAmount();
                BigDecimal shopDiscountPrice = itemVo.getShopDiscountAmount() == null ? BigDecimal.ZERO : itemVo.getShopDiscountAmount();
                platformDiscountAmount = platformDiscountAmount.add(platformDiscountPrice);
                shopDiscountAmount = shopDiscountPrice.add(shopDiscountPrice);
                BigDecimal payTotalAmount = tradeItemReqDto.getPayOrigTotalAmount().subtract(platformDiscountPrice).subtract(shopDiscountPrice);
                if (BigDecimal.ZERO.compareTo(payTotalAmount) == 1) {
                    payTotalAmount = BigDecimal.ZERO;
                }
                tradeItemReqDto.setPayTotalAmount(payTotalAmount);
                tradeItemReqDto.setItemPrice(itemVo.getDiscountPrice());
                tradeItemReqDto.setPlatformDiscountPrice(platformDiscountPrice);
                tradeItemReqDto.setShopDiscountPrice(shopDiscountPrice);
            }
            payAmount = payAmount.add(tradeItemReqDto.getPayTotalAmount());
        }
        orderReqDto.setPayAmount(payAmount);
        orderReqDto.setPlatformDiscountAmount(platformDiscountAmount);
        orderReqDto.setShopDiscountAmount(shopDiscountAmount);
    }
}

