/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.api.enums.DeliveryStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.ShippingCompanyEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.ShippingTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.YesNoEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.ShippingReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.DeliveryLogisticRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.DeliveryRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderDeliveryInfoRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderDeliveryLogisticRespDto;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IDeliveryService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderDeliveryInfoService;
import com.dtyunxi.yundt.cube.center.trade.dao.das.DeliveryLogisticsDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.OrderAddressDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.OrderDeliveryDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.RefDeliveryOrderDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderAddressEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderDeliveryEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.RefDeliveryOrderEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.StdRefDeliveryOrderEo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrderDeliveryInfoServiceImpl
implements IOrderDeliveryInfoService {
    private static Logger logger = LoggerFactory.getLogger(OrderDeliveryInfoServiceImpl.class);
    @Autowired
    private IDeliveryService deliveryService;
    @Autowired
    private OrderAddressDas orderAddressDas;
    @Autowired
    private RefDeliveryOrderDas refDeliveryOrderDas;
    @Autowired
    private OrderDeliveryDas orderDeliveryDas;
    @Autowired
    private DeliveryLogisticsDas deliveryLogisticsDas;

    @Override
    public OrderDeliveryInfoRespDto queryOrderDeliveryInfo(String orderNo) {
        OrderDeliveryInfoRespDto orderDeliveryInfoRespDto = new OrderDeliveryInfoRespDto();
        OrderAddressEo orderAddressSelect = OrderAddressEo.newInstance();
        orderAddressSelect.setOrderNo(orderNo);
        OrderAddressEo orderAddressEo = (OrderAddressEo)this.orderAddressDas.selectOne((BaseEo)orderAddressSelect);
        if (null != orderAddressEo) {
            orderDeliveryInfoRespDto.setReceiverName(orderAddressEo.getDeliveryName());
            orderDeliveryInfoRespDto.setReceiverPhone(orderAddressEo.getDeliveryPhone());
            orderDeliveryInfoRespDto.setReceiverPostcode(orderAddressEo.getPostcode());
            orderDeliveryInfoRespDto.setReceiverAddress(orderAddressEo.getAddress());
        } else {
            logger.error("\u67e5\u8be2\u8ba2\u5355\u6536\u8d27\u5730\u5740\u4fe1\u606f\u51fa\u73b0\u5f02\u5e38\uff0c\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u6536\u8d27\u5730\u5740\u4fe1\u606f\uff01orderNo\uff1a{}", (Object)orderNo);
        }
        orderDeliveryInfoRespDto.setDeliverys(this.queryDeliveryByOrderNo(orderNo));
        return orderDeliveryInfoRespDto;
    }

    @Override
    public List<OrderDeliveryLogisticRespDto> queryOrderDeliveryLogistic(String orderNo) {
        ArrayList list = Lists.newArrayList();
        List refDeliveryOrderEoList = this.refDeliveryOrderDas.selectByOrderNo(orderNo);
        if (CollectionUtils.isNotEmpty((Collection)refDeliveryOrderEoList)) {
            List orderDeliveryEoList = this.orderDeliveryDas.selectByDeliveryNoList(refDeliveryOrderEoList.stream().map(StdRefDeliveryOrderEo::getDeliveryNo).collect(Collectors.toList()));
            orderDeliveryEoList.forEach(orderDeliveryEo -> {
                List deliveryLogisticsEoList;
                String deliveryNo = orderDeliveryEo.getDeliveryNo();
                OrderDeliveryLogisticRespDto orderDeliveryLogisticRespDto = new OrderDeliveryLogisticRespDto();
                orderDeliveryLogisticRespDto.setOrderNo(orderNo);
                orderDeliveryLogisticRespDto.setDeliveryNo(deliveryNo);
                orderDeliveryLogisticRespDto.setExpressCode(orderDeliveryEo.getExpressCode());
                orderDeliveryLogisticRespDto.setShippingCompany(orderDeliveryEo.getShippingCompany());
                List<Object> deliveryLogisticRespDtoList = Lists.newLinkedList();
                if (ShippingTypeEnum.EXPRESS.getType().equals(orderDeliveryEo.getShippingType()) && CollectionUtils.isNotEmpty((Collection)(deliveryLogisticsEoList = this.deliveryLogisticsDas.listByDeliveryNoDesc(deliveryNo)))) {
                    deliveryLogisticRespDtoList = deliveryLogisticsEoList.stream().map(deliveryLogisticEo -> {
                        DeliveryLogisticRespDto deliveryLogisticRespDto = new DeliveryLogisticRespDto();
                        DtoHelper.eo2Dto((BaseEo)deliveryLogisticEo, (BaseVo)deliveryLogisticRespDto);
                        return deliveryLogisticRespDto;
                    }).collect(Collectors.toList());
                }
                if (ShippingTypeEnum.EXPRESS.getType().equals(orderDeliveryEo.getShippingType()) && StringUtils.isNotBlank((CharSequence)orderDeliveryEo.getShippingCompanyCode()) && StringUtils.isNotBlank((CharSequence)orderDeliveryEo.getExpressCode())) {
                    ShippingReqDto shippingReqDto = new ShippingReqDto();
                    shippingReqDto.setShippingNo(orderDeliveryEo.getShippingCompanyCode());
                    shippingReqDto.setShippingCode(orderDeliveryEo.getExpressCode());
                    if (ShippingCompanyEnum.SF.getCode().equals(orderDeliveryEo.getShippingCompanyCode())) {
                        shippingReqDto.setCustomerName(orderDeliveryEo.getDeliveryMobile().substring(orderDeliveryEo.getDeliveryMobile().length() - 4));
                    }
                    if (ShippingCompanyEnum.JD.getCode().equals(orderDeliveryEo.getShippingCompanyCode())) {
                        shippingReqDto.setCustomerName("");
                    }
                    deliveryLogisticRespDtoList = this.deliveryService.listDeliveryLogistics(shippingReqDto);
                    Collections.reverse(deliveryLogisticRespDtoList);
                }
                orderDeliveryLogisticRespDto.setLogisticRespDtoList((List)deliveryLogisticRespDtoList);
                list.add(orderDeliveryLogisticRespDto);
            });
        }
        return list;
    }

    private List<DeliveryRespDto> queryDeliveryByOrderNo(String orderNo) {
        ArrayList<DeliveryRespDto> deliveryRespDtos = new ArrayList<DeliveryRespDto>();
        RefDeliveryOrderEo refDeliveryOrderSelect = RefDeliveryOrderEo.newInstance();
        refDeliveryOrderSelect.setOrderNo(orderNo);
        List refDeliveryOrders = this.refDeliveryOrderDas.select((BaseEo)refDeliveryOrderSelect);
        if (CollectionUtils.isEmpty((Collection)refDeliveryOrders)) {
            logger.error("\u67e5\u8be2\u8ba2\u5355\u7269\u6d41\u4fe1\u606f\u51fa\u73b0\u5f02\u5e38\uff0c\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u8ba2\u5355\u53d1\u8d27\u5355\u5173\u8054\uff01orderNo\uff1a{}", (Object)orderNo);
            return deliveryRespDtos;
        }
        for (RefDeliveryOrderEo refDeliveryOrderEo : refDeliveryOrders) {
            DeliveryRespDto delivery = this.deliveryService.getDetailByDeliveryNo(refDeliveryOrderEo.getDeliveryNo());
            String parentDeliveryNo = delivery.getParentDeliveryNo();
            if (StringUtils.isNotBlank((CharSequence)parentDeliveryNo) && !"0".equals(parentDeliveryNo) && DeliveryStatusEnum.CANCELED.getStatus().equals(delivery.getDeliveryStatus())) continue;
            deliveryRespDtos.add(delivery);
        }
        return deliveryRespDtos;
    }

    @Override
    public Map<Integer, List<OrderDeliveryEo>> querySceneNum(String orderNo) {
        HashMap<Integer, List<OrderDeliveryEo>> sceneMap = new HashMap<Integer, List<OrderDeliveryEo>>(1);
        ArrayList<OrderDeliveryEo> orderDeliveryEos = new ArrayList<OrderDeliveryEo>();
        int scene = -1;
        int scene1 = 1;
        int scene2 = 2;
        int scene3 = 3;
        RefDeliveryOrderEo refDeliveryOrderSelect = RefDeliveryOrderEo.newInstance();
        refDeliveryOrderSelect.setOrderNo(orderNo);
        List refDeliveryOrders = this.refDeliveryOrderDas.select((BaseEo)refDeliveryOrderSelect);
        if (CollectionUtils.isEmpty((Collection)refDeliveryOrders)) {
            logger.error("\u65b9\u6cd5\u540d\u79f0\uff1aquerySceneNum\uff0c\u65b9\u6cd5\u8bf4\u660e\uff1a\u67e5\u8be2\u573a\u666f\u5e8f\u53f7\uff0c\u5f02\u5e38\u8bf4\u660e\uff1a\u6839\u636e\u8ba2\u5355\u67e5\u8be2\u53d1\u8d27\u5355\u5217\u8868\u4e3a\u7a7a\uff01\uff0c\u67e5\u8be2\u53c2\u6570orderNo\uff1a{}", (Object)orderNo);
            sceneMap.put(scene, orderDeliveryEos);
            return sceneMap;
        }
        for (RefDeliveryOrderEo refDeliveryOrderEo : refDeliveryOrders) {
            OrderDeliveryEo delivery = this.deliveryService.getOrderDeliveryByDeliveryNo(refDeliveryOrderEo.getDeliveryNo());
            if (DeliveryStatusEnum.CANCELED.getStatus().equals(delivery.getDeliveryStatus())) continue;
            orderDeliveryEos.add(delivery);
        }
        if (refDeliveryOrders.size() == 1) {
            for (OrderDeliveryEo orderDeliveryEo : orderDeliveryEos) {
                if (null == orderDeliveryEo.getIfMerge() || YesNoEnum.NO.getValue() == orderDeliveryEo.getIfMerge()) {
                    scene = scene1;
                    continue;
                }
                if (YesNoEnum.YES.getValue() != orderDeliveryEo.getIfMerge()) continue;
                scene = scene2;
            }
        } else if (refDeliveryOrders.size() > 1) {
            boolean flagError = false;
            for (RefDeliveryOrderEo refDeliveryOrder : refDeliveryOrders) {
                List<RefDeliveryOrderEo> refDeliveryOrderEos = this.queryRefDeliveryOrderEosByDeliveryNo(refDeliveryOrder.getDeliveryNo());
                if (refDeliveryOrderEos.size() == 1) continue;
                logger.error("\u65b9\u6cd5\u540d\u79f0\uff1aquerySceneNum\uff0c\u65b9\u6cd5\u8bf4\u660e\uff1a\u67e5\u8be2\u573a\u666f\u5e8f\u53f7\uff0c\u5f02\u5e38\u8bf4\u660e\uff1a\u4e00\u4e2a\u8ba2\u5355\u5b58\u5728\u591a\u4e2a\u53d1\u8d27\u5355\uff0c\u4f46\u8fd9\u4e9b\u53d1\u8d27\u5355\u8fd8\u4ece\u5c5e\u4e8e\u5176\u4ed6\u8ba2\u5355\uff01\uff0c\u67e5\u8be2\u53c2\u6570orderNo\uff1a{}", (Object)orderNo);
                flagError = true;
                break;
            }
            if (!flagError) {
                scene = scene3;
            }
        }
        sceneMap.put(scene, orderDeliveryEos);
        return sceneMap;
    }

    @Override
    public List<RefDeliveryOrderEo> queryRefDeliveryOrderEosByDeliveryNo(String deliveryNo) {
        RefDeliveryOrderEo deliveryOrderSelect = RefDeliveryOrderEo.newInstance();
        deliveryOrderSelect.setDeliveryNo(deliveryNo);
        return this.refDeliveryOrderDas.select((BaseEo)deliveryOrderSelect);
    }
}

