/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.util.RandomCodeUtil;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderProofCreateReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderProofDisableReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderProofUrlReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderProofUseReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderProofRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.exception.TradeExceptionCode;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.IFlowLockService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderProofService;
import com.dtyunxi.yundt.cube.center.trade.biz.util.Assert;
import com.dtyunxi.yundt.cube.center.trade.dao.das.OrderDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.OrderProofDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderProofEo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrderProofServiceImpl
implements IOrderProofService {
    @Autowired
    OrderProofDas orderProofDas;
    @Autowired
    OrderDas orderDas;
    @Resource
    private ICacheService cacheService;
    @Resource
    IFlowLockService tradeLockService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addOrderProof(List<OrderProofCreateReqDto> orderProofCreateReqDtoList) {
        ArrayList<OrderProofEo> orderProofEos = new ArrayList<OrderProofEo>();
        try {
            if (CollectionUtils.isNotEmpty(orderProofCreateReqDtoList)) {
                for (OrderProofCreateReqDto orderProofCreateReqDto : orderProofCreateReqDtoList) {
                    if (orderProofCreateReqDto.getEffectiveStartTime() != null && orderProofCreateReqDto.getEffectiveEndTime() != null && orderProofCreateReqDto.getEffectiveEndTime().before(orderProofCreateReqDto.getEffectiveStartTime())) {
                        throw new BizException(TradeExceptionCode.TIME_ERROR.getCode(), TradeExceptionCode.TIME_ERROR.getMsg() + "\u6ce8\u610f\u6709\u6548\u65f6\u95f4");
                    }
                    OrderProofEo queryEo = OrderProofEo.newInstance();
                    queryEo.setOrderNo(orderProofCreateReqDto.getOrderNo());
                    if (this.orderProofDas.count((BaseEo)queryEo) > 0) {
                        throw new BizException(TradeExceptionCode.ORDER_PROOF_CODE_EXIST.getCode(), TradeExceptionCode.ORDER_PROOF_CODE_EXIST.getMsg());
                    }
                    String code = this.generateOrderProofCode(orderProofCreateReqDto);
                    OrderProofEo orderProofEo = OrderProofEo.newInstance();
                    DtoHelper.dto2Eo((BaseVo)orderProofCreateReqDto, (BaseEo)orderProofEo);
                    orderProofEo.setCode(code);
                    orderProofEo.setStatus(Integer.valueOf(1));
                    orderProofEos.add(orderProofEo);
                }
            }
            if (CollectionUtils.isNotEmpty(orderProofEos)) {
                this.orderProofDas.insertBatch(orderProofEos);
            }
        }
        finally {
            if (CollectionUtils.isNotEmpty(orderProofEos)) {
                for (OrderProofEo orderProofEo : orderProofEos) {
                    this.removeKey(orderProofEo.getTenantId(), orderProofEo.getCode());
                }
            }
        }
    }

    @Override
    public List<OrderProofRespDto> findListByOrderNoAndStatusAndReturnType(String orderNo, int status, int returnType) {
        OrderProofEo orderProofEo = OrderProofEo.newInstance();
        orderProofEo.setOrderNo(orderNo);
        orderProofEo.setStatus(Integer.valueOf(status));
        orderProofEo.setReturnType(Integer.valueOf(returnType));
        List orderProofEos = this.orderProofDas.select((BaseEo)orderProofEo);
        if (CollectionUtils.isNotEmpty((Collection)orderProofEos)) {
            ArrayList<OrderProofRespDto> orderProofRespDtoList = new ArrayList<OrderProofRespDto>();
            DtoHelper.eoList2DtoList((Collection)orderProofEos, orderProofRespDtoList, OrderProofRespDto.class);
            return orderProofRespDtoList;
        }
        return null;
    }

    @Override
    public int countByIdsReturnType(String tradeNo, Collection<Long> ids, int status) {
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"id", (Object)StringUtils.join(ids, (String)",")));
        sqlFilters.add(SqlFilter.eq((String)"trade_no", (Object)tradeNo));
        sqlFilters.add(SqlFilter.eq((String)"status", (Object)status));
        OrderProofEo orderProofEo = OrderProofEo.newInstance();
        orderProofEo.setSqlFilters(sqlFilters);
        return this.orderProofDas.count((BaseEo)orderProofEo);
    }

    @Override
    public void modifyStatus(String tradeNo, Set<Long> ids, Integer fromStatus, Integer toStatus) {
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"id", (Object)StringUtils.join(ids, (String)",")));
        sqlFilters.add(SqlFilter.eq((String)"trade_no", (Object)tradeNo));
        int statusSize = this.countByIdsReturnType(tradeNo, ids, fromStatus);
        Assert.isTrue(ids.size() == statusSize, "\u6838\u9500\u7801\u4fee\u6539\u72b6\u6001\u9519\u8bef\uff0c\u5df2\u7ecf\u4e0d\u7b26\u5408\u4fee\u6539\u72b6\u6001\u6761\u4ef6");
        OrderProofEo orderProofEo = OrderProofEo.newInstance();
        orderProofEo.setStatus(toStatus);
        orderProofEo.setSqlFilters(sqlFilters);
        this.orderProofDas.updateSelectiveSqlFilter((BaseEo)orderProofEo);
    }

    @Override
    public void modifyReturnTradeNo(String tradeNo, Set<Long> ids, String returnTradeNo) {
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        OrderProofEo orderProofEo = OrderProofEo.newInstance();
        orderProofEo.setReturnTradeNo(returnTradeNo);
        sqlFilters.add(SqlFilter.in((String)"id", (Object)StringUtils.join(ids, (String)",")));
        sqlFilters.add(SqlFilter.eq((String)"trade_no", (Object)tradeNo));
        orderProofEo.setSqlFilters(sqlFilters);
        this.orderProofDas.updateSelectiveSqlFilter((BaseEo)orderProofEo);
    }

    String getStatusLockKey(String tradeNo) {
        return "lock_proof_trade_modify_status" + tradeNo;
    }

    @Override
    public Boolean checkFinishUseOrderProof(String orderNo) {
        OrderProofEo orderProofEo = OrderProofEo.newInstance();
        orderProofEo.setStatus(Integer.valueOf(1));
        orderProofEo.setOrderNo(orderNo);
        return this.orderProofDas.count((BaseEo)orderProofEo) == 0;
    }

    private String getCacheKey(Long talentId, String code) {
        return talentId + code + this.getClass();
    }

    private void removeKey(Long talentId, String code) {
        this.cacheService.delCache(this.getCacheKey(talentId, code));
    }

    private String generateOrderProofCode(OrderProofCreateReqDto orderProofCreateReqDto) {
        for (int i = 20; i > 0; --i) {
            String code = RandomCodeUtil.generateTextCode((int)0, (int)6) + orderProofCreateReqDto.getOrderNo().substring(orderProofCreateReqDto.getOrderNo().length() - 4);
            String cacheKey = this.getCacheKey(orderProofCreateReqDto.getTenantId(), code);
            Boolean isSuccess = this.cacheService.add(cacheKey, (Object)1);
            if (!isSuccess.booleanValue()) continue;
            OrderProofEo select = OrderProofEo.newInstance();
            select.setTenantId(orderProofCreateReqDto.getTenantId());
            select.setStatus(Integer.valueOf(1));
            select.setCode(code);
            int count = this.orderProofDas.count((BaseEo)select);
            if (count == 0) {
                return code;
            }
            this.removeKey(orderProofCreateReqDto.getTenantId(), code);
        }
        throw new BizException("\u751f\u6210\u6838\u9500\u7801\u5931\u8d25");
    }

    @Override
    public void addOrderProofUrl(List<OrderProofUrlReqDto> orderProofUrlReqDtoList) {
        if (CollectionUtils.isNotEmpty(orderProofUrlReqDtoList)) {
            HashMap<String, OrderProofUrlReqDto> orderProofUrlReqDtoMap = new HashMap<String, OrderProofUrlReqDto>();
            for (OrderProofUrlReqDto orderProofUrlReqDto : orderProofUrlReqDtoList) {
                if (orderProofUrlReqDto.getCode() == null) continue;
                orderProofUrlReqDtoMap.put(orderProofUrlReqDto.getCode(), orderProofUrlReqDto);
            }
            ArrayList resultDtos = new ArrayList();
            resultDtos.addAll(orderProofUrlReqDtoMap.values());
            for (OrderProofUrlReqDto orderProofUrlReqDto : resultDtos) {
                List orderProofEoList = this.orderProofDas.selectByOrderNoAndCode(orderProofUrlReqDto.getOrderNo(), orderProofUrlReqDto.getCode());
                if (!CollectionUtils.isNotEmpty((Collection)orderProofEoList)) continue;
                OrderProofEo orderProofEo = (OrderProofEo)orderProofEoList.get(0);
                orderProofEo.setUrl(orderProofUrlReqDto.getUrl());
                this.orderProofDas.updateSelective((BaseEo)orderProofEo);
            }
        }
    }

    @Override
    public void useOrderProof(List<OrderProofUseReqDto> orderProofUseReqDtoList) {
        Assert.isTrue(CollectionUtils.isNotEmpty(orderProofUseReqDtoList), "\u4f7f\u7528\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        for (OrderProofUseReqDto orderProofUseReqDto : orderProofUseReqDtoList) {
            OrderProofEo orderProofEo = OrderProofEo.newInstance();
            DtoHelper.dto2Eo((BaseVo)orderProofUseReqDto, (BaseEo)orderProofEo);
            orderProofEo.setStatus(Integer.valueOf(1));
            orderProofEo.setUser(null);
            OrderProofEo eo = (OrderProofEo)this.orderProofDas.selectOne((BaseEo)orderProofEo);
            if (eo != null) {
                if (eo.getEffectiveStartTime().after(new Date()) || eo.getEffectiveEndTime().before(new Date())) {
                    throw new BizException(TradeExceptionCode.ORDER_PROOF_CODE_NOT_ALLOW_USE.getCode(), TradeExceptionCode.ORDER_PROOF_CODE_NOT_ALLOW_USE.getMsg());
                }
                HashSet<Long> ids = new HashSet<Long>();
                ids.add(eo.getId());
                this.modifyStatus(orderProofUseReqDto.getOrderNo(), ids, 1, 2);
                OrderProofEo proofEo = OrderProofEo.newInstance();
                proofEo.setId(eo.getId());
                proofEo.setUser(orderProofUseReqDto.getUser());
                this.orderProofDas.updateSelective((BaseEo)proofEo);
                continue;
            }
            throw new BizException("\u6838\u9500\u7801\u4e0d\u5b58\u5728");
        }
    }

    @Override
    public void disableOrderProof(List<OrderProofDisableReqDto> orderProofDisableReqDtoList) {
        if (CollectionUtils.isNotEmpty(orderProofDisableReqDtoList)) {
            ArrayList<String> codes = new ArrayList<String>();
            ArrayList<String> orderNos = new ArrayList<String>();
            for (OrderProofDisableReqDto dto : orderProofDisableReqDtoList) {
                if (StringUtils.isBlank((CharSequence)dto.getCode()) || StringUtils.isBlank((CharSequence)dto.getOrderNo())) {
                    throw new BizException(TradeExceptionCode.CODE_ORDERNO_NOTNULL.getCode(), TradeExceptionCode.CODE_ORDERNO_NOTNULL.getMsg());
                }
                codes.add(dto.getCode());
                orderNos.add(dto.getOrderNo());
            }
            OrderProofEo orderProofEo = OrderProofEo.newInstance();
            ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
            sqlFilters.add(SqlFilter.in((String)"code", (Object)StringUtils.join(codes, (String)",")));
            sqlFilters.add(SqlFilter.in((String)"order_no", (Object)StringUtils.join(orderNos, (String)",")));
            orderProofEo.setSqlFilters(sqlFilters);
            orderProofEo.setStatus(Integer.valueOf(4));
            this.orderProofDas.updateSelectiveSqlFilter((BaseEo)orderProofEo);
        }
    }

    @Override
    public List<OrderProofRespDto> queryOrderProofByOrderNo(String orderNo, String filter) {
        OrderProofEo orderProofEo = (OrderProofEo)JSON.parseObject((String)filter, OrderProofEo.class);
        orderProofEo.setOrderNo(orderNo);
        List orderProofEos = this.orderProofDas.select((BaseEo)orderProofEo);
        if (CollectionUtils.isNotEmpty((Collection)orderProofEos)) {
            ArrayList<OrderProofRespDto> orderProofRespDtoList = new ArrayList<OrderProofRespDto>();
            DtoHelper.eoList2DtoList((Collection)orderProofEos, orderProofRespDtoList, OrderProofRespDto.class);
            return orderProofRespDtoList;
        }
        return null;
    }

    @Override
    public OrderProofRespDto queryOrderProofByCode(String code, String filter) {
        OrderProofEo orderProofEo = (OrderProofEo)JSON.parseObject((String)filter, OrderProofEo.class);
        orderProofEo.setCode(code);
        OrderProofEo result = (OrderProofEo)this.orderProofDas.selectOne((BaseEo)orderProofEo);
        if (result != null) {
            OrderProofRespDto orderProofRespDto = new OrderProofRespDto();
            DtoHelper.eo2Dto((BaseEo)result, (BaseVo)orderProofRespDto);
            return orderProofRespDto;
        }
        return null;
    }
}

