/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.core.util.JSON;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.payment.api.config.IPayCenterConfigApi;
import com.dtyunxi.yundt.cube.center.payment.dto.config.QueryAccountRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.request.PayConfigQueryReqDto;
import com.dtyunxi.yundt.cube.center.payment.dto.response.PayConfigQueryRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.constants.tob.PayConfigUseChannelEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.tob.PayConfigUseTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.tob.PayMethodTobEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.query.PayTypeQueryReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.query.PayInfoRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.query.PayTypeQueryRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.exception.TradeExceptionCode;
import com.dtyunxi.yundt.cube.center.trade.biz.config.PayConfig;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IPayTypeService;
import com.dtyunxi.yundt.cube.center.trade.biz.util.Assert;
import com.dtyunxi.yundt.cube.center.trade.dao.das.PayConfigDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.PayConfigEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.StdPayConfigEo;
import com.dtyunxi.yundt.module.context.api.IContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class PayTypeServiceImpl
implements IPayTypeService {
    private static final Logger logger = LoggerFactory.getLogger(PayTypeServiceImpl.class);
    @Resource
    private PayConfig payConfig;
    @Resource
    private IPayCenterConfigApi payCenterConfigApi;
    @Resource
    private PayConfigDas payConfigDas;
    @Resource
    private IContext context;

    @Override
    public PayTypeQueryRespDto queryPayTypeList(PayTypeQueryReqDto payTypeQueryReqDto) {
        String useChannel = payTypeQueryReqDto.getUseChannel();
        String storeCode = this.payConfig.getStoreId();
        String appCode = this.payConfig.getAppId();
        PayConfigUseChannelEnum payConfigUseChannelEnum = PayConfigUseChannelEnum.toUseChannelEnum((String)useChannel);
        Assert.notNull((Object)payConfigUseChannelEnum, TradeExceptionCode.INVALID_USE_CHANNEL);
        PayTypeQueryRespDto payTypeQueryRespDto = new PayTypeQueryRespDto();
        payTypeQueryRespDto.setPayGroupFlag(Boolean.FALSE);
        payTypeQueryRespDto.setPayMutexRuleFlag(Boolean.FALSE);
        payTypeQueryRespDto.setPayMutexRuleList((List)ListUtil.toList((Object[])new List[0]));
        payTypeQueryRespDto.setPayTypeList((List)ListUtil.toList((Object[])new PayInfoRespDto[0]));
        QueryAccountRequest queryAccountRequest = new QueryAccountRequest();
        queryAccountRequest.setAppCode(appCode);
        queryAccountRequest.setStoreCode(storeCode);
        queryAccountRequest.setPartnerCode("102,103");
        PayConfigQueryReqDto payConfigQueryReqDto = new PayConfigQueryReqDto();
        payConfigQueryReqDto.setQueryAccountRequest(queryAccountRequest);
        logger.debug("[\u6536\u94f6\u53f0] >>> \u8c03\u7528\u652f\u4ed8\u4e2d\u5fc3\uff0c\u67e5\u8be2\u652f\u6301\u7684\u5728\u7ebf\u652f\u4ed8\u548c\u7ebf\u4e0b\u652f\u4ed8\uff0c\u53c2\u6570\uff1a[{}]", (Object)JSON.toJsonString((Object)payConfigQueryReqDto));
        RestResponse payConfigQueryRespDtoRestResponse = this.payCenterConfigApi.queryPayList(payConfigQueryReqDto);
        PayConfigQueryRespDto payConfigQueryRespDto = (PayConfigQueryRespDto)RestResponseHelper.extractData((RestResponse)payConfigQueryRespDtoRestResponse);
        if (Objects.isNull(payConfigQueryRespDto)) {
            return payTypeQueryRespDto;
        }
        ArrayList onlinePayList = payConfigQueryRespDto.getOnlinePayList();
        if (CollUtil.isEmpty((Collection)onlinePayList)) {
            onlinePayList = new ArrayList();
        }
        Map onlinePayMap = onlinePayList.stream().collect(Collectors.toMap(item -> item.getPartnerCode() + "-" + item.getPayType(), Function.identity(), (o1, o2) -> o2));
        boolean offlinePayState = payConfigQueryRespDto.getOfflineState();
        logger.debug("[\u6536\u94f6\u53f0] >>> \u7ebf\u4e0b\u652f\u4ed8\u652f\u6301\u72b6\u6001[{}]", (Object)offlinePayState);
        PayConfigEo payConfigEo = this.newPayConfigEo(storeCode, appCode);
        payConfigEo.setUseChannel(useChannel);
        payConfigEo.setUseType(PayConfigUseTypeEnum.PAY_TYPE_SORT.code());
        List payConfigList = this.payConfigDas.select((BaseEo)payConfigEo).stream().sorted(Comparator.comparing(StdPayConfigEo::getSort)).collect(Collectors.toList());
        if (CollUtil.isEmpty(payConfigList)) {
            return payTypeQueryRespDto;
        }
        List payTypeList = payConfigList.stream().filter(item -> {
            String key = item.getExtension();
            String mainData = item.getMainData();
            PayMethodTobEnum payMethodTobEnum = PayMethodTobEnum.fromCode((String)mainData);
            if (Objects.isNull(payMethodTobEnum)) {
                return false;
            }
            if (Objects.equals(PayMethodTobEnum.OFFLINE_AMOUNT_PAY, payMethodTobEnum) || Objects.equals(PayMethodTobEnum.OFFLINE_PUBLIC_REMIT_PAY, payMethodTobEnum)) {
                return Objects.equals(key, Boolean.TRUE.toString()) && offlinePayState;
            }
            return Objects.equals(key, Boolean.TRUE.toString()) || onlinePayMap.containsKey(key);
        }).map(item -> {
            PayInfoRespDto payInfoRespDto = new PayInfoRespDto();
            BeanUtils.copyProperties((Object)item, (Object)payInfoRespDto);
            return payInfoRespDto;
        }).collect(Collectors.toList());
        payTypeQueryRespDto.setPayTypeList(payTypeList);
        payConfigEo = this.newPayConfigEo(storeCode, appCode);
        payConfigEo.setUseType(PayConfigUseTypeEnum.PAY_GROUP_FLAG.code());
        payConfigEo = (PayConfigEo)this.payConfigDas.selectOne((BaseEo)payConfigEo);
        payTypeQueryRespDto.setPayGroupFlag(Boolean.valueOf(Objects.nonNull(payConfigEo) && Objects.equals(payConfigEo.getMainData(), Boolean.TRUE.toString())));
        if (payTypeQueryRespDto.getPayGroupFlag().booleanValue()) {
            payConfigEo = this.newPayConfigEo(storeCode, appCode);
            payConfigEo.setUseType(PayConfigUseTypeEnum.PAY_MUTEX_RULE_FLAG.code());
            payConfigEo = (PayConfigEo)this.payConfigDas.selectOne((BaseEo)payConfigEo);
            payTypeQueryRespDto.setPayMutexRuleFlag(Boolean.valueOf(Objects.nonNull(payConfigEo) && Objects.equals(payConfigEo.getMainData(), Boolean.TRUE.toString())));
            if (payTypeQueryRespDto.getPayMutexRuleFlag().booleanValue()) {
                payConfigEo = this.newPayConfigEo(storeCode, appCode);
                payConfigEo.setUseType(PayConfigUseTypeEnum.PAY_MUTEX_RULES.code());
                List payMutexRulesList = this.payConfigDas.select((BaseEo)payConfigEo);
                List list = payMutexRulesList.stream().map(item -> {
                    List list1 = JSON.parseList((String)item.getMainData(), String.class);
                    Collections.sort(list1);
                    return list1;
                }).collect(Collectors.toList());
                payTypeQueryRespDto.setPayMutexRuleList(list);
            }
        }
        return payTypeQueryRespDto;
    }

    private PayConfigEo newPayConfigEo(String storeCode, String appCode) {
        PayConfigEo payConfigEo = new PayConfigEo();
        payConfigEo.setInstanceId(this.context.instanceId());
        payConfigEo.setTenantId(this.context.tenantId());
        return payConfigEo;
    }
}

