/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.trade.api.constants.PickupEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.PickupCodeUseReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.PickupRecordModifyReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.PickupRecordReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.PickupDetailRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.PickupRecordDetailRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.PickupRecordRespDto;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IPickupCodeService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IPickupDetailService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IPickupRecordService;
import com.dtyunxi.yundt.cube.center.trade.dao.das.PickupDetailDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.PickupRecordDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.PickupDetailEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.PickupRecordEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
public class PickupRecordServiceImpl
implements IPickupRecordService {
    private static Logger logger = LoggerFactory.getLogger(PickupRecordServiceImpl.class);
    @Resource
    private PickupRecordDas pickupRecordDas;
    @Resource
    private PickupDetailDas pickupDetailDas;
    @Resource
    IPickupDetailService pickupDetailService;
    @Resource
    IPickupCodeService pickupCodeService;

    @Override
    public Long add(PickupRecordReqDto pickupRecordReqDto) {
        PickupRecordEo pickupRecordEo = new PickupRecordEo();
        DtoHelper.dto2Eo((BaseVo)pickupRecordReqDto, (BaseEo)pickupRecordEo);
        this.pickupRecordDas.insert((BaseEo)pickupRecordEo);
        this.pickupDetailService.addList(pickupRecordReqDto.getPickupDetails());
        return pickupRecordEo.getId();
    }

    @Override
    public PickupRecordEo getByTradeNo(String tradeNo) {
        PickupRecordEo pickupRecordEo = new PickupRecordEo();
        pickupRecordEo.setTradeNo(tradeNo);
        return (PickupRecordEo)this.pickupRecordDas.selectOne((BaseEo)pickupRecordEo);
    }

    @Override
    @Transactional
    public void usePickupCode(PickupCodeUseReqDto pickupCodeUseReqDto) {
        Long id = this.pickupCodeService.cancelAfterVerification(pickupCodeUseReqDto.getPickupRecordNo(), pickupCodeUseReqDto.getCode(), pickupCodeUseReqDto.getCheckPerson());
        pickupCodeUseReqDto.getPickupDetails().forEach(pickupDetailUseReqDto -> {
            PickupDetailEo pickupDetailEo = (PickupDetailEo)this.pickupDetailDas.selectByPrimaryKey(pickupDetailUseReqDto.getId());
            pickupDetailEo.setActualPickupNum(pickupDetailEo.getPickupNum());
            pickupDetailEo.setStatus(PickupEnum.PICK_RECORD_SUCCESS.getName());
            pickupDetailEo.setPickupCodeId(id);
            this.pickupDetailDas.update((BaseEo)pickupDetailEo);
        });
    }

    @Override
    public void modifyStatus(String tradeNo, String status) {
        PickupRecordEo pickupRecordEo = this.getByTradeNo(tradeNo);
        pickupRecordEo.setStatus(status);
        this.pickupRecordDas.update((BaseEo)pickupRecordEo);
    }

    @Override
    public void modify(PickupRecordModifyReqDto pickupRecordReqDto) {
        PickupRecordEo pickupRecordEo = new PickupRecordEo();
        DtoHelper.dto2Eo((BaseVo)pickupRecordReqDto, (BaseEo)pickupRecordEo);
        this.pickupRecordDas.updateSelective((BaseEo)pickupRecordEo);
    }

    @Override
    public List<PickupRecordRespDto> queryList(PickupRecordReqDto pickupRecordReqDto) {
        PickupRecordEo pickupRecordEo = new PickupRecordEo();
        DtoHelper.dto2Eo((BaseVo)pickupRecordReqDto, (BaseEo)pickupRecordEo);
        List resultList = this.pickupRecordDas.select((BaseEo)pickupRecordEo);
        ArrayList<PickupRecordRespDto> pickupRecordRespDtos = new ArrayList<PickupRecordRespDto>();
        if (CollectionUtils.isNotEmpty((Collection)resultList)) {
            DtoHelper.eoList2DtoList((Collection)resultList, pickupRecordRespDtos, PickupRecordRespDto.class);
        }
        return pickupRecordRespDtos;
    }

    @Override
    public PageInfo<PickupRecordRespDto> queryList(PickupRecordReqDto pickupRecordReqDto, Integer pageNum, Integer pageSize) {
        PickupRecordEo pickupRecordEo = new PickupRecordEo();
        DtoHelper.dto2Eo((BaseVo)pickupRecordReqDto, (BaseEo)pickupRecordEo);
        PageInfo pageInfo = this.pickupRecordDas.selectPage((BaseEo)pickupRecordEo, pageNum, pageSize);
        List resultList = pageInfo.getList();
        ArrayList pickupRecordRespDtos = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)resultList)) {
            DtoHelper.eoList2DtoList((Collection)resultList, pickupRecordRespDtos, PickupRecordRespDto.class);
        }
        PageInfo pageInfoDto = new PageInfo();
        BeanUtils.copyProperties((Object)pageInfo, (Object)pageInfoDto);
        pageInfoDto.setList(pickupRecordRespDtos);
        return pageInfoDto;
    }

    @Override
    public PickupRecordRespDto queryById(Long id) {
        PickupRecordEo pickupRecordEo = new PickupRecordEo();
        pickupRecordEo.setId(id);
        PickupRecordEo result = (PickupRecordEo)this.pickupRecordDas.selectOne((BaseEo)pickupRecordEo);
        PickupRecordRespDto pickupRecordRespDto = new PickupRecordRespDto();
        DtoHelper.eo2Dto((BaseEo)result, (BaseVo)pickupRecordRespDto);
        return pickupRecordRespDto;
    }

    @Override
    public List<PickupRecordRespDto> queryByDeliveryNo(String deliveryNo) {
        PickupRecordEo pickupRecordEo = PickupRecordEo.newInstance();
        pickupRecordEo.setDeliveryNo(deliveryNo);
        List pickupRecordEoList = this.pickupRecordDas.select((BaseEo)pickupRecordEo);
        if (CollectionUtils.isEmpty((Collection)pickupRecordEoList)) {
            return new ArrayList<PickupRecordRespDto>();
        }
        ArrayList<PickupRecordRespDto> pickupRecordRespDtoList = new ArrayList<PickupRecordRespDto>(pickupRecordEoList.size());
        DtoHelper.eoList2DtoList((Collection)pickupRecordEoList, pickupRecordRespDtoList, PickupRecordRespDto.class);
        return pickupRecordRespDtoList;
    }

    @Override
    public PickupRecordDetailRespDto queryDetailByPickupRecordNo(String pickupRecordNo) {
        if (StringUtils.isEmpty((Object)pickupRecordNo)) {
            throw new BizException("\u81ea\u63d0\u6d41\u6c34\u53f7\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        PickupRecordEo pickupRecordEo = new PickupRecordEo();
        pickupRecordEo.setPickupRecordNo(pickupRecordNo);
        PickupRecordEo result = (PickupRecordEo)this.pickupRecordDas.selectOne((BaseEo)pickupRecordEo);
        if (result == null) {
            throw new BizException("\u6ca1\u6709\u8be5\u81ea\u63d0\u6d41\u6c34\u53f7\u7684\u8bb0\u5f55");
        }
        PickupDetailEo pic = PickupDetailEo.newInstance();
        pic.setPickupRecordNo(pickupRecordNo);
        List picks = this.pickupDetailDas.select((BaseEo)pic);
        ArrayList details = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)picks, details, PickupDetailRespDto.class);
        PickupRecordDetailRespDto pickupRecordDetailRespDto = new PickupRecordDetailRespDto();
        DtoHelper.eo2Dto((BaseEo)result, (BaseVo)pickupRecordDetailRespDto);
        pickupRecordDetailRespDto.setPickupDetailRespDtoList(details);
        return pickupRecordDetailRespDto;
    }

    @Override
    public List<PickupRecordDetailRespDto> queryDetailByDeliveryNo(String deliveryNo) {
        if (StringUtils.isEmpty((Object)deliveryNo)) {
            throw new BizException("\u53d1\u8d27\u5355\u53f7\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        PickupRecordEo pickupRecordEo = new PickupRecordEo();
        pickupRecordEo.setDeliveryNo(deliveryNo);
        List result = this.pickupRecordDas.select((BaseEo)pickupRecordEo);
        if (result == null || result.isEmpty()) {
            throw new BizException("\u6ca1\u6709\u8be5\u53d1\u8d27\u5355\u53f7\u7684\u8bb0\u5f55");
        }
        ArrayList<PickupRecordDetailRespDto> pics = new ArrayList<PickupRecordDetailRespDto>();
        result.stream().forEach(eo -> pics.add(this.queryDetailByPickupRecordNo(eo.getPickupRecordNo())));
        return pics;
    }
}

