/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.trade.api.constants.DefaultValue;
import com.dtyunxi.yundt.cube.center.trade.api.constants.OrderStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.OrderTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.ProblemOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderQueryReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.TradeItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IChannelService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IProblemOrderService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IProblemTradeItemService;
import com.dtyunxi.yundt.cube.center.trade.dao.das.ProblemOrderDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.ChannelEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.ProblemOrderEo;
import com.dtyunxi.yundt.cube.center.trade.ext.api.dto.response.OrderBizRespDto;
import com.dtyunxi.yundt.cube.center.trade.ext.api.enums.OrderQueryEnum;
import com.dtyunxi.yundt.cube.connector.comm.dto.request.TradeReqDto;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
@Transactional(rollbackFor={Exception.class})
public class ProblemOrderServiceImpl
implements IProblemOrderService {
    private static Logger logger = LoggerFactory.getLogger(ProblemOrderServiceImpl.class);
    @Autowired
    private IProblemOrderService problemOrderService;
    @Resource
    private IProblemTradeItemService tradeItemService;
    @Resource
    private ProblemOrderDas problemOrderDas;
    @Resource
    private IChannelService channelService;
    @Resource
    private IOrderService orderService;

    @Override
    public PageInfo<OrderBizRespDto> queryByPageForBizResp(OrderQueryReqDto orderQueryReq, Integer pageNum, Integer pageSize) {
        PageInfo<OrderRespDto> orderRespDtoPageInfo = this.queryByPageForResp(orderQueryReq, pageNum, pageSize);
        if (orderRespDtoPageInfo == null) {
            return null;
        }
        if (orderRespDtoPageInfo.getList() == null) {
            PageInfo pageInfo = new PageInfo();
            BeanUtils.copyProperties(orderRespDtoPageInfo, (Object)pageInfo);
            return pageInfo;
        }
        ArrayList bizRespDtos = new ArrayList();
        CubeBeanUtils.copyCollection(bizRespDtos, (Collection)orderRespDtoPageInfo.getList(), OrderBizRespDto.class);
        PageInfo pageInfo = new PageInfo();
        BeanUtils.copyProperties(orderRespDtoPageInfo, (Object)pageInfo);
        pageInfo.setList(bizRespDtos);
        return pageInfo;
    }

    private PageInfo<OrderRespDto> queryByPageForResp(OrderQueryReqDto orderQueryReq, Integer pageNum, Integer pageSize) {
        if (null == orderQueryReq.getOrderType()) {
            orderQueryReq.setIsSplit(DefaultValue.NO);
        } else if (OrderTypeEnum.CHILDREN_ORDER.getType().equals(orderQueryReq.getOrderType()) || OrderTypeEnum.PARENT_ORDER.getType().equals(orderQueryReq.getOrderType())) {
            orderQueryReq.setIsSplit(orderQueryReq.getOrderType());
        }
        List<Object> orderRepDtoList = Lists.newArrayList();
        PageInfo<ProblemOrderEo> pageInfo = this.queryByPage(orderQueryReq, pageNum, pageSize);
        PageInfo page = new PageInfo();
        CubeBeanUtils.copyProperties((Object)page, pageInfo, (String[])new String[]{"list", "navigatepageNums"});
        if (!CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
            orderRepDtoList = this.getOrderRespDto(pageInfo.getList(), orderQueryReq.getIsContainItem(), orderQueryReq.getIfExport());
        }
        page.setList((List)orderRepDtoList);
        return page;
    }

    private PageInfo<ProblemOrderEo> queryByPage(OrderQueryReqDto orderQueryReq, Integer pageNum, Integer pageSize) {
        ProblemOrderEo orderEo = ProblemOrderEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)orderQueryReq, (BaseEo)orderEo);
        orderEo.setInstanceId(orderQueryReq.getInstanceId());
        orderEo.setTenantId(orderQueryReq.getTenantId());
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        if (!CollectionUtils.isEmpty((Collection)orderQueryReq.getSqlFilterList())) {
            sqlFilters.addAll(orderQueryReq.getSqlFilterList());
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (orderQueryReq.getDataType() == null || orderQueryReq.getDataType().equals(1)) {
            if (orderQueryReq.getStartTime() != null) {
                sqlFilters.add(SqlFilter.ge((String)"create_time", (Object)format.format(orderQueryReq.getStartTime())));
            }
            if (orderQueryReq.getEndTime() != null) {
                sqlFilters.add(SqlFilter.le((String)"create_time", (Object)format.format(orderQueryReq.getEndTime())));
            }
        } else if (orderQueryReq.getDataType() == 2) {
            if (orderQueryReq.getStartTime() != null) {
                sqlFilters.add(SqlFilter.ge((String)"update_time", (Object)format.format(orderQueryReq.getStartTime())));
            }
            if (orderQueryReq.getEndTime() != null) {
                sqlFilters.add(SqlFilter.le((String)"update_time", (Object)format.format(orderQueryReq.getEndTime())));
            }
        } else if (orderQueryReq.getDataType() == 3) {
            if (orderQueryReq.getStartTime() != null) {
                sqlFilters.add(SqlFilter.ge((String)"delivery_time", (Object)format.format(orderQueryReq.getStartTime())));
            }
            if (orderQueryReq.getEndTime() != null) {
                sqlFilters.add(SqlFilter.le((String)"delivery_time", (Object)format.format(orderQueryReq.getEndTime())));
            }
        } else if (orderQueryReq.getDataType() == 4) {
            if (orderQueryReq.getStartTime() != null) {
                sqlFilters.add(SqlFilter.ge((String)"receive_time", (Object)format.format(orderQueryReq.getStartTime())));
            }
            if (orderQueryReq.getEndTime() != null) {
                sqlFilters.add(SqlFilter.le((String)"receive_time", (Object)format.format(orderQueryReq.getEndTime())));
            }
        }
        if (orderQueryReq.getPayStartTime() != null && orderQueryReq.getPayEndTime() != null) {
            sqlFilters.add(SqlFilter.le((String)"change_time", (Object)format.format(orderQueryReq.getPayEndTime())));
            sqlFilters.add(SqlFilter.gt((String)"change_time", (Object)format.format(orderQueryReq.getPayStartTime())));
        }
        if (!CollectionUtils.isEmpty((Collection)orderQueryReq.getReferrerIds())) {
            sqlFilters.add(SqlFilter.in((String)"referrer_id", (Object)orderQueryReq.getReferrerIds()));
        }
        if (!CollectionUtils.isEmpty((Collection)orderQueryReq.getTradeNos())) {
            sqlFilters.add(SqlFilter.in((String)"trade_no", (Object)orderQueryReq.getTradeNos()));
        }
        if (orderQueryReq.getDeliveryAddress() != null) {
            if (!StringUtils.isEmpty((Object)orderQueryReq.getDeliveryAddress().getDeliveryName())) {
                sqlFilters.add(SqlFilter.like((String)"delivery_address", (Object)("%" + orderQueryReq.getDeliveryAddress().getDeliveryName() + "%")));
            }
            if (!StringUtils.isEmpty((Object)orderQueryReq.getDeliveryAddress().getDeliveryMobile())) {
                sqlFilters.add(SqlFilter.like((String)"delivery_address", (Object)("%" + orderQueryReq.getDeliveryAddress().getDeliveryMobile() + "%")));
            }
        }
        if (!StringUtils.isEmpty((Object)orderQueryReq.getOrderNo())) {
            sqlFilters.add(SqlFilter.like((String)"order_no", (Object)("%" + orderQueryReq.getOrderNo() + "%")));
            orderEo.setOrderNo(null);
        }
        if (!StringUtils.isEmpty((Object)orderQueryReq.getThirdOrderNo())) {
            sqlFilters.add(SqlFilter.like((String)"third_order_no", (Object)("%" + orderQueryReq.getThirdOrderNo() + "%")));
            orderEo.setThirdOrderNo(null);
        }
        if (!StringUtils.isEmpty((Object)orderQueryReq.getThirdParentOrderNo())) {
            sqlFilters.add(SqlFilter.like((String)"third_parent_order_no", (Object)("%" + orderQueryReq.getThirdParentOrderNo() + "%")));
            orderEo.setThirdParentOrderNo(null);
        }
        if (!StringUtils.isEmpty((Object)orderQueryReq.getSaleChannelOrderNo())) {
            sqlFilters.add(SqlFilter.like((String)"sale_channel_order_no", (Object)("%" + orderQueryReq.getSaleChannelOrderNo() + "%")));
            orderEo.setSaleChannelOrderNo(null);
        }
        if (orderQueryReq.getPlaceStartTime() != null && orderQueryReq.getPlaceEndTime() != null) {
            sqlFilters.add(SqlFilter.le((String)"place_time", (Object)format.format(orderQueryReq.getPlaceEndTime())));
            sqlFilters.add(SqlFilter.gt((String)"place_time", (Object)format.format(orderQueryReq.getPlaceStartTime())));
        }
        if (!StringUtils.isEmpty((Object)orderQueryReq.getOrderTradeStatus())) {
            String[] statusArray = orderQueryReq.getOrderTradeStatus().split(",");
            sqlFilters.add(SqlFilter.in((String)"order_trade_status", Arrays.asList(statusArray)));
            orderEo.setOrderTradeStatus(null);
        }
        orderEo.setEndTime(null);
        if (orderQueryReq.getOrderTradeStatus() == null) {
            sqlFilters.add(SqlFilter.ne((String)"order_trade_status", (Object)OrderStatusEnum.INIT.getCode()));
        }
        orderEo.setSqlFilters(sqlFilters);
        orderEo.setOrderByDesc("id, user_id");
        if (!StringUtils.isEmpty((Object)orderQueryReq.getTradeNo())) {
            orderEo.setOrderNo(orderQueryReq.getTradeNo());
            orderEo.setEndTime(null);
            List resultList = this.problemOrderDas.select((BaseEo)orderEo);
            PageInfo pageInfo = new PageInfo(resultList);
            if (CollectionUtils.isEmpty((Collection)resultList)) {
                pageInfo.setTotal(0L);
            } else {
                pageInfo.setTotal(1L);
            }
            pageInfo.setPageNum(pageNum.intValue());
            pageInfo.setPageSize(pageSize.intValue());
            pageInfo.setIsFirstPage(true);
            pageInfo.setIsLastPage(true);
            return pageInfo;
        }
        return this.problemOrderDas.selectPage((BaseEo)orderEo, pageNum, pageSize, Boolean.valueOf(false));
    }

    private List<OrderRespDto> getOrderRespDto(List<ProblemOrderEo> orderEoList, Integer isContainItem, Boolean ifExport) {
        if (isContainItem == null) {
            isContainItem = DefaultValue.YES;
        }
        ArrayList<OrderRespDto> orderRepDtoList = new ArrayList<OrderRespDto>();
        DtoHelper.eoList2DtoList(orderEoList, orderRepDtoList, OrderRespDto.class);
        orderRepDtoList.forEach(orderRespDto -> {
            ChannelEo channelEo = this.channelService.queryByCode(orderRespDto.getSaleChannel());
            if (channelEo != null) {
                orderRespDto.setSaleChannel(channelEo.getName());
            }
        });
        if (Boolean.TRUE.equals(ifExport)) {
            return this.batchFillItem(orderRepDtoList);
        }
        if (DefaultValue.YES.equals(isContainItem)) {
            orderRepDtoList.forEach(orderRespDto -> orderRespDto.setOrderItems(this.tradeItemService.queryDtoByTradeNo(orderRespDto.getOrderNo())));
        }
        return orderRepDtoList;
    }

    private List<OrderRespDto> batchFillItem(List<OrderRespDto> orderRepDtoList) {
        Set<String> orderNos = orderRepDtoList.stream().map(OrderRespDto::getOrderNo).collect(Collectors.toSet());
        List<TradeItemRespDto> tradeItemRespDtos = this.tradeItemService.queryByOrderNos(orderNos);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(tradeItemRespDtos)) {
            Map<String, List<TradeItemRespDto>> orderItemsMap = tradeItemRespDtos.stream().collect(Collectors.groupingBy(TradeItemRespDto::getTradeNo));
            orderRepDtoList.forEach(orderRespDto -> orderRespDto.setOrderItems((List)orderItemsMap.get(orderRespDto.getOrderNo())));
        }
        return orderRepDtoList;
    }

    @Override
    public OrderDetailRespDto getDetail(String orderNo, String attrs) {
        ProblemOrderEo orderEo = this.getByOrderNo(orderNo);
        if (null == orderEo) {
            return null;
        }
        OrderDetailRespDto orderDetailRespDto = new OrderDetailRespDto();
        DtoHelper.eo2Dto((BaseEo)orderEo, (BaseVo)orderDetailRespDto);
        orderDetailRespDto.setDeliveryInfo(orderEo.getDeliveryInfo());
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)attrs)) {
            return orderDetailRespDto;
        }
        String[] attrArr = org.apache.commons.lang3.StringUtils.split((String)attrs, (String)",");
        ArrayList orderQueryEnums = Lists.newArrayList();
        for (String attr : attrArr) {
            OrderQueryEnum queryEnum = OrderQueryEnum.getOrderQueryEnum((String)attr);
            if (null == queryEnum) continue;
            orderQueryEnums.add(queryEnum);
            if (!OrderQueryEnum.ALL.equals((Object)queryEnum)) continue;
            orderQueryEnums = Lists.newArrayList((Object[])OrderQueryEnum.values());
            break;
        }
        for (OrderQueryEnum queryEnum : orderQueryEnums) {
            switch (queryEnum) {
                case PAY_RECORD: {
                    break;
                }
                case ADDRESS: {
                    break;
                }
                case INVOICE: {
                    break;
                }
                case ITEM: {
                    List<TradeItemRespDto> tradeItemRepDtos = this.tradeItemService.queryDtoByTradeNo(orderEo.getOrderNo());
                    orderDetailRespDto.setOrderItems(tradeItemRepDtos);
                    break;
                }
                case CHANNEL: {
                    ChannelEo channelEo = this.channelService.queryByCode(orderEo.getSaleChannel());
                    orderDetailRespDto.setSaleChannel(channelEo != null ? channelEo.getName() : orderEo.getSaleChannel());
                    break;
                }
                case DELIVERY: {
                    break;
                }
                case ACTIVITY: {
                    break;
                }
            }
        }
        return orderDetailRespDto;
    }

    @Override
    public String retry(String tradeNo) {
        List<OrderEo> orderEos;
        ProblemOrderEo problemOrderEo = this.getByOrderNo(tradeNo);
        if (problemOrderEo == null || ProblemOrderStatusEnum.COMPLETE.getCode().equals(problemOrderEo.getOrderStatus())) {
            return "\u5f02\u5e38\u5355\u5df2\u5b8c\u6210\uff0c\u65e0\u9700\u5904\u7406";
        }
        String datagramInfo = problemOrderEo.getDatagramInfo();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)datagramInfo)) {
            return "\u5f02\u5e38\u5355\u539f\u62a5\u6587\u6570\u636e\u4e3a\u7a7a";
        }
        TradeReqDto tradeReqDto = (TradeReqDto)JSONObject.parseObject((String)datagramInfo, TradeReqDto.class);
        List<TradeReqDto> tradeReqDtos = Arrays.asList(tradeReqDto);
        try {
            orderEos = this.orderService.addSynOrder(tradeReqDtos);
        }
        catch (Exception e) {
            logger.error("\u5f02\u5e38\u5355\u91cd\u8bd5\u5931\u8d25", (Throwable)e);
            return "\u5f02\u5e38\u5355\u91cd\u8bd5\u5931\u8d25";
        }
        List errorMsg = orderEos.stream().filter(orderEo -> {
            Map extFields = orderEo.getExtFields();
            return MapUtils.isNotEmpty((Map)extFields) && extFields.get("errorMsg") != null;
        }).map(orderEo -> orderEo.getExtFields().get("errorMsg")).collect(Collectors.toList());
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(errorMsg)) {
            return JSONObject.toJSONString(errorMsg);
        }
        problemOrderEo.setOrderStatus(ProblemOrderStatusEnum.COMPLETE.getCode());
        this.problemOrderDas.update((BaseEo)problemOrderEo);
        return "success";
    }

    public ProblemOrderEo getByOrderNo(String tradeNo) {
        ProblemOrderEo orderEo = new ProblemOrderEo();
        orderEo.setOrderNo(tradeNo);
        return (ProblemOrderEo)this.problemOrderDas.selectOne((BaseEo)orderEo);
    }
}

