/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IDirectoryQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.TradeItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IProblemTradeItemService;
import com.dtyunxi.yundt.cube.center.trade.dao.das.ProblemTradeItemDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.ProblemTradeItemEo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ProblemTradeItemServiceImpl
implements IProblemTradeItemService {
    private static Logger logger = LoggerFactory.getLogger(ProblemTradeItemServiceImpl.class);
    @Resource
    private ProblemTradeItemDas problemTradeItemDas;
    @Resource
    private ICacheService cacheService;
    @Resource
    private IDirectoryQueryApi directoryQueryApi;

    @Override
    public List<TradeItemRespDto> queryDtoByTradeNo(String tradeNo) {
        ArrayList list = null;
        List<ProblemTradeItemEo> tradeItemEos = this.queryByTradeNo(tradeNo);
        if (!CollectionUtils.isEmpty(tradeItemEos)) {
            list = this.getEosToResp(tradeItemEos);
        }
        return !CollectionUtils.isEmpty(list) ? list : Lists.newArrayList();
    }

    @Override
    public List<TradeItemRespDto> queryByOrderNos(Set<String> orderNos) {
        ProblemTradeItemEo tradeItemEo = new ProblemTradeItemEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"trade_no", (Object)StringUtils.join(orderNos, (String)",")));
        tradeItemEo.setSqlFilters(sqlFilters);
        List itemEos = this.problemTradeItemDas.select((BaseEo)tradeItemEo);
        if (!CollectionUtils.isEmpty((Collection)itemEos)) {
            return this.getEosToResp(itemEos);
        }
        return null;
    }

    private List<TradeItemRespDto> getEosToResp(List<ProblemTradeItemEo> tradeItemEos) {
        return tradeItemEos.stream().map(eo -> {
            TradeItemRespDto dto = new TradeItemRespDto();
            DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)dto, (String[])new String[]{"cycleValue"});
            if (StringUtils.isNotBlank((CharSequence)eo.getCycleValue())) {
                Integer[] cycleValue = (Integer[])Stream.of(StringUtils.split((String)eo.getCycleValue(), (String)",")).map(Integer::valueOf).toArray(Integer[]::new);
                dto.setCycleValue(cycleValue);
            }
            if (StringUtils.isNotEmpty((CharSequence)eo.getRemark())) {
                dto.setRemark(eo.getRemark());
            }
            int completeDeliveryNum = dto.getCompleteDeliveryNum() != null ? dto.getCompleteDeliveryNum() : 0;
            dto.setCompleteDeliveryNum(Integer.valueOf(completeDeliveryNum));
            if (dto.getItemNum() != null) {
                dto.setIncompleteDeliveryNum(Integer.valueOf(dto.getItemNum() - completeDeliveryNum));
            }
            return dto;
        }).collect(Collectors.toList());
    }

    private List<ProblemTradeItemEo> queryByTradeNo(String tradeNo) {
        ProblemTradeItemEo tradeItemEo = new ProblemTradeItemEo();
        tradeItemEo.setTradeNo(tradeNo);
        tradeItemEo.setOrderBy("gift");
        return this.problemTradeItemDas.select((BaseEo)tradeItemEo);
    }
}

