/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopBaseDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.constants.ActivityConstant;
import com.dtyunxi.yundt.cube.center.trade.api.constants.FullGiftPromotionSettingConditionsEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.FullGiftPromotionSettingConditionsUnitEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.OtherMutexEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.SimilarMutexEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.activity.OrderActivityAddReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.activity.OrderActivityReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.TradeItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.activity.OrderActivityRespDto;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.utils.TradeUtil;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderActivityService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IPromotionCalculationService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.ITradeItemService;
import com.dtyunxi.yundt.cube.center.trade.dao.das.FullGiftPromotionSettingDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.FullGiftPromotionSettingEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.StdFullGiftPromotionSettingEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.TradeItemEo;
import com.dtyunxi.yundt.cube.center.trade.dao.mapper.FullGiftMapper;
import com.dtyunxi.yundt.cube.center.trade.dao.vo.FullGiftAndItemRangeVo;
import com.dtyunxi.yundt.cube.center.trade.dao.vo.FullGiftSaveVo;
import com.dtyunxi.yundt.cube.center.trade.ext.api.dto.response.OrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.OrderCreateBo;
import io.jsonwebtoken.lang.Collections;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class PromotionCalculationServiceImpl
implements IPromotionCalculationService {
    @Resource
    private IOrderService orderService;
    @Resource
    private ITradeItemService tradeItemService;
    @Resource
    private IOrderActivityService orderActivityService;
    @Resource
    private IShopQueryApi iShopQueryApi;
    @Resource
    private FullGiftMapper fullGiftMapper;
    @Resource
    private FullGiftPromotionSettingDas fullGiftPromotionSettingDas;

    private List<FullGiftAndItemRangeVo> filterMutualExclusionWithOtherActivity(String tradeNo, List<FullGiftAndItemRangeVo> fullGiftAndItemRangeVos) {
        OrderActivityReqDto orderActivityReqDtoSelect = new OrderActivityReqDto();
        orderActivityReqDtoSelect.setOrderNo(tradeNo);
        List<OrderActivityRespDto> orderActivityRespDtos = this.orderActivityService.queryList(orderActivityReqDtoSelect);
        if (CollectionUtils.isEmpty(orderActivityRespDtos)) {
            return fullGiftAndItemRangeVos;
        }
        List<FullGiftAndItemRangeVo> fullGiftAndItemRangeVosReturn = fullGiftAndItemRangeVos.stream().filter(fullGiftAndItemRangeVo -> OtherMutexEnum.OFF.getCode() == fullGiftAndItemRangeVo.getIfOtherMutex()).collect(Collectors.toList());
        return fullGiftAndItemRangeVosReturn;
    }

    private List<FullGiftAndItemRangeVo> queryFullGiftActivityMatched(String tradeNo, List<TradeItemRespDto> tradeItemRespDtos) {
        TradeItemRespDto tradeItemRespDto = tradeItemRespDtos.get(0);
        String shopId = tradeItemRespDto.getShopId();
        RestResponse shopBaseDtoRestResponse = this.iShopQueryApi.queryBaseById(Long.valueOf(Long.parseLong(shopId)));
        String shopCode = Optional.ofNullable(shopBaseDtoRestResponse).map(d -> (ShopBaseDto)d.getData()).map(s -> s.getCode()).get();
        List skuCodes = tradeItemRespDtos.stream().map(TradeItemRespDto::getSkuCode).collect(Collectors.toList());
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopCode", shopCode);
        params.put("skuCodes", skuCodes);
        List fullGiftAndItemRangeVosSelect = this.fullGiftMapper.selectWithLeftJoinItemRangeByParam(params);
        List<Object> fullGiftAndItemRangeVos = new ArrayList<FullGiftAndItemRangeVo>();
        if (!Collections.isEmpty((Collection)fullGiftAndItemRangeVosSelect)) {
            if (fullGiftAndItemRangeVosSelect.size() == 1) {
                fullGiftAndItemRangeVos = fullGiftAndItemRangeVosSelect;
            } else if (fullGiftAndItemRangeVosSelect.size() > 1) {
                Map<Integer, List<FullGiftAndItemRangeVo>> mutexMap = fullGiftAndItemRangeVosSelect.stream().collect(Collectors.groupingBy(FullGiftAndItemRangeVo::getIfSimilarMutex));
                List<FullGiftAndItemRangeVo> similarMutexOff = mutexMap.get(SimilarMutexEnum.OFF.getCode());
                if (CollectionUtils.isNotEmpty(similarMutexOff)) {
                    fullGiftAndItemRangeVos = similarMutexOff;
                } else {
                    List<FullGiftAndItemRangeVo> similarMutexOn = mutexMap.get(SimilarMutexEnum.ON.getCode());
                    if (CollectionUtils.isNotEmpty(similarMutexOn)) {
                        List sortByLevel = similarMutexOn.stream().sorted(Comparator.comparing(FullGiftAndItemRangeVo::getActivityLevel, Comparator.reverseOrder())).collect(Collectors.toList());
                        fullGiftAndItemRangeVos = new ArrayList();
                        fullGiftAndItemRangeVos.add(sortByLevel.get(0));
                    }
                }
            }
        }
        return fullGiftAndItemRangeVos;
    }

    private Map<Long, List<FullGiftSaveVo>> calculateFullGift(List<FullGiftAndItemRangeVo> fullGiftAndItemRangeVos, List<TradeItemRespDto> tradeItemRespDtos) {
        HashMap<Long, List<FullGiftSaveVo>> map = new HashMap<Long, List<FullGiftSaveVo>>();
        for (FullGiftAndItemRangeVo fullGiftAndItemRangeVo : fullGiftAndItemRangeVos) {
            List<FullGiftPromotionSettingEo> fullGiftPromotionSettingEosFull;
            ArrayList<FullGiftSaveVo> fullGiftSaveVos = new ArrayList<FullGiftSaveVo>();
            Long fullGiftId = fullGiftAndItemRangeVo.getId();
            FullGiftPromotionSettingEo fullGiftPromotionSettingEoSelect = new FullGiftPromotionSettingEo();
            fullGiftPromotionSettingEoSelect.setFullGiftId(fullGiftId);
            List fullGiftPromotionSettingEos = this.fullGiftPromotionSettingDas.select((BaseEo)fullGiftPromotionSettingEoSelect);
            Map<Integer, List<FullGiftPromotionSettingEo>> conditions = fullGiftPromotionSettingEos.stream().collect(Collectors.groupingBy(StdFullGiftPromotionSettingEo::getConditions));
            List<FullGiftPromotionSettingEo> fullGiftPromotionSettingEosEachFull = conditions.get(FullGiftPromotionSettingConditionsEnum.EACH_FULL);
            if (CollectionUtils.isNotEmpty(fullGiftPromotionSettingEosEachFull)) {
                FullGiftPromotionSettingEo fullGiftPromotionSettingEo = fullGiftPromotionSettingEosEachFull.get(0);
                this.addFullGiftSaveVo(tradeItemRespDtos, fullGiftSaveVos, fullGiftPromotionSettingEo, fullGiftAndItemRangeVo.getRetailPrice(), FullGiftPromotionSettingConditionsEnum.EACH_FULL.getCode());
            }
            if (CollectionUtils.isNotEmpty(fullGiftPromotionSettingEosFull = conditions.get(FullGiftPromotionSettingConditionsEnum.FULL))) {
                List sortByNum = fullGiftPromotionSettingEosFull.stream().sorted(Comparator.comparing(StdFullGiftPromotionSettingEo::getNum, Comparator.reverseOrder())).collect(Collectors.toList());
                FullGiftPromotionSettingEo fullGiftPromotionSettingEo = (FullGiftPromotionSettingEo)sortByNum.get(0);
                this.addFullGiftSaveVo(tradeItemRespDtos, fullGiftSaveVos, fullGiftPromotionSettingEo, fullGiftAndItemRangeVo.getRetailPrice(), FullGiftPromotionSettingConditionsEnum.FULL.getCode());
            }
            map.put(fullGiftId, fullGiftSaveVos);
        }
        return map;
    }

    private void addFullGiftSaveVo(List<TradeItemRespDto> tradeItemRespDtos, List<FullGiftSaveVo> fullGiftSaveVos, FullGiftPromotionSettingEo fullGiftPromotionSettingEo, BigDecimal retailPrice, Integer fullGiftPromotionSettingConditionsCode) {
        Integer conditionsUnit = fullGiftPromotionSettingEo.getConditionsUnit();
        for (TradeItemRespDto tradeItemRespDto : tradeItemRespDtos) {
            Number resultNum;
            Integer giftNum = fullGiftPromotionSettingEo.getGiftNum();
            int giftNumAll = 0;
            if (FullGiftPromotionSettingConditionsUnitEnum.PIECE.getCode() == conditionsUnit) {
                resultNum = tradeItemRespDto.getItemNum() / conditionsUnit;
                if ((Integer)resultNum > 0) {
                    if (FullGiftPromotionSettingConditionsEnum.EACH_FULL.getCode() == fullGiftPromotionSettingConditionsCode) {
                        giftNumAll = giftNum * (Integer)resultNum;
                    } else if (FullGiftPromotionSettingConditionsEnum.FULL.getCode() == fullGiftPromotionSettingConditionsCode) {
                        giftNumAll = giftNum * 1;
                    }
                }
            } else if (FullGiftPromotionSettingConditionsUnitEnum.YUAN.getCode() == conditionsUnit && ((BigDecimal)(resultNum = tradeItemRespDto.getItemOrigPrice().divide(new BigDecimal(conditionsUnit), 0, 1))).compareTo(new BigDecimal(0)) > 0) {
                if (FullGiftPromotionSettingConditionsEnum.EACH_FULL.getCode() == fullGiftPromotionSettingConditionsCode) {
                    giftNumAll = giftNum * ((BigDecimal)resultNum).intValue();
                } else if (FullGiftPromotionSettingConditionsEnum.FULL.getCode() == fullGiftPromotionSettingConditionsCode) {
                    giftNumAll = giftNum * 1;
                }
            }
            fullGiftSaveVos.add(new FullGiftSaveVo(fullGiftPromotionSettingEo.getSkuCode(), fullGiftPromotionSettingEo.getGiftName(), Integer.valueOf(giftNumAll), retailPrice));
        }
    }

    private void saveFullGiftActivity(String tradeNo, OrderReqDto orderReqDto, Map<Long, List<FullGiftSaveVo>> fullGiftMap) {
        ArrayList<TradeItemEo> tradeItemEos = new ArrayList<TradeItemEo>();
        fullGiftMap.entrySet().stream().forEach(entry -> {
            Long fullGiftId = (Long)entry.getKey();
            List fullGiftSaveVos = (List)entry.getValue();
            fullGiftSaveVos.forEach(fullGiftSaveVo -> {
                TradeItemEo tradeItemEo = new TradeItemEo();
                tradeItemEo.setTradeItemNo(TradeUtil.generateTradeNo(tradeNo));
                tradeItemEo.setTradeNo(tradeNo);
                tradeItemEo.setItemOrigPrice(fullGiftSaveVo.getRetailPrice());
                tradeItemEo.setItemName(fullGiftSaveVo.getGiftName());
                tradeItemEo.setItemNum(fullGiftSaveVo.getGiftNum());
                tradeItemEo.setSkuCode(fullGiftSaveVo.getSkuCode());
                tradeItemEo.setItemPrice(BigDecimal.ZERO);
                tradeItemEo.setPayTotalAmount(BigDecimal.ZERO);
                tradeItemEo.setDiscountTotalAmount(tradeItemEo.getItemOrigPrice().multiply(new BigDecimal(tradeItemEo.getItemNum())));
                tradeItemEo.setActivityDiscountAmount(tradeItemEo.getDiscountTotalAmount());
                tradeItemEos.add(tradeItemEo);
            });
            OrderActivityAddReqDto activityAddReqDto = new OrderActivityAddReqDto();
            activityAddReqDto.setTradeNo(orderReqDto.getTradeNo());
            activityAddReqDto.setOrderNo(orderReqDto.getTradeNo());
            activityAddReqDto.setUserId(orderReqDto.getUserId());
            activityAddReqDto.setUserSrc(orderReqDto.getUserSrc());
            activityAddReqDto.setStatus(Integer.valueOf(0));
            activityAddReqDto.setParentType(ActivityConstant.FULL_GIFT_ACTIVITY);
            activityAddReqDto.setType(ActivityConstant.FULL_GIFT_ACTIVITY);
            activityAddReqDto.setParentActivityId("0L");
            activityAddReqDto.setActivityId(String.valueOf(fullGiftId));
            this.orderActivityService.add(activityAddReqDto);
        });
        this.tradeItemService.addItems(tradeItemEos);
    }

    @Override
    public void handleFullGiftActivity(OrderCreateBo orderBo) {
        OrderEo orderEo = this.orderService.queryByOrderNo(orderBo.getOrderEo().getOrderNo());
        OrderRespDto orderRespDto = new OrderRespDto();
        DtoHelper.eo2Dto((BaseEo)orderEo, (BaseVo)orderRespDto);
        String tradeNo = orderRespDto.getTradeNo();
        List<TradeItemRespDto> tradeItemRespDtos = this.tradeItemService.queryDtoByTradeNo(tradeNo);
        List<FullGiftAndItemRangeVo> fullGiftAndItemRangeVos1 = this.queryFullGiftActivityMatched(tradeNo, tradeItemRespDtos);
        if (CollectionUtils.isEmpty(fullGiftAndItemRangeVos1)) {
            return;
        }
        List<FullGiftAndItemRangeVo> fullGiftAndItemRangeVos2 = this.filterMutualExclusionWithOtherActivity(tradeNo, fullGiftAndItemRangeVos1);
        if (CollectionUtils.isEmpty(fullGiftAndItemRangeVos2)) {
            return;
        }
        Map<Long, List<FullGiftSaveVo>> fullGiftMap = this.calculateFullGift(fullGiftAndItemRangeVos2, tradeItemRespDtos);
        this.saveFullGiftActivity(tradeNo, orderBo.getOrderReqDto(), fullGiftMap);
    }
}

