/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.channel.IChannelConfig;
import com.dtyunxi.cube.commons.channel.shipping.impl.AbstractShippingChannelImpl;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.yundt.cube.center.trade.api.constants.SfChannelPayMethodEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.SfChannelProductTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.sf.CancelOrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.sf.CreateOrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.sf.SfBaseReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.sf.SfCreateOrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.sf.CancelOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.sf.CreateOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.sf.SfBaseRespDto;
import com.dtyunxi.yundt.cube.center.trade.biz.config.SfChannelConfig;
import com.dtyunxi.yundt.cube.center.trade.biz.service.ISfShippingChannelService;
import com.dtyunxi.yundt.cube.center.trade.biz.util.SfSignUtil;
import com.google.common.collect.Lists;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class SfShippingChannelServiceImpl
extends AbstractShippingChannelImpl
implements ISfShippingChannelService {
    @Resource
    private SfChannelConfig sfChannelConfig;
    @Resource
    private RestTemplate restTemplate;
    @Resource
    private ICacheService commonCacheService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public SfShippingChannelServiceImpl(SfChannelConfig sfChannelConfig) {
        this.sfChannelConfig = sfChannelConfig;
        this.config(sfChannelConfig);
    }

    public String name() {
        return this.getClass().getSimpleName();
    }

    public void config(IChannelConfig config) {
        this.sfChannelConfig = (SfChannelConfig)config;
    }

    @Override
    public String createOrder(SfCreateOrderReqDto sfCreateOrderReqDto) throws Exception {
        CreateOrderReqDto createOrderReqDto = new CreateOrderReqDto();
        BeanUtils.copyProperties((Object)sfCreateOrderReqDto, (Object)createOrderReqDto);
        if (StringUtils.isBlank((CharSequence)sfCreateOrderReqDto.getPayMethod())) {
            createOrderReqDto.setPayMethod(SfChannelPayMethodEnum.OTHER.getCode());
        }
        if (StringUtils.isBlank((CharSequence)createOrderReqDto.getExpressType())) {
            createOrderReqDto.setExpressType(SfChannelProductTypeEnum.SFTH.getCode());
        }
        ArrayList cargo = Lists.newArrayList();
        ArrayList addedService = Lists.newArrayList();
        ArrayList extra = Lists.newArrayList();
        createOrderReqDto.setCargo((List)cargo);
        createOrderReqDto.setAddedService((List)addedService);
        createOrderReqDto.setExtra((List)extra);
        String url = this.sfChannelConfig.getUrl() + "/api/open/createOrder";
        this.logger.info("\u987a\u4e30\u4e0b\u5355\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)createOrderReqDto));
        SfBaseRespDto<CreateOrderRespDto.CreateOrderDataRespDto> respDto = this.doSfOrder(createOrderReqDto, url, new ParameterizedTypeReference<SfBaseRespDto<CreateOrderRespDto.CreateOrderDataRespDto>>(){});
        if (!"0".equals(respDto.getErrorCode())) {
            throw new BizException(respDto.getErrorCode(), respDto.getMessage());
        }
        CreateOrderRespDto.CreateOrderDataRespDto data = (CreateOrderRespDto.CreateOrderDataRespDto)respDto.getData();
        if (respDto.getHttpStatus().equals(HttpStatus.OK.value()) && "0".equals(respDto.getErrorCode())) {
            if ("1".equals(data.getFilterResult()) || "2".equals(data.getFilterResult())) {
                String expressCode = data.getMailNumber();
                if (CollectionUtils.isEmpty((Collection)data.getRlsInfo()) || data.getRlsInfo().size() == 0) {
                    this.logger.warn("\u987a\u4e30\u8fd0\u5355\u53f7\u65e0\u8be6\u60c5\u4fe1\u606f\uff0cexpressCode\uff1a{}", (Object)expressCode);
                }
                sfCreateOrderReqDto.setExpressCode(expressCode);
                this.commonCacheService.setCache("DELIVERY_SF_CACHE_" + sfCreateOrderReqDto.getDeliveryNo(), (Object)sfCreateOrderReqDto, 172800);
                this.logger.info("\u987a\u4e30\u4e0b\u5355\u6210\u529f\uff0cdeliveryNo:{}, expressCode:{}", (Object)sfCreateOrderReqDto.getDeliveryNo(), (Object)expressCode);
                return expressCode;
            }
            this.logger.error("\u987a\u4e30\u4e0b\u5355\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)data.getRemark());
            throw new BizException("\u987a\u4e30\u4e0b\u5355\u5931\u8d25\uff0c" + data.getRemark());
        }
        this.logger.error("\u987a\u4e30\u4e0b\u5355\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)data.getRemark());
        throw new BizException(respDto.getErrorCode(), respDto.getMessage());
    }

    @Override
    public void cancelOrder(CancelOrderReqDto cancelOrderReqDto) {
        this.initBaseInfo((SfBaseReqDto)cancelOrderReqDto);
        String url = this.sfChannelConfig.getUrl() + "/api/cancel/order";
        this.logger.info("\u8bf7\u6c42\u987a\u4e30\u53d6\u6d88\u8ba2\u5355\u63a5\u53e3\uff0crequest url:{},data:{}", (Object)url, (Object)JSON.toJSONString((Object)cancelOrderReqDto));
        CancelOrderRespDto cancelOrderRespDto = (CancelOrderRespDto)this.restTemplate.postForObject(url, (Object)cancelOrderReqDto, CancelOrderRespDto.class, new Object[0]);
        this.logger.info("\u8bf7\u6c42\u987a\u4e30\u53d6\u6d88\u8ba2\u5355\u63a5\u53e3,repose: {}", (Object)JSON.toJSONString((Object)cancelOrderRespDto));
        try {
            this.commonCacheService.delCache("DELIVERY_SF_CACHE_" + cancelOrderReqDto.getDeliveryNo());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (cancelOrderRespDto.getHttpStatus().equals(HttpStatus.OK.value())) {
            if ("2".equals(((CancelOrderRespDto.CancelOrderDataRespDto)cancelOrderRespDto.getData()).getResStatus())) {
                this.logger.error("\u5ba2\u6237\u8ba2\u5355\u53f7\u4e0e\u987a\u4e30\u8fd0\u5355\u4e0d\u5339\u914d, orderNumber:{}, mailNumber:{}", (Object)cancelOrderReqDto.getOrderNumber(), (Object)cancelOrderReqDto.getMailNumber());
                throw new BizException("\u5ba2\u6237\u8ba2\u5355\u53f7\u4e0e\u987a\u4e30\u8fd0\u5355\u4e0d\u5339\u914d");
            }
        } else {
            this.logger.error("\u987a\u4e30\u53d6\u6d88\u8ba2\u5355\u5931\u8d25,errorCode:{},message:{}", (Object)cancelOrderRespDto.getErrorCode(), (Object)cancelOrderRespDto.getMessage());
            throw new BizException(cancelOrderRespDto.getErrorCode(), cancelOrderRespDto.getMessage());
        }
        this.logger.info("\u53d6\u6d88\u987a\u4e30\u4e0b\u5355\u6210\u529f\uff0cdeliveryNo:{}, mailNumber:{}", (Object)cancelOrderReqDto.getDeliveryNo(), (Object)cancelOrderReqDto.getMailNumber());
    }

    public <T> SfBaseRespDto<T> doSfOrder(CreateOrderReqDto reqDto, String url, ParameterizedTypeReference<SfBaseRespDto<T>> responseType) throws Exception {
        this.initBaseInfo((SfBaseReqDto)reqDto);
        this.logger.info("\u8bf7\u6c42\u987a\u4e30\u4e0b\u5355\u63a5\u53e3\uff0c\u53c2\u6570\u8bf7\u6c42url:{}, CreateOrderReqDto\uff1a{}", (Object)url, (Object)JSON.toJSONString((Object)reqDto));
        RequestEntity requestEntity = new RequestEntity((Object)reqDto, HttpMethod.POST, new URI(url));
        ResponseEntity exchange = this.restTemplate.exchange(requestEntity, responseType);
        SfBaseRespDto resp = (SfBaseRespDto)exchange.getBody();
        this.logger.info("\u987a\u4e30\u4e0b\u5355\u54cd\u5e94\uff0c\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)resp));
        return resp;
    }

    private void initBaseInfo(SfBaseReqDto sfBaseReqDto) {
        if (null == this.sfChannelConfig || StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{this.sfChannelConfig.getAppId(), this.sfChannelConfig.getAppSecret(), this.sfChannelConfig.getUrl()})) {
            this.logger.error("\u987a\u4e30\u4e0b\u5355\u5931\u8d25\uff0cnacos\u672a\u914d\u7f6e\u987a\u4e30\u914d\u7f6e\u4fe1\u606f\uff01");
            throw new BizException("nacos\u672a\u914d\u7f6e\u987a\u4e30\u914d\u7f6e\u4fe1\u606f\uff01");
        }
        String requestId = UUID.randomUUID().toString();
        String timestamp = String.valueOf(System.currentTimeMillis());
        sfBaseReqDto.setAppId(this.sfChannelConfig.getAppId());
        sfBaseReqDto.setRequestId(requestId);
        sfBaseReqDto.setTimestamp(timestamp);
        sfBaseReqDto.setSign(SfSignUtil.sign(this.sfChannelConfig.getAppId(), requestId, timestamp, this.sfChannelConfig.getAppSecret()));
    }
}

