/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.util;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import com.dtyunxi.cube.biz.commons.utils.HttpClientUtils;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.yundt.cube.center.trade.biz.util.EasyPoiExportUtil;
import java.io.ByteArrayInputStream;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelParseObjectUtil {
    private static Logger logger = LoggerFactory.getLogger(ExcelParseObjectUtil.class);

    public static <T> List<T> parseImportFile(String fileUrl, Class<T> clazz) {
        long startTime = System.currentTimeMillis();
        if (StringUtils.isBlank((CharSequence)fileUrl)) {
            throw new BizException("\u5bfc\u5165\u8def\u5f84\u4e0d\u5b58\u5728");
        }
        byte[] bytes = HttpClientUtils.doGetRawData((String)fileUrl);
        Optional.ofNullable(bytes).orElseThrow(() -> new BizException("\u4e0b\u8f7d\u4e0d\u5230\u6587\u4ef6"));
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        Optional.ofNullable(inputStream).orElseThrow(() -> new BizException("\u5bfc\u5165\u53c2\u6570\u6709\u8bef"));
        ExcelImportResult data = EasyPoiExportUtil.importExcel(inputStream, 0, 1, clazz);
        logger.info("\u5bfc\u5165\u89e3\u6790excel\u6587\u4ef6, \u8017\u65f6={}", (Object)(System.currentTimeMillis() - startTime));
        return data.getList();
    }
}

