/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.engine;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.enhance.flow.ActionNode;
import com.dtyunxi.cube.enhance.flow.ActionNodeComponent;
import com.dtyunxi.cube.enhance.flow.ConvertNode;
import com.dtyunxi.cube.enhance.flow.ConvertNodeConponent;
import com.dtyunxi.cube.enhance.flow.NodeConvertMap;
import com.dtyunxi.util.SpringBeanUtil;
import com.dtyunxi.yundt.cube.center.trade.engine.ActionNodeConvertInfo;
import com.dtyunxi.yundt.cube.center.trade.engine.ActionNodeInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;

public class ActionNodeService
implements CommandLineRunner,
ApplicationContextAware {
    private static Logger logger = LoggerFactory.getLogger(ActionNodeService.class);
    private Map<String, ActionNodeInfo> actionNodeMap;
    private Map<Long, Map<String, List<ActionNodeConvertInfo>>> flwDefActionNodeCovertMap;
    private Map<Long, Map<String, List<ActionNodeConvertInfo>>> newFlwDefActionNodeCovertMap;
    private Map<Class, Pair<Object, Method>> actionInputs;
    private Map<String, Map<String, Method>> actionNode2MethodMap = new HashMap<String, Map<String, Method>>();
    private Map<String, Map<String, Method>> convertNode2MethodMap = new HashMap<String, Map<String, Method>>();
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void run(String ... args) throws Exception {
        this.actionNodeMap = new HashMap<String, ActionNodeInfo>(16);
        this.actionInputs = new HashMap<Class, Pair<Object, Method>>(16);
        this.flwDefActionNodeCovertMap = new HashMap<Long, Map<String, List<ActionNodeConvertInfo>>>(8);
        this.newFlwDefActionNodeCovertMap = new HashMap<Long, Map<String, List<ActionNodeConvertInfo>>>(8);
        Map actionNodeBeansMap = this.applicationContext.getBeansWithAnnotation(ActionNodeComponent.class);
        for (Object actionNodeBean : actionNodeBeansMap.values()) {
            Class targetClass = AopUtils.getTargetClass(actionNodeBean);
            ReflectionUtils.doWithMethods((Class)targetClass, method -> {
                ActionNode actionNodeAnno;
                HashMap actionNodeMethodMap = this.actionNode2MethodMap.get(targetClass.getCanonicalName());
                if (actionNodeMethodMap == null) {
                    actionNodeMethodMap = Maps.newHashMap();
                    this.actionNode2MethodMap.put(targetClass.getCanonicalName(), actionNodeMethodMap);
                }
                if ((actionNodeAnno = method.getAnnotation(ActionNode.class)) != null) {
                    this.addActionNode(actionNodeBean, method, actionNodeAnno);
                    actionNodeMethodMap.put(method.getName(), method);
                }
            }, (ReflectionUtils.MethodFilter)ReflectionUtils.USER_DECLARED_METHODS);
        }
        Map convertNodeBeansMap = this.applicationContext.getBeansWithAnnotation(ConvertNodeConponent.class);
        if (convertNodeBeansMap == null) {
            logger.warn("\u52a0\u8f7dconvertNodeBeansMap\u4e3a\u7a7a");
        } else {
            logger.info("\u52a0\u8f7dconvertNodeBeansMap\u4e3a{}", (Object)JSONObject.toJSONString(convertNodeBeansMap.values()));
        }
        for (Object convertNodeBean : convertNodeBeansMap.values()) {
            Class targetClass = AopUtils.getTargetClass(convertNodeBean);
            ReflectionUtils.doWithMethods((Class)targetClass, method -> {
                ConvertNode convertNodeAnno;
                HashMap convertNodeMethodMap = this.convertNode2MethodMap.get(targetClass.getCanonicalName());
                if (convertNodeMethodMap == null) {
                    convertNodeMethodMap = Maps.newHashMap();
                    this.convertNode2MethodMap.put(targetClass.getCanonicalName(), convertNodeMethodMap);
                }
                if ((convertNodeAnno = method.getAnnotation(ConvertNode.class)) != null) {
                    convertNodeMethodMap.put(method.getName(), method);
                }
            }, (ReflectionUtils.MethodFilter)ReflectionUtils.USER_DECLARED_METHODS);
        }
        logger.info("\u52a0\u8f7dconvertNode2MethodMap\u4e3a{}", (Object)JSON.toJSONString(this.convertNode2MethodMap));
    }

    private void addActionNode(Object bean, Method method, ActionNode actionNodeAnno) {
        String nodeCode = method.getDeclaringClass().getCanonicalName() + "#" + method.getName();
        ActionNodeInfo actionNodeInfo = new ActionNodeInfo(actionNodeAnno, method);
        this.actionNodeMap.put(nodeCode, actionNodeInfo);
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length != 1) {
            throw new RuntimeException("\u5904\u7406\u8282\u70b9\u4e0d\u7b26\u5408\u89c4\u8303,\u65b9\u6cd5" + nodeCode + " \u5fc5\u987b\u6709\u4e14\u53ea\u6709\u4e00\u4e2a\u53c2\u6570");
        }
        Class<?> inputClass = parameterTypes[0];
        this.actionInputs.put(inputClass, (Pair<Object, Method>)Pair.of((Object)bean, (Object)method));
    }

    public Map<String, ActionNodeInfo> getActionNodes() {
        return this.actionNodeMap;
    }

    public Map<Long, Map<String, List<ActionNodeConvertInfo>>> getActionNodeConverts() {
        return this.flwDefActionNodeCovertMap;
    }

    public void exchangeActionNodeConverts() {
        this.newFlwDefActionNodeCovertMap.forEach((flowDefId, item) -> this.flwDefActionNodeCovertMap.put((Long)flowDefId, (Map<String, List<ActionNodeConvertInfo>>)item));
        this.newFlwDefActionNodeCovertMap = new HashMap<Long, Map<String, List<ActionNodeConvertInfo>>>(8);
    }

    public ActionNodeInfo findActionNodeByCode(String nodeCode) {
        return this.getActionNodes().get(nodeCode);
    }

    public List<ActionNodeConvertInfo> findActionNodeConvert(Long flwDefId, String prevNodeCode, String prevNodeResultCode) {
        logger.info("\u6d41\u7a0bid={}\u524d\u7f6e\u8282\u70b9={} \u5904\u7406\u7ed3\u679c={} \u67e5\u8be2\u8f6c\u6362\u5668", new Object[]{flwDefId, prevNodeCode, prevNodeResultCode});
        Map<String, List<ActionNodeConvertInfo>> actionNodeConvertMap = this.getActionNodeConverts().get(flwDefId);
        if (actionNodeConvertMap == null) {
            logger.info("\u6d41\u7a0bid={},\u83b7\u53d6\u5230\u7684\u7ed3\u679c\u4e3a\u7a7a", (Object)flwDefId);
            return null;
        }
        String key = ActionNodeService.actionNodeConvertMapKey(prevNodeCode, prevNodeResultCode);
        logger.info("\u6d41\u7a0bid={},\u8f6c\u6362\u5668\u7684key={}", (Object)flwDefId, (Object)key);
        return actionNodeConvertMap.get(key);
    }

    public static String actionNodeConvertMapKey(String prevNodeCode, String prevNodeResultCode) {
        return prevNodeCode + "#" + prevNodeResultCode;
    }

    public void appendActionNodeConvertMap(Long flwDefId, Collection<NodeConvertMap> nodeConvertMaps) {
        if (CollectionUtils.isEmpty(nodeConvertMaps)) {
            return;
        }
        if (this.newFlwDefActionNodeCovertMap == null) {
            this.newFlwDefActionNodeCovertMap = new HashMap<Long, Map<String, List<ActionNodeConvertInfo>>>(8);
        }
        nodeConvertMaps.forEach(nodeConvertMap -> {
            List list;
            logger.info("nodeConvertMap:{}", (Object)JSONObject.toJSONString((Object)nodeConvertMap));
            String key = ActionNodeService.actionNodeConvertMapKey(nodeConvertMap.getPrevNodeCode(), nodeConvertMap.getPrevNodeResultCode());
            HashMap actionNodeConvertMap = this.newFlwDefActionNodeCovertMap.get(flwDefId);
            if (actionNodeConvertMap == null) {
                actionNodeConvertMap = Maps.newHashMap();
                this.newFlwDefActionNodeCovertMap.put(flwDefId, actionNodeConvertMap);
            }
            if ((list = (List)actionNodeConvertMap.get(key)) == null) {
                list = Lists.newLinkedList();
                actionNodeConvertMap.put(key, list);
            }
            try {
                String[] convertNodeInfoArray = nodeConvertMap.getConvertNodeCode().split("#");
                logger.info("convertNodeInfoArray:{}", (Object)JSONObject.toJSONString((Object)convertNodeInfoArray));
                String[] nextNodeInfoArray = nodeConvertMap.getNextNodeCode().split("#");
                logger.info("convertNodeInfoArray:{}", (Object)JSONObject.toJSONString((Object)nextNodeInfoArray));
                Class<?> convertNodeClass = Class.forName(convertNodeInfoArray[0]);
                logger.info("convertNodeClass:{}", (Object)JSONObject.toJSONString((Object)convertNodeClass.getCanonicalName()));
                Class<?> nextNodeClass = Class.forName(nextNodeInfoArray[0]);
                logger.info("nextNodeClass:{}", (Object)JSONObject.toJSONString((Object)nextNodeClass.getCanonicalName()));
                Object convertNode = SpringBeanUtil.getBean(convertNodeClass);
                Object nextNode = SpringBeanUtil.getBean(nextNodeClass);
                ActionNodeConvertInfo actionNodeConvertInfo = new ActionNodeConvertInfo();
                actionNodeConvertInfo.setConvertBean(convertNode);
                Map<String, Method> convertNodeMethodMap = this.convertNode2MethodMap.get(convertNodeInfoArray[0]);
                logger.info("convertNodeMethodMap:{}", (Object)JSONObject.toJSONString(convertNodeMethodMap));
                Map<String, Method> nextNodeMethodMap = this.actionNode2MethodMap.get(nextNodeInfoArray[0]);
                logger.info("nextNodeMethodMap:{}", (Object)JSONObject.toJSONString(nextNodeMethodMap));
                actionNodeConvertInfo.setConvertMethod(convertNodeMethodMap.get(convertNodeInfoArray[1]));
                actionNodeConvertInfo.setNextActionBean(nextNode);
                actionNodeConvertInfo.setNextActionMethod(nextNodeMethodMap.get(nextNodeInfoArray[1]));
                list.add(actionNodeConvertInfo);
            }
            catch (Exception e) {
                logger.warn("\u8ffd\u52a0\u8282\u70b9\u8f6c\u6362\u96c6\u5f02\u5e38\uff1a\u8f6c\u6362\u8282\u70b9\u7f16\u7801\u3010{}\u3011\uff0c\u540e\u7f6e\u5904\u7406\u8282\u70b9\u7f16\u7801\u3010{}\u3011", new Object[]{nodeConvertMap.getConvertNodeCode(), nodeConvertMap.getNextNodeCode(), e});
            }
        });
    }

    public void resetNewFlwDefActionNodeCovertMap() {
        if (this.newFlwDefActionNodeCovertMap == null) {
            this.newFlwDefActionNodeCovertMap = new HashMap<Long, Map<String, List<ActionNodeConvertInfo>>>(8);
        } else {
            this.newFlwDefActionNodeCovertMap.clear();
        }
    }
}

