/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.engine;

import com.dtyunxi.cube.enhance.flow.INodeLinkEo;
import com.dtyunxi.cube.enhance.flow.StatusNodeInfo;
import com.dtyunxi.yundt.cube.center.trade.engine.ActionNodeConvertInfo;
import com.dtyunxi.yundt.cube.center.trade.engine.ActionNodeInfo;
import com.dtyunxi.yundt.cube.center.trade.engine.ActionNodeService;
import com.dtyunxi.yundt.cube.center.trade.engine.AvailableStatus;
import com.dtyunxi.yundt.cube.center.trade.engine.FlowDef;
import com.dtyunxi.yundt.cube.center.trade.engine.NodeLinkService;
import com.dtyunxi.yundt.cube.center.trade.engine.StatusNodeService;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;

public class FlowManager
implements CommandLineRunner {
    private static Logger logger = LoggerFactory.getLogger(FlowManager.class);
    private Map<Long, FlowDef> defMap = new HashMap<Long, FlowDef>();
    @Resource
    private NodeLinkService nodeLinkService;
    @Resource
    private ActionNodeService actionNodeService;
    @Resource
    private StatusNodeService statusNodeService;

    public void run(String ... args) throws Exception {
        try {
            this.initFlowDef();
            if (this.defMap == null || this.defMap.isEmpty()) {
                logger.warn("\u52a0\u8f7d\u6d41\u7a0b\u5931\u8d25,\u53ef\u7528\u6d41\u7a0b\u4e3a\u7a7a", (Throwable)new Exception("\u53ef\u7528\u6d41\u7a0b\u4e3a\u7a7a!!!!!"));
            }
        }
        catch (Exception e) {
            logger.error("\u6d41\u7a0b\u521d\u59cb\u5316\u5931\u8d25", (Throwable)e);
        }
    }

    public void initFlowDef() {
        this.actionNodeService.resetNewFlwDefActionNodeCovertMap();
        Map<Long, List<INodeLinkEo>> defs = this.nodeLinkService.getActiveFLows();
        for (Map.Entry<Long, List<INodeLinkEo>> entry : defs.entrySet()) {
            try {
                this.buildFlow(entry.getKey(), entry.getValue());
            }
            catch (Exception e) {
                logger.warn("\u89e3\u6790\u6d41\u7a0b\u51fa\u9519,\u5ffd\u7565,\u5bf9\u5e94\u4e0d\u751f\u6548,flowDefId={}", (Object)entry.getKey(), (Object)e);
            }
        }
        this.actionNodeService.exchangeActionNodeConverts();
    }

    public FlowDef findById(Long flowDefId) {
        return this.defMap.get(flowDefId);
    }

    public Map<Long, FlowDef> getFlowInfo() {
        return this.defMap;
    }

    public FlowDef buildFlow(Long defId, List<INodeLinkEo> refs) {
        FlowDef def = new FlowDef();
        def.setDefId(defId);
        def.nextStatusRefs = new HashMap<String, Map<String, List<StatusNodeInfo>>>(8);
        def.preStatuses = new HashMap<String, Set<AvailableStatus>>(8);
        def.ends = new HashSet<String>();
        for (INodeLinkEo ref : refs) {
            if (4 == ref.getPrevType()) continue;
            String prevNodeCode = ref.getPrevCode();
            String nextNodeCode = ref.getNextCode();
            String bizResult = ref.getPrevResult();
            boolean isStart = prevNodeCode.equals("start");
            if (isStart) {
                def.startNode = this.packActionNodeInfo(ref.getNextCode());
                continue;
            }
            if (2 == ref.getPrevType()) {
                if (3 == ref.getNextType()) {
                    try {
                        def.addNextStatus(prevNodeCode, bizResult, this.packStatusNodeInfo(nextNodeCode));
                        continue;
                    }
                    catch (Exception e) {
                        logger.error("\u6d41\u7a0b{},\u524d\u7f6e\u8282\u70b9{}\uff0c\u540e\u7f6e\u8282\u70b9{}\uff0c\u51fa\u73b0\u5f02\u5e38", new Object[]{defId, prevNodeCode, nextNodeCode});
                        throw e;
                    }
                }
                logger.warn("\u51fa\u73b0\u4e24\u4e2a\u5904\u7406\u8282\u70b9\u76f4\u63a5\u8fde\u63a5,defId={}, from={},to={}", new Object[]{defId, prevNodeCode, nextNodeCode});
                continue;
            }
            if (3 != ref.getPrevType()) continue;
            boolean isEnd = nextNodeCode.equals("end");
            if (isEnd) {
                def.ends.add(prevNodeCode);
                continue;
            }
            StatusNodeInfo prevNode = this.packStatusNodeInfo(prevNodeCode);
            def.addPrevStatus(nextNodeCode, prevNode);
        }
        this.defMap.put(defId, def);
        return def;
    }

    public ActionNodeInfo findActionNodeByCode(String curNodeCode) {
        return this.actionNodeService.findActionNodeByCode(curNodeCode);
    }

    public Map<Long, FlowDef> getDefMap() {
        return this.defMap;
    }

    private StatusNodeInfo packStatusNodeInfo(String nodeCode) {
        return this.statusNodeService.findByPrimaryKey(nodeCode);
    }

    private ActionNodeInfo packActionNodeInfo(String nodeCode) {
        return this.actionNodeService.findActionNodeByCode(nodeCode);
    }

    private List<ActionNodeConvertInfo> packActionNodeConvertInfo(Long flwDefId, String prevNodeCode, String prevNodeResultCode) {
        return this.actionNodeService.findActionNodeConvert(flwDefId, prevNodeCode, prevNodeResultCode);
    }

    public FlowManager setNodeLinkService(NodeLinkService nodeLinkService) {
        this.nodeLinkService = nodeLinkService;
        return this;
    }

    public FlowManager setActionNodeService(ActionNodeService actionNodeService) {
        this.actionNodeService = actionNodeService;
        return this;
    }

    public FlowManager setStatusNodeService(StatusNodeService statusNodeService) {
        this.statusNodeService = statusNodeService;
        return this;
    }
}

