/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.engine;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.enhance.flow.IFlowEntity;
import com.dtyunxi.cube.enhance.flow.NodeInfo;
import com.dtyunxi.cube.enhance.flow.StatusNodeChangeInfo;
import com.dtyunxi.cube.enhance.flow.StatusNodeInfo;
import com.dtyunxi.cube.enhance.flow.StatusValueInfo;
import com.dtyunxi.util.SpringBeanUtil;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.config.TradeEngineConfig;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IFlowConvertLogService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IFlowDocChangeLogService;
import com.dtyunxi.yundt.cube.center.trade.dao.das.base.AbstractBaseDas;
import com.dtyunxi.yundt.cube.center.trade.engine.ActionNodeConvertInfo;
import com.dtyunxi.yundt.cube.center.trade.engine.ActionNodeInfo;
import com.dtyunxi.yundt.cube.center.trade.engine.FlowDef;
import com.dtyunxi.yundt.cube.center.trade.engine.FlowManager;
import com.dtyunxi.yundt.cube.center.trade.engine.IActionReturn;
import com.dtyunxi.yundt.cube.center.trade.engine.TradeEngineUtil;
import com.dtyunxi.yundt.cube.center.trade.ext.api.dto.flow.FlowConvertLogDto;
import com.google.common.collect.Lists;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class TradeEngine {
    private static Logger logger = LoggerFactory.getLogger(TradeEngine.class);
    public static boolean highPrefMode = true;
    public static String PROCESS_NODE_RESULT;
    private static FlowManager flowManager;
    private static TradeEngineConfig tradeEngineConfig;
    private static IFlowConvertLogService flowConvertLogService;
    private static IFlowDocChangeLogService flowDocChangeLogService;

    public static void setFlowManager(FlowManager flowManager) {
        TradeEngine.flowManager = flowManager;
    }

    public static FlowManager getFlowManager() {
        if (flowManager == null) {
            flowManager = (FlowManager)SpringBeanUtil.getBean(FlowManager.class);
        }
        return flowManager;
    }

    public static TradeEngineConfig getTradeEngineConfig() {
        if (tradeEngineConfig == null) {
            tradeEngineConfig = (TradeEngineConfig)SpringBeanUtil.getBean(TradeEngineConfig.class);
        }
        return tradeEngineConfig;
    }

    public static IFlowConvertLogService getFlowConvertLogService() {
        if (flowConvertLogService == null) {
            flowConvertLogService = (IFlowConvertLogService)SpringBeanUtil.getBean((String)"flowConvertLogService", IFlowConvertLogService.class);
        }
        return flowConvertLogService;
    }

    public static IFlowDocChangeLogService getFlowDocChangeLogService() {
        if (flowDocChangeLogService == null) {
            flowDocChangeLogService = (IFlowDocChangeLogService)SpringBeanUtil.getBean((String)"flowDocChangeLogService", IFlowDocChangeLogService.class);
        }
        return flowDocChangeLogService;
    }

    public static void validate(IFlowEntity bizEo, String curNodeCode) {
        FlowDef def;
        if (bizEo == null) {
            throw new RuntimeException("bizEo\u4e0d\u80fd\u4e3anull");
        }
        if (bizEo.getFlowDefId() == null) {
            logger.error("\u5c1a\u672a\u5173\u8054\u6d41\u7a0b,class:{} ,id:{}", bizEo.getClass(), (Object)bizEo.getFlowDefId());
        }
        if ((def = TradeEngine.getFlowDefByEntity(bizEo)) == null) {
            logger.error("\u6d41\u7a0b\u6ca1\u6709\u52a0\u8f7d:{}", (Object)bizEo.getFlowDefId());
        }
        ActionNodeInfo curNode = TradeEngine.getActionNodeInfo(curNodeCode);
        def.statusCheck(curNode, bizEo);
    }

    public static <E extends IFlowEntity> E setFlowStatus(E bizEo, String actionResult, String curActionNodeCode) {
        ServiceContext.getContext().set("dtyunxi.env.module", bizEo);
        FlowDef def = TradeEngine.getFlowDefByEntity(bizEo);
        if (def == null) {
            throw new BizException("\u6d41\u7a0b\u5b9a\u4e49" + bizEo.getFlowDefId() + "\u4e0d\u5b58\u5728");
        }
        ActionNodeInfo curNode = TradeEngine.getActionNodeInfo(curActionNodeCode);
        List<StatusNodeInfo> nextNodes = def.getNextStatus(curNode, actionResult);
        ArrayList statusChangeList = Lists.newArrayList();
        if (nextNodes == null) {
            logger.info("\u5904\u7406\u7ed3\u679c\u4e0d\u9700\u8981\u6539\u52a8\u4fe1\u606f. \u5355\u636e\u7c7b\u578b:{},id:{},\u5904\u7406\u8282\u70b9:{},\u7ed3\u679c:{}", new Object[]{bizEo.getEntityName(), bizEo.getId(), curNode.getNodeName(), actionResult});
            TradeEngineUtil.setFlowCurrentActionResult(actionResult);
            TradeEngineUtil.setFlowEntity(bizEo);
            return bizEo;
        }
        for (NodeInfo nodeInfo : nextNodes) {
            if (nodeInfo instanceof StatusNodeInfo) {
                StatusNodeInfo nextStatusNode = (StatusNodeInfo)nodeInfo;
                String curStatusValue = bizEo.getStatus(nextStatusNode.getStatusField());
                StatusNodeChangeInfo statusNodeChangeInfo = new StatusNodeChangeInfo();
                statusNodeChangeInfo.setStatusField(nextStatusNode.getStatusField());
                statusNodeChangeInfo.setStatusValue(curStatusValue);
                statusNodeChangeInfo.setNextValue(nextStatusNode.getStatusValue());
                statusChangeList.add(statusNodeChangeInfo);
                bizEo.setStatus(nextStatusNode.getStatusField(), nextStatusNode.getStatusValue());
                continue;
            }
            throw new RuntimeException("\u6682\u4e0d\u652f\u6301\u6d41\u8f6c\u5230\u5904\u7406\u8282\u70b9,cureNode=" + curNode.getNodeCode() + ",defId=" + def.getDefId() + ",nextNode=" + nodeInfo.getNodeCode());
        }
        TradeEngineUtil.setFlowCurrentActionResult(actionResult);
        TradeEngineUtil.setFlowEntity(bizEo);
        if (TradeEngine.getTradeEngineConfig().isChange()) {
            if (bizEo.getId() == null) {
                bizEo.setId(AbstractBaseDas.getId());
            }
            TradeEngine.getFlowDocChangeLogService().createLog(bizEo, def, statusChangeList, curActionNodeCode, actionResult);
        }
        return bizEo;
    }

    public static String getNextActionNode(IFlowEntity bizEo) {
        return "OrderService#auditOrder";
    }

    private static FlowDef getFlowDefByEntity(IFlowEntity bizEo) {
        return TradeEngine.getFlowManager().findById(bizEo.getFlowDefId());
    }

    public static void endNotify(String flowSeq, String endResult) {
    }

    private static ActionNodeInfo getActionNodeInfo(String curNodeCode) {
        StackTraceElement stackTraceElement;
        ActionNodeInfo actionNodeInfo;
        if (StringUtils.isNotBlank((CharSequence)curNodeCode)) {
            ActionNodeInfo actionNodeInfo2 = TradeEngine.getFlowManager().findActionNodeByCode(curNodeCode);
            if (actionNodeInfo2 != null) {
                return actionNodeInfo2;
            }
            if (highPrefMode) {
                return null;
            }
        }
        int callerPos = 2;
        StackTraceElement[] stack = new Throwable().getStackTrace();
        if (stack != null && stack.length > callerPos && (actionNodeInfo = TradeEngine.stackTrace2actionNode(stackTraceElement = stack[callerPos])) != null) {
            return actionNodeInfo;
        }
        int depth = 0;
        for (StackTraceElement stackTraceElement2 : stack) {
            ActionNodeInfo actionNodeInf;
            if (depth > 0 && (actionNodeInf = TradeEngine.stackTrace2actionNode(stackTraceElement2)) != null) {
                return actionNodeInf;
            }
            ++depth;
        }
        throw new RuntimeException("\u5f53\u524d\u8c03\u7528\u6808\u4e2d >>\u6ca1\u6709<< \u7528\u6ce8\u89e3\u5b9a\u4e49\u5904\u7406>\u8282\u70b9\u4fe1\u606f<!!");
    }

    private static ActionNodeInfo stackTrace2actionNode(StackTraceElement stackTraceElement) {
        String className = stackTraceElement.getClassName();
        String methodName = stackTraceElement.getMethodName();
        String actionNodeCode = className + "#" + methodName;
        return TradeEngine.getFlowManager().findActionNodeByCode(actionNodeCode);
    }

    public static void launchNext(String actionNodeName, IActionReturn actionResp) {
        IFlowEntity flowEntity = actionResp.getFlowEntity();
        FlowDef def = TradeEngine.getFlowDefByEntity(flowEntity);
        Set<ActionNodeConvertInfo> actionLinks = def.getNextConvert(actionNodeName, actionResp.getActionResult());
        if (CollectionUtils.isEmpty(actionLinks)) {
            return;
        }
        for (ActionNodeConvertInfo actionLink : actionLinks) {
            Object nextInput = null;
            try {
                nextInput = actionLink.getConvertMethod().invoke(actionLink.getConvertBean(), actionResp.getFlowEntity());
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                logger.warn("\u8c03\u7528\u8f6c\u6362\u8282\u70b9\u5931\u8d25,\u65b9\u6cd5:{}", (Object)actionLink.getConvertMethod().getName(), (Object)e);
            }
            try {
                actionLink.getNextActionMethod().invoke(actionLink.getNextActionBean(), nextInput);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                logger.warn("\u8c03\u7528\u4e0b\u4e00\u4e2a\u5904\u7406\u8282\u70b9\u5931\u8d25,\u65b9\u6cd5:{}", (Object)actionLink.getNextActionMethod().getName(), (Object)e);
            }
        }
    }

    public static void autoProcess(Object actionResp, String actionNodeName, List<ActionNodeConvertInfo> autoActionList) {
        if (CollectionUtils.isEmpty(autoActionList)) {
            return;
        }
        boolean convertLog = TradeEngine.getTradeEngineConfig().isConvert();
        autoActionList.forEach(autoAction -> {
            StringBuilder remark = new StringBuilder();
            Object output = null;
            try {
                logger.info("\u8fdb\u5165\u8f6c\u6362\u5668\u6267\u884cid={},action={}", (Object)TradeEngineUtil.getFLowDefId(), (Object)autoAction.getNodeCode());
                logger.info("\u6d41\u7a0bid={} \u6267\u884c\u8f6c\u6362\u5668\u65b9\u6cd5 convertMethod={}", (Object)TradeEngineUtil.getFLowDefId(), (Object)autoAction.getConvertMethod().getName());
                output = autoAction.getConvertMethod().invoke(autoAction.getConvertBean(), actionResp);
                try {
                    logger.info("\u6d41\u7a0bid={} \u6267\u884c\u8f6c\u6362\u5668 nextActionMethod={}", (Object)TradeEngineUtil.getFLowDefId(), (Object)autoAction.getNextActionMethod().getName());
                    autoAction.getNextActionMethod().invoke(autoAction.getNextActionBean(), output);
                }
                catch (IllegalAccessException e) {
                    logger.warn("\u540e\u7f6e\u5904\u7406\u8282\u70b9-\u975e\u6cd5\u8bbf\u95ee\uff1a", (Throwable)e);
                    remark.append("\u540e\u7f6e\u5904\u7406\u8282\u70b9-\u975e\u6cd5\u8bbf\u95ee");
                }
                catch (InvocationTargetException e) {
                    logger.warn("\u540e\u7f6e\u5904\u7406\u8282\u70b9-\u8c03\u7528\u5f02\u5e38\uff1a", (Throwable)e);
                    remark.append("\u540e\u7f6e\u5904\u7406\u8282\u70b9-\u8c03\u7528\u5f02\u5e38");
                }
            }
            catch (IllegalAccessException e) {
                logger.warn("\u8f6c\u6362\u8282\u70b9-\u975e\u6cd5\u8bbf\u95ee\uff1a", (Throwable)e);
                remark.append("\u8f6c\u6362\u8282\u70b9-\u975e\u6cd5\u8bbf\u95ee");
            }
            catch (InvocationTargetException e) {
                logger.warn("\u8f6c\u6362\u8282\u70b9-\u8c03\u7528\u5f02\u5e38\uff1a", (Throwable)e);
                remark.append("\u8f6c\u6362\u8282\u70b9-\u8c03\u7528\u5f02\u5e38");
            }
            if (convertLog) {
                final FlowDef flowDef = TradeEngine.getFlowManager().findById(TradeEngineUtil.getFLowDefId());
                IFlowEntity flowEntity = TradeEngineUtil.getFlowEntity();
                if (flowEntity == null) {
                    flowEntity = new IFlowEntity(){

                        public String getEntityName() {
                            return null;
                        }

                        public Long getId() {
                            return -1L;
                        }

                        public void setId(Long id) {
                        }

                        public Long getFlowDefId() {
                            return flowDef.getDefId();
                        }

                        public void setFlowDefId(Long flowDefId) {
                        }

                        public Map<String, StatusValueInfo> getStatusDesc() {
                            return null;
                        }

                        public String getStatus(String statusField) {
                            return null;
                        }

                        public void setStatus(String statusField, String newStatus) {
                        }
                    };
                }
                String convertNodeCode = autoAction.getConvertBean().getClass().getCanonicalName() + "#" + autoAction.getConvertMethod().getName();
                String nextNodeCode = autoAction.getNextActionBean().getClass().getCanonicalName() + "#" + autoAction.getNextActionMethod().getName();
                TradeEngine.getFlowConvertLogService().createLog(flowEntity, flowDef, FlowConvertLogDto.init((String)actionNodeName, (String)TradeEngineUtil.getFlowCurrentActionResult(), (String)convertNodeCode, (String)nextNodeCode, (String)(actionResp == null ? "" : JSONObject.toJSONString((Object)actionResp)), (String)(output == null ? "" : JSONObject.toJSONString((Object)output)), (String)remark.toString()));
            }
        });
    }
}

