/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.dao.das;

import com.alibaba.druid.util.StringUtils;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.trade.dao.das.base.AbstractBaseDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderStatisticsEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.TradeItemEo;
import com.dtyunxi.yundt.cube.center.trade.dao.mapper.OrderMapper;
import com.dtyunxi.yundt.cube.center.trade.dao.vo.OrderQueryVo;
import com.dtyunxi.yundt.cube.center.trade.dao.vo.OrderStatisticsVo;
import com.dtyunxi.yundt.cube.center.trade.dao.vo.OrderStatusCountVo;
import com.github.pagehelper.PageHelper;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Repository;

@Repository
public class OrderDas
extends AbstractBaseDas<OrderEo, String> {
    @Resource
    private OrderMapper orderMapper;

    public OrderEo lockByOrderNo(String orderNo) {
        if (StringUtils.isEmpty((CharSequence)orderNo)) {
            throw new BizException("\u8ba2\u5355\u53f7\u4e0d\u80fd\u7a7a");
        }
        if (!StringUtils.isEmpty((CharSequence)orderNo)) {
            return this.orderMapper.lockByOrderNo(orderNo);
        }
        return null;
    }

    public BigDecimal sumPayAmount(OrderQueryVo orderEo) {
        OrderEo orderEo1 = this.orderMapper.sumPayAmount(orderEo);
        if (orderEo1 != null) {
            return orderEo1.getPayAmount();
        }
        return BigDecimal.ZERO;
    }

    public Set<OrderEo> queryRefererIdNoReply(OrderQueryVo orderEo) {
        return this.orderMapper.queryRefererIdNoReply(orderEo);
    }

    public int countRefererIdOrderNum(OrderQueryVo orderEo) {
        OrderEo orderEo1 = this.orderMapper.countRefererIdOrderNum(orderEo);
        if (orderEo1 != null) {
            return orderEo1.getTotalItemNum();
        }
        return 0;
    }

    public OrderEo findByOrderNo(String orderNo) {
        OrderEo selectParam = new OrderEo();
        selectParam.setOrderNo(orderNo);
        List list = this.getMapper().findList((BaseEo)selectParam);
        return CollectionUtils.isEmpty((Collection)list) ? null : (OrderEo)list.get(0);
    }

    public List<OrderStatusCountVo> countOrderByStatus(OrderQueryVo orderQueryVo) {
        return this.orderMapper.countOrderByStatus(orderQueryVo);
    }

    public List<TradeItemEo> countItem(OrderQueryVo orderQueryVo) {
        return this.orderMapper.countItem(orderQueryVo);
    }

    public List<OrderStatusCountVo> countOrderByStatusTob(OrderQueryVo orderQueryVo) {
        return this.orderMapper.countOrderByStatusTob(orderQueryVo);
    }

    public OrderStatusCountVo countAfterSalesTob(OrderQueryVo orderQueryVo) {
        return this.orderMapper.countAfterSalesTob(orderQueryVo);
    }

    public List<OrderStatisticsVo> statisticsOrder(OrderStatisticsEo orderStatisticsEo) {
        PageHelper.startPage((int)orderStatisticsEo.getPageNum(), (int)orderStatisticsEo.getPageSize());
        return this.orderMapper.statisticsOrder(orderStatisticsEo);
    }

    public Date getFirstPlaceOrderByCustomerId(Long customerId) {
        return this.orderMapper.getFirstPlaceOrderByCustomerId(String.valueOf(customerId));
    }

    public void clearTradeItemBatch(String orderNo) {
        this.orderMapper.clearTradeItemBatch(orderNo);
    }
}

