/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.flow.action;

import com.dtyunxi.cube.enhance.flow.ActionNode;
import com.dtyunxi.cube.enhance.flow.ActionNodeComponent;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderDeliveryPlanCycleDto;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.dto.CreateDeliveryPlanBo;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.dto.OrderBo;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderDeliveryPlanService;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderDeliveryPlanEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderEo;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="orderDeliveryPlanAction")
@ActionNodeComponent
public class OrderDeliveryPlanAction {
    private static final Logger logger = LoggerFactory.getLogger(OrderDeliveryPlanAction.class);
    @Resource
    private IOrderDeliveryPlanService orderDeliveryPlanService;

    @ActionNode(entity=OrderEo.class, name="\u521b\u5efa\u8ba2\u5355\u914d\u9001\u8ba1\u5212")
    public CreateDeliveryPlanBo createOrderDeliveryPlan(CreateDeliveryPlanBo createDeliveryPlanBo) {
        String orderNo = createDeliveryPlanBo.getOrderEo().getOrderNo();
        logger.info("\u8ba2\u5355{}\u5f00\u59cb\u751f\u6210\u8ba2\u5355\u914d\u9001\u8ba1\u5212", (Object)orderNo);
        createDeliveryPlanBo.setOrderNo(orderNo);
        List<OrderDeliveryPlanEo> orderDeliveryPlanEos = this.orderDeliveryPlanService.generateOrderDeliveryPlan(createDeliveryPlanBo.getOrderEo());
        if (CollectionUtils.isNotEmpty(orderDeliveryPlanEos)) {
            List<OrderDeliveryPlanCycleDto> orderDeliveryPlanCycleDtos = orderDeliveryPlanEos.stream().map(orderDeliveryPlanEo -> {
                OrderDeliveryPlanCycleDto cycleDto = new OrderDeliveryPlanCycleDto();
                cycleDto.setOrderNo(orderNo);
                cycleDto.setDeliveryPlanId(orderDeliveryPlanEo.getId());
                cycleDto.setDeliveryDate(orderDeliveryPlanEo.getDeliveryDate());
                cycleDto.setCycleItemCount(orderDeliveryPlanEo.getCycleItemCount());
                return cycleDto;
            }).collect(Collectors.toList());
            createDeliveryPlanBo.setDeliveryPlanCycleDtoList(orderDeliveryPlanCycleDtos);
        }
        return createDeliveryPlanBo;
    }

    @ActionNode(entity=OrderEo.class, name="\u68c0\u67e5\u662f\u5426\u4e3a\u5468\u671f\u8d2d\u8ba2\u5355")
    public String checkIsCycleOrder(OrderBo orderBo) {
        OrderEo orderEo = orderBo.getOrderEo();
        if (orderEo != null && orderEo.getIsCycleBuy() != null && 1 == orderEo.getIsCycleBuy()) {
            return "TRUE";
        }
        return "FALSE";
    }
}

