/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.mq.process;

import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.yundt.cube.center.trade.api.constants.DeliveryPlanStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.OrderStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderDeliveryPlanService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderService;
import com.dtyunxi.yundt.cube.center.trade.dao.das.OrderDeliveryDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.OrderDeliveryPlanDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.TradeItemDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderDeliveryEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderDeliveryPlanEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.TradeItemEo;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@MQDesc(tag="CONFIRM_ORDER_DELIVERY_TAG")
public class ConfirmDeliveryProcess
implements IMessageProcessor<String> {
    private static final Logger logger = LoggerFactory.getLogger(ConfirmDeliveryProcess.class);
    @Resource
    private OrderDeliveryPlanDas orderDeliveryPlanDas;
    @Resource
    private OrderDeliveryDas orderDeliveryDas;
    @Resource
    private TradeItemDas tradeItemDas;
    @Resource
    private IOrderService orderService;
    @Resource
    private IOrderDeliveryPlanService orderDeliveryPlanService;

    @Transactional(rollbackFor={Exception.class})
    public MessageResponse process(String deliveryNo) {
        logger.info("\u53d1\u8d27\u5355\u786e\u8ba4\u6536\u8d27\u5904\u7406: deliveryNo={}", (Object)deliveryNo);
        OrderDeliveryEo orderDeliveryEoQuery = new OrderDeliveryEo();
        orderDeliveryEoQuery.setDeliveryNo(deliveryNo);
        OrderDeliveryEo orderDeliveryEo = (OrderDeliveryEo)this.orderDeliveryDas.selectOne((BaseEo)orderDeliveryEoQuery);
        OrderDeliveryPlanEo deliveryPlanEo = (OrderDeliveryPlanEo)this.orderDeliveryPlanDas.selectByPrimaryKey(orderDeliveryEo.getDeliveryPlanId());
        if (deliveryPlanEo != null) {
            boolean lastConfirm = false;
            List<OrderDeliveryPlanEo> orderDeliveryPlanEoList = this.orderDeliveryPlanService.queryListByOrderNo(deliveryPlanEo.getOrderNo());
            if (CollectionUtils.isNotEmpty(orderDeliveryPlanEoList)) {
                int size = orderDeliveryPlanEoList.size();
                long finishDeliveryCount = orderDeliveryPlanEoList.stream().filter(orderDeliveryPlanEo -> DeliveryPlanStatusEnum.FINISH_DELIVERY.name().equals(orderDeliveryPlanEo.getDeliveryStatus())).count();
                lastConfirm = finishDeliveryCount + 1L == (long)size;
            }
            deliveryPlanEo.setDeliveryStatus(DeliveryPlanStatusEnum.FINISH_DELIVERY.name());
            this.orderDeliveryPlanDas.updateSelective((BaseEo)deliveryPlanEo);
            if (lastConfirm) {
                logger.info("\u8ba2\u5355\u5bf9\u6700\u540e\u4e00\u4e2a\u53d1\u8d27\u5355\u786e\u8ba4\u6536\u8d27: orderNo={}, deliveryNo={}", (Object)deliveryPlanEo.getOrderNo(), (Object)deliveryNo);
                this.orderService.modifyOrderTradeStatus(null, deliveryPlanEo.getOrderNo(), OrderStatusEnum.CONFIRM.getCode());
            }
            TradeItemEo tradeItemEoParam = TradeItemEo.newInstance();
            tradeItemEoParam.setTradeNo(deliveryPlanEo.getOrderNo());
            TradeItemEo tradeItemEo = (TradeItemEo)this.tradeItemDas.selectOne((BaseEo)tradeItemEoParam);
            if (tradeItemEo != null) {
                int completeDeliveryNum = tradeItemEo.getCompleteDeliveryNum() != null ? tradeItemEo.getCompleteDeliveryNum() : 0;
                tradeItemEo.setCompleteDeliveryNum(Integer.valueOf(completeDeliveryNum + deliveryPlanEo.getCycleItemCount()));
                this.tradeItemDas.updateSelective((BaseEo)tradeItemEo);
            }
        }
        return MessageResponse.SUCCESS;
    }
}

