/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemCycleBuyRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.cyclebuy.query.IItemCycleBuyQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopWarehouseDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopBaseDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.constants.CycleBuyDeliveryTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.DeliveryPlanStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.RateByDayEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.RateByMonthEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderDeliveryPlanReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderDeliveryPlanRespDto;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderDeliveryPlanService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.ITradeItemService;
import com.dtyunxi.yundt.cube.center.trade.dao.das.OrderDeliveryPlanDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.PayRecordDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderDeliveryPlanEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.TradeItemEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrderDeliveryPlanServiceImpl
implements IOrderDeliveryPlanService {
    private static final Logger logger = LoggerFactory.getLogger(OrderDeliveryPlanServiceImpl.class);
    @Resource
    private OrderDeliveryPlanDas orderDeliveryPlanDas;
    @Resource
    private IOrderService orderService;
    @Resource
    private ITradeItemService tradeItemService;
    @Resource
    private IShopQueryApi shopQueryApi;
    @Resource
    private IItemQueryApi itemQueryApi;
    @Resource
    private IItemCycleBuyQueryApi itemCycleBuyQueryApi;
    @Resource
    private PayRecordDas payRecordDas;

    @Override
    public List<OrderDeliveryPlanEo> queryListByOrderNo(String orderNo) {
        OrderDeliveryPlanEo orderDeliveryPlanEo = OrderDeliveryPlanEo.newInstance();
        orderDeliveryPlanEo.setOrderNo(orderNo);
        return this.orderDeliveryPlanDas.selectList((BaseEo)orderDeliveryPlanEo);
    }

    @Override
    public PageInfo<OrderDeliveryPlanRespDto> queryPage(OrderDeliveryPlanReqDto orderCyclePlanRepDto, Integer pageNum, Integer pageSize) {
        OrderDeliveryPlanEo orderDeliveryPlanEo = this.buildQueryEo(orderCyclePlanRepDto);
        orderDeliveryPlanEo.setOrderByDesc("createTime");
        PageInfo pageInfo = new PageInfo();
        ArrayList list = Lists.newArrayList();
        PageInfo page = this.orderDeliveryPlanDas.selectPage((BaseEo)orderDeliveryPlanEo, pageNum, pageSize);
        if (page != null) {
            CubeBeanUtils.copyProperties((Object)pageInfo, (Object)page, (String[])new String[]{"list"});
            if (CollectionUtils.isNotEmpty((Collection)page.getList())) {
                CubeBeanUtils.copyCollection((Collection)list, (Collection)page.getList(), OrderDeliveryPlanRespDto.class);
                list.forEach(dto -> {
                    if (dto.getDeliveryStatus() != null) {
                        dto.setDeliveryStatusName(DeliveryPlanStatusEnum.valueOf((String)dto.getDeliveryStatus()).getName());
                    }
                });
            }
            pageInfo.setList((List)list);
        }
        return pageInfo;
    }

    @Override
    public List<OrderDeliveryPlanRespDto> queryList(OrderDeliveryPlanReqDto orderCyclePlanRepDto) {
        OrderDeliveryPlanEo orderCyclePlanEo = this.buildQueryEo(orderCyclePlanRepDto);
        ArrayList list = Lists.newArrayList();
        List eoList = this.orderDeliveryPlanDas.select((BaseEo)orderCyclePlanEo);
        if (CollectionUtils.isNotEmpty((Collection)eoList)) {
            CubeBeanUtils.copyCollection((Collection)list, (Collection)eoList, OrderDeliveryPlanRespDto.class);
            list.forEach(dto -> {
                if (dto.getDeliveryStatus() != null) {
                    dto.setDeliveryStatusName(DeliveryPlanStatusEnum.valueOf((String)dto.getDeliveryStatus()).getName());
                }
            });
        }
        return list;
    }

    public OrderDeliveryPlanEo buildQueryEo(OrderDeliveryPlanReqDto orderCyclePlanRepDto) {
        String deliveryDateEnd;
        String deliveryDateStart;
        String memberId;
        String shopName;
        String itemName;
        OrderDeliveryPlanEo orderCyclePlanEo = OrderDeliveryPlanEo.newInstance();
        orderCyclePlanEo.setDeliveryStatus(orderCyclePlanRepDto.getDeliveryStatus());
        orderCyclePlanEo.setItemId(orderCyclePlanRepDto.getItemId());
        orderCyclePlanEo.setShopId(orderCyclePlanRepDto.getShopId());
        orderCyclePlanEo.setSkuId(orderCyclePlanRepDto.getSkuId());
        ArrayList sqlFilterList = Lists.newArrayList();
        String orderNo = orderCyclePlanRepDto.getOrderNo();
        if (StringUtils.isNotBlank((CharSequence)orderNo)) {
            sqlFilterList.add(SqlFilter.like((String)"orderNo", (Object)StringUtils.wrap((String)orderNo, (String)"%")));
        }
        if (StringUtils.isNotBlank((CharSequence)(itemName = orderCyclePlanRepDto.getItemName()))) {
            sqlFilterList.add(SqlFilter.like((String)"itemName", (Object)StringUtils.wrap((String)itemName, (String)"%")));
        }
        if (StringUtils.isNotBlank((CharSequence)(shopName = orderCyclePlanRepDto.getShopName()))) {
            sqlFilterList.add(SqlFilter.like((String)"shopName", (Object)StringUtils.wrap((String)shopName, (String)"%")));
        }
        if (StringUtils.isNotBlank((CharSequence)(memberId = orderCyclePlanRepDto.getMemberId()))) {
            sqlFilterList.add(SqlFilter.like((String)"memberId", (Object)StringUtils.wrap((String)memberId, (String)"%")));
        }
        if (StringUtils.isNotBlank((CharSequence)(deliveryDateStart = orderCyclePlanRepDto.getDeliveryDateStart()))) {
            sqlFilterList.add(SqlFilter.ge((String)"deliveryDate", (Object)deliveryDateStart));
        }
        if (StringUtils.isNotBlank((CharSequence)(deliveryDateEnd = orderCyclePlanRepDto.getDeliveryDateEnd()))) {
            sqlFilterList.add(SqlFilter.le((String)"deliveryDate", (Object)deliveryDateEnd));
        }
        orderCyclePlanEo.setSqlFilters((List)sqlFilterList);
        return orderCyclePlanEo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<OrderDeliveryPlanEo> generateOrderDeliveryPlan(OrderEo orderEo) {
        try {
            TradeItemEo tradeItemEo;
            logger.info("\u8ba2\u5355{}\u751f\u6210\u914d\u9001\u8ba1\u5212", (Object)orderEo.getOrderNo());
            List tradeItemEoList = this.tradeItemService.queryByTradeNo(orderEo.getOrderNo());
            if (CollectionUtils.isNotEmpty((Collection)tradeItemEoList) && (tradeItemEo = (TradeItemEo)tradeItemEoList.get(0)) != null && tradeItemEo.getCycleBuy() != null && tradeItemEo.getCycleBuy().booleanValue()) {
                List<Date> deliveryDateList;
                this.checkDeliveryStartDate(orderEo, tradeItemEo);
                Integer cycleType = tradeItemEo.getCycleType();
                Integer[] cycleValue = (Integer[])Stream.of(StringUtils.split((String)tradeItemEo.getCycleValue(), (String)",")).map(Integer::valueOf).toArray(Integer[]::new);
                Integer totalCycleCount = tradeItemEo.getTotalCycleCount();
                Integer cycleItemCount = tradeItemEo.getCycleItemNum();
                Date cycleStart = tradeItemEo.getCycleStart();
                Date cycleEnd = tradeItemEo.getCycleEnd();
                String shopId = orderEo.getShopId();
                ShopWarehouseDto shopWarehouseDto = null;
                ShopBaseDto shopBaseDto = null;
                if (StringUtils.isNotBlank((CharSequence)shopId)) {
                    RestResponse shopDtoRestResponse = this.shopQueryApi.queryBaseById(Long.valueOf(Long.parseLong(shopId)));
                    shopBaseDto = (ShopBaseDto)RestResponseHelper.extractData((RestResponse)shopDtoRestResponse);
                    RestResponse response = this.shopQueryApi.queryShopWarehouseByShopId(Long.valueOf(shopId), null);
                    List shopWarehouseDtoList = (List)RestResponseHelper.extractData((RestResponse)response);
                    ShopWarehouseDto shopWarehouseDto2 = shopWarehouseDto = CollectionUtils.isNotEmpty((Collection)shopWarehouseDtoList) ? (ShopWarehouseDto)shopWarehouseDtoList.get(0) : null;
                }
                if (CollectionUtils.isNotEmpty(deliveryDateList = this.getDeliveryDate(cycleType, cycleValue, totalCycleCount, cycleStart, cycleEnd))) {
                    List deliveryDateStrList = deliveryDateList.stream().map(date -> DateFormatUtils.format((Date)date, (String)"yyyy-MM-dd")).collect(Collectors.toList());
                    logger.info("\u8ba2\u5355{}\u751f\u6210\u914d\u9001\u8ba1\u5212\u7684\u65e5\u671f\u5217\u8868\uff1a{}", (Object)orderEo.getOrderNo(), deliveryDateStrList);
                    LinkedList orderCyclePlanEoList = Lists.newLinkedList();
                    for (int i = 0; i < deliveryDateList.size(); ++i) {
                        Date deliveryDate = deliveryDateList.get(i);
                        OrderDeliveryPlanEo orderDeliveryPlanEo = OrderDeliveryPlanEo.newInstance();
                        orderDeliveryPlanEo.setOrderNo(orderEo.getOrderNo());
                        orderDeliveryPlanEo.setDeliveryDate(deliveryDate);
                        orderDeliveryPlanEo.setDeliveryStatus(DeliveryPlanStatusEnum.WAIT_DELIVERY.name());
                        String deliveryAddress = orderEo.getDeliveryAddress();
                        if (StringUtils.isNotBlank((CharSequence)deliveryAddress)) {
                            JSONObject address = JSONObject.parseObject((String)deliveryAddress);
                            orderDeliveryPlanEo.setAddress(address.getString("address"));
                        }
                        if (StringUtils.isNotBlank((CharSequence)tradeItemEo.getItemSerial())) {
                            orderDeliveryPlanEo.setItemId(Long.valueOf(tradeItemEo.getItemSerial()));
                        }
                        orderDeliveryPlanEo.setItemName(tradeItemEo.getItemName());
                        if (StringUtils.isNotBlank((CharSequence)tradeItemEo.getSkuSerial())) {
                            orderDeliveryPlanEo.setSkuId(Long.valueOf(tradeItemEo.getSkuSerial()));
                        }
                        orderDeliveryPlanEo.setSpec(tradeItemEo.getSkuDesc());
                        if (i == deliveryDateList.size() - 1 && tradeItemEo.getItemNum() % tradeItemEo.getCycleItemNum() != 0) {
                            orderDeliveryPlanEo.setCycleItemCount(Integer.valueOf(tradeItemEo.getItemNum() % tradeItemEo.getCycleItemNum()));
                        } else {
                            orderDeliveryPlanEo.setCycleItemCount(cycleItemCount);
                        }
                        orderDeliveryPlanEo.setMemberId(orderEo.getUserId());
                        if (StringUtils.isNotBlank((CharSequence)orderEo.getShopId())) {
                            orderDeliveryPlanEo.setShopId(Long.valueOf(orderEo.getShopId()));
                        }
                        if (shopBaseDto != null) {
                            orderDeliveryPlanEo.setShopName(shopBaseDto.getName());
                        }
                        if (shopWarehouseDto != null) {
                            orderDeliveryPlanEo.setWarehouseId(shopWarehouseDto.getWarehouseId());
                            orderDeliveryPlanEo.setWarehouseName(shopWarehouseDto.getWarehouseName());
                        }
                        orderCyclePlanEoList.add(orderDeliveryPlanEo);
                    }
                    this.orderDeliveryPlanDas.insertBatch((List)orderCyclePlanEoList);
                    return orderCyclePlanEoList;
                }
            }
        }
        catch (Exception e) {
            logger.error("\u8ba2\u5355{}\u751f\u6210\u914d\u9001\u8ba1\u5212\u5931\u8d25: " + e.getMessage(), (Object)orderEo.getOrderNo(), (Object)e);
            throw e;
        }
        return null;
    }

    private void checkDeliveryStartDate(OrderEo orderEo, TradeItemEo tradeItemEo) {
        logger.info("\u6821\u9a8c\u8ba2\u5355\u662f\u5426\u5ef6\u8fdf\u914d\u9001\u8d77\u6b62\u65e5\u671f: orderNo={}, payTime={}", (Object)orderEo.getOrderNo(), (Object)DateUtil.getDateFormat((Date)orderEo.getPayTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        String orderNo = orderEo.getOrderNo();
        Date payTime = orderEo.getPayTime();
        if (payTime != null) {
            Optional<ItemCycleBuyRespDto> optional;
            Integer cycleType = tradeItemEo.getCycleType();
            Integer[] cycleValue = (Integer[])Stream.of(StringUtils.split((String)tradeItemEo.getCycleValue(), (String)",")).map(Integer::valueOf).toArray(Integer[]::new);
            Integer totalCycleCount = tradeItemEo.getTotalCycleCount();
            Date initCycleStart = tradeItemEo.getInitCycleStart();
            String shopId = tradeItemEo.getShopId();
            String itemId = tradeItemEo.getItemSerial();
            RestResponse restResponse = this.itemCycleBuyQueryApi.queryItemCycleBuy(Long.valueOf(shopId), Long.valueOf(itemId));
            List itemCycleBuyRespDtoList = (List)RestResponseHelper.extractData((RestResponse)restResponse);
            if (CollectionUtils.isNotEmpty((Collection)itemCycleBuyRespDtoList) && (optional = itemCycleBuyRespDtoList.stream().filter(dto -> cycleType.intValue() == dto.getDeliveryType().intValue()).findFirst()).isPresent()) {
                int latestHour = optional.get().getLatestHour() == 24 ? 0 : optional.get().getLatestHour();
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(payTime);
                calendar.add(6, 1);
                payTime = calendar.getTime();
                int payHour = calendar.get(11);
                Date payOfDay = DateUtil.getDayBegin((Date)payTime);
                Date initOfDay = DateUtil.getDayBegin((Date)initCycleStart);
                if (payOfDay.after(initOfDay) || payOfDay.getTime() == initOfDay.getTime() && payHour > latestHour) {
                    logger.info("\u8ba2\u5355{}\u652f\u4ed8\u65f6\u95f4\u8d85\u8fc7\u5f53\u5929{}\u70b9, \u8d77\u59cb\u914d\u9001\u65e5\u671f\u5f80\u540e\u9000\u4e00\u5929", (Object)orderNo, (Object)latestHour);
                    initCycleStart = new DateTime((Object)initCycleStart).plusDays(1).toDate();
                    Map<String, Date> dateMap = this.getCycleBuyEndDate(cycleType, cycleValue, initCycleStart, totalCycleCount);
                    Date cycleStart = dateMap.get("startDate");
                    Date cycleEnd = dateMap.get("endDate");
                    tradeItemEo.setCycleStart(cycleStart);
                    tradeItemEo.setCycleEnd(cycleEnd);
                    this.tradeItemService.modifyTradeItem(tradeItemEo);
                }
            }
        }
    }

    private List<Date> getDeliveryDate(Integer cycleType, Integer[] cycleValue, Integer totalCycleCount, Date cycleStart, Date cycleEnd) {
        LocalDate cycleStartDate = LocalDate.parse(new SimpleDateFormat("yyyy-MM-dd").format(cycleStart));
        LocalDate cycleEndDate = LocalDate.parse(new SimpleDateFormat("yyyy-MM-dd").format(cycleEnd));
        List<Object> list = Lists.newArrayList();
        if (CycleBuyDeliveryTypeEnum.BY_DAY.getCode() == cycleType.intValue()) {
            int rate = cycleValue[0];
            list = Arrays.asList(RateByDayEnum.EVERYDAY.getCode(), RateByDayEnum.EVERY_OTHER_DAY.getCode(), RateByDayEnum.EVERY_TWO_DAYS.getCode(), RateByDayEnum.EVERY_THREE_DAYS.getCode()).contains(rate) ? Stream.iterate(cycleStartDate, date -> date.plusDays(rate)).limit(totalCycleCount.intValue()).map(date -> Date.from(date.atStartOfDay(ZoneId.systemDefault()).toInstant())).collect(Collectors.toList()) : Stream.iterate(cycleStartDate, date -> date.plusDays(1L)).limit(ChronoUnit.DAYS.between(cycleStartDate, cycleEndDate) + 1L).filter(date -> {
                int ordinal = date.getDayOfWeek().getValue();
                if (RateByDayEnum.WORKDAY.getCode() == rate) {
                    return Arrays.asList(1, 2, 3, 4, 5).contains(ordinal);
                }
                if (RateByDayEnum.REST_DAY.getCode() == rate) {
                    return Arrays.asList(6, 7).contains(ordinal);
                }
                return false;
            }).map(date -> Date.from(date.atStartOfDay(ZoneId.systemDefault()).toInstant())).collect(Collectors.toList());
        }
        if (CycleBuyDeliveryTypeEnum.BY_WEEK.getCode() == cycleType.intValue()) {
            ArrayList cycleValueList = Lists.newArrayList((Object[])cycleValue);
            list = Stream.iterate(cycleStartDate, date -> date.plusDays(1L)).limit(ChronoUnit.DAYS.between(cycleStartDate, cycleEndDate) + 1L).filter(date -> {
                int ordinal = date.getDayOfWeek().getValue();
                return cycleValueList.contains(ordinal);
            }).map(date -> Date.from(date.atStartOfDay(ZoneId.systemDefault()).toInstant())).collect(Collectors.toList());
        }
        if (CycleBuyDeliveryTypeEnum.BY_MONTH.getCode() == cycleType.intValue()) {
            Date firstDeliveryDate = null;
            boolean isLastDayOfMonth = RateByMonthEnum.LAST.getCode() == cycleValue[0].intValue();
            int currentDayOfMonth = new DateTime((Object)cycleStart).getDayOfMonth();
            DateTime d1 = new DateTime((Object)cycleStart);
            DateTime d2 = new DateTime((Object)cycleStart).plusMonths(1);
            firstDeliveryDate = isLastDayOfMonth ? new DateTime(d1.getYear(), d1.getMonthOfYear(), d1.dayOfMonth().getMaximumValue(), 0, 0, 0).toDate() : (currentDayOfMonth > cycleValue[0] ? new DateTime(d2.getYear(), d2.getMonthOfYear(), cycleValue[0].intValue(), 0, 0, 0).toDate() : new DateTime(d1.getYear(), d1.getMonthOfYear(), cycleValue[0].intValue(), 0, 0, 0).toDate());
            cycleStartDate = LocalDate.parse(new SimpleDateFormat("yyyy-MM-dd").format(firstDeliveryDate));
            list = Stream.iterate(cycleStartDate, date -> date.plusMonths(1L)).limit(ChronoUnit.MONTHS.between(cycleStartDate, cycleEndDate) + 1L).map(date -> {
                if (isLastDayOfMonth) {
                    LocalDate localDate = date.withDayOfMonth(date.lengthOfMonth());
                    return Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
                }
                return Date.from(date.atStartOfDay(ZoneId.systemDefault()).toInstant());
            }).collect(Collectors.toList());
        }
        return list;
    }

    private Map<String, Date> getCycleBuyEndDate(Integer cycleType, Integer[] cycleValue, Date startDate, Integer totalCycleCount) {
        HashMap dateMap = Maps.newHashMap();
        Date endDate = null;
        try {
            if (CycleBuyDeliveryTypeEnum.BY_DAY.getCode() == cycleType.intValue()) {
                int startDayOfWeek;
                int rate = cycleValue[0];
                if (Arrays.asList(RateByDayEnum.EVERYDAY.getCode(), RateByDayEnum.EVERY_OTHER_DAY.getCode(), RateByDayEnum.EVERY_TWO_DAYS.getCode(), RateByDayEnum.EVERY_THREE_DAYS.getCode()).contains(rate)) {
                    endDate = new DateTime((Object)startDate).plusDays(rate * (totalCycleCount - 1)).toDate();
                }
                int currentDayOfWeek = new DateTime((Object)startDate).getDayOfWeek();
                int totalWorkDayOfWeek = 5;
                int totalRestDayOfWeek = 2;
                if (RateByDayEnum.WORKDAY.getCode() == rate) {
                    int surplusCycleCount;
                    if (Arrays.asList(6, 7).contains(currentDayOfWeek)) {
                        startDate = this.getNextMonday(startDate);
                    }
                    startDayOfWeek = new DateTime((Object)startDate).getDayOfWeek();
                    int surplusExecuteDays = totalWorkDayOfWeek - startDayOfWeek + 1;
                    endDate = totalCycleCount <= surplusExecuteDays ? new DateTime((Object)startDate).plusDays(totalCycleCount - 1).toDate() : ((surplusCycleCount = totalCycleCount - surplusExecuteDays) % totalWorkDayOfWeek == 0 ? new DateTime((Object)this.getNextMonday(startDate)).plusDays((surplusCycleCount / totalWorkDayOfWeek - 1) * 7 + 4).toDate() : new DateTime((Object)this.getNextMonday(startDate)).plusDays(surplusCycleCount / totalWorkDayOfWeek * 7 + surplusCycleCount % totalWorkDayOfWeek - 1).toDate());
                }
                if (RateByDayEnum.REST_DAY.getCode() == rate) {
                    if (!Arrays.asList(6, 7).contains(currentDayOfWeek)) {
                        startDate = new DateTime((Object)this.getNextMonday(startDate)).minusDays(2).toDate();
                    }
                    if (6 == (startDayOfWeek = new DateTime((Object)startDate).getDayOfWeek())) {
                        endDate = new DateTime((Object)startDate).minusDays(5).plusDays(totalCycleCount / totalRestDayOfWeek * 7 + totalCycleCount % totalRestDayOfWeek * 6 - 1).toDate();
                    }
                    if (7 == startDayOfWeek) {
                        if (1 == totalCycleCount) {
                            endDate = startDate;
                        } else {
                            int surplusCycleCount = totalCycleCount - 1;
                            endDate = new DateTime((Object)this.getNextMonday(startDate)).plusDays(surplusCycleCount / totalRestDayOfWeek * 7 + surplusCycleCount % totalRestDayOfWeek * 6 - 1).toDate();
                        }
                    }
                }
            }
            if (CycleBuyDeliveryTypeEnum.BY_WEEK.getCode() == cycleType.intValue()) {
                int currentDayOfWeek = new DateTime((Object)startDate).getDayOfWeek();
                cycleValue = (Integer[])Stream.of(cycleValue).mapToInt(Integer::intValue).sorted().boxed().toArray(Integer[]::new);
                int[] rate = Stream.of(cycleValue).mapToInt(Integer::intValue).sorted().filter(r -> r >= currentDayOfWeek).toArray();
                if (totalCycleCount <= rate.length) {
                    endDate = new DateTime((Object)startDate).plusDays(rate[totalCycleCount - 1] - currentDayOfWeek).toDate();
                } else {
                    int surplusCycleCount = totalCycleCount - rate.length;
                    int maxRate = cycleValue[cycleValue.length - 1];
                    endDate = surplusCycleCount % cycleValue.length == 0 ? new DateTime((Object)this.getNextMonday(startDate)).plusDays((surplusCycleCount / cycleValue.length - 1) * 7 + maxRate - 1).toDate() : new DateTime((Object)this.getNextMonday(startDate)).plusDays(surplusCycleCount / cycleValue.length * 7 + cycleValue[surplusCycleCount % cycleValue.length - 1] - 1).toDate();
                }
                startDate = rate.length > 0 ? new DateTime((Object)startDate).plusDays(rate[0] - currentDayOfWeek).toDate() : new DateTime((Object)startDate).minusDays(currentDayOfWeek - cycleValue[0]).plusDays(7).toDate();
            }
            if (CycleBuyDeliveryTypeEnum.BY_MONTH.getCode() == cycleType.intValue()) {
                int currentDayOfMonth = new DateTime((Object)startDate).getDayOfMonth();
                boolean isLastDayOfMonth = RateByMonthEnum.LAST.getCode() == cycleValue[0].intValue();
                int rate = isLastDayOfMonth ? new DateTime((Object)startDate).dayOfMonth().getMaximumValue() : cycleValue[0].intValue();
                DateTime startDateTime = new DateTime((Object)startDate);
                if (currentDayOfMonth <= rate) {
                    startDate = this.getYearMonthDay(startDateTime.getYear(), startDateTime.getMonthOfYear(), rate, isLastDayOfMonth);
                } else {
                    DateTime nextStartDateTime = startDateTime.plusMonths(1);
                    startDate = this.getYearMonthDay(nextStartDateTime.getYear(), nextStartDateTime.getMonthOfYear(), rate, isLastDayOfMonth);
                }
                DateTime endMonth = new DateTime((Object)startDate).plusMonths(totalCycleCount - 1);
                endDate = this.getYearMonthDay(endMonth.getYear(), endMonth.getMonthOfYear(), rate, isLastDayOfMonth);
            }
        }
        catch (Exception e) {
            logger.error("\u8ba1\u7b97\u914d\u7f6e\u5468\u671f\u7684\u5230\u65e5\u671f\u5931\u8d25: " + e.getMessage(), (Throwable)e);
        }
        dateMap.put("startDate", startDate);
        dateMap.put("endDate", endDate);
        return dateMap;
    }

    private Date getNextMonday(Date date) {
        org.joda.time.LocalDate today = new org.joda.time.LocalDate((Object)date);
        int old = today.getDayOfWeek();
        org.joda.time.LocalDate next = today.plusDays(8 - old);
        return next.toDate();
    }

    private Date getYearMonthDay(int year, int month, int day, boolean isLastDay) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, year);
        calendar.set(2, month - 1);
        if (isLastDay) {
            calendar.set(5, calendar.getActualMaximum(5));
        } else {
            calendar.set(5, day);
        }
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTime();
    }
}

