/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.customer.biz.customer.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.AuditInfoDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.constants.AddressTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.constants.AuditStatusEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.constants.CustomerTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.constants.SettleStatusEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.constants.StatusEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.AuditOperationResultDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.CertificationDeadlineDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.CompanyInfoDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.CustomerAddResultDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.CustomerInfoDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.OrgInfoDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.SettleStatusDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.AddressAddReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerAreaListReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerAuditReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerCheckReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerSearchReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.ExportRecordReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.RCustomerSalesmanReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.UserAccountReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.AddressRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.BaseRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.BillInfoRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CertificationCountRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.ContactsInfoRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerAreaRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerCheckRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerExtDetailRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerNameSimpleRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.InvoiceInfoRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.UserAccountRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.exception.CustomerBusinessRuntimeException;
import com.dtyunxi.yundt.cube.center.customer.api.customer.exception.CustomerExceptionCode;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.mq.producer.CustomerChangeProducer;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.service.IAddressService;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.service.IBillInfoService;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.service.IContactsInfoService;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.service.ICustomerAreaService;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.service.ICustomerExtService;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.service.ICustomerService;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.service.IRCustomerSalesmanService;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.util.AssertUtil;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.util.MybatisPlusUtils;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.util.NoGenUtil;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.CustomerDas;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.CustomerExportRecordDas;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.CustomerGroupDas;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.CustomerLevelDas;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.CustomerSalesmanDas;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.CustomerStatusDas;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.CustomerTypeDas;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.RCustomerRegionDas;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.RCustomerSalesmanDas;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.mapper.CustomerMapper;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.mapper.CustomerRelationBaseMapper;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.CustomerEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.CustomerExportRecordEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.CustomerLevelEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.CustomerSalesmanEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.CustomerStatusEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.CustomerTypeEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.RCustomerRegionEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.RCustomerSalesmanEo;
import com.dtyunxi.yundt.cube.center.customer.dao.stdeo.customer.StdCustomerEo;
import com.dtyunxi.yundt.cube.center.customer.dao.stdeo.customer.StdCustomerGroupEo;
import com.dtyunxi.yundt.cube.center.customer.dao.stdeo.customer.StdCustomerLevelEo;
import com.dtyunxi.yundt.cube.center.customer.dao.stdeo.customer.StdCustomerSalesmanEo;
import com.dtyunxi.yundt.cube.center.customer.dao.stdeo.customer.StdCustomerTypeEo;
import com.dtyunxi.yundt.cube.center.customer.dao.stdeo.customer.StdRCustomerRegionEo;
import com.dtyunxi.yundt.cube.center.data.api.query.IAreaGroupQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SellerQueryReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.IAccessApi;
import com.dtyunxi.yundt.cube.center.user.api.IOrganizationApi;
import com.dtyunxi.yundt.cube.center.user.api.IOrganizationExtApi;
import com.dtyunxi.yundt.cube.center.user.api.IUserApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationInfoDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgAdvAddReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgAdvInfoReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgAdvModifyReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgAdvQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.UserOrgRelationQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.UserOrgRelationReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.tcbj.EmployeeExtQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.BizOrganizationRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.EmployeeExtRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAdvDetailRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAdvInfoRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAdvOpRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAdvRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAndOrgInfoRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.RoleRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.UserRespDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IAccessQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IBizOrganizationQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IEmployeeExpandQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryExtApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IUserQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="customerV2Service")
public class CustomerExtServiceImpl
implements ICustomerExtService {
    private Logger logger = LoggerFactory.getLogger(CustomerExtServiceImpl.class);
    @Resource
    private ICacheService cacheService;
    @Resource
    private CustomerDas customerDas;
    @Resource
    private CustomerTypeDas customerTypeDas;
    @Resource
    private CustomerExportRecordDas customerExportRecordDas;
    @Resource
    private IContext context;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private CustomerStatusDas customerStatusDas;
    @Resource
    private CustomerGroupDas customerGroupDas;
    @Resource
    private RCustomerRegionDas rCustomerRegionDas;
    @Resource
    private CustomerLevelDas customerLevelDas;
    @Resource
    private IOrganizationExtApi organizationExtApi;
    @Resource
    private IOrganizationQueryExtApi organizationQueryExtApi;
    @Resource
    private IEmployeeExpandQueryApi employeeExpandQueryApi;
    @Resource
    private IUserQueryApi userQueryApi;
    @Value(value="${yundt.cube.customer.orgRootId}")
    private Long orgRootId;
    @Resource
    private IUserApi userApi;
    @Resource
    private ICustomerService customerService;
    @Resource
    private IContactsInfoService contactsInfoService;
    @Resource
    private IBillInfoService billInfoService;
    @Resource
    private IAddressService addressService;
    @Resource
    private IAreaGroupQueryApi areaGroupQueryApi;
    @Resource
    private ICustomerAreaService customerAreaService;
    @Resource
    private IOrganizationQueryApi organizationQueryApi;
    @Resource
    private IOrganizationApi organizationApi;
    @Resource
    private IAccessApi accessApi;
    @Resource
    private IAccessQueryApi accessQueryApi;
    @Resource
    private IBizOrganizationQueryApi bizOrganizationQueryApi;
    @Value(value="${yundt.cube.customer.dealerRoleCode}")
    private String dealerRoleCode;
    @Value(value="${yundt.cube.customer.mallPattern:1}")
    private Integer mallPattern;
    @Value(value="${yundt.cube.customer.generate.code:false}")
    private Boolean generateCustomerCode;
    @Resource
    private CustomerChangeProducer customerChangeProducer;
    @Resource
    private CustomerSalesmanDas customerSalesmanDas;
    @Resource
    private RCustomerSalesmanDas rCustomerSalesmanDas;
    @Autowired
    private IRCustomerSalesmanService rCustomerSalesmanService;
    @Resource
    private ISellerQueryApi sellerQueryApi;
    @Resource
    private CustomerRelationBaseMapper customerRelationBaseMapper;
    @Resource
    private IOrganizationQueryExtApi iOrganizationQueryExtApi;

    @Override
    public CustomerAddResultDto add(CustomerReqDto reqDto) {
        OrganizationInfoDto organizationInfoDto;
        RestResponse listRestResponse;
        Long orgInfoId;
        UserDto userDto;
        Integer adminFlag;
        String code = reqDto.getCode();
        reqDto.setId(null);
        if (this.generateCustomerCode.booleanValue() || StringUtils.isBlank((CharSequence)reqDto.getCode())) {
            code = this.generateCustomerCode(reqDto);
            reqDto.setCode(code);
            if (StringUtils.isBlank((CharSequence)reqDto.getExternalCode())) {
                reqDto.setExternalCode(code);
                reqDto.setEasCode(code);
            }
        }
        this.validCustomerCode(reqDto, reqDto.getTenantId());
        Assert.notNull((Object)reqDto.getCompanyInfoDto(), (String)"\u516c\u53f8\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        CompanyInfoDto companyInfoDto = reqDto.getCompanyInfoDto();
        if (companyInfoDto != null && !StringUtils.equals((CharSequence)"zooid", (CharSequence)companyInfoDto.getSubjectType())) {
            Assert.notNull((Object)reqDto.getCompanyInfoDto().getCreditCode(), (String)"\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Assert.notNull((Object)reqDto.getCompanyInfoDto().getOrgName(), (String)"\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Assert.notNull((Object)reqDto.getCompanyInfoDto().getLegalName(), (String)"\u6cd5\u4eba\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
        if (companyInfoDto != null && StringUtils.equals((CharSequence)"zooid", (CharSequence)companyInfoDto.getSubjectType())) {
            Assert.notNull((Object)reqDto.getCompanyInfoDto().getLegalCardNum(), (String)"\u8eab\u4efd\u8bc1\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
        Long currentUserOrgId = reqDto.getOrgId();
        List orgAdvInfoRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.iOrganizationQueryExtApi.queryOrgAdvInfoListByCreditCode(reqDto.getCompanyInfoDto().getCreditCode()));
        this.logger.info("\u4fe1\u7528\u4ee3\u7801\u7ec4\u7ec7\u4fe1\u606f:{},tenantId:{},instanceId:{}", new Object[]{JSONArray.toJSON((Object)orgAdvInfoRespDtoList), this.context.tenantId(), this.context.instanceId()});
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)orgAdvInfoRespDtoList) && StringUtils.isNotBlank((CharSequence)((OrgAdvInfoRespDto)orgAdvInfoRespDtoList.get(0)).getOrgCode())) {
            List orgIdList = orgAdvInfoRespDtoList.stream().map(OrgAdvInfoRespDto::getOrgCode).collect(Collectors.toList());
            List eoList = ((ExtQueryChainWrapper)this.customerDas.filter().in((Object)"code", orgIdList)).list();
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)eoList)) {
                AssertUtil.isFalse(eoList.stream().anyMatch(r -> Objects.equals(r.getMerchantId(), 1000000000000000001L) || Objects.equals(r.getMerchantId(), 1000000000000000002L) || Objects.equals(r.getMerchantId(), 1000000000000000003L) || CustomerTypeEnum.DEALER.getCode().equals(r.getType())), "\u4e00\u7ea7\u7ecf\u9500\u5546\u7684\u4fe1\u7528\u4ee3\u7801\u4e0d\u7ed9\u65b0\u589e");
                ServiceContext serviceContext = ServiceContext.getContext();
                String object = Optional.ofNullable(serviceContext.getAttachment("yes.req.cus.b2b.organizationId")).orElse(serviceContext.getAttachment("yes.req.cus.b2b.organizationid"));
                Long orgId = Optional.ofNullable(reqDto.getOrgId()).orElse(Optional.ofNullable(object).map(Long::valueOf).orElse(null));
                Assert.notNull((Object)orgId, (String)"\u8bf7\u6c42\u5934\u7ec4\u7ec7id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                List merchantIdList = eoList.stream().map(StdCustomerEo::getMerchantId).distinct().collect(Collectors.toList());
                if (!org.springframework.util.CollectionUtils.isEmpty(merchantIdList) && merchantIdList.contains(orgId)) {
                    throw new CustomerBusinessRuntimeException("\u540c\u4e00\u4e2a\u79df\u6237\u4e0b\u5df2\u7ecf\u5b58\u5728\u8be5\u4fe1\u7528\u4ee3\u7801\uff0c\u4e0d\u80fd\u65b0\u589e");
                }
            }
        }
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)orgAdvInfoRespDtoList) && Objects.isNull(reqDto.getCompanyInfoDto().getOrgInfoId())) {
            Optional.of(orgAdvInfoRespDtoList).ifPresent(r -> {
                List organizationDtos = (List)RestResponseHelper.extractData((RestResponse)this.organizationQueryApi.queryListByOrgCode(((OrgAdvInfoRespDto)orgAdvInfoRespDtoList.get(0)).getInstanceId(), (List)Lists.newArrayList((Object[])new String[]{((OrgAdvInfoRespDto)r.get(0)).getOrgCode()})));
                OrganizationDto organizationDto = (OrganizationDto)organizationDtos.get(0);
                reqDto.getCompanyInfoDto().setOrgInfoId(organizationDto.getId());
                reqDto.getCompanyInfoDto().setOrgCode(((OrgAdvInfoRespDto)r.get(0)).getOrgCode());
                reqDto.getCompanyInfoDto().setTenantId(((OrgAdvInfoRespDto)orgAdvInfoRespDtoList.get(0)).getTenantId());
            });
        }
        if (Objects.isNull(adminFlag = (Integer)this.cacheService.hget("COMMON", "USER_ADMIN_KEY", this.context.userId() + "", Integer.class)) && Objects.equals((userDto = (UserDto)RestResponseHelper.extractData((RestResponse)this.userQueryApi.queryById(this.context.userId(), "{}"))).getUserType(), 11)) {
            adminFlag = 1;
            this.cacheService.hset("COMMON", "USER_ADMIN_KEY", this.context.userId() + "", (Object)1, 0);
        }
        boolean isBb = Objects.equals(adminFlag, 1);
        if (CustomerTypeEnum.DEALER.getCode().equals(reqDto.getType())) {
            if (Objects.isNull(currentUserOrgId)) {
                currentUserOrgId = this.getCurrentUserOrgId();
            }
            reqDto.setMerchantId(currentUserOrgId);
        } else if (CustomerTypeEnum.RETAILER.getCode().equals(reqDto.getType()) || isBb) {
            if (CustomerTypeEnum.DEALER.getCode().equals(reqDto.getChannel())) {
                if (Objects.isNull(currentUserOrgId)) {
                    currentUserOrgId = this.getCurrentUserOrgId();
                }
                reqDto.setMerchantId(currentUserOrgId);
            }
            Assert.notNull((Object)reqDto.getMerchantId(), (String)"\u6240\u5c5e\u5546\u5bb6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
        if (Objects.isNull(reqDto.getCompanyInfoDto().getOrgInfoId())) {
            OrgAdvAddReqDto orgAdvAddReqDto = new OrgAdvAddReqDto();
            OrgAdvInfoReqDto orgAdvInfoReqDto = new OrgAdvInfoReqDto();
            CubeBeanUtils.copyProperties((Object)orgAdvInfoReqDto, (Object)reqDto.getCompanyInfoDto(), (String[])new String[0]);
            orgAdvAddReqDto.setOrgAdvInfoReqDto(orgAdvInfoReqDto);
            orgAdvAddReqDto.setCode(code);
            orgAdvAddReqDto.setName(reqDto.getCompanyInfoDto().getOrgName());
            orgAdvAddReqDto.setEntityPropCode("company");
            orgAdvAddReqDto.setType("2");
            orgAdvAddReqDto.setParentId(this.orgRootId);
            orgAdvAddReqDto.setTenantId(Long.valueOf(1L));
            RestResponse add = this.organizationExtApi.add(orgAdvAddReqDto);
            if (!"0".equals(add.getResultCode())) {
                if (add.getResultMsg().equals(CustomerExceptionCode.ORG_NAME_EXISTS.getMsg())) {
                    throw new CustomerBusinessRuntimeException(CustomerExceptionCode.COMPANY_NAME_EXISTS.getCode(), CustomerExceptionCode.COMPANY_NAME_EXISTS.getMsg());
                }
                throw new BizException(add.getResultCode(), add.getResultMsg());
            }
            orgInfoId = ((OrgAdvOpRespDto)add.getData()).getOrgId();
            if (StringUtils.isNotEmpty((CharSequence)reqDto.getCompanyInfoDto().getProvinceCode())) {
                AddressAddReqDto addressReqDto = new AddressAddReqDto();
                CubeBeanUtils.copyProperties((Object)addressReqDto, (Object)reqDto.getCompanyInfoDto(), (String[])new String[0]);
                addressReqDto.setOrgInfoId(orgInfoId);
                addressReqDto.setAddressType(AddressTypeEnum.COMPANY.getCode());
                this.addressService.addAddress(addressReqDto);
            }
        } else {
            Assert.notNull((Object)reqDto.getCompanyInfoDto().getOrgCode(), (String)"\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Assert.notNull((Object)reqDto.getCompanyInfoDto().getOrgInfoId(), (String)"\u7ec4\u7ec7ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            CustomerEo queryEo = CustomerEo.newInstance();
            queryEo.setOrgInfoId(reqDto.getCompanyInfoDto().getOrgInfoId());
            queryEo.setMerchantId(reqDto.getMerchantId());
            List customerEoList = this.customerDas.select((BaseEo)queryEo);
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)customerEoList)) {
                if (CustomerTypeEnum.DEALER.getCode().equals(reqDto.getType())) {
                    throw new CustomerBusinessRuntimeException(CustomerExceptionCode.DEALER_CUSTOMER_EXISTS.getCode(), String.format(CustomerExceptionCode.DEALER_CUSTOMER_EXISTS.getMsg(), ((CustomerEo)customerEoList.get(0)).getCode()));
                }
                if (CustomerTypeEnum.RETAILER.getCode().equals(reqDto.getType())) {
                    throw new CustomerBusinessRuntimeException(CustomerExceptionCode.RETAILER_CUSTOMER_EXISTS.getCode(), String.format(CustomerExceptionCode.RETAILER_CUSTOMER_EXISTS.getMsg(), ((CustomerEo)customerEoList.get(0)).getCode()));
                }
                code = queryEo.getCode();
                Long i = this.cacheService.incr(code);
                String str = String.format("%01d", i);
                reqDto.setCode(str);
            }
            this.updateOrgInfo(reqDto.getCompanyInfoDto());
            this.addressService.removeAddressByOrgInfoIdAndType(reqDto.getCompanyInfoDto().getOrgInfoId(), AddressTypeEnum.COMPANY.getCode());
            if (StringUtils.isNotEmpty((CharSequence)reqDto.getCompanyInfoDto().getProvinceCode())) {
                AddressAddReqDto addressReqDto = new AddressAddReqDto();
                CubeBeanUtils.copyProperties((Object)addressReqDto, (Object)reqDto.getCompanyInfoDto(), (String[])new String[0]);
                addressReqDto.setOrgInfoId(reqDto.getCompanyInfoDto().getOrgInfoId());
                addressReqDto.setAddressType(AddressTypeEnum.COMPANY.getCode());
                addressReqDto.setStatus(Integer.valueOf(0));
                this.addressService.addAddress(addressReqDto);
            }
            orgInfoId = reqDto.getCompanyInfoDto().getOrgInfoId();
        }
        reqDto.setOrgInfoId(orgInfoId);
        CustomerEo customerEo = CustomerEo.newInstance();
        this.initCustomerEo(reqDto, customerEo);
        customerEo.setAuditStatus(AuditStatusEnum.DRAFT.getCode());
        customerEo.setSettleStatus(SettleStatusEnum.UNSETTLE.getCode());
        UserOrgRelationQueryReqDto relationQueryReqDto = new UserOrgRelationQueryReqDto();
        relationQueryReqDto.setOrgId(orgInfoId);
        RestResponse pageInfoRestResponse = this.organizationQueryApi.queryUserOrgRelation(relationQueryReqDto, Integer.valueOf(1), Integer.valueOf(1));
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResponse);
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
            customerEo.setUserId(((UserRespDto)pageInfo.getList().get(0)).getId());
        }
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)((Collection)(listRestResponse = this.organizationQueryApi.queryOrgAndOrgInfoByIds((List)Lists.newArrayList((Object[])new Long[]{orgInfoId}))).getData())) && (organizationInfoDto = ((OrgAndOrgInfoRespDto)((List)listRestResponse.getData()).get(0)).getOrganizationInfoDto()) != null && StringUtils.isNotEmpty((CharSequence)organizationInfoDto.getCreditCode())) {
            customerEo.setIfCertification(Integer.valueOf(1));
        }
        if (StringUtils.isEmpty((CharSequence)customerEo.getThirdParentPartyId()) && Objects.nonNull(customerEo.getMerchantId())) {
            this.logger.info("\u586b\u5145");
            SellerQueryReqDto sellerQueryReqDto = new SellerQueryReqDto();
            sellerQueryReqDto.setOrganizationId(customerEo.getMerchantId());
            CustomerEo finalCustomerEo = customerEo;
            Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.sellerQueryApi.queryListOnPost(sellerQueryReqDto))).filter(CollUtil::isNotEmpty).map(r -> (SellerRespDto)r.get(0)).ifPresent(r -> {
                finalCustomerEo.setThirdParentPartyId(r.getCode());
                finalCustomerEo.setThirdPartyMappingId(r.getCode());
            });
            if (StringUtils.isEmpty((CharSequence)customerEo.getThirdPartyId())) {
                customerEo.setThirdPartyId(NoGenUtil.generateCode("ZT"));
            }
        }
        customerEo.setOrgInfoId(orgInfoId);
        this.customerDas.insert((BaseEo)customerEo);
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)reqDto.getRegionCodeList())) {
            ArrayList<RCustomerRegionEo> customerRegionEos = new ArrayList<RCustomerRegionEo>(reqDto.getRegionCodeList().size());
            for (String regionCode : reqDto.getRegionCodeList()) {
                RCustomerRegionEo customerRegionEo = new RCustomerRegionEo();
                customerRegionEo.setCustomerId(customerEo.getId());
                customerRegionEo.setRegionCode(regionCode);
                customerRegionEos.add(customerRegionEo);
            }
            this.rCustomerRegionDas.insertBatch(customerRegionEos);
        }
        CustomerAddResultDto resultDto = new CustomerAddResultDto();
        resultDto.setCustomerId(customerEo.getId());
        resultDto.setOrgInfoId(orgInfoId);
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)reqDto.getSalesmanIds())) {
            RCustomerSalesmanReqDto salesmanReqDto = new RCustomerSalesmanReqDto();
            salesmanReqDto.setCustomerId(reqDto.getId());
            salesmanReqDto.setSalesmanIds(reqDto.getSalesmanIds());
            salesmanReqDto.setOrgId(currentUserOrgId);
            this.rCustomerSalesmanService.add(salesmanReqDto);
        }
        CustomerAuditReqDto auditReqDto = new CustomerAuditReqDto();
        auditReqDto.setAuditStatus("PASS");
        auditReqDto.setCustomerId(customerEo.getId());
        this.auditCustomer(auditReqDto);
        return resultDto;
    }

    private String generateCustomerCode(CustomerReqDto reqDto) {
        Long customerTypeId = reqDto.getCustomerTypeId();
        String code = ((CustomerTypeEo)((ExtQueryChainWrapper)this.customerTypeDas.filter().eq((Object)"id", (Object)customerTypeId)).one()).getCode();
        return NoGenUtil.generateCode(code);
    }

    private CustomerInfoDto createCustomerInfo(CustomerEo customerEo) {
        CustomerInfoDto customerInfoDto = new CustomerInfoDto();
        customerInfoDto.setCustomerId(customerEo.getId());
        customerInfoDto.setCustomerCode(customerEo.getCode());
        customerInfoDto.setCustomerName(customerEo.getName());
        customerInfoDto.setCustomerTypeId(customerEo.getCustomerTypeId());
        customerInfoDto.setOrgId(customerEo.getOrgInfoId());
        customerInfoDto.setInstanceId(this.context.instanceId());
        customerInfoDto.setTenantId(this.context.tenantId());
        customerInfoDto.setMerchantId(customerEo.getMerchantId());
        return customerInfoDto;
    }

    @Override
    public void update(CustomerReqDto reqDto) {
        Long currentUserOrgId;
        CompanyInfoDto companyInfoDto;
        Assert.notNull((Object)reqDto.getId(), (String)CustomerExceptionCode.PK_ID_NULL.getMsg(), (Object[])new Object[0]);
        CustomerEo queryEo = (CustomerEo)this.customerDas.selectByPrimaryKey(reqDto.getId());
        Assert.notNull((Object)queryEo, (String)CustomerExceptionCode.CUSTOMER_NON_EXIST.getMsg(), (Object[])new Object[0]);
        this.validCustomerCode(reqDto, reqDto.getTenantId());
        if (CustomerTypeEnum.RETAILER.getCode().equals(reqDto.getType())) {
            Assert.notNull((Object)reqDto.getMerchantId(), (String)"\u6240\u5c5e\u5546\u5bb6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
        if (Objects.nonNull(companyInfoDto = reqDto.getCompanyInfoDto())) {
            Assert.notNull((Object)companyInfoDto.getCreditCode(), (String)"\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Assert.notNull((Object)companyInfoDto.getOrgInfoId(), (String)"\u7ec4\u7ec7ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            RestResponse orgAdvDetailRestResp = this.organizationQueryExtApi.queryById(companyInfoDto.getOrgInfoId());
            OrgAdvDetailRespDto orgAdvDetailRespDto = (OrgAdvDetailRespDto)RestResponseHelper.extractData((RestResponse)orgAdvDetailRestResp);
            this.logger.info("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u4e3a:{}", (Object)JSONObject.toJSONString((Object)orgAdvDetailRespDto));
            companyInfoDto.setOrgCode(orgAdvDetailRespDto.getCode());
            Assert.notNull((Object)companyInfoDto.getOrgCode(), (String)"\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Assert.notNull((Object)companyInfoDto.getOrgName(), (String)"\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Assert.notNull((Object)companyInfoDto.getLegalName(), (String)"\u6cd5\u4eba\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Assert.notNull((Object)reqDto.getMerchantId(), (String)"\u6240\u5c5e\u5546\u5bb6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            List customerEoList = this.customerDas.getMapper().selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"org_info_id", (Object)companyInfoDto.getOrgInfoId())).eq((Object)"merchant_id", (Object)reqDto.getMerchantId())).ne((Object)"id", (Object)reqDto.getId()));
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)customerEoList)) {
                if (CustomerTypeEnum.DEALER.getCode().equals(reqDto.getType())) {
                    throw new CustomerBusinessRuntimeException(CustomerExceptionCode.DEALER_CUSTOMER_EXISTS.getCode(), String.format(CustomerExceptionCode.DEALER_CUSTOMER_EXISTS.getMsg(), ((CustomerEo)customerEoList.get(0)).getCode()));
                }
                if (CustomerTypeEnum.RETAILER.getCode().equals(reqDto.getType())) {
                    throw new CustomerBusinessRuntimeException(CustomerExceptionCode.RETAILER_CUSTOMER_EXISTS.getCode(), String.format(CustomerExceptionCode.RETAILER_CUSTOMER_EXISTS.getMsg(), ((CustomerEo)customerEoList.get(0)).getCode()));
                }
            }
            this.updateOrgInfo(companyInfoDto);
            this.addressService.removeAddressByOrgInfoIdAndType(companyInfoDto.getOrgInfoId(), AddressTypeEnum.COMPANY.getCode());
            if (StringUtils.isNotEmpty((CharSequence)companyInfoDto.getProvinceCode())) {
                AddressAddReqDto addressReqDto = new AddressAddReqDto();
                CubeBeanUtils.copyProperties((Object)addressReqDto, (Object)companyInfoDto, (String[])new String[0]);
                addressReqDto.setOrgInfoId(companyInfoDto.getOrgInfoId());
                addressReqDto.setAddressType(AddressTypeEnum.COMPANY.getCode());
                this.addressService.addAddress(addressReqDto);
            }
            reqDto.setOrgInfoId(companyInfoDto.getOrgInfoId());
        }
        CustomerEo customerEo = new CustomerEo();
        reqDto.setThirdPartyId(null);
        reqDto.setOrgInfoId(null);
        reqDto.setThirdParentPartyId(null);
        this.initCustomerEo(reqDto, customerEo);
        this.customerDas.updateSelective((BaseEo)customerEo);
        RCustomerRegionEo deleteEo = new RCustomerRegionEo();
        deleteEo.setCustomerId(reqDto.getId());
        this.rCustomerRegionDas.delete((BaseEo)deleteEo);
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)reqDto.getRegionCodeList())) {
            ArrayList<RCustomerRegionEo> customerRegionEos = new ArrayList<RCustomerRegionEo>(reqDto.getRegionCodeList().size());
            for (String regionCode : reqDto.getRegionCodeList()) {
                RCustomerRegionEo customerRegionEo = new RCustomerRegionEo();
                customerRegionEo.setCustomerId(reqDto.getId());
                customerRegionEo.setRegionCode(regionCode);
                customerRegionEos.add(customerRegionEo);
            }
            this.rCustomerRegionDas.insertBatch(customerRegionEos);
        }
        if (Objects.isNull(currentUserOrgId = reqDto.getOrgId())) {
            currentUserOrgId = this.getCurrentUserOrgId();
        }
        RCustomerSalesmanReqDto salesmanReqDto = new RCustomerSalesmanReqDto();
        salesmanReqDto.setCustomerId(reqDto.getId());
        salesmanReqDto.setSalesmanIds(reqDto.getSalesmanIds());
        salesmanReqDto.setOrgId(currentUserOrgId);
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)reqDto.getSalesmanIds())) {
            this.rCustomerSalesmanService.update(salesmanReqDto);
        }
        CubeBeanUtils.copyProperties((Object)queryEo, (Object)customerEo, (String[])new String[0]);
        String regionCodes = StringUtils.join((Iterable)reqDto.getRegionCodeList(), (String)",");
        String regionNames = StringUtils.join((Iterable)reqDto.getRegionNameList(), (String)",");
        this.sendMq(queryEo, regionNames, regionCodes);
    }

    @Override
    public void sendMq(CustomerEo customerEo, String regionNames, String regionCodes) {
        CustomerRespDto customerRespDto = new CustomerRespDto();
        this.logger.info("\u53d1\u9001mq\u5f53\u524d\u7c7b=CustomerServiceImpl.sendMq()customerEo = [" + customerEo + "], regionNames = [" + regionNames + "], regionNames = [" + regionCodes + "]");
        try {
            if (customerEo.getCustomerTypeId() != null) {
                CustomerTypeEo customerTypeEo = (CustomerTypeEo)this.customerTypeDas.selectByPrimaryKey(customerEo.getCustomerTypeId());
                customerRespDto.setCustomerTypeName(customerTypeEo.getName());
            }
            if (customerEo.getStatusId() != null) {
                CustomerStatusEo customerStatusEo = (CustomerStatusEo)this.customerStatusDas.selectByPrimaryKey(customerEo.getStatusId());
                customerRespDto.setStatusName(customerStatusEo.getName());
            }
            customerRespDto.setStatusId(customerEo.getStatusId());
            customerRespDto.setId(customerEo.getId());
            customerRespDto.setCode(customerEo.getCode());
            customerRespDto.setName(customerEo.getName());
            customerRespDto.setRegionId(customerEo.getRegionId());
            customerRespDto.setRegionCode(regionCodes);
            customerRespDto.setRegion(regionNames);
            customerRespDto.setCustomerTypeId(customerEo.getCustomerTypeId());
            customerRespDto.setCustomerId(customerEo.getId());
            customerRespDto.setId(customerEo.getId());
            this.commonsMqService.sendSingleMessage("CUSTOMER_UPDATE", (Object)customerRespDto);
            this.logger.info("\u53d1\u9001\u5ba2\u6237\u66f4\u65b0\u5e7f\u64ad\u6d88\u606f: {}", (Object)JSON.toJSONString((Object)customerRespDto));
            this.commonsMqService.publishMessageAsync("CUSTOMER_UPDATE_PUBLISH", (Object)JSON.toJSONString((Object)customerRespDto));
        }
        catch (Exception e) {
            this.logger.debug(e.getMessage());
        }
    }

    @Override
    public List<CustomerNameSimpleRespDto> queryByListParent(Long customerId, Integer type, Long superiorOrgId) {
        ArrayList<Long> customerIds = new ArrayList<Long>();
        customerIds.add(customerId);
        List customerNameSimpleRespDtos = this.customerDas.queryListByParentIds(customerIds);
        List<Long> sunParentIds = customerNameSimpleRespDtos.stream().map(CustomerNameSimpleRespDto::getId).collect(Collectors.toList());
        if (!org.springframework.util.CollectionUtils.isEmpty(sunParentIds)) {
            customerNameSimpleRespDtos.addAll(this.getCustomerRespDtos(sunParentIds));
        }
        List collect = customerNameSimpleRespDtos.stream().map(CustomerNameSimpleRespDto::getId).collect(Collectors.toList());
        collect.add(customerId);
        if (Objects.isNull(superiorOrgId)) {
            superiorOrgId = this.getCurrentUserOrgId();
        }
        List customerNameSimpleRespDtos1 = this.customerDas.queryListByNotIds(this.context.instanceId(), this.context.tenantId(), collect, type, superiorOrgId);
        return customerNameSimpleRespDtos1;
    }

    private List<CustomerNameSimpleRespDto> getCustomerRespDtos(List<Long> parentIds) {
        List customerNameSimpleRespDtos = this.customerDas.queryListByParentIds(parentIds);
        List<Long> sunParentIds = customerNameSimpleRespDtos.stream().map(CustomerNameSimpleRespDto::getId).collect(Collectors.toList());
        if (!org.springframework.util.CollectionUtils.isEmpty(sunParentIds)) {
            customerNameSimpleRespDtos.addAll(this.getCustomerRespDtos(sunParentIds));
        }
        return customerNameSimpleRespDtos;
    }

    @Override
    public CustomerExtDetailRespDto queryById(Long id) {
        List<AddressRespDto> addressRespDtos;
        InvoiceInfoRespDto invoiceInfoRespDto;
        List<BillInfoRespDto> billInfoRespDtos;
        List<ContactsInfoRespDto> contactsInfoRespDtos;
        CustomerExtDetailRespDto customerDetailRespDto = new CustomerExtDetailRespDto();
        CustomerRespDto customerRespDto = this.customerService.queryById(id);
        BeanUtils.copyProperties((Object)customerRespDto, (Object)customerDetailRespDto);
        RestResponse orgAdvDetailRestResp = this.organizationQueryExtApi.queryById(customerRespDto.getOrgInfoId());
        OrgAdvDetailRespDto orgAdvDetailRespDto = (OrgAdvDetailRespDto)RestResponseHelper.extractData((RestResponse)orgAdvDetailRestResp);
        CompanyInfoDto companyInfoDto = new CompanyInfoDto();
        OrgAdvInfoRespDto orgAdvInfoRespDto = orgAdvDetailRespDto.getOrgAdvInfoRespDto();
        if (Objects.nonNull(orgAdvInfoRespDto)) {
            BeanUtils.copyProperties((Object)orgAdvInfoRespDto, (Object)companyInfoDto);
        }
        this.logger.info("\u52a0\u8f7d\u5230\u7684\u516c\u53f8\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)companyInfoDto));
        companyInfoDto.setOrgInfoId(customerRespDto.getOrgInfoId());
        List<AddressRespDto> addressList = this.addressService.queryAddressListByOrgInfoIdAndType(companyInfoDto.getOrgInfoId(), Lists.newArrayList((Object[])new String[]{AddressTypeEnum.COMPANY.getCode()}));
        if (!org.springframework.util.CollectionUtils.isEmpty(addressList)) {
            BeanUtil.copyProperties((Object)addressList.get(0), (Object)companyInfoDto, (CopyOptions)CopyOptions.create().ignoreNullValue());
        }
        customerDetailRespDto.setCompanyInfoDto(companyInfoDto);
        List employeeIds = this.customerDas.queryRelEmployeeIdsByCustomerId(customerRespDto.getId());
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)employeeIds)) {
            customerDetailRespDto.setSalesmanIds(employeeIds.stream().map(String::valueOf).collect(Collectors.joining(",")));
            customerDetailRespDto.setSalesmanId((Long)employeeIds.get(0));
            EmployeeExtQueryReqDto reqDto = new EmployeeExtQueryReqDto();
            reqDto.setIds(employeeIds);
            reqDto.setPageSize(Integer.valueOf(10000));
            reqDto.setPageNum(Integer.valueOf(1));
            PageInfo dtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.employeeExpandQueryApi.queryByPage(reqDto));
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)dtoPageInfo.getList())) {
                customerDetailRespDto.setSalesmanName(dtoPageInfo.getList().stream().map(EmployeeExtRespDto::getName).collect(Collectors.joining(",")));
                customerDetailRespDto.setSalesmanNames(dtoPageInfo.getList().stream().map(EmployeeExtRespDto::getName).collect(Collectors.joining(",")));
            }
        }
        if (Objects.nonNull(customerRespDto.getUserId())) {
            UserAccountRespDto userAccount = this.createUserAccount(customerRespDto.getUserId(), customerRespDto.getOrgInfoId());
            customerDetailRespDto.setUserAccount(userAccount);
        } else {
            UserOrgRelationQueryReqDto relationQueryReqDto = new UserOrgRelationQueryReqDto();
            relationQueryReqDto.setOrgId(customerRespDto.getOrgInfoId());
            RestResponse pageInfoRestResponse = this.organizationQueryApi.queryUserOrgRelation(relationQueryReqDto, Integer.valueOf(1), Integer.valueOf(1));
            PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResponse);
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
                Long userId = ((UserRespDto)pageInfo.getList().get(0)).getId();
                UserAccountRespDto userAccount = this.createUserAccount(userId, customerRespDto.getOrgInfoId());
                customerDetailRespDto.setUserAccount(userAccount);
            }
        }
        if (CollUtil.isNotEmpty((Collection)customerRespDto.getRegionCodeList())) {
            CustomerAreaListReqDto customerAreaListReqDto = new CustomerAreaListReqDto();
            customerAreaListReqDto.setCodes(customerRespDto.getRegionCodeList());
            customerDetailRespDto.setRegionNameList(this.customerAreaService.queryForList(customerAreaListReqDto).stream().map(CustomerAreaRespDto::getName).collect(Collectors.toList()));
        }
        if (!org.springframework.util.CollectionUtils.isEmpty(contactsInfoRespDtos = this.contactsInfoService.queryContactsInfoListByOrgInfoId(customerRespDto.getOrgInfoId()))) {
            customerDetailRespDto.setContactsInfoList(contactsInfoRespDtos);
        }
        if (!org.springframework.util.CollectionUtils.isEmpty(billInfoRespDtos = this.billInfoService.queryBillInfoListByOrgInfoId(customerRespDto.getOrgInfoId()))) {
            customerDetailRespDto.setBillInfoList(billInfoRespDtos);
        }
        if (Objects.nonNull(invoiceInfoRespDto = this.billInfoService.queryInvoiceInfoByOrgInfoId(customerRespDto.getOrgInfoId()))) {
            customerDetailRespDto.setInvoiceInfo(invoiceInfoRespDto);
        }
        if (!org.springframework.util.CollectionUtils.isEmpty(addressRespDtos = this.addressService.queryAddressListByOrgInfoIdAndType(customerRespDto.getOrgInfoId(), Lists.newArrayList((Object[])new String[]{AddressTypeEnum.DELIVERY.getCode(), AddressTypeEnum.INVOICE.getCode()})))) {
            customerDetailRespDto.setAddressDtoList(addressRespDtos);
        }
        AuditInfoDto auditInfoDto = new AuditInfoDto();
        auditInfoDto.setAuditDesc(customerDetailRespDto.getAuditDesc());
        auditInfoDto.setApplyTime(customerDetailRespDto.getCreateTime());
        auditInfoDto.setApplyPerson(customerDetailRespDto.getCreatePerson());
        auditInfoDto.setAuditPerson(customerDetailRespDto.getCreatePerson());
        auditInfoDto.setAuditTime(customerDetailRespDto.getAuditTime());
        auditInfoDto.setAuditStatus(customerDetailRespDto.getAuditStatus());
        auditInfoDto.setApplyType("ADD");
        customerDetailRespDto.setAuditInfo(auditInfoDto);
        return customerDetailRespDto;
    }

    private UserAccountRespDto createUserAccount(Long userId, Long orgInfoId) {
        UserDto userDto = null;
        try {
            RestResponse userRestResp = this.userQueryApi.queryById(userId, "{}");
            userDto = (UserDto)RestResponseHelper.extractData((RestResponse)userRestResp);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        if (Objects.nonNull(userDto)) {
            UserAccountRespDto userAccount = new UserAccountRespDto();
            userAccount.setUserId(userId);
            userAccount.setUserName(userDto.getUserName());
            userAccount.setOrgInfoId(orgInfoId);
            return userAccount;
        }
        return null;
    }

    @Override
    public CustomerRespDto queryByCode(String code) {
        CustomerEo selectItemCustomer = new CustomerEo();
        selectItemCustomer.setCode(code);
        List customerEos = this.customerDas.selectList((BaseEo)selectItemCustomer);
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)customerEos)) {
            return null;
        }
        CustomerRespDto customerRespDto = new CustomerRespDto();
        DtoHelper.eo2Dto((BaseEo)((BaseEo)customerEos.get(0)), (BaseVo)customerRespDto);
        return customerRespDto;
    }

    @Override
    public PageInfo<CustomerRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        CustomerSearchReqDto searchReqDto = new CustomerSearchReqDto();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            searchReqDto = (CustomerSearchReqDto)JSONObject.parseObject((String)filter, CustomerSearchReqDto.class);
        }
        return this.getCustomerRespDtoPageInfo(searchReqDto, pageNum, pageSize);
    }

    @Override
    public PageInfo<CustomerRespDto> queryByNewPage(CustomerSearchReqDto searchReqDto, Integer pageNum, Integer pageSize) {
        this.logger.info("\u5ba2\u6237\u4fe1\u606f\u5206\u9875\u67e5\u8be2\u6761\u4ef6searchReqDto\uff0c{}", (Object)searchReqDto);
        return this.getCustomerRespDtoPageInfo(searchReqDto, pageNum, pageSize);
    }

    private PageInfo<CustomerRespDto> getCustomerRespDtoPageInfo(CustomerSearchReqDto searchReqDto, Integer pageNum, Integer pageSize) {
        List idList;
        List customerIdList;
        List eos;
        if (StringUtils.isNotEmpty((CharSequence)searchReqDto.getCompanyName())) {
            OrgAdvQueryReqDto orgAdvQueryReqDto = new OrgAdvQueryReqDto();
            orgAdvQueryReqDto.setName(searchReqDto.getCompanyName());
            RestResponse orgAdvResponse = this.organizationQueryExtApi.queryPage(orgAdvQueryReqDto, Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE));
            PageInfo orgAdvRespPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)orgAdvResponse);
            if (Objects.nonNull(orgAdvRespPageInfo) && !org.springframework.util.CollectionUtils.isEmpty((Collection)orgAdvRespPageInfo.getList())) {
                searchReqDto.setOrgInfoIds(orgAdvRespPageInfo.getList().stream().map(OrgAdvRespDto::getId).collect(Collectors.toList()));
            } else {
                return new PageInfo();
            }
        }
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)searchReqDto.getRegionCodes())) {
            CustomerAreaListReqDto customerAreaListReqDto = new CustomerAreaListReqDto();
            customerAreaListReqDto.setCodes(searchReqDto.getRegionCodes());
            List<String> regionCodeList = this.customerAreaService.querySubCodeAll(customerAreaListReqDto);
            RCustomerRegionEo selectEo = new RCustomerRegionEo();
            ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
            sqlFilters.add(SqlFilter.in((String)"region_code", regionCodeList));
            selectEo.setSqlFilters(sqlFilters);
            List customerRegionEos = this.rCustomerRegionDas.select((BaseEo)selectEo);
            Set customerIdList2 = customerRegionEos.stream().map(StdRCustomerRegionEo::getCustomerId).collect(Collectors.toSet());
            if (org.springframework.util.CollectionUtils.isEmpty(customerIdList2)) {
                return new PageInfo();
            }
            searchReqDto.setIdList(new ArrayList(customerIdList2));
        }
        if (Objects.nonNull(searchReqDto.getSalesmanUserId())) {
            Set realSalesmanIds = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.customerSalesmanDas.filter(true).select(new String[]{"id"}).eq((Object)"status", (Object)1)).eq((Object)"user_id", (Object)searchReqDto.getSalesmanId())).list().stream().map(BaseEo::getId).collect(Collectors.toSet());
            if (org.springframework.util.CollectionUtils.isEmpty(realSalesmanIds)) {
                return new PageInfo();
            }
            eos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.rCustomerSalesmanDas.filter(true).in((Object)"real_salesman_id", realSalesmanIds)).eq((Object)"org_id", (Object)this.getCurrentUserOrgId())).list();
            if (org.springframework.util.CollectionUtils.isEmpty((Collection)eos)) {
                return new PageInfo();
            }
            customerIdList = eos.stream().map(RCustomerSalesmanEo::getCustomerId).collect(Collectors.toList());
            idList = searchReqDto.getIdList();
            if (org.springframework.util.CollectionUtils.isEmpty((Collection)idList)) {
                idList = customerIdList;
            } else {
                idList.retainAll(customerIdList);
            }
            if (org.springframework.util.CollectionUtils.isEmpty((Collection)idList)) {
                return new PageInfo();
            }
            searchReqDto.setIdList(idList);
        }
        if (Objects.nonNull(searchReqDto.getSalesmanId())) {
            RCustomerSalesmanEo eo = new RCustomerSalesmanEo();
            eo.setSalesmanId(searchReqDto.getSalesmanId());
            eo.setOrgId(this.queryOrgIdByUserId(this.context.userId()));
            eos = this.rCustomerSalesmanDas.select((BaseEo)eo);
            if (org.springframework.util.CollectionUtils.isEmpty((Collection)eos)) {
                return new PageInfo();
            }
            customerIdList = eos.stream().map(RCustomerSalesmanEo::getCustomerId).collect(Collectors.toList());
            idList = searchReqDto.getIdList();
            if (org.springframework.util.CollectionUtils.isEmpty((Collection)idList)) {
                idList = customerIdList;
            } else {
                idList.retainAll(customerIdList);
            }
            if (org.springframework.util.CollectionUtils.isEmpty(idList)) {
                return new PageInfo();
            }
            searchReqDto.setIdList(idList);
        }
        if (searchReqDto.getListFlag().booleanValue()) {
            searchReqDto.setAuditStatus(AuditStatusEnum.AUDIT_PASS.getCode());
        }
        Assert.isTrue((null != searchReqDto.getType() ? 1 : 0) != 0, (String)"\u5ba2\u6237\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.isTrue((null != searchReqDto.getChannel() ? 1 : 0) != 0, (String)"\u6e20\u9053\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Long currentUserOrgId = this.getCurrentUserOrgId();
        if (null != currentUserOrgId) {
            ArrayList merchantIds = Lists.newArrayList();
            if (CustomerTypeEnum.BRAND.getCode().equals(searchReqDto.getChannel())) {
                List customerEos;
                if (CustomerTypeEnum.DEALER.getCode().equals(searchReqDto.getType())) {
                    merchantIds.add(currentUserOrgId);
                } else if (CustomerTypeEnum.RETAILER.getCode().equals(searchReqDto.getType()) && !org.springframework.util.CollectionUtils.isEmpty((Collection)(customerEos = this.customerDas.getMapper().selectList((Wrapper)new QueryWrapper().eq((Object)"merchant_id", (Object)currentUserOrgId))))) {
                    merchantIds.addAll(customerEos.stream().filter(bean -> null != bean.getOrgInfoId()).map(StdCustomerEo::getOrgInfoId).collect(Collectors.toList()));
                }
            } else if (CustomerTypeEnum.DEALER.getCode().equals(searchReqDto.getChannel()) && CustomerTypeEnum.RETAILER.getCode().equals(searchReqDto.getType())) {
                merchantIds.add(currentUserOrgId);
            }
            searchReqDto.setMerchantIds((List)merchantIds);
        }
        this.logger.info("\u5ba2\u6237\u4fe1\u606f\u5206\u9875\u67e5\u8be2\u7b5b\u9009\u5bf9\u8c61searchReqDto\uff0c{}", (Object)JSON.toJSONString((Object)searchReqDto));
        PageInfo pageInfo = this.customerDas.queryPageBySearchConExt(pageNum, pageSize, searchReqDto);
        if (Objects.nonNull(pageInfo) && !org.springframework.util.CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
            List rCustomerRegionEos = this.rCustomerRegionDas.selectCodeByCusList(pageInfo.getList().stream().map(BaseRespDto::getId).collect(Collectors.toList()));
            HashMap<Long, String> idRegionCodeMap = new HashMap(0);
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)rCustomerRegionEos)) {
                idRegionCodeMap = rCustomerRegionEos.stream().collect(Collectors.groupingBy(StdRCustomerRegionEo::getCustomerId, Collectors.mapping(StdRCustomerRegionEo::getRegionCode, Collectors.joining(","))));
            }
            List regionCodes = rCustomerRegionEos.stream().map(StdRCustomerRegionEo::getRegionCode).collect(Collectors.toList());
            List customerIds = pageInfo.getList().stream().map(BaseRespDto::getId).collect(Collectors.toList());
            RCustomerSalesmanEo rCustomerSalesmanEo = new RCustomerSalesmanEo();
            LambdaQueryWrapper queryRWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)MybatisPlusUtils.newLambdaQueryWrapper(rCustomerSalesmanEo).in(RCustomerSalesmanEo::getCustomerId, customerIds)).eq(RCustomerSalesmanEo::getOrgId, (Object)this.queryOrgIdByUserId(this.context.userId()));
            List rCustomerSalesmanEos = this.rCustomerSalesmanDas.getMapper().selectList((Wrapper)queryRWrapper);
            HashMap<Long, String> salesmanNameMap = new HashMap();
            HashMap<Long, String> salesmanIdsMap = new HashMap();
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)rCustomerSalesmanEos)) {
                List salesmanIds = rCustomerSalesmanEos.stream().map(RCustomerSalesmanEo::getSalesmanId).distinct().collect(Collectors.toList());
                salesmanIdsMap = rCustomerSalesmanEos.stream().collect(Collectors.groupingBy(RCustomerSalesmanEo::getCustomerId, Collectors.mapping(e -> e.getSalesmanId().toString(), Collectors.joining(","))));
                CustomerSalesmanEo customerSalesmanEo = new CustomerSalesmanEo();
                LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)MybatisPlusUtils.newLambdaQueryWrapper(customerSalesmanEo).in(StdCustomerSalesmanEo::getUserId, salesmanIds)).eq(StdCustomerSalesmanEo::getOrgInfoId, (Object)this.queryOrgIdByUserId(this.context.userId()));
                List customerSalesmanEos = this.customerSalesmanDas.getMapper().selectList((Wrapper)queryWrapper);
                salesmanNameMap = customerSalesmanEos.stream().collect(Collectors.toMap(StdCustomerSalesmanEo::getUserId, StdCustomerSalesmanEo::getName, (e1, e2) -> e1));
            }
            CompletableFuture<Map> typeMapFuture = CompletableFuture.supplyAsync(() -> this.customerTypeDas.getMapper().selectList((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{BaseEo::getId, StdCustomerTypeEo::getName}).in(BaseEo::getId, (Collection)pageInfo.getList().stream().map(CustomerRespDto::getCustomerTypeId).distinct().collect(Collectors.toList()))).stream().collect(Collectors.toMap(BaseEo::getId, StdCustomerTypeEo::getName)));
            CompletableFuture<Map> statusMapFuture = CompletableFuture.supplyAsync(() -> this.customerStatusDas.getMapper().selectList((Wrapper)new LambdaQueryWrapper().in(BaseEo::getId, (Collection)pageInfo.getList().stream().map(CustomerRespDto::getStatusId).distinct().collect(Collectors.toList()))).stream().collect(Collectors.toMap(BaseEo::getId, Function.identity())));
            CompletableFuture<Map> levelMapFuture = CompletableFuture.supplyAsync(() -> this.customerLevelDas.getMapper().selectList((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{BaseEo::getId, StdCustomerLevelEo::getName}).in(BaseEo::getId, (Collection)pageInfo.getList().stream().map(CustomerRespDto::getLevelId).distinct().collect(Collectors.toList()))).stream().collect(Collectors.toMap(BaseEo::getId, StdCustomerLevelEo::getName)));
            CompletableFuture<Map> regionNameMapFuture = CompletableFuture.supplyAsync(() -> {
                if (org.springframework.util.CollectionUtils.isEmpty((Collection)regionCodes)) {
                    return new HashMap();
                }
                CustomerAreaListReqDto customerAreaListReqDto = new CustomerAreaListReqDto();
                customerAreaListReqDto.setCodes(regionCodes);
                return this.customerAreaService.queryForList(customerAreaListReqDto).stream().collect(Collectors.toMap(CustomerAreaRespDto::getCode, CustomerAreaRespDto::getName, (o, o1) -> o));
            });
            CompletableFuture<Map> customerNameMapFuture = CompletableFuture.supplyAsync(() -> Optional.of(pageInfo.getList().stream().map(CustomerRespDto::getParentCustomerId).filter(Objects::nonNull).distinct().collect(Collectors.toList())).filter(org.apache.commons.collections.CollectionUtils::isNotEmpty).map(parentIds -> this.customerDas.queryListByIds(parentIds).stream().collect(Collectors.toMap(CustomerNameSimpleRespDto::getId, CustomerNameSimpleRespDto::getName))).orElse(new HashMap(0)));
            CompletableFuture<Map> orgNameMapFuture = CompletableFuture.supplyAsync(() -> ((List)this.bizOrganizationQueryApi.getOrganizationsByIds(pageInfo.getList().stream().map(CustomerRespDto::getOrgInfoId).distinct().collect(Collectors.toList())).getData()).stream().collect(Collectors.toMap(OrganizationDto::getId, OrganizationDto::getName)));
            CompletableFuture<Map> groupNameMapFuture = CompletableFuture.supplyAsync(() -> {
                List groupIds = pageInfo.getList().stream().map(CustomerRespDto::getCustomerGroupId).distinct().collect(Collectors.toList());
                if (org.springframework.util.CollectionUtils.isEmpty(groupIds)) {
                    return new HashMap(0);
                }
                return this.customerGroupDas.selectByIds(groupIds).stream().collect(Collectors.toMap(BaseEo::getId, StdCustomerGroupEo::getGroupName));
            });
            CompletableFuture<Map> creditCodeMapFuture = CompletableFuture.supplyAsync(() -> {
                HashMap<Long, String> map = new HashMap<Long, String>();
                RestResponse orgList = this.organizationQueryApi.queryOrgAndOrgInfoByIds(pageInfo.getList().stream().map(CustomerRespDto::getOrgInfoId).distinct().collect(Collectors.toList()));
                if (orgList.getData() == null) {
                    return map;
                }
                for (OrgAndOrgInfoRespDto a : (List)orgList.getData()) {
                    if (a.getOrganizationInfoDto() == null || !StringUtils.isNotEmpty((CharSequence)a.getOrganizationInfoDto().getCreditCode())) continue;
                    map.putIfAbsent(a.getOrganizationDto().getId(), a.getOrganizationInfoDto().getCreditCode());
                }
                return map;
            });
            CompletableFuture.allOf(customerNameMapFuture, orgNameMapFuture, groupNameMapFuture, levelMapFuture, statusMapFuture, typeMapFuture, creditCodeMapFuture, regionNameMapFuture);
            HashMap<Long, String> customerNameMap = new HashMap(0);
            HashMap<Long, String> orgNameMap = new HashMap(0);
            HashMap<Long, String> groupNameMap = new HashMap(0);
            HashMap<Long, String> creditCodeMap = new HashMap(0);
            HashMap<String, String> regionNameMap = new HashMap(0);
            HashMap<Long, String> levelMap = new HashMap(0);
            Map<Long, Object> statusMap = new HashMap<Long, CustomerStatusEo>(0);
            Map<Long, String> typeMap = new HashMap<Long, String>(0);
            try {
                regionNameMap = regionNameMapFuture.get();
                customerNameMap = customerNameMapFuture.get();
                orgNameMap = orgNameMapFuture.get();
                groupNameMap = groupNameMapFuture.get();
                creditCodeMap = creditCodeMapFuture.get();
                levelMap = levelMapFuture.get();
                statusMap = statusMapFuture.get();
                typeMap = typeMapFuture.get();
            }
            catch (Exception e3) {
                e3.printStackTrace();
            }
            for (CustomerRespDto customerRespDto : pageInfo.getList()) {
                this.peekData(searchReqDto, idRegionCodeMap, salesmanNameMap, salesmanIdsMap, customerNameMap, orgNameMap, groupNameMap, creditCodeMap, regionNameMap, levelMap, statusMap, typeMap, customerRespDto);
            }
        }
        return pageInfo;
    }

    private void peekData(CustomerSearchReqDto searchReqDto, Map<Long, String> idRegionCodeMap, Map<Long, String> salesmanNameMap, Map<Long, String> salesmanIdsMap, Map<Long, String> customerNameMap, Map<Long, String> orgNameMap, Map<Long, String> groupNameMap, Map<Long, String> creditCodeMap, Map<String, String> regionNameMap, Map<Long, String> levelMap, Map<Long, CustomerStatusEo> statusMap, Map<Long, String> typeMap, CustomerRespDto customerRespDto) {
        CustomerStatusEo statusEo = statusMap.getOrDefault(customerRespDto.getStatusId(), new CustomerStatusEo());
        customerRespDto.setAccountStatus(statusEo.getAccountStatus());
        customerRespDto.setRecordStatus(statusEo.getRecordStatus());
        customerRespDto.setStatusName(statusEo.getName());
        customerRespDto.setCustomerTypeName(typeMap.getOrDefault(customerRespDto.getCustomerTypeId(), ""));
        customerRespDto.setLevelName(levelMap.getOrDefault(customerRespDto.getLevelId(), ""));
        customerRespDto.setRegionCodes(idRegionCodeMap.get(customerRespDto.getId()));
        if (StringUtils.isNotEmpty((CharSequence)salesmanIdsMap.get(customerRespDto.getId()))) {
            customerRespDto.setSalesmanIds(salesmanIdsMap.get(customerRespDto.getId()));
            ArrayList<String> salesmanNameList = new ArrayList<String>();
            for (String salesmanId : customerRespDto.getSalesmanIds().split(",")) {
                salesmanNameList.add(salesmanNameMap.get(Long.valueOf(salesmanId)));
            }
            customerRespDto.setSalesmanNames(String.join((CharSequence)",", salesmanNameList));
        }
        if (StringUtils.isNotEmpty((CharSequence)customerRespDto.getRegionCodes())) {
            ArrayList<String> regionNameList = new ArrayList<String>();
            for (String code : customerRespDto.getRegionCodes().split(",")) {
                regionNameList.add(regionNameMap.get(code));
            }
            customerRespDto.setRegionNames(String.join((CharSequence)",", regionNameList));
        }
        if (null != customerRespDto.getOrgInfoId() && creditCodeMap != null) {
            customerRespDto.setOrgName(orgNameMap.getOrDefault(customerRespDto.getOrgInfoId(), ""));
            customerRespDto.setCreditCode(creditCodeMap.getOrDefault(customerRespDto.getOrgInfoId(), ""));
        }
        if (customerRespDto.getParentCustomerId() != null) {
            customerRespDto.setParentCustomerName(customerNameMap.getOrDefault(customerRespDto.getParentCustomerId(), ""));
        }
        if (StatusEnum.ENABLED.getCode().equals(customerRespDto.getRecordStatus()) && StatusEnum.ENABLED.getCode().equals(customerRespDto.getAccountStatus())) {
            customerRespDto.setValetFlag(StatusEnum.ENABLED.getCode());
        } else {
            customerRespDto.setValetFlag(StatusEnum.DISABLED.getCode());
        }
        if (null != customerRespDto.getCustomerGroupId()) {
            customerRespDto.setCustomerGroupName(groupNameMap.getOrDefault(customerRespDto.getCustomerGroupId(), ""));
        }
        if (!searchReqDto.getListFlag().booleanValue()) {
            customerRespDto.setApplyTime(customerRespDto.getCreateTime());
            customerRespDto.setApplyPerson(customerRespDto.getCreatePerson());
            customerRespDto.setApplyType("ADD");
        }
    }

    private OrgAdvDetailRespDto getOrgAdvDetailRespDto(Long id) {
        RestResponse orgAdvDetailRestResp = this.organizationQueryExtApi.queryById(id);
        return (OrgAdvDetailRespDto)RestResponseHelper.extractData((RestResponse)orgAdvDetailRestResp);
    }

    @Override
    public List<CustomerRespDto> queryByList(String filter) {
        CustomerSearchReqDto searchReqDto = new CustomerSearchReqDto();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            searchReqDto = (CustomerSearchReqDto)JSONObject.parseObject((String)filter, CustomerSearchReqDto.class);
        }
        if (Objects.isNull(searchReqDto.getInstanceId())) {
            searchReqDto.setInstanceId(this.context.instanceId());
        }
        if (Objects.isNull(searchReqDto.getTenantId())) {
            searchReqDto.setTenantId(this.context.tenantId());
        }
        List customerList = this.customerDas.queryByList(searchReqDto);
        for (CustomerRespDto customerRespDto : customerList) {
            if (!StringUtils.isNotEmpty((CharSequence)customerRespDto.getRegionCodes())) continue;
            List<String> regionList = Arrays.asList(customerRespDto.getRegionCodes().split(","));
            customerRespDto.setRegionCodeList(regionList);
        }
        return customerList;
    }

    @Override
    public void moveCustomerToRegion(String sourceRegionCode, String targetRegionCode) {
        RCustomerRegionEo sourceSelectEo = new RCustomerRegionEo();
        sourceSelectEo.setRegionCode(sourceRegionCode);
        List sourceRegionEos = this.rCustomerRegionDas.select((BaseEo)sourceSelectEo);
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)sourceRegionEos)) {
            throw new CustomerBusinessRuntimeException(CustomerExceptionCode.REGION_NON_EXIST_CUSTOMER.getCode(), CustomerExceptionCode.REGION_NON_EXIST_CUSTOMER.getMsg());
        }
        RCustomerRegionEo targetSelectEo = new RCustomerRegionEo();
        targetSelectEo.setRegionCode(targetRegionCode);
        List targetRegionEos = this.rCustomerRegionDas.select((BaseEo)targetSelectEo);
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)targetRegionEos)) {
            this.customerDas.updateCustomerByRegionCode(sourceRegionCode, targetRegionCode);
        } else {
            List sourceCustomerIds = sourceRegionEos.stream().map(StdRCustomerRegionEo::getCustomerId).collect(Collectors.toList());
            List targetCustomerIds = targetRegionEos.stream().map(StdRCustomerRegionEo::getCustomerId).collect(Collectors.toList());
            sourceCustomerIds.retainAll(targetCustomerIds);
            if (org.springframework.util.CollectionUtils.isEmpty(sourceCustomerIds)) {
                this.customerDas.updateCustomerByRegionCode(sourceRegionCode, targetRegionCode);
            } else {
                this.customerDas.updateByRegionCodeAndOutCustomerId(sourceRegionCode, targetRegionCode, sourceCustomerIds);
                RCustomerRegionEo deleteEo = new RCustomerRegionEo();
                ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
                sqlFilters.add(SqlFilter.in((String)"customer_id", (Object)StringUtils.join(sourceCustomerIds, (String)",")));
                deleteEo.setSqlFilters(sqlFilters);
                deleteEo.setRegionCode(sourceRegionCode);
                this.rCustomerRegionDas.delete((BaseEo)deleteEo);
            }
        }
    }

    private void validCustomerName(CustomerReqDto reqDto) {
        Assert.notNull((Object)reqDto.getName(), (String)CustomerExceptionCode.NAME_NULL.getMsg(), (Object[])new Object[0]);
        CustomerEo eo = CustomerEo.newInstance();
        eo.setName(reqDto.getName());
        eo.setTenantId(reqDto.getTenantId());
        List customerEos = this.customerDas.select((BaseEo)eo);
        if (reqDto.getId() == null && !org.springframework.util.CollectionUtils.isEmpty((Collection)customerEos)) {
            throw new CustomerBusinessRuntimeException(CustomerExceptionCode.NAME_EXISTS.getCode(), "\u5ba2\u6237" + CustomerExceptionCode.NAME_EXISTS.getMsg() + "\u4e0d\u5141\u8bb8\u65b0\u589e");
        }
        if (reqDto.getId() != null && !org.springframework.util.CollectionUtils.isEmpty((Collection)customerEos) && !((CustomerEo)customerEos.get(0)).getId().equals(reqDto.getId())) {
            throw new CustomerBusinessRuntimeException(CustomerExceptionCode.NAME_EXISTS.getCode(), "\u5ba2\u6237" + CustomerExceptionCode.NAME_EXISTS.getMsg() + "\u4e0d\u5141\u8bb8\u4fee\u6539");
        }
    }

    private void initCustomerEo(CustomerReqDto reqDto, CustomerEo customerEo) {
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)customerEo);
        if (Objects.nonNull(reqDto.getCompanyInfoDto()) && StringUtils.isNotEmpty((CharSequence)reqDto.getCompanyInfoDto().getCreditCode())) {
            customerEo.setIfCertification(Integer.valueOf(1));
        }
        customerEo.setEffectiveStartTime(Optional.ofNullable(reqDto.getStartDate()).orElse(Optional.ofNullable(reqDto.getEffectiveStartTime()).orElse(new Date())));
        customerEo.setEffectiveEndTime(Optional.ofNullable(reqDto.getEndDate()).orElse(reqDto.getEffectiveEndTime()));
        this.logger.info("\u521d\u59cb\u5316\u540e\u7684\u5ba2\u6237:{}", (Object)JSONObject.toJSONString((Object)reqDto));
    }

    private void validCustomerCode(CustomerReqDto reqDto, Long tenantId) {
        if (Objects.nonNull(reqDto)) {
            Assert.notNull((Object)reqDto.getCode(), (String)CustomerExceptionCode.CUSTOMER_CODE_NULL.getMsg(), (Object[])new Object[0]);
            CustomerEo customerEo = CustomerEo.newInstance();
            customerEo.setTenantId(tenantId);
            customerEo.setCode(reqDto.getCode());
            customerEo = (CustomerEo)this.customerDas.selectOne((BaseEo)customerEo);
            if (customerEo != null) {
                if (reqDto.getId() == null) {
                    throw new CustomerBusinessRuntimeException(CustomerExceptionCode.CUSTOMER_CODE_EXISTS.getCode(), CustomerExceptionCode.CUSTOMER_CODE_EXISTS.getMsg() + reqDto.getCode());
                }
                if (reqDto.getId() != null && !customerEo.getId().equals(reqDto.getId())) {
                    throw new CustomerBusinessRuntimeException(CustomerExceptionCode.CUSTOMER_CODE_EXISTS.getCode(), CustomerExceptionCode.CUSTOMER_CODE_EXISTS.getMsg() + reqDto.getCode());
                }
            }
        }
    }

    @Override
    public Integer countByCustomerTypeId(Long customerTypeId) {
        return this.customerDas.countByCustomerTypeId(customerTypeId);
    }

    @Override
    public void updateCustomerTypeId(Long originCustomerTypeId, Long finalCustomerTypeId) {
        CustomerMapper mapper = (CustomerMapper)this.customerDas.getMapper();
        mapper.updateCustomerTypeId(originCustomerTypeId, finalCustomerTypeId);
    }

    @Override
    public PageInfo<CustomerTypeEo> queryCustomerTypeByPage(Integer pageNum, Integer pageSize) {
        if (pageNum == null) {
            pageNum = 1;
        }
        if (pageSize == null) {
            pageSize = 20;
        }
        CustomerTypeEo customerTypeEo = new CustomerTypeEo();
        customerTypeEo.setOrderBy("sort");
        return this.customerTypeDas.selectPage((BaseEo)customerTypeEo, pageNum, pageSize);
    }

    @Override
    @Transactional
    public void updateAccountStatus(CustomerReqDto customerReqDto) {
        CustomerEo customer = (CustomerEo)this.customerDas.selectByPrimaryKey(customerReqDto.getId());
        if (Objects.isNull(customer)) {
            throw new CustomerBusinessRuntimeException(CustomerExceptionCode.CUSTOMER_NON_EXIST.getCode(), CustomerExceptionCode.CUSTOMER_NON_EXIST.getMsg());
        }
        customer.setStatusId(customerReqDto.getStatusId());
        customer.setUserId(null != customerReqDto.getUserId() ? customerReqDto.getUserId() : customer.getUserId());
        this.customerDas.update((BaseEo)customer);
        this.sendMq(customer, "", "");
    }

    @Override
    public void saveCustomerExportRecord(ExportRecordReqDto reqDto) {
        Assert.isTrue((reqDto != null ? 1 : 0) != 0, (String)"\u5ba2\u5546\u5bfc\u51fa\u8bb0\u5f55\u4e3a\u7a7a", (Object[])new Object[0]);
        reqDto.setTenantId(ServiceContext.getContext().getRequestTenantId());
        reqDto.setInstanceId(ServiceContext.getContext().getRequestInstanceId());
        CustomerExportRecordEo exportRecordEo = CustomerExportRecordEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)exportRecordEo);
        this.customerExportRecordDas.insert((BaseEo)exportRecordEo);
    }

    @Override
    public List<CustomerNameSimpleRespDto> queryListByIds(List<Long> ids) {
        return this.customerDas.queryListByIds(ids);
    }

    @Override
    public void submit(Long id) {
        CustomerEo customerEo = new CustomerEo();
        CustomerEo eo = (CustomerEo)this.customerDas.selectByPrimaryKey(id);
        if (!Objects.equals(AuditStatusEnum.AUDIT_PASS.getCode(), eo.getAuditStatus())) {
            customerEo.setAuditStatus(AuditStatusEnum.WAIT_AUDIT.getCode());
        }
        customerEo.setId(id);
        this.customerDas.updateSelective((BaseEo)customerEo);
    }

    @Override
    public AuditOperationResultDto auditCustomer(CustomerAuditReqDto reqDto) {
        if (Objects.isNull(reqDto.getCustomerId())) {
            throw new CustomerBusinessRuntimeException(CustomerExceptionCode.CUSTOMER_ID_NULL.getCode(), CustomerExceptionCode.CUSTOMER_ID_NULL.getMsg());
        }
        CustomerEo customerEo = (CustomerEo)this.customerDas.selectByPrimaryKey(reqDto.getCustomerId());
        if (null == customerEo) {
            throw new CustomerBusinessRuntimeException(CustomerExceptionCode.CUSTOMER_NON_EXIST.getCode(), CustomerExceptionCode.CUSTOMER_NON_EXIST.getMsg());
        }
        AuditOperationResultDto resultDto = new AuditOperationResultDto();
        if ("PASS".equals(reqDto.getAuditStatus())) {
            customerEo.setAuditStatus(AuditStatusEnum.AUDIT_PASS.getCode());
            resultDto.setPopupFlag(Integer.valueOf(0));
            if (Objects.nonNull(customerEo.getUserId())) {
                UserDto userDto = new UserDto();
                userDto.setTenantId(this.context.tenantId());
                userDto.setInstanceId(this.context.instanceId());
                userDto.setStatus(Integer.valueOf(1));
                RestResponse restResponse = this.userApi.updatePasswordPermitted(customerEo.getUserId(), userDto);
                RestResponseHelper.checkOrThrow((RestResponse)restResponse);
            }
        } else {
            customerEo.setAuditStatus(AuditStatusEnum.AUDIT_REJECT.getCode());
            resultDto.setPopupFlag(Integer.valueOf(0));
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getAuditDesc())) {
            customerEo.setAuditDesc(reqDto.getAuditDesc());
        }
        if (resultDto.getPopupFlag() == 0) {
            customerEo.setAuditTime(new Date());
            this.customerDas.updateSelective((BaseEo)customerEo);
        }
        CustomerInfoDto customerInfoDto = this.createCustomerInfo(customerEo);
        this.customerChangeProducer.sendCustomerChangeMq(customerInfoDto);
        return resultDto;
    }

    @Override
    public Long addCustomerAccount(UserAccountReqDto userAccountReqDto) {
        this.logger.info("\u5f00\u59cb\u521b\u5efa\u5ba2\u6237\u8d26\u53f7\u4fe1\u606f,CustomerDetailReqDto:{}", (Object)JSON.toJSONString((Object)userAccountReqDto));
        Assert.notNull((Object)userAccountReqDto.getOrgInfoId(), (String)"\u7ec4\u7ec7ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)userAccountReqDto.getCustomerId(), (String)"\u5ba2\u6237ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        CustomerEo queryEo = (CustomerEo)this.customerDas.selectByPrimaryKey(userAccountReqDto.getCustomerId());
        Assert.notNull((Object)queryEo, (String)CustomerExceptionCode.CUSTOMER_NON_EXIST.getMsg(), (Object[])new Object[0]);
        UserDto userDto = new UserDto();
        BeanUtils.copyProperties((Object)userAccountReqDto, (Object)userDto);
        Long instanceId = this.context.instanceId();
        Long tenantId = this.context.tenantId();
        userDto.setTenantId(tenantId);
        userDto.setInstanceId(instanceId);
        RestResponse longRestResponse = this.userApi.addUser(instanceId, userDto);
        Long userId = (Long)RestResponseHelper.extractData((RestResponse)longRestResponse);
        UserDto updateUser = new UserDto();
        updateUser.setTenantId(this.context.tenantId());
        updateUser.setInstanceId(this.context.instanceId());
        updateUser.setStatus(Integer.valueOf(0));
        RestResponse restResponse = this.userApi.updatePasswordPermitted(userId, updateUser);
        RestResponseHelper.checkOrThrow((RestResponse)restResponse);
        UserOrgRelationReqDto userOrgRelationReqDto = new UserOrgRelationReqDto();
        userOrgRelationReqDto.setUserId(userId);
        userOrgRelationReqDto.setOrgIds(Collections.singletonList(userAccountReqDto.getOrgInfoId()));
        RestResponse voidRestResponse = this.organizationApi.addUserOrgRelation(userOrgRelationReqDto);
        RestResponseHelper.checkOrThrow((RestResponse)voidRestResponse);
        CustomerEo customer = new CustomerEo();
        customer.setId(userAccountReqDto.getCustomerId());
        customer.setUserId(userId);
        this.customerDas.updateSelective((BaseEo)customer);
        return userId;
    }

    @Override
    public void updateCustomerAccount(UserAccountReqDto userAccountReqDto) {
        this.logger.info("\u5f00\u59cb\u7f16\u8f91\u5ba2\u6237\u8d26\u53f7\u4fe1\u606f,CustomerDetailReqDto:{}", (Object)JSON.toJSONString((Object)userAccountReqDto));
        Assert.notNull((Object)userAccountReqDto.getOrgInfoId(), (String)"\u7ec4\u7ec7ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)userAccountReqDto.getCustomerId(), (String)"\u5ba2\u6237ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        UserDto userDto = new UserDto();
        BeanUtils.copyProperties((Object)userAccountReqDto, (Object)userDto);
        Long instanceId = this.context.instanceId();
        Long tenantId = this.context.tenantId();
        userDto.setTenantId(tenantId);
        userDto.setInstanceId(instanceId);
        RestResponse restResponse = this.userApi.updatePasswordPermitted(userAccountReqDto.getUserId(), userDto);
        RestResponseHelper.checkOrThrow((RestResponse)restResponse);
        CustomerEo customerEo = (CustomerEo)this.customerDas.selectByPrimaryKey(userAccountReqDto.getCustomerId());
        if (Objects.isNull(customerEo.getUserId())) {
            customerEo.setUserId(userAccountReqDto.getUserId());
            this.customerDas.updateSelective((BaseEo)customerEo);
        }
    }

    @Override
    public void updateAuditStatusByReject(Long customerId) {
        CustomerEo customer = (CustomerEo)this.customerDas.selectByPrimaryKey(customerId);
        if (AuditStatusEnum.AUDIT_REJECT.getCode().equals(customer.getAuditStatus())) {
            customer.setAuditStatus(AuditStatusEnum.WAIT_AUDIT.getCode());
            this.customerDas.updateSelective((BaseEo)customer);
        }
    }

    @Override
    public void updateSettleStatus(SettleStatusDto settleStatusDto) {
        List customerEoList;
        Long customerId;
        this.logger.info("\u66f4\u65b0\u5165\u9a7b\u72b6\u6001 " + JSON.toJSONString((Object)settleStatusDto));
        Assert.notNull((Object)settleStatusDto.getSettleStatus(), (String)"\u5165\u9a7b\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (Objects.nonNull(settleStatusDto.getCustomerId())) {
            CustomerEo customer = new CustomerEo();
            customer.setId(settleStatusDto.getCustomerId());
            customer.setSettleStatus(settleStatusDto.getSettleStatus());
            this.customerDas.updateSelective((BaseEo)customer);
            customerId = settleStatusDto.getCustomerId();
        } else {
            Assert.notNull((Object)settleStatusDto.getOrgInfoId(), (String)"\u7ec4\u7ec7\u4fe1\u606fID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Long merchantId = this.getCurrentUserOrgId();
            CustomerEo queryCustomer = new CustomerEo();
            queryCustomer.setOrgInfoId(settleStatusDto.getOrgInfoId());
            queryCustomer.setMerchantId(merchantId);
            List customerEos = this.customerDas.select((BaseEo)queryCustomer);
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)customerEos)) {
                CustomerEo updateCustomer = (CustomerEo)customerEos.get(0);
                updateCustomer.setSettleStatus(settleStatusDto.getSettleStatus());
                this.customerDas.updateSelective((BaseEo)updateCustomer);
                customerId = updateCustomer.getId();
            } else {
                throw new CustomerBusinessRuntimeException(CustomerExceptionCode.CUSTOMER_NON_EXIST.getCode(), CustomerExceptionCode.CUSTOMER_NON_EXIST.getMsg());
            }
        }
        CustomerEo customerEo = (CustomerEo)this.customerDas.selectByPrimaryKey(customerId);
        Assert.notNull((Object)customerEo, (String)"\u7ecf\u9500\u5546\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        if (SettleStatusEnum.SETTLED.getCode().equals(settleStatusDto.getSettleStatus())) {
            customerEoList = this.customerDas.getMapper().selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"user_id", (Object)customerEo.getUserId())).eq((Object)"settle_status", (Object)SettleStatusEnum.SETTLED.getCode())).ne((Object)"id", (Object)customerId));
            if (org.springframework.util.CollectionUtils.isEmpty((Collection)customerEoList) && ObjectUtils.isNotEmpty((Object)customerEo.getUserId())) {
                RestResponse roleRestResp = this.accessQueryApi.queryRoleByCode(this.dealerRoleCode);
                RoleRespDto roleDto = (RoleRespDto)RestResponseHelper.extractData((RestResponse)roleRestResp);
                RestResponse voidRestResponse1 = this.accessApi.addUserRoles(roleDto.getInstanceId(), customerEo.getUserId(), Collections.singletonList(roleDto.getId()));
                RestResponseHelper.checkOrThrow((RestResponse)voidRestResponse1);
            }
        } else if (SettleStatusEnum.DISABLED.getCode().equals(settleStatusDto.getSettleStatus()) && org.springframework.util.CollectionUtils.isEmpty((Collection)(customerEoList = this.customerDas.getMapper().selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"user_id", (Object)customerEo.getUserId())).eq((Object)"settle_status", (Object)SettleStatusEnum.SETTLED.getCode())).ne((Object)"id", (Object)customerId)))) && ObjectUtils.isNotEmpty((Object)customerEo.getUserId())) {
            RestResponse voidRestResp = this.accessApi.removeUserRoles(customerEo.getUserId(), this.dealerRoleCode);
            RestResponseHelper.checkOrThrow((RestResponse)voidRestResp);
        }
    }

    @Override
    public void updateCompanyInfo(CompanyInfoDto companyInfoDto) {
        Assert.notNull((Object)companyInfoDto.getOrgCode(), (String)"\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)companyInfoDto.getCreditCode(), (String)"\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)companyInfoDto.getOrgName(), (String)"\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)companyInfoDto.getLegalName(), (String)"\u6cd5\u4eba\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)companyInfoDto.getOrgInfoId(), (String)"\u7ec4\u7ec7ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)companyInfoDto.getCustomerId(), (String)"\u5ba2\u6237ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)companyInfoDto.getMerchantId(), (String)"\u6240\u5c5e\u5546\u5bb6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List customerEoList = this.customerDas.getMapper().selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"org_info_id", (Object)companyInfoDto.getOrgInfoId())).eq((Object)"merchant_id", (Object)companyInfoDto.getMerchantId())).ne((Object)"id", (Object)companyInfoDto.getCustomerId()));
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)customerEoList)) {
            if (CustomerTypeEnum.DEALER.getCode().equals(((CustomerEo)customerEoList.get(0)).getType())) {
                throw new CustomerBusinessRuntimeException(CustomerExceptionCode.DEALER_CUSTOMER_EXISTS.getCode(), String.format(CustomerExceptionCode.DEALER_CUSTOMER_EXISTS.getMsg(), ((CustomerEo)customerEoList.get(0)).getCode()));
            }
            if (CustomerTypeEnum.RETAILER.getCode().equals(((CustomerEo)customerEoList.get(0)).getType())) {
                throw new CustomerBusinessRuntimeException(CustomerExceptionCode.RETAILER_CUSTOMER_EXISTS.getCode(), String.format(CustomerExceptionCode.RETAILER_CUSTOMER_EXISTS.getMsg(), ((CustomerEo)customerEoList.get(0)).getCode()));
            }
        }
        this.updateOrgInfo(companyInfoDto);
        this.addressService.removeAddressByOrgInfoIdAndType(companyInfoDto.getOrgInfoId(), AddressTypeEnum.COMPANY.getCode());
        if (StringUtils.isNotEmpty((CharSequence)companyInfoDto.getProvinceCode())) {
            AddressAddReqDto addressReqDto = new AddressAddReqDto();
            CubeBeanUtils.copyProperties((Object)addressReqDto, (Object)companyInfoDto, (String[])new String[0]);
            addressReqDto.setOrgInfoId(companyInfoDto.getOrgInfoId());
            addressReqDto.setAddressType(AddressTypeEnum.COMPANY.getCode());
            this.addressService.addAddress(addressReqDto);
        }
    }

    private void updateOrgInfo(CompanyInfoDto companyInfoDto) {
        OrgAdvModifyReqDto orgAdvModifyReqDto = new OrgAdvModifyReqDto();
        orgAdvModifyReqDto.setName(companyInfoDto.getOrgName());
        orgAdvModifyReqDto.setCode(companyInfoDto.getOrgCode());
        orgAdvModifyReqDto.setId(companyInfoDto.getOrgInfoId());
        orgAdvModifyReqDto.setEntityPropCode("company");
        orgAdvModifyReqDto.setTenantId(companyInfoDto.getTenantId());
        OrgAdvInfoReqDto orgAdvInfoReqDto = new OrgAdvInfoReqDto();
        CubeBeanUtils.copyProperties((Object)orgAdvInfoReqDto, (Object)companyInfoDto, (String[])new String[0]);
        orgAdvModifyReqDto.setOrgAdvInfoReqDto(orgAdvInfoReqDto);
        RestResponse modify = this.organizationExtApi.modify(orgAdvModifyReqDto);
        if (!"0".equals(modify.getResultCode())) {
            if (modify.getResultMsg().equals(CustomerExceptionCode.ORG_NAME_EXISTS.getMsg())) {
                throw new CustomerBusinessRuntimeException(CustomerExceptionCode.COMPANY_NAME_EXISTS.getCode(), CustomerExceptionCode.COMPANY_NAME_EXISTS.getMsg());
            }
            throw new BizException(modify.getResultCode(), modify.getResultMsg());
        }
        if (StringUtils.isNotEmpty((CharSequence)companyInfoDto.getCreditCode())) {
            CustomerEo customerEo = new CustomerEo();
            customerEo.setOrgInfoId(companyInfoDto.getOrgInfoId());
            List customerEoList = this.customerDas.select((BaseEo)customerEo);
            customerEoList.forEach(n -> {
                n.setIfCertification(Integer.valueOf(1));
                this.customerDas.updateSelective((BaseEo)n);
            });
        }
    }

    @Override
    public CompanyInfoDto queryCompanyByCreditCode(String creditCode) {
        Assert.notNull((Object)creditCode, (String)"\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        RestResponse orgAdvInfoRestResp = this.organizationQueryExtApi.queryOrgAdvInfoByCreditCode(creditCode, this.context.tenantId(), this.context.instanceId());
        OrgAdvInfoRespDto orgAdvInfoRespDto = (OrgAdvInfoRespDto)RestResponseHelper.extractData((RestResponse)orgAdvInfoRestResp);
        if (Objects.isNull(orgAdvInfoRespDto)) {
            return null;
        }
        CompanyInfoDto companyInfoDto = new CompanyInfoDto();
        CubeBeanUtils.copyProperties((Object)companyInfoDto, (Object)orgAdvInfoRespDto, (String[])new String[0]);
        companyInfoDto.setOrgInfoId(orgAdvInfoRespDto.getOrgId());
        return companyInfoDto;
    }

    @Override
    public CompanyInfoDto queryCompanyByOrgInfoId(Long orgInfoId, Integer channel, Long brandOrgId) {
        Long merchantId;
        Assert.notNull((Object)orgInfoId, (String)"\u7ec4\u7ec7ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)channel, (String)"\u6e20\u9053\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        RestResponse orgAdvDetailRestResp = this.organizationQueryExtApi.queryById(orgInfoId);
        OrgAdvDetailRespDto orgAdvDetailRespDto = (OrgAdvDetailRespDto)RestResponseHelper.extractData((RestResponse)orgAdvDetailRestResp);
        CompanyInfoDto companyInfoDto = new CompanyInfoDto();
        OrgAdvInfoRespDto orgAdvInfoRespDto = orgAdvDetailRespDto.getOrgAdvInfoRespDto();
        if (Objects.nonNull(orgAdvInfoRespDto)) {
            BeanUtils.copyProperties((Object)orgAdvInfoRespDto, (Object)companyInfoDto);
        }
        companyInfoDto.setOrgInfoId(orgInfoId);
        List<AddressRespDto> addressList = this.addressService.queryAddressListByOrgInfoIdAndType(companyInfoDto.getOrgInfoId(), Lists.newArrayList((Object[])new String[]{AddressTypeEnum.COMPANY.getCode()}));
        if (!org.springframework.util.CollectionUtils.isEmpty(addressList)) {
            BeanUtils.copyProperties((Object)addressList.get(0), (Object)companyInfoDto);
        }
        if (CustomerTypeEnum.BRAND.getCode().equals(channel)) {
            merchantId = this.getCurrentUserOrgId();
        } else if (CustomerTypeEnum.DEALER.getCode().equals(channel)) {
            Assert.notNull((Object)brandOrgId, (String)"\u54c1\u724c\u65b9\u7ec4\u7ec7ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            merchantId = brandOrgId;
        } else {
            this.desensitization(companyInfoDto);
            return companyInfoDto;
        }
        List customerEoList = this.customerDas.getMapper().selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"org_info_id", (Object)orgInfoId)).eq((Object)"merchant_id", (Object)merchantId));
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)customerEoList)) {
            companyInfoDto.setCustomerName(((CustomerEo)customerEoList.get(0)).getName());
            companyInfoDto.setSettleStatus(((CustomerEo)customerEoList.get(0)).getSettleStatus());
            companyInfoDto.setCustomerId(((CustomerEo)customerEoList.get(0)).getId());
        }
        return companyInfoDto;
    }

    private void desensitization(CompanyInfoDto companyInfoDto) {
        if (Objects.isNull(companyInfoDto)) {
            return;
        }
        Integer legalCardType = companyInfoDto.getLegalCardType();
        String legalCardNum = companyInfoDto.getLegalCardNum();
        if (Objects.equals(legalCardType, 1) && StrUtil.isNotBlank((CharSequence)legalCardNum)) {
            int length = legalCardNum.length();
            if (length == 15) {
                legalCardNum = legalCardNum.replaceAll("(\\w{6})\\w*(\\w{3})", "$1******$2");
            } else if (length == 18) {
                legalCardNum = legalCardNum.replaceAll("(\\w{6})\\w*(\\w{4})", "$1********$2");
            }
            companyInfoDto.setLegalCardNum(legalCardNum);
        }
    }

    @Override
    public CompanyInfoDto queryDealerCompanyByCurrentUser() {
        Long currentUserOrgId = this.getCurrentUserOrgId();
        List customerEoList = this.customerDas.getMapper().selectList((Wrapper)new QueryWrapper().eq((Object)"org_info_id", (Object)currentUserOrgId));
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)customerEoList)) {
            return this.queryCompanyByOrgInfoId(currentUserOrgId, CustomerTypeEnum.DEALER.getCode(), ((CustomerEo)customerEoList.get(0)).getMerchantId());
        }
        return null;
    }

    @Override
    public PageInfo<OrgInfoDto> queryOrgInfoPageByUserId(Long userId, String orgName, Integer pageNum, Integer pageSize) {
        List orgIdList;
        if (Objects.isNull(userId)) {
            userId = this.context.userId();
        }
        Assert.notNull((Object)userId, (String)"queryOrgInfoPageByUserId\uff0c\u627e\u4e0d\u5230userId", (Object[])new Object[0]);
        RestResponse pageInfoRestResponse = this.organizationQueryApi.queryUserOrgRelation(userId, Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE));
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResponse);
        if (Objects.isNull(pageInfo) || org.springframework.util.CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
            return new PageInfo();
        }
        JSONObject jsonObject = new JSONObject();
        ArrayList filters = Lists.newArrayList();
        filters.add(SqlFilter.in((String)"id", pageInfo.getList().stream().map(OrganizationDto::getId).collect(Collectors.toList())));
        if (StringUtils.isNotEmpty((CharSequence)orgName)) {
            filters.add(SqlFilter.like((String)"name", (Object)("%" + orgName + "%")));
        }
        jsonObject.put("filters", (Object)filters);
        RestResponse pageInfoRestResp = this.bizOrganizationQueryApi.queryBizOrganizationByPage(jsonObject.toJSONString(), pageNum, pageSize);
        PageInfo bizOrgPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResp);
        List orgPageInfoList = bizOrgPageInfo.getList();
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)orgPageInfoList)) {
            return new PageInfo();
        }
        PageInfo listRespDtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)listRespDtoPageInfo, (Object)bizOrgPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList listRespDtoList = Lists.newArrayList();
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)orgPageInfoList) && !org.springframework.util.CollectionUtils.isEmpty(orgIdList = orgPageInfoList.stream().map(BizOrganizationRespDto::getId).collect(Collectors.toList()))) {
            filters = Lists.newArrayList();
            filters.add(SqlFilter.in((String)"org_info_id", orgIdList));
            CustomerEo customerEo = new CustomerEo();
            customerEo.setSqlFilters((List)filters);
            customerEo.setDr(0);
            customerEo.setType(CustomerTypeEnum.RETAILER.getCode());
            List customerEoList = this.customerDas.select((BaseEo)customerEo);
            if (org.springframework.util.CollectionUtils.isEmpty((Collection)customerEoList)) {
                return new PageInfo();
            }
            List merchantIdList = customerEoList.stream().map(StdCustomerEo::getMerchantId).collect(Collectors.toList());
            jsonObject = new JSONObject();
            filters = Lists.newArrayList();
            filters.add(SqlFilter.in((String)"id", merchantIdList));
            jsonObject.put("filters", (Object)filters);
            RestResponse pageInfoOrgRestResp = this.bizOrganizationQueryApi.queryBizOrganizationByPage(jsonObject.toJSONString(), pageNum, pageSize);
            List organizationRespDtoList = ((PageInfo)pageInfoOrgRestResp.getData()).getList();
            Map<Long, String> orgMap = organizationRespDtoList.stream().collect(Collectors.toMap(BizOrganizationRespDto::getId, BizOrganizationRespDto::getName));
            Map<Long, List<CustomerEo>> customerMap = customerEoList.stream().collect(Collectors.groupingBy(StdCustomerEo::getOrgInfoId));
            for (BizOrganizationRespDto bizOrganizationRespDto : orgPageInfoList) {
                OrgInfoDto orgInfoDto = new OrgInfoDto();
                orgInfoDto.setOrgInfoId(bizOrganizationRespDto.getId());
                orgInfoDto.setOrgName(bizOrganizationRespDto.getName());
                orgInfoDto.setOrgCode(bizOrganizationRespDto.getCode());
                orgInfoDto.setId(bizOrganizationRespDto.getId());
                List<CustomerEo> eoList = customerMap.get(bizOrganizationRespDto.getId());
                if (!org.springframework.util.CollectionUtils.isEmpty(eoList)) {
                    StringBuffer stringBuffer = new StringBuffer();
                    eoList.forEach(n -> {
                        String sellerName = (String)orgMap.get(n.getMerchantId());
                        stringBuffer.append(sellerName).append(",");
                    });
                    orgInfoDto.setSellerName(stringBuffer.substring(0, stringBuffer.toString().length() - 1));
                }
                listRespDtoList.add(orgInfoDto);
            }
        }
        listRespDtoPageInfo.setList((List)listRespDtoList);
        return listRespDtoPageInfo;
    }

    @Override
    public CustomerCheckRespDto checkCustomer(CustomerCheckReqDto reqDto) {
        Long currentUserOrgId;
        CustomerCheckRespDto respDto = new CustomerCheckRespDto();
        respDto.setPass(true);
        if (CustomerTypeEnum.DEALER.getCode().equals(reqDto.getType())) {
            currentUserOrgId = this.getCurrentUserOrgId();
            reqDto.setMerchantId(currentUserOrgId);
        } else if (CustomerTypeEnum.RETAILER.getCode().equals(reqDto.getType()) && CustomerTypeEnum.DEALER.getCode().equals(reqDto.getChannel())) {
            if (reqDto.getCustomerId() != null) {
                Long merchantId = ((CustomerEo)this.customerDas.selectByPrimaryKey(reqDto.getCustomerId())).getMerchantId();
                reqDto.setMerchantId(merchantId);
            } else {
                currentUserOrgId = this.getCurrentUserOrgId();
                reqDto.setMerchantId(currentUserOrgId);
            }
        }
        if (Objects.isNull(reqDto.getMerchantId())) {
            return respDto;
        }
        List customerEoList = Lists.newArrayList();
        customerEoList = Objects.isNull(reqDto.getCustomerId()) ? this.customerDas.getMapper().selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"org_info_id", (Object)reqDto.getOrgInfoId())).eq((Object)"merchant_id", (Object)reqDto.getMerchantId())) : this.customerDas.getMapper().selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"org_info_id", (Object)reqDto.getOrgInfoId())).eq((Object)"merchant_id", (Object)reqDto.getMerchantId())).ne((Object)"id", (Object)reqDto.getCustomerId()));
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)customerEoList)) {
            if (CustomerTypeEnum.DEALER.getCode().equals(reqDto.getType())) {
                respDto.setPass(false);
                respDto.setErrorMsg(String.format(CustomerExceptionCode.DEALER_CUSTOMER_EXISTS.getMsg(), ((CustomerEo)customerEoList.get(0)).getCode()));
            } else if (CustomerTypeEnum.RETAILER.getCode().equals(reqDto.getType())) {
                respDto.setPass(false);
                respDto.setErrorMsg(String.format(CustomerExceptionCode.RETAILER_CUSTOMER_EXISTS.getMsg(), ((CustomerEo)customerEoList.get(0)).getCode()));
            }
        }
        return respDto;
    }

    @Override
    public List<CustomerRespDto> queryListByCustomerIds(List<Long> ids) {
        List customerEos = this.customerDas.selectByIds(ids);
        RCustomerRegionEo selectEo = new RCustomerRegionEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"customer_id", ids));
        selectEo.setDr(0);
        selectEo.setSqlFilters(sqlFilters);
        List customerRegionEos = this.rCustomerRegionDas.select((BaseEo)selectEo);
        Map<Object, Object> customerTypeEoMap = Maps.newHashMap();
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)customerEos)) {
            Set customerTypeIds = customerEos.stream().map(StdCustomerEo::getCustomerTypeId).collect(Collectors.toSet());
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)queryWrapper.in(BaseEo::getId, customerTypeIds)).eq(BaseEo::getDr, (Object)0);
            List customerTypeEos = this.customerTypeDas.getMapper().selectList((Wrapper)queryWrapper);
            customerTypeEoMap = customerTypeEos.stream().collect(Collectors.toMap(BaseEo::getId, e -> e, (e1, e2) -> e1));
        }
        HashMap finalCustomerTypeEoMap = customerTypeEoMap;
        List<CustomerRespDto> list = customerEos.stream().map(item -> {
            CustomerTypeEo customerTypeEo;
            CustomerRespDto customerRespDto = new CustomerRespDto();
            DtoHelper.eo2Dto((BaseEo)item, (BaseVo)customerRespDto);
            if (CollUtil.isNotEmpty((Collection)customerRegionEos)) {
                List regionCodeList = customerRegionEos.stream().filter(e -> e.getCustomerId().equals(item.getId())).map(StdRCustomerRegionEo::getRegionCode).collect(Collectors.toList());
                if (CollUtil.isNotEmpty(regionCodeList)) {
                    CustomerAreaListReqDto customerAreaListReqDto = new CustomerAreaListReqDto();
                    customerAreaListReqDto.setCodes(regionCodeList);
                    customerRespDto.setRegionNames(StringUtils.join((Iterable)this.customerAreaService.queryForList(customerAreaListReqDto).stream().map(CustomerAreaRespDto::getName).collect(Collectors.toList()), (String)","));
                }
                customerRespDto.setRegionCodeList(regionCodeList);
            }
            if ((customerTypeEo = (CustomerTypeEo)finalCustomerTypeEoMap.get(item.getCustomerTypeId())) != null) {
                customerRespDto.setCustomerTypeName(customerTypeEo.getName());
            }
            return customerRespDto;
        }).collect(Collectors.toList());
        return list;
    }

    @Override
    public List<CustomerRespDto> queryCustomerListByUser(Long userId, Integer channel) {
        if (Objects.isNull(userId)) {
            userId = this.context.userId();
        }
        Long userOrgId = this.queryOrgIdByUserId(userId);
        Assert.notNull((Object)userOrgId, (String)(" \u627e\u4e0d\u5230userId\u5bf9\u5e94\u7684\u673a\u6784id,userId:" + userId), (Object[])new Object[0]);
        List<Long> orgIdList = new ArrayList<Long>();
        if (Objects.equals(channel, CustomerTypeEnum.BRAND.getCode())) {
            CustomerEo customerEo = new CustomerEo();
            customerEo.setMerchantId(userOrgId);
            List customerEos = this.customerDas.select((BaseEo)customerEo);
            orgIdList = customerEos.stream().map(StdCustomerEo::getOrgInfoId).collect(Collectors.toList());
        } else {
            orgIdList.add(userOrgId);
        }
        if (CollUtil.isEmpty(orgIdList)) {
            return ListUtil.empty();
        }
        return this.queryDownstreamCustomerListByOrgIds(orgIdList);
    }

    @Override
    public Integer queryMallPattern() {
        return this.mallPattern;
    }

    @Override
    public Long queryOrgIdByUserId(Long userId) {
        String cahceKey;
        Long cacheValue;
        AssertUtil.isTrue(userId != null, "queryOrgIdByUserId\uff0c\u627e\u4e0d\u5230userId:");
        if (userId.equals(this.context.userId())) {
            ServiceContext serviceContext = ServiceContext.getContext();
            String customer = serviceContext.getAttachment("yes.req.cus.b2b.customerid");
            if (StringUtils.isNotEmpty((CharSequence)customer)) {
                Long customerId = Long.valueOf(customer);
                return Optional.ofNullable(this.customerDas.selectByPrimaryKey(customerId)).map(StdCustomerEo::getOrgInfoId).orElse(null);
            }
            String object = serviceContext.getAttachment("yes.req.cus.b2b.organizationid");
            if (StringUtils.isNotEmpty((CharSequence)object)) {
                return Long.valueOf(object);
            }
        }
        if (null != (cacheValue = (Long)this.cacheService.getCache(cahceKey = "queryOrgIdByUserId_" + userId, Long.class))) {
            return cacheValue;
        }
        RestResponse pageInfoRestResponse = this.organizationQueryApi.queryUserOrgRelation(userId, Integer.valueOf(1), Integer.valueOf(1));
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResponse);
        AssertUtil.isTrue(!org.springframework.util.CollectionUtils.isEmpty((Collection)pageInfo.getList()), "\u5f53\u524d\u767b\u5f55\u4eba\u672a\u7ed1\u5b9a\u7ec4\u7ec7");
        this.logger.info("\u67e5\u8be2\u5230\u5173\u8054\u7684\u7ec4\u7ec7\u5173\u7cfb{}", (Object)JSON.toJSONString((Object)pageInfo.getList()));
        Long orgId = pageInfo.getList().stream().filter(o -> this.orgRootId.equals(o.getParentId())).findFirst().orElse(new OrganizationDto()).getId();
        if (orgId != null) {
            this.cacheService.setCache(cahceKey, (Object)orgId, 86400);
        }
        return orgId;
    }

    @Override
    public Long getCurrentUserOrgId() {
        AssertUtil.isTrue(this.context.userId() != null, "getCurrentUserOrgId\u65b9\u6cd5\uff0c\u4e0a\u4e0b\u6587\u4e2d\u627e\u4e0d\u5230userId");
        return this.queryOrgIdByUserId(this.context.userId());
    }

    @Override
    public List<Long> queryUpstreamOrgIdsByOrgId(Long userOrgId) {
        String cahceKey = "queryUpstreamOrgIdsByOrgId_" + userOrgId;
        List cacheValue = (List)this.cacheService.getCache(cahceKey, List.class);
        if (null != cacheValue) {
            return cacheValue;
        }
        List orgIds = this.customerDas.queryUpstreamOrgIdsByOrgId(userOrgId);
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)orgIds)) {
            this.cacheService.add(cahceKey, (Object)orgIds, 60);
        }
        return orgIds;
    }

    @Override
    public List<Long> queryUpstreamOrgIdsByUserId(Long userId) {
        ServiceContext serviceContext;
        String object;
        if (userId == null) {
            userId = this.context.userId();
        }
        if (userId.equals(this.context.userId()) && (object = (serviceContext = ServiceContext.getContext()).getAttachment("yes.req.cus.b2b.sellerorgid")) != null) {
            return Collections.singletonList(Long.valueOf(object));
        }
        Long currentUserOrgId = this.queryOrgIdByUserId(userId);
        Assert.notNull((Object)currentUserOrgId, (String)(" \u627e\u4e0d\u5230userId\u5bf9\u5e94\u7684\u673a\u6784id,userId:" + userId), (Object[])new Object[0]);
        return this.queryUpstreamOrgIdsByOrgId(currentUserOrgId);
    }

    @Override
    public List<Long> queryUpstreamOrgIdsByUserIdAndEnabledStatus(Long userId) {
        ServiceContext serviceContext;
        String object;
        if (userId == null) {
            userId = this.context.userId();
        }
        if (userId == null) {
            return Lists.newArrayList();
        }
        if (userId.equals(this.context.userId()) && StringUtils.isNotEmpty((CharSequence)(object = (String)(serviceContext = ServiceContext.getContext()).get("yes.req.cus.b2b.sellerorgid")))) {
            Long customerId;
            CustomerEo customerEo;
            CustomerStatusEo customerStatusEo;
            String customer = (String)serviceContext.get("yes.req.cus.b2b.customerid");
            if (StringUtils.isNotEmpty((CharSequence)customer) && (customerStatusEo = (CustomerStatusEo)this.customerStatusDas.selectByPrimaryKey((customerEo = (CustomerEo)this.customerDas.selectByPrimaryKey(customerId = Long.valueOf(customer))).getStatusId())) != null && StatusEnum.ENABLED.getCode().equals(customerStatusEo.getRecordStatus()) && StatusEnum.ENABLED.getCode().equals(customerStatusEo.getAccountStatus())) {
                return Collections.singletonList(Long.valueOf(object));
            }
            return Lists.newArrayList();
        }
        Long currentUserOrgId = this.queryOrgIdByUserId(userId);
        AssertUtil.isTrue(currentUserOrgId != null, " \u627e\u4e0d\u5230userId\u5bf9\u5e94\u7684\u673a\u6784id,userId:" + userId);
        List customerEoList = ((ExtQueryChainWrapper)this.customerDas.filter().eq((Object)"org_info_id", (Object)currentUserOrgId)).list();
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)customerEoList)) {
            return Lists.newArrayList();
        }
        ArrayList upstreamOrgIds = Lists.newArrayList();
        Map statusMap = ((ExtQueryChainWrapper)this.customerStatusDas.filter().in((Object)"id", (Collection)customerEoList.stream().map(StdCustomerEo::getStatusId).collect(Collectors.toSet()))).list().stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
        for (CustomerEo customerEo : customerEoList) {
            CustomerStatusEo customerStatusEo = (CustomerStatusEo)statusMap.get(customerEo.getStatusId());
            if (customerStatusEo == null || !StatusEnum.ENABLED.getCode().equals(customerStatusEo.getRecordStatus()) || !StatusEnum.ENABLED.getCode().equals(customerStatusEo.getAccountStatus())) continue;
            upstreamOrgIds.add(customerEo.getMerchantId());
        }
        return upstreamOrgIds;
    }

    @Override
    public List<Long> queryDownstreamOrgListByOrgId(Long orgInfoId) {
        String cahceKey;
        List cacheValue;
        if (Objects.isNull(orgInfoId)) {
            orgInfoId = this.getCurrentUserOrgId();
        }
        if (null != (cacheValue = (List)this.cacheService.getCache(cahceKey = "queryDownstreamOrgListByOrgId_" + orgInfoId, List.class))) {
            return cacheValue;
        }
        List customerEoList = this.customerDas.getMapper().selectList((Wrapper)new QueryWrapper().eq((Object)"merchant_id", (Object)orgInfoId));
        List<Long> orgIds = customerEoList.stream().map(StdCustomerEo::getOrgInfoId).collect(Collectors.toList());
        if (!org.springframework.util.CollectionUtils.isEmpty(orgIds)) {
            this.cacheService.add(cahceKey, orgIds, 60);
        }
        return orgIds;
    }

    @Override
    public List<CustomerRespDto> queryDownstreamCustomerListByOrgIds(List<Long> orgIds) {
        ArrayList list = Lists.newArrayList();
        if (org.springframework.util.CollectionUtils.isEmpty(orgIds)) {
            return list;
        }
        if ((orgIds = orgIds.stream().distinct().collect(Collectors.toList())).size() > 3000) {
            List partition = Lists.partition(orgIds, (int)3000);
            for (List org : partition) {
                CustomerEo customerDto = new CustomerEo();
                customerDto.setDr(0);
                QueryWrapper query = new QueryWrapper((Object)customerDto);
                query.in((Object)"merchant_id", (Collection)org);
                List customerList = this.customerDas.getMapper().selectList((Wrapper)query);
                ArrayList newList = Lists.newArrayList();
                DtoHelper.eoList2DtoList((Collection)customerList, (Collection)newList, CustomerRespDto.class);
                list.addAll(newList);
            }
            return list;
        }
        CustomerEo customerDto = new CustomerEo();
        customerDto.setDr(0);
        QueryWrapper query = new QueryWrapper((Object)customerDto);
        query.in((Object)"merchant_id", orgIds);
        List customerList = this.customerDas.getMapper().selectList((Wrapper)query);
        DtoHelper.eoList2DtoList((Collection)customerList, (Collection)list, CustomerRespDto.class);
        return list;
    }

    @Override
    public List<Long> queryDownstreamCustomerIdsByOrgIds(List<Long> orgIds) {
        List<CustomerRespDto> customerRespDtos = this.queryDownstreamCustomerListByOrgIds(orgIds);
        List<Long> collect = customerRespDtos.stream().map(BaseRespDto::getId).collect(Collectors.toList());
        return collect;
    }

    @Override
    public CustomerRespDto queryCustomerByOrgAndMerch(Long orgId, Long merchId) {
        CustomerRespDto res;
        String cahceKey = "queryCustomerByOrgAndMerch_" + orgId + "_" + merchId;
        CustomerRespDto cacheValue = (CustomerRespDto)this.cacheService.getCache(cahceKey, CustomerRespDto.class);
        if (null != cacheValue) {
            return cacheValue;
        }
        List customerRespDtos = this.customerDas.queryCustomerByOrgIdAndUpstreamOrgId(orgId, merchId);
        CustomerRespDto customerRespDto = res = !org.springframework.util.CollectionUtils.isEmpty((Collection)customerRespDtos) ? (CustomerRespDto)customerRespDtos.get(0) : null;
        if (res != null) {
            this.cacheService.add(cahceKey, (Object)res, 300);
        }
        return res;
    }

    @Override
    public List<Long> queryCustomerIdsByOrgId(List<Long> orgIds) {
        QueryWrapper filter = new QueryWrapper();
        if (!org.springframework.util.CollectionUtils.isEmpty(orgIds)) {
            filter.in((Object)"org_info_id", orgIds);
        }
        List customerEos = this.customerDas.getMapper().selectList((Wrapper)filter);
        List<Long> collect = customerEos.stream().map(BaseEo::getId).collect(Collectors.toList());
        return collect;
    }

    @Override
    public List<Long> queryCustomerIdsByUserId(Long userId) {
        ServiceContext serviceContext;
        String object;
        if (userId == null) {
            userId = this.context.userId();
        }
        if (userId.equals(this.context.userId()) && (object = (serviceContext = ServiceContext.getContext()).getAttachment("yes.req.cus.b2b.customerid")) != null) {
            return Collections.singletonList(Long.valueOf(object));
        }
        Long currentUserOrgId = this.queryOrgIdByUserId(userId);
        Assert.notNull((Object)currentUserOrgId, (String)(" \u627e\u4e0d\u5230userId\u5bf9\u5e94\u7684\u673a\u6784id,userId:" + userId), (Object[])new Object[0]);
        String cahceKey = "queryCustomerIdsByOrgId_" + currentUserOrgId;
        List cacheValue = (List)this.cacheService.getCache(cahceKey, List.class);
        if (null != cacheValue) {
            return cacheValue;
        }
        List<Long> customerIds = this.queryCustomerIdsByOrgId(Collections.singletonList(currentUserOrgId));
        if (!org.springframework.util.CollectionUtils.isEmpty(customerIds)) {
            this.cacheService.add(cahceKey, customerIds, 60);
        }
        return customerIds;
    }

    @Override
    public CustomerRespDto selectOneCustomerByOrgId(Long orgInfoId) {
        CustomerEo customerEo = new CustomerEo();
        customerEo.setOrgInfoId(orgInfoId);
        customerEo = (CustomerEo)this.customerDas.selectOne((BaseEo)customerEo);
        CustomerRespDto customerRespDto = null;
        if (customerEo != null) {
            CustomerLevelEo customerLevelEo;
            customerRespDto = new CustomerRespDto();
            CubeBeanUtils.copyProperties((Object)customerRespDto, (Object)customerEo, (String[])new String[0]);
            if (customerEo.getParentCustomerId() != null) {
                CustomerEo customerEo1 = (CustomerEo)this.customerDas.selectByPrimaryKey(customerEo.getParentCustomerId());
                customerEo1 = customerEo1 == null ? new CustomerEo() : customerEo1;
                customerRespDto.setParentCustomerName(customerEo1.getName());
            }
            CustomerTypeEo customerTypeEo = (CustomerTypeEo)this.customerTypeDas.selectByPrimaryKey(customerEo.getCustomerTypeId());
            org.springframework.util.Assert.notNull((Object)customerTypeEo, (String)CustomerExceptionCode.CUSTOMER_NON_EXIST.getMsg());
            customerRespDto.setCustomerTypeName(customerTypeEo.getName());
            RCustomerRegionEo selectEo = new RCustomerRegionEo();
            selectEo.setCustomerId(customerEo.getId());
            List customerRegionEos = this.rCustomerRegionDas.select((BaseEo)selectEo);
            List regionCodeList = customerRegionEos.stream().map(StdRCustomerRegionEo::getRegionCode).collect(Collectors.toList());
            customerRespDto.setRegionCodeList(regionCodeList);
            if (Objects.nonNull(customerEo.getLevelId()) && Objects.nonNull(customerLevelEo = (CustomerLevelEo)this.customerLevelDas.selectByPrimaryKey(customerEo.getLevelId()))) {
                customerRespDto.setLevelName(customerLevelEo.getName());
            }
        }
        return customerRespDto;
    }

    @Override
    public List<CustomerRespDto> queryListByOrgIdAndMerchantIds(List<Long> merchanIds, Long orgInfoId) {
        List eos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.customerDas.filter(true).in(CollectionUtils.isNotEmpty(merchanIds), (Object)"merchant_id", merchanIds)).eq(orgInfoId != null, (Object)"org_info_id", (Object)orgInfoId)).list();
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)eos)) {
            Map customerRegionsMap = ((ExtQueryChainWrapper)this.rCustomerRegionDas.filter(true).in((Object)"customer_id", (Collection)eos.stream().map(BaseEo::getId).collect(Collectors.toList()))).list().stream().collect(Collectors.groupingBy(StdRCustomerRegionEo::getCustomerId, Collectors.mapping(StdRCustomerRegionEo::getRegionCode, Collectors.toList())));
            return eos.stream().map(eo -> {
                CustomerRespDto customerRespDto = new CustomerRespDto();
                CubeBeanUtils.copyProperties((Object)customerRespDto, (Object)eo, (String[])new String[0]);
                customerRespDto.setRegionCodeList((List)customerRegionsMap.get(eo.getId()));
                return customerRespDto;
            }).collect(Collectors.toList());
        }
        return Lists.newArrayList();
    }

    @Override
    public List<CustomerRespDto> queryListByOrgIdsAndMerchantId(List<Long> orgInfoIds, Long merchantId) {
        CustomerEo customerEo = new CustomerEo();
        ArrayList sqlFilters = Lists.newArrayList();
        sqlFilters.add(SqlFilter.in((String)"org_info_id", orgInfoIds));
        customerEo.setMerchantId(merchantId);
        customerEo.setSqlFilters((List)sqlFilters);
        List eos = this.customerDas.select((BaseEo)customerEo);
        ArrayList customerRespDtos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)customerRespDtos, (Collection)eos, CustomerRespDto.class);
        return customerRespDtos;
    }

    @Override
    public void batchUpdateDeadline(CertificationDeadlineDto certificationDeadlineDto) {
        this.logger.info("\u6279\u91cf\u4fee\u6539\u5ba2\u6237\u8ba4\u8bc1\u622a\u81f3\u65f6\u95f4ids,{}", (Object)certificationDeadlineDto.getCustomerIds());
        this.logger.info("\u622a\u81f3\u65f6\u95f4,{}", (Object)certificationDeadlineDto.getDeadline());
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)certificationDeadlineDto.getCustomerIds())) {
            throw new BizException("-1", "\u5ba2\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.customerDas.updateCertificationDeadline(certificationDeadlineDto.getCustomerIds(), certificationDeadlineDto.getDeadline());
        this.customerDas.removeCache(certificationDeadlineDto.getCustomerIds().stream().collect(Collectors.toSet()));
    }

    @Override
    public List<CertificationCountRespDto> queryCertificationCount(String filter) {
        this.logger.info("\u8ba4\u8bc1\u6570\u91cf\u67e5\u8be2\u6761\u4ef6\uff0c{}", (Object)filter);
        CustomerSearchReqDto searchReqDto = new CustomerSearchReqDto();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            searchReqDto = (CustomerSearchReqDto)JSONObject.parseObject((String)filter, CustomerSearchReqDto.class);
        }
        return this.listCertificationCountRespDto(searchReqDto);
    }

    private List<CertificationCountRespDto> listCertificationCountRespDto(CustomerSearchReqDto searchReqDto) {
        List<Object> certificationCountDtos = new ArrayList<CertificationCountRespDto>();
        if (StringUtils.isNotEmpty((CharSequence)searchReqDto.getCompanyName())) {
            OrgAdvQueryReqDto orgAdvQueryReqDto = new OrgAdvQueryReqDto();
            orgAdvQueryReqDto.setName(searchReqDto.getCompanyName());
            RestResponse orgAdvResponse = this.organizationQueryExtApi.queryPage(orgAdvQueryReqDto, Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE));
            PageInfo orgAdvRespPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)orgAdvResponse);
            if (Objects.nonNull(orgAdvRespPageInfo) && !org.springframework.util.CollectionUtils.isEmpty((Collection)orgAdvRespPageInfo.getList())) {
                searchReqDto.setOrgInfoIds(orgAdvRespPageInfo.getList().stream().map(OrgAdvRespDto::getId).collect(Collectors.toList()));
            } else {
                return certificationCountDtos;
            }
        }
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)searchReqDto.getRegionCodes())) {
            CustomerAreaListReqDto customerAreaListReqDto = new CustomerAreaListReqDto();
            customerAreaListReqDto.setCodes(searchReqDto.getRegionCodes());
            List<String> regionCodeList = this.customerAreaService.querySubCodeAll(customerAreaListReqDto);
            RCustomerRegionEo selectEo = new RCustomerRegionEo();
            ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
            sqlFilters.add(SqlFilter.in((String)"region_code", regionCodeList));
            selectEo.setSqlFilters(sqlFilters);
            List customerRegionEos = this.rCustomerRegionDas.select((BaseEo)selectEo);
            Set customerIdList = customerRegionEos.stream().map(StdRCustomerRegionEo::getCustomerId).collect(Collectors.toSet());
            if (org.springframework.util.CollectionUtils.isEmpty(customerIdList)) {
                return certificationCountDtos;
            }
            searchReqDto.setIdList(new ArrayList(customerIdList));
        }
        if (Objects.nonNull(searchReqDto.getSalesmanId())) {
            RCustomerSalesmanEo eo = new RCustomerSalesmanEo();
            eo.setSalesmanId(searchReqDto.getSalesmanId());
            eo.setOrgId(this.queryOrgIdByUserId(this.context.userId()));
            List eos = this.rCustomerSalesmanDas.select((BaseEo)eo);
            if (org.springframework.util.CollectionUtils.isEmpty((Collection)eos)) {
                return certificationCountDtos;
            }
            List customerIdList = eos.stream().map(RCustomerSalesmanEo::getCustomerId).collect(Collectors.toList());
            List idList = searchReqDto.getIdList();
            if (org.springframework.util.CollectionUtils.isEmpty((Collection)idList)) {
                idList = customerIdList;
            } else {
                idList.retainAll(customerIdList);
            }
            if (org.springframework.util.CollectionUtils.isEmpty(idList)) {
                return certificationCountDtos;
            }
            searchReqDto.setIdList(idList);
        }
        if (searchReqDto.getListFlag().booleanValue()) {
            searchReqDto.setAuditStatus(AuditStatusEnum.AUDIT_PASS.getCode());
        }
        Long currentUserOrgId = this.getCurrentUserOrgId();
        Assert.isTrue((null != searchReqDto.getType() ? 1 : 0) != 0, (String)"\u5ba2\u6237\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.isTrue((null != searchReqDto.getChannel() ? 1 : 0) != 0, (String)"\u6e20\u9053\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (null != currentUserOrgId) {
            ArrayList merchantIds = Lists.newArrayList();
            if (CustomerTypeEnum.BRAND.getCode().equals(searchReqDto.getChannel())) {
                List customerEos;
                if (CustomerTypeEnum.DEALER.getCode().equals(searchReqDto.getType())) {
                    merchantIds.add(currentUserOrgId);
                } else if (CustomerTypeEnum.RETAILER.getCode().equals(searchReqDto.getType()) && !org.springframework.util.CollectionUtils.isEmpty((Collection)(customerEos = this.customerDas.getMapper().selectList((Wrapper)new QueryWrapper().eq((Object)"merchant_id", (Object)currentUserOrgId))))) {
                    merchantIds.addAll(customerEos.stream().filter(bean -> null != bean.getOrgInfoId()).map(StdCustomerEo::getOrgInfoId).collect(Collectors.toList()));
                }
            } else if (CustomerTypeEnum.DEALER.getCode().equals(searchReqDto.getChannel()) && CustomerTypeEnum.RETAILER.getCode().equals(searchReqDto.getType())) {
                merchantIds.add(currentUserOrgId);
            }
            searchReqDto.setMerchantIds((List)merchantIds);
        }
        certificationCountDtos = this.customerDas.queryCertificationCount(searchReqDto);
        return certificationCountDtos;
    }

    @Override
    public List<CertificationCountRespDto> queryCertificationCountPost(CustomerSearchReqDto searchReqDto) {
        return this.listCertificationCountRespDto(searchReqDto);
    }

    @Override
    public List<Long> querySubCustomerIdListByOrgIds(List<Long> orgIds) {
        if (org.springframework.util.CollectionUtils.isEmpty(orgIds)) {
            return Lists.newArrayList();
        }
        CustomerEo customerDto = new CustomerEo();
        customerDto.setDr(0);
        QueryWrapper query = new QueryWrapper((Object)customerDto);
        query.in((Object)"merchant_id", (Collection)orgIds.stream().distinct().collect(Collectors.toList()));
        return this.customerDas.getMapper().selectList((Wrapper)query.select(new String[]{"id"}));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disabledCustomer() {
        List respDtoList = this.customerDas.queryByEffectiveEnd();
        if (CollUtil.isEmpty((Collection)respDtoList)) {
            this.logger.info("\u5ba2\u6237\u67e5\u8be2\u4e3a\u7a7a");
            return;
        }
        CustomerStatusEo customerStatusEo = (CustomerStatusEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.customerStatusDas.filter().eq((Object)"code", (Object)"disabled")).last("Limit 1")).one();
        if (Objects.isNull(customerStatusEo)) {
            this.logger.info("\u5ba2\u6237\u72b6\u6001\u67e5\u8be2\u4e3a\u7a7a");
            return;
        }
        ArrayList customerEos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)customerEos, (Collection)respDtoList, CustomerEo.class);
        for (CustomerEo customerEo : customerEos) {
            customerEo.setStatusId(customerStatusEo.getId());
            this.customerDas.update((BaseEo)customerEo);
        }
    }

    @Override
    public void enableCustomer() {
        List respDtoList = this.customerDas.queryByEffectiveStart();
        if (CollUtil.isEmpty((Collection)respDtoList)) {
            this.logger.info("\u5ba2\u6237\u67e5\u8be2\u4e3a\u7a7a");
            return;
        }
        CustomerStatusEo customerStatusEo = (CustomerStatusEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.customerStatusDas.filter().eq((Object)"code", (Object)"enabled")).last("Limit 1")).one();
        if (Objects.isNull(customerStatusEo)) {
            this.logger.info("\u5ba2\u6237\u72b6\u6001\u67e5\u8be2\u4e3a\u7a7a");
            return;
        }
        ArrayList customerEos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)customerEos, (Collection)respDtoList, CustomerEo.class);
        for (CustomerEo customerEo : customerEos) {
            customerEo.setStatusId(customerStatusEo.getId());
            this.customerDas.update((BaseEo)customerEo);
        }
    }
}

