/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.customer.biz.customer.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.icommerce.utils.BizExceptionHelper;
import com.dtyunxi.icommerce.utils.IExceptionCode;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerSalesmanReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.RCustomerSalesmanReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.SalesmanReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerSalesmanRespDto;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.constants.CustomerExceptionCode;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.service.ICustomerExtService;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.service.ICustomerSalesmanService;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.service.IRCustomerSalesmanService;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.util.MybatisPlusUtils;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.CustomerDas;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.CustomerSalesmanDas;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.RCustomerSalesmanDas;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.CustomerEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.CustomerSalesmanEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.RCustomerSalesmanEo;
import com.dtyunxi.yundt.cube.center.customer.dao.stdeo.customer.StdCustomerEo;
import com.dtyunxi.yundt.cube.center.customer.dao.stdeo.customer.StdCustomerSalesmanEo;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IUserQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class CustomerSalesmanServiceImpl
implements ICustomerSalesmanService {
    @Resource
    private CustomerSalesmanDas customerSalesmanDas;
    @Resource
    private CustomerDas customerDas;
    @Resource
    private IUserQueryApi userQueryApi;
    @Resource
    private ICustomerExtService customerExtService;
    @Autowired
    private IRCustomerSalesmanService rCustomerSalesmanService;
    @Autowired
    private RCustomerSalesmanDas rCustomerSalesmanDas;
    @Autowired
    private IContext context;

    private synchronized String getSalesmanCode() {
        String yyddd = DateUtil.format((Date)new Date(), (String)"yyDDD");
        HashSet<String> numbersSet = new HashSet<String>();
        while (numbersSet.size() != 5) {
            numbersSet.add(RandomUtil.randomNumbers((int)5));
        }
        List codeList = numbersSet.stream().map(code -> "YWY".concat(yyddd).concat((String)code)).collect(Collectors.toList());
        CustomerSalesmanEo customerSalesmanEo = new CustomerSalesmanEo();
        LambdaQueryWrapper<CustomerSalesmanEo> queryWrapper = MybatisPlusUtils.newLambdaQueryWrapper(customerSalesmanEo);
        queryWrapper.in(StdCustomerSalesmanEo::getCode, codeList);
        List customerSalesmanEos = this.customerSalesmanDas.getMapper().selectList(queryWrapper);
        if (CollUtil.isEmpty((Collection)customerSalesmanEos)) {
            return (String)codeList.stream().findFirst().get();
        }
        return this.getSalesmanCode();
    }

    @Override
    public Long addCustomerSalesman(CustomerSalesmanReqDto addReqDto) {
        CustomerSalesmanEo customerSalesmanEo = new CustomerSalesmanEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)customerSalesmanEo);
        if (Objects.isNull(customerSalesmanEo.getUserId())) {
            BizExceptionHelper.throwBizException((IExceptionCode)CustomerExceptionCode.INVALID_USER_ID);
        }
        if (Objects.isNull(customerSalesmanEo.getOrgInfoId())) {
            customerSalesmanEo.setOrgInfoId(this.customerExtService.getCurrentUserOrgId());
        }
        MybatisPlusUtils.setCommonInfo(customerSalesmanEo);
        CustomerSalesmanEo userSalesmanEo = new CustomerSalesmanEo();
        userSalesmanEo.setUserId(customerSalesmanEo.getUserId());
        MybatisPlusUtils.checkUnique(this.customerSalesmanDas, userSalesmanEo, CustomerExceptionCode.CUSTOMER_SALESMAN_EXISTS);
        if (StrUtil.isNotBlank((CharSequence)customerSalesmanEo.getJobNumber())) {
            CustomerSalesmanEo jobSalesmanEo = new CustomerSalesmanEo();
            jobSalesmanEo.setJobNumber(customerSalesmanEo.getJobNumber());
            jobSalesmanEo.setOrgInfoId(customerSalesmanEo.getOrgInfoId());
            MybatisPlusUtils.checkUnique(this.customerSalesmanDas, jobSalesmanEo, CustomerExceptionCode.CUSTOMER_SALESMAN_JOB_NUMBER);
        }
        customerSalesmanEo.setCode(this.getSalesmanCode());
        this.customerSalesmanDas.insert((BaseEo)customerSalesmanEo);
        return customerSalesmanEo.getId();
    }

    @Override
    public void modifyCustomerSalesman(CustomerSalesmanReqDto modifyReqDto) {
        if (Objects.isNull(modifyReqDto.getId())) {
            return;
        }
        CustomerSalesmanEo customerSalesman = (CustomerSalesmanEo)this.customerSalesmanDas.selectByPrimaryKey(modifyReqDto.getId());
        if (Objects.isNull(customerSalesman)) {
            return;
        }
        CustomerSalesmanEo customerSalesmanEo = new CustomerSalesmanEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)customerSalesmanEo);
        if (Objects.isNull(customerSalesmanEo.getUserId())) {
            BizExceptionHelper.throwBizException((IExceptionCode)CustomerExceptionCode.INVALID_USER_ID);
        }
        CustomerSalesmanEo userSalesmanEo = new CustomerSalesmanEo();
        userSalesmanEo.setUserId(customerSalesmanEo.getUserId());
        userSalesmanEo.setId(customerSalesmanEo.getId());
        MybatisPlusUtils.checkUnique(this.customerSalesmanDas, userSalesmanEo, CustomerExceptionCode.CUSTOMER_SALESMAN_EXISTS);
        if (StrUtil.isNotBlank((CharSequence)customerSalesmanEo.getJobNumber())) {
            CustomerSalesmanEo jobSalesmanEo = new CustomerSalesmanEo();
            jobSalesmanEo.setJobNumber(customerSalesmanEo.getJobNumber());
            jobSalesmanEo.setOrgInfoId(customerSalesmanEo.getOrgInfoId());
            jobSalesmanEo.setId(customerSalesmanEo.getId());
            MybatisPlusUtils.checkUnique(this.customerSalesmanDas, jobSalesmanEo, CustomerExceptionCode.CUSTOMER_SALESMAN_JOB_NUMBER);
        }
        customerSalesmanEo.setCode(customerSalesman.getCode());
        customerSalesmanEo.setOrgInfoId(customerSalesman.getOrgInfoId());
        this.customerSalesmanDas.update((BaseEo)customerSalesmanEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeCustomerSalesman(String ids) {
        List salesmanIdList = Arrays.stream(ids.split(",")).distinct().map(id -> Long.valueOf(id)).collect(Collectors.toList());
        if (CollUtil.isEmpty(salesmanIdList)) {
            return;
        }
        List customerSalesmanEos = this.customerSalesmanDas.selectByIds(salesmanIdList);
        for (CustomerSalesmanEo customerSalesman : customerSalesmanEos) {
            if (Objects.equals(customerSalesman.getDr(), 1)) continue;
            this.customerSalesmanDas.logicDeleteById(customerSalesman.getId());
        }
        List userIdList = customerSalesmanEos.stream().filter(item -> Objects.equals(item.getDr(), 0) && Objects.nonNull(item.getUserId())).map(StdCustomerSalesmanEo::getUserId).distinct().collect(Collectors.toList());
        CustomerEo customerEo = new CustomerEo();
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)MybatisPlusUtils.newLambdaQueryWrapper(customerEo).in(StdCustomerEo::getSalesmanId, userIdList);
        List customerEos = this.customerDas.getMapper().selectList((Wrapper)queryWrapper);
        for (CustomerEo customer : customerEos) {
            customer.setSalesmanId(null);
            this.customerDas.update((BaseEo)customer);
        }
    }

    @Override
    public CustomerSalesmanRespDto queryById(Long id) {
        CustomerSalesmanEo customerSalesmanEo = (CustomerSalesmanEo)this.customerSalesmanDas.selectByPrimaryKey(id);
        CustomerSalesmanRespDto customerSalesmanRespDto = new CustomerSalesmanRespDto();
        DtoHelper.eo2Dto((BaseEo)customerSalesmanEo, (BaseVo)customerSalesmanRespDto);
        UserDto userDto = (UserDto)RestResponseHelper.extractData((RestResponse)this.userQueryApi.queryById(customerSalesmanEo.getUserId(), "{}"));
        if (Objects.nonNull(userDto)) {
            customerSalesmanRespDto.setUserName(userDto.getUserName());
        }
        CustomerEo customerEo = new CustomerEo();
        customerEo.setSalesmanId(customerSalesmanRespDto.getUserId());
        customerSalesmanRespDto.setCustomerCount(Integer.valueOf(this.customerDas.count((BaseEo)customerEo)));
        return customerSalesmanRespDto;
    }

    @Override
    public PageInfo<CustomerSalesmanRespDto> queryByPage(CustomerSalesmanReqDto customerSalesmanReqDto, Integer pageNum, Integer pageSize) {
        CustomerSalesmanEo customerSalesmanEo = new CustomerSalesmanEo();
        DtoHelper.dto2Eo((BaseVo)customerSalesmanReqDto, (BaseEo)customerSalesmanEo);
        if (Objects.isNull(customerSalesmanEo.getOrgInfoId())) {
            customerSalesmanEo.setOrgInfoId(this.customerExtService.getCurrentUserOrgId());
        }
        String name = customerSalesmanEo.getName();
        customerSalesmanEo.setName(null);
        LambdaQueryWrapper<CustomerSalesmanEo> queryWrapper = MybatisPlusUtils.newLambdaQueryWrapper(customerSalesmanEo);
        if (StrUtil.isNotBlank((CharSequence)name)) {
            queryWrapper.like(StdCustomerSalesmanEo::getName, (Object)name);
        }
        queryWrapper.orderByDesc(BaseEo::getCreateTime);
        PageInfo<CustomerSalesmanRespDto> dtoPageInfo = MybatisPlusUtils.selectPage(this.customerSalesmanDas, queryWrapper, CustomerSalesmanRespDto.class, pageNum, pageSize);
        List list = dtoPageInfo.getList();
        if (CollUtil.isEmpty((Collection)list)) {
            return dtoPageInfo;
        }
        List userIdList = list.stream().filter(item -> Objects.nonNull(item.getUserId())).map(item -> item.getUserId()).distinct().collect(Collectors.toList());
        if (CollUtil.isEmpty(userIdList)) {
            return dtoPageInfo;
        }
        RCustomerSalesmanEo salesmanEo = new RCustomerSalesmanEo();
        salesmanEo.setDr(0);
        LambdaQueryWrapper customerWrapper = new QueryWrapper((Object)salesmanEo).select(new String[]{"salesman_id,COUNT(1) AS count"}).lambda();
        customerWrapper.groupBy(RCustomerSalesmanEo::getSalesmanId);
        customerWrapper.in(RCustomerSalesmanEo::getSalesmanId, userIdList);
        customerWrapper.eq(RCustomerSalesmanEo::getOrgId, (Object)this.customerExtService.queryOrgIdByUserId(this.context.userId()));
        List salesmanEos = this.rCustomerSalesmanDas.getMapper().selectList((Wrapper)customerWrapper);
        Map<Long, Integer> countMap = salesmanEos.stream().collect(Collectors.toMap(RCustomerSalesmanEo::getSalesmanId, RCustomerSalesmanEo::getCount));
        list.forEach(item -> {
            if (countMap.containsKey(item.getUserId())) {
                item.setCustomerCount((Integer)countMap.get(item.getUserId()));
            }
        });
        return dtoPageInfo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void changeSalesman(SalesmanReqDto salesmanReqDto) {
        CustomerSalesmanEo customerSalesmanEo = (CustomerSalesmanEo)this.customerSalesmanDas.selectByPrimaryKey(salesmanReqDto.getSalesmanId());
        if (Objects.isNull(customerSalesmanEo) || Objects.isNull(customerSalesmanEo.getUserId())) {
            return;
        }
        List customerIdList = salesmanReqDto.getCustomerIdList();
        if (CollUtil.isEmpty((Collection)customerIdList)) {
            return;
        }
        Long userId = customerSalesmanEo.getUserId();
        List customerEos = this.customerDas.selectByIds(customerIdList);
        for (CustomerEo customerEo : customerEos) {
            customerEo.setSalesmanId(userId);
            this.customerDas.update((BaseEo)customerEo);
        }
    }

    @Override
    public void endSalesman(SalesmanReqDto salesmanReqDto) {
        CustomerSalesmanEo customerSalesmanEo = (CustomerSalesmanEo)this.customerSalesmanDas.selectByPrimaryKey(salesmanReqDto.getSalesmanId());
        if (Objects.isNull(customerSalesmanEo)) {
            return;
        }
        List customerIdList = salesmanReqDto.getCustomerIdList();
        if (CollUtil.isEmpty((Collection)customerIdList)) {
            return;
        }
        CustomerEo customerEo = new CustomerEo();
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)MybatisPlusUtils.newLambdaQueryWrapper(customerEo).in(BaseEo::getId, (Collection)customerIdList);
        List customerEos = this.customerDas.getMapper().selectList((Wrapper)queryWrapper);
        for (CustomerEo customer : customerEos) {
            customer.setSalesmanId(null);
            this.customerDas.update((BaseEo)customer);
        }
    }

    @Override
    public void addSalesmanRelation(SalesmanReqDto salesmanReqDto) {
        CustomerSalesmanEo customerSalesmanEo = (CustomerSalesmanEo)this.customerSalesmanDas.selectByPrimaryKey(salesmanReqDto.getSalesmanId());
        if (Objects.isNull(customerSalesmanEo) || Objects.isNull(customerSalesmanEo.getUserId())) {
            return;
        }
        List customerIdList = salesmanReqDto.getCustomerIdList();
        if (CollUtil.isEmpty((Collection)customerIdList)) {
            return;
        }
        ArrayList list = Lists.newArrayList();
        for (Long customerId : customerIdList) {
            RCustomerSalesmanEo salesmanEo = new RCustomerSalesmanEo();
            salesmanEo.setSalesmanId(customerSalesmanEo.getUserId());
            salesmanEo.setCustomerId(customerId);
            salesmanEo.setOrgId(customerSalesmanEo.getOrgInfoId());
            list.add(salesmanEo);
        }
        this.rCustomerSalesmanService.syncBatchAdd(list);
    }

    @Override
    public Boolean querySalesmanStatusByUserId(Long userId) {
        CustomerSalesmanEo customerSalesmanEo = new CustomerSalesmanEo();
        customerSalesmanEo.setUserId(userId);
        List list = this.customerSalesmanDas.select((BaseEo)customerSalesmanEo);
        if (CollUtil.isEmpty((Collection)list)) {
            return null;
        }
        CustomerSalesmanEo customerSalesman = (CustomerSalesmanEo)list.stream().findFirst().get();
        return Objects.equals(customerSalesman.getStatus(), 1);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchAddSalesmanRelation(List<CustomerSalesmanReqDto> customerSalesmanReqDtos) {
        if (CollectionUtils.isEmpty(customerSalesmanReqDtos)) {
            return;
        }
        for (CustomerSalesmanReqDto customerSalesmanReqDto : customerSalesmanReqDtos) {
            if (CollectionUtils.isEmpty((Collection)customerSalesmanReqDto.getCustomerSalesmanReqDtos())) continue;
            HashSet customerCodes = Sets.newHashSet();
            HashSet orgIds = Sets.newHashSet();
            for (RCustomerSalesmanReqDto salesmanReqDto : customerSalesmanReqDto.getCustomerSalesmanReqDtos()) {
                if (StringUtils.isNotBlank((String)salesmanReqDto.getCustomerCode())) {
                    customerCodes.add(salesmanReqDto.getCustomerCode());
                }
                if (salesmanReqDto.getOrgId() == null) continue;
                orgIds.add(salesmanReqDto.getOrgId());
            }
            CustomerSalesmanEo salesmanEo = new CustomerSalesmanEo();
            ArrayList salesmanSqlFilters = Lists.newArrayList();
            salesmanSqlFilters.add(SqlFilter.in((String)"org_info_id", (Object)orgIds));
            salesmanEo.setSqlFilters((List)salesmanSqlFilters);
            salesmanEo.setUserId(customerSalesmanReqDto.getUserId());
            List eos = this.customerSalesmanDas.select((BaseEo)salesmanEo);
            Map<String, CustomerSalesmanEo> salesmanEoMap = eos.stream().collect(Collectors.toMap(e -> e.getUserId() + "#" + e.getOrgInfoId(), e -> e, (e1, e2) -> e1));
            Map<Object, Object> eoMap = Maps.newHashMap();
            if (CollectionUtil.isNotEmpty((Collection)customerCodes)) {
                CustomerEo customerEo = new CustomerEo();
                ArrayList sqlFilters = Lists.newArrayList();
                sqlFilters.add(SqlFilter.in((String)"third_party_id", (Object)customerCodes));
                customerEo.setSqlFilters((List)sqlFilters);
                List customerEos = this.customerDas.select((BaseEo)customerEo);
                eoMap = customerEos.stream().collect(Collectors.toMap(StdCustomerEo::getThirdPartyId, e -> e, (e1, e2) -> e1));
            }
            HashMap map = Maps.newHashMap();
            ArrayList relations = Lists.newArrayList();
            for (RCustomerSalesmanReqDto dto : customerSalesmanReqDto.getCustomerSalesmanReqDtos()) {
                CustomerSalesmanEo customerSalesmanEo;
                if (!salesmanEoMap.containsKey(customerSalesmanReqDto.getUserId() + "#" + dto.getOrgId()) && !map.containsKey(customerSalesmanReqDto.getUserId() + "#" + dto.getOrgId())) {
                    customerSalesmanEo = new CustomerSalesmanEo();
                    CubeBeanUtils.copyProperties((Object)customerSalesmanEo, (Object)customerSalesmanReqDto, (String[])new String[]{"orgInfoId"});
                    customerSalesmanEo.setOrgInfoId(dto.getOrgId());
                    customerSalesmanEo.setId(Long.valueOf(IdGenrator.nextId((long)IdGenrator.getWorkerId(), (long)ServiceContext.getContext().getRequestTenantCode())));
                    map.put(customerSalesmanReqDto.getUserId() + "#" + dto.getOrgId(), customerSalesmanEo);
                    salesmanEoMap.put(customerSalesmanReqDto.getUserId() + "#" + dto.getOrgId(), customerSalesmanEo);
                }
                if (!eoMap.containsKey(dto.getCustomerCode())) continue;
                customerSalesmanEo = salesmanEoMap.get(customerSalesmanReqDto.getUserId() + "#" + dto.getOrgId());
                CustomerEo customerEo1 = (CustomerEo)eoMap.get(dto.getCustomerCode());
                RCustomerSalesmanEo rCustomerSalesmanEo = new RCustomerSalesmanEo();
                rCustomerSalesmanEo.setSalesmanId(customerSalesmanReqDto.getUserId());
                rCustomerSalesmanEo.setCustomerId(customerEo1.getId());
                rCustomerSalesmanEo.setRealSalesmanId(customerSalesmanEo.getId());
                rCustomerSalesmanEo.setOrgId(dto.getOrgId());
                relations.add(rCustomerSalesmanEo);
            }
            this.customerSalesmanDas.insertBatch(new ArrayList(map.values()));
            this.rCustomerSalesmanService.syncBatchAdd(relations);
        }
    }

    @Override
    public void updateStatus(CustomerSalesmanReqDto modifyReqDto) {
        this.customerSalesmanDas.getMapper().update(null, (Wrapper)((LambdaUpdateWrapper)new UpdateWrapper().lambda().set(true, StdCustomerSalesmanEo::getStatus, (Object)modifyReqDto.getStatus()).eq(StdCustomerSalesmanEo::getUserId, (Object)modifyReqDto.getUserId())).eq(StdCustomerSalesmanEo::getOrgInfoId, (Object)modifyReqDto.getOrgInfoId()));
    }
}

