/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.price.biz.utils;

import com.dtyunxi.huieryun.cache.api.ICacheService;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CodeGenerateUtil {
    private static final String ACCOUNT_FLOW_CODE = "ACCOUNT_FLOW_CODE";
    private static final String ACCOUNT_CODE_PREFIX = "YJ";
    private static final String APPLY_CODE = "APPLY_CODE";
    private static final String APPLY_CODE_PREFIX = "XT";
    @Autowired
    private ICacheService cacheService;

    public String getAccountFlowCode() {
        return this.getCode(ACCOUNT_CODE_PREFIX, ACCOUNT_FLOW_CODE);
    }

    public String getApplyCode() {
        return this.getCode(APPLY_CODE_PREFIX, APPLY_CODE);
    }

    public String getCode(String prefix, String codeCache) {
        String nowTime = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
        long incr = this.cacheService.incr(codeCache);
        if (incr < 1000L) {
            String temp = String.valueOf(1000L + incr);
            temp = temp.replaceFirst("1", "0");
            return prefix + nowTime.concat(temp);
        }
        String temp = String.valueOf(incr);
        temp = temp.substring(temp.length() - 4);
        return prefix + nowTime.concat(temp);
    }
}

