/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.price.dao.das;

import cn.hutool.core.date.DateUtil;
import com.dtyunxi.yundt.cube.center.price.api.dto.PriceTypeDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.CommunalPriceQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.PriceQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.PriceQueryReqV2Dto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.PriceRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.PriceRespV2Dto;
import com.dtyunxi.yundt.cube.center.price.dao.das.base.AbstractBaseDas;
import com.dtyunxi.yundt.cube.center.price.dao.eo.PriceEo;
import com.dtyunxi.yundt.cube.center.price.dao.mapper.PriceMapper;
import com.github.pagehelper.PageHelper;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.stereotype.Repository;

@Repository
public class PriceDas
extends AbstractBaseDas<PriceEo, Long> {
    @Resource
    private PriceMapper priceMapper;

    public List<PriceRespDto> selectPageList(PriceQueryReqDto reqDto) {
        return this.priceMapper.selectPageList(reqDto);
    }

    public List<PriceTypeDto> selectPriceItemList(List<Long> skuIdList, List<Long> priceTypeIdList, Long tenantId, Long instanceId) {
        return this.priceMapper.selectPriceItemList(skuIdList, priceTypeIdList, tenantId, instanceId);
    }

    public List<PriceEo> selectEnablePricePolicy(CommunalPriceQueryReqDto reqDto) {
        return this.priceMapper.selectEnablePricePolicyList(reqDto);
    }

    public List<PriceRespV2Dto> queryPriceByPage(PriceQueryReqV2Dto reqDto) {
        PageHelper.startPage((int)reqDto.getPageNum(), (int)reqDto.getPageSize());
        return this.priceMapper.queryPage(reqDto);
    }

    public List<PriceEo> queryEffectivePriceList(PriceEo price, Integer relationCustomerType, Integer relationItemType) {
        Long orgId = price.getOrganizationId();
        Long typeId = price.getTypeId();
        Long originalPriceId = price.getOriginalPriceId();
        String startTime = DateUtil.format((Date)price.getEffectiveTime(), (String)"yyyy-MM-dd HH:mm:ss");
        String endTime = Objects.isNull(price.getInvalidTime()) ? "9999-12-12 23:59:59" : DateUtil.format((Date)price.getInvalidTime(), (String)"yyyy-MM-dd HH:mm:ss");
        return this.priceMapper.queryEffectivePriceList(orgId, typeId, originalPriceId, relationCustomerType, relationItemType, startTime, endTime);
    }

    public PriceEo checkPriceNameUnique(Long orgId, Long id, String name, boolean limitStatus) {
        return this.priceMapper.checkPriceNameUnique(orgId, id, name, limitStatus, DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
    }

    public PriceEo queryById(Long id) {
        return this.priceMapper.queryById(id);
    }
}

