/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.rebate.svr.rest;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.rebate.api.IOrderApi;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.OrderDetailVO;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.OrderAddReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.OrderAdjustmentReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.OrderAuditReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.OrderModifyReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.OrderQueryReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.RebateOrderCountReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.response.OrderImportRespDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.response.OrderRespDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.response.RebateOrderCountRespDto;
import com.dtyunxi.yundt.cube.center.rebate.api.query.IOrderQueryApi;
import com.github.pagehelper.PageInfo;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/v1/order"})
public class OrderRest
implements IOrderApi,
IOrderQueryApi {
    @Resource
    private IOrderApi orderApi;
    @Resource
    private IOrderQueryApi orderQueryApi;

    public RestResponse<Long> addOrder(@Valid @RequestBody OrderAddReqDto reqDto) {
        return this.orderApi.addOrder(reqDto);
    }

    public RestResponse<OrderImportRespDto> importOrder(@RequestParam(value="file") MultipartFile file) {
        return this.orderApi.importOrder(file);
    }

    public RestResponse<Void> modifyOrder(@Valid @RequestBody OrderModifyReqDto reqDto) {
        return this.orderApi.modifyOrder(reqDto);
    }

    public RestResponse<Void> removeOrder(@RequestBody List<Long> ids) {
        return this.orderApi.removeOrder(ids);
    }

    public RestResponse<OrderRespDto> queryOrderById(@PathVariable(value="id") Long id) {
        return this.orderQueryApi.queryOrderById(id);
    }

    public RestResponse<PageInfo<OrderRespDto>> queryOrderByPage(@SpringQueryMap OrderQueryReqDto reqDto, @RequestParam(name="pageNum", required=false, defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", required=false, defaultValue="10") Integer pageSize) {
        return this.orderQueryApi.queryOrderByPage(reqDto, pageNum, pageSize);
    }

    public RestResponse<PageInfo<OrderDetailVO>> queryOrderDetailById(Long id, Integer pageNum, Integer pageSize) {
        return this.orderQueryApi.queryOrderDetailById(id, pageNum, pageSize);
    }

    public RestResponse<Void> auditRebateOrder(@Valid @RequestBody OrderAuditReqDto reqDto) {
        return this.orderApi.auditRebateOrder(reqDto);
    }

    public RestResponse<Void> issueRebate(@PathVariable(value="ids") String ids) {
        return this.orderApi.issueRebate(ids);
    }

    public RestResponse<Void> manualAdjustment(@RequestBody @Valid OrderAdjustmentReqDto orderAdjustmentReqDto) {
        return this.orderApi.manualAdjustment(orderAdjustmentReqDto);
    }

    public RestResponse<RebateOrderCountRespDto> queryOrderCount(@RequestBody RebateOrderCountReqDto reqDto) {
        return this.orderQueryApi.queryOrderCount(reqDto);
    }
}

