package com.dtyunxi.yundt.cube.center.customer.dao.stdeo.customer;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;

import javax.persistence.Column;

/**
 * StdInvoiceInfoEo对象
 *
 * @author liuji
 * @since 2021-07-19
 */
public class StdInvoiceInfoEo extends CubeBaseEo {

    /**
     * 纳税人识别号
     */
    @Column(name = "duty_num")
    private String dutyNum;
    /**
     * 发票内容
     */
    @Column(name = "invoice_content")
    private String invoiceContent;
    /**
     * 发票内容类型
     */
    @Column(name = "invoice_content_type")
    private String invoiceContentType;
    /**
     * 是否默认发票内容 0 不是默认发票内容   1 是默认发票内容
     */
    @Column(name = "invoice_status")
    private Integer invoiceStatus;
    /**
     * 发票抬头
     */
    @Column(name = "invoice_title")
    private String invoiceTitle;
    /**
     * 发票抬头类型:0:个人 1, 组织
     */
    @Column(name = "invoice_title_type")
    private Integer invoiceTitleType;
    /**
     * 发票类型:0:普通发票 1:专用发票
     */
    @Column(name = "invoice_type")
    private Integer invoiceType;

    /**
     * 组织信息ID
     */
    @Column(name = "org_info_id")
    private Long orgInfoId;


    public String getDutyNum() {
        return dutyNum;
    }

    public void setDutyNum(String dutyNum) {
        this.dutyNum = dutyNum;
    }

    public String getInvoiceContent() {
        return invoiceContent;
    }

    public void setInvoiceContent(String invoiceContent) {
        this.invoiceContent = invoiceContent;
    }

    public String getInvoiceContentType() {
        return invoiceContentType;
    }

    public void setInvoiceContentType(String invoiceContentType) {
        this.invoiceContentType = invoiceContentType;
    }

    public Integer getInvoiceStatus() {
        return invoiceStatus;
    }

    public void setInvoiceStatus(Integer invoiceStatus) {
        this.invoiceStatus = invoiceStatus;
    }

    public String getInvoiceTitle() {
        return invoiceTitle;
    }

    public void setInvoiceTitle(String invoiceTitle) {
        this.invoiceTitle = invoiceTitle;
    }

    public Integer getInvoiceTitleType() {
        return invoiceTitleType;
    }

    public void setInvoiceTitleType(Integer invoiceTitleType) {
        this.invoiceTitleType = invoiceTitleType;
    }

    public Integer getInvoiceType() {
        return invoiceType;
    }

    public void setInvoiceType(Integer invoiceType) {
        this.invoiceType = invoiceType;
    }

    public Long getOrgInfoId() {
        return orgInfoId;
    }

    public void setOrgInfoId(Long orgInfoId) {
        this.orgInfoId = orgInfoId;
    }
}