/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.rebate.biz.gift.service.impl;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.util.ObjectUtil;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.mj.biz.commons.utils.EasyPoiExportUtil;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.constant.IncomeExpenditureEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.constant.TradeTypeEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.enums.AdvanceModeEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.enums.AdvanceStatusEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.enums.SendBackEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.BalanceAdvanceAddReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.BalanceAdvanceQueryReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.BalanceQueryReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.BalanceStatementAddReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.GiftBalanceModifyReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.response.balance.BalanceAdvanceListRespDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.response.balance.BalanceDetailRespDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.response.balance.BalanceListRespDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.response.balance.GiftBalanceExcelRespDto;
import com.dtyunxi.yundt.cube.center.rebate.biz.gift.mq.BalanceAdvanceParams;
import com.dtyunxi.yundt.cube.center.rebate.biz.gift.service.ICommonService;
import com.dtyunxi.yundt.cube.center.rebate.biz.gift.service.IGiftBalanceAdvanceService;
import com.dtyunxi.yundt.cube.center.rebate.biz.gift.service.IGiftBalanceService;
import com.dtyunxi.yundt.cube.center.rebate.biz.gift.service.IGiftBalanceStatementService;
import com.dtyunxi.yundt.cube.center.rebate.biz.gift.utils.BeanUtils;
import com.dtyunxi.yundt.cube.center.rebate.biz.gift.utils.NumberFormatUtils;
import com.dtyunxi.yundt.cube.center.rebate.biz.gift.utils.RandomBalanceCodeUtil;
import com.dtyunxi.yundt.cube.center.rebate.biz.gift.vo.GiftBalanceAdvanceExportVo;
import com.dtyunxi.yundt.cube.center.rebate.biz.gift.vo.GiftBalanceAdvanceImportExportVo;
import com.dtyunxi.yundt.cube.center.rebate.dao.eo.gift.GiftBalanceAdvanceEo;
import com.dtyunxi.yundt.cube.center.rebate.dao.gift.das.GiftBalanceAdvanceDas;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class GiftBalanceAdvanceServiceImpl
implements IGiftBalanceAdvanceService {
    private static final Logger logger = LoggerFactory.getLogger(GiftBalanceAdvanceServiceImpl.class);
    @Resource
    private GiftBalanceAdvanceDas giftBalanceAdvanceDas;
    @Resource
    private IGiftBalanceStatementService giftBalanceStatementService;
    @Resource
    private IGiftBalanceService giftBalanceService;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private ICommonsMqService mqService;
    @Resource
    private IContext context;
    @Resource
    private Environment environment;
    @Resource
    private ICommonService commonService;

    @Override
    public PageInfo<BalanceAdvanceListRespDto> queryPage(BalanceAdvanceQueryReqDto reqDto) {
        PageHelper.startPage((int)reqDto.getPageNum(), (int)reqDto.getPageSize());
        if (ObjectUtil.isEmpty((Object)reqDto.getOrganizationId())) {
            Long userId = reqDto.getUserId();
            Long orgId = (Long)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryOrgIdByUserId(userId == null ? this.context.userId() : userId));
            reqDto.setOrganizationId(orgId);
        }
        if (ObjectUtil.isEmpty((Object)reqDto.getOrganizationId())) {
            logger.info("\u7ec4\u7ec7ID\u4e3a\u7a7a");
            return new PageInfo();
        }
        logger.info("\u67e5\u8be2\u9884\u652f\u989d\u5ea6 {}", (Object)reqDto);
        List respDtoList = this.giftBalanceAdvanceDas.queryPage(reqDto, null, this.context.tenantId(), this.context.instanceId());
        return new PageInfo(respDtoList);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void add(BalanceAdvanceAddReqDto addReqDto) {
        MessageResponse messageResponse;
        long delayTime;
        logger.info("\u65b0\u589e\u9884\u652f\u989d\u5ea6 {}", (Object)addReqDto);
        GiftBalanceAdvanceEo eo = new GiftBalanceAdvanceEo();
        String advanceNo = RandomBalanceCodeUtil.getDataToNumber(6);
        BeanUtils.copyProperties(addReqDto, eo);
        eo.setAdvanceNo(advanceNo);
        if (addReqDto.getSendBackEnum() != null) {
            eo.setSendBack(addReqDto.getSendBackEnum().getCode());
        }
        eo.setStatus(AdvanceStatusEnum.IS_SEND.getCode());
        if (addReqDto.getSendBackEnum() != null) {
            eo.setAdvanceMode(addReqDto.getAdvanceModeEnum().getCode());
        }
        eo.setAdvanceTime(com.dtyunxi.util.DateUtil.getSysDate());
        this.giftBalanceAdvanceDas.insert((BaseEo)eo);
        eo = new GiftBalanceAdvanceEo();
        eo.setCustomerId(addReqDto.getCustomerId());
        eo.setAdvanceNo(advanceNo);
        eo.setAdvanceAmount(null);
        GiftBalanceAdvanceEo oldEo = (GiftBalanceAdvanceEo)this.giftBalanceAdvanceDas.selectOne((BaseEo)eo);
        if (AdvanceModeEnum.IMMEDIATELY.getCode().equals(eo.getAdvanceMode())) {
            this.send(oldEo.getId());
            return;
        }
        BalanceAdvanceParams message = new BalanceAdvanceParams();
        message.setId(oldEo.getId());
        message.setSendOrBack(true);
        message.setAdvanceGrantTime(addReqDto.getAdvanceGrantTime());
        message.setAdvanceSendBackTime(addReqDto.getAdvanceSendBackTime());
        long currentTimeMillis = System.currentTimeMillis();
        if (addReqDto.getAdvanceGrantTime() == null) {
            this.send(oldEo.getId());
        } else {
            delayTime = addReqDto.getAdvanceGrantTime().getTime() - currentTimeMillis < 0L ? 0L : addReqDto.getAdvanceGrantTime().getTime() - currentTimeMillis;
            messageResponse = this.mqService.sendDelaySingleMessageAsync(this.environment.resolvePlaceholders("${GIFT_BALANCE_ADVANCE_TOPIC:GIFT_BALANCE_TOPIC}"), this.environment.resolvePlaceholders("${GIFT_BALANCE_ADVANCE_TAG:GIFT_BALANCE_TAG}"), (Object)message, Long.valueOf(delayTime / 1000L));
            logger.info("\u65b0\u589e\u9884\u652f\u989d\u5ea6\u53d1\u653e\u901a\u77e5 {}, {}", (Object)addReqDto, (Object)messageResponse);
        }
        if (SendBackEnum.YES.getCode().equals(addReqDto.getSendBackEnum().getCode())) {
            message.setSendOrBack(false);
            delayTime = addReqDto.getAdvanceSendBackTime().getTime() - currentTimeMillis < 0L ? 0L : addReqDto.getAdvanceSendBackTime().getTime() - currentTimeMillis;
            messageResponse = this.mqService.sendDelaySingleMessageAsync(this.environment.resolvePlaceholders("${GIFT_BALANCE_ADVANCE_TOPIC:GIFT_BALANCE_TOPIC}"), this.environment.resolvePlaceholders("${GIFT_BALANCE_ADVANCE_TAG:GIFT_BALANCE_TAG}"), (Object)message, Long.valueOf(delayTime / 1000L));
            logger.info("\u65b0\u589e\u9884\u652f\u989d\u5ea6\u5f52\u8fd8\u901a\u77e5 {}, {}", (Object)addReqDto, (Object)messageResponse);
        }
    }

    @Override
    @Transactional
    public int delete(Long id) {
        logger.info("\u5220\u9664\u9884\u652f\u989d\u5ea6 {}", (Object)id);
        GiftBalanceAdvanceEo eo = (GiftBalanceAdvanceEo)this.giftBalanceAdvanceDas.selectByPrimaryKey(id);
        if (eo == null) {
            throw new BizException("\u9884\u652f\u989d\u5ea6\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        if (!AdvanceStatusEnum.IS_SEND.getCode().equals(eo.getStatus())) {
            throw new BusinessRuntimeException("\u975e\u5f85\u53d1\u653e\u989d\u5ea6\u4e0d\u80fd\u5220\u9664");
        }
        this.giftBalanceAdvanceDas.delete((BaseEo)eo);
        return 1;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void send(Long id) {
        GiftBalanceAdvanceEo eo = (GiftBalanceAdvanceEo)this.giftBalanceAdvanceDas.selectByPrimaryKey(id);
        if (SendBackEnum.YES.getCode().endsWith(eo.getSendBack())) {
            eo.setStatus(AdvanceStatusEnum.WAIT_RETURN.getCode());
        } else {
            eo.setStatus(AdvanceStatusEnum.NO_RETURN.getCode());
        }
        if (eo.getAdvanceTime() == null) {
            eo.setAdvanceTime(com.dtyunxi.util.DateUtil.getSysDate());
        }
        if (eo.getAdvanceGrantTime() == null) {
            eo.setAdvanceGrantTime(com.dtyunxi.util.DateUtil.getSysDate());
        }
        GiftBalanceModifyReqDto giftBalanceModifyReqDto = new GiftBalanceModifyReqDto();
        giftBalanceModifyReqDto.setCustomerId(eo.getCustomerId());
        giftBalanceModifyReqDto.setUsableBalance(eo.getAdvanceAmount());
        giftBalanceModifyReqDto.setBalance(eo.getAdvanceAmount());
        this.giftBalanceService.modify(giftBalanceModifyReqDto);
        BalanceDetailRespDto balanceDetailRespDto = this.getBalanceDetailRespDto(eo);
        logger.info("\u9884\u652f\u989d\u5ea6\u53d1\u653e {}, {}, {}, {}", new Object[]{id, eo, giftBalanceModifyReqDto, balanceDetailRespDto});
        BalanceStatementAddReqDto statementAdd = new BalanceStatementAddReqDto();
        statementAdd.setTradeTypeEnum(TradeTypeEnum.QUOTA_ISSUANCE);
        statementAdd.setTradeAmount(eo.getAdvanceAmount());
        statementAdd.setBalance(balanceDetailRespDto.getBalance());
        statementAdd.setIncomeExpenditureEnum(IncomeExpenditureEnum.INCOME);
        statementAdd.setBusinessNo(eo.getAdvanceNo());
        statementAdd.setCustomerId(eo.getCustomerId());
        this.giftBalanceStatementService.add(statementAdd);
        this.giftBalanceAdvanceDas.update((BaseEo)eo);
    }

    @Override
    public void sendBack(Long id) {
        GiftBalanceAdvanceEo eo = (GiftBalanceAdvanceEo)this.giftBalanceAdvanceDas.selectByPrimaryKey(id);
        if (SendBackEnum.YES.getCode().endsWith(eo.getSendBack())) {
            eo.setStatus(AdvanceStatusEnum.ALEADY_RETURN.getCode());
        }
        GiftBalanceModifyReqDto giftBalanceModifyReqDto = new GiftBalanceModifyReqDto();
        giftBalanceModifyReqDto.setCustomerId(eo.getCustomerId());
        giftBalanceModifyReqDto.setUsableBalance(eo.getAdvanceAmount().negate());
        giftBalanceModifyReqDto.setBalance(eo.getAdvanceAmount().negate());
        this.giftBalanceService.modify(giftBalanceModifyReqDto);
        BalanceDetailRespDto balanceDetailRespDto = this.getBalanceDetailRespDto(eo);
        giftBalanceModifyReqDto.setBalance(eo.getAdvanceAmount().negate());
        logger.info("\u9884\u652f\u989d\u5ea6\u5f52\u8fd8 {}, {}, {}, {}", new Object[]{id, eo, giftBalanceModifyReqDto, balanceDetailRespDto});
        BalanceStatementAddReqDto statementAdd = new BalanceStatementAddReqDto();
        statementAdd.setTradeTypeEnum(TradeTypeEnum.QUOTA_RETURN);
        statementAdd.setTradeAmount(eo.getAdvanceAmount());
        statementAdd.setBalance(balanceDetailRespDto.getBalance());
        statementAdd.setIncomeExpenditureEnum(IncomeExpenditureEnum.EXPENDITURE);
        statementAdd.setBusinessNo(eo.getAdvanceNo());
        statementAdd.setCustomerId(eo.getCustomerId());
        statementAdd.setTenantId(eo.getTenantId());
        statementAdd.setInstanceId(eo.getInstanceId());
        this.giftBalanceStatementService.add(statementAdd);
        this.giftBalanceAdvanceDas.update((BaseEo)eo);
    }

    @Override
    public RestResponse<Object> exportGiftBalanceAdvance(BalanceAdvanceQueryReqDto reqDto) {
        String exportUrl = null;
        try {
            PageInfo<BalanceAdvanceListRespDto> pageInfo = this.queryPage(reqDto);
            if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
                List list = pageInfo.getList();
                ArrayList rList = Lists.newArrayList();
                CubeBeanUtils.copyCollection((Collection)rList, (Collection)list, GiftBalanceAdvanceExportVo.class);
                rList.stream().forEach(e -> {
                    e.setSendBack(SendBackEnum.toName((String)e.getSendBack()));
                    e.setStatus(AdvanceStatusEnum.toName((String)e.getStatus()));
                });
                String excelName = "cube/\u9884\u652f\u989d\u5ea6-\u8ba2\u5355\u660e\u7ec6Excel-" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss");
                exportUrl = EasyPoiExportUtil.getExportUrl((List)rList, GiftBalanceAdvanceExportVo.class, null, (String)excelName, (String)"xls");
            }
        }
        catch (Exception e2) {
            logger.error("\u5bfc\u51fa\u9884\u652f\u989d\u5ea6-\u9519\u8bef:{}", (Object)e2.toString());
            return new RestResponse("-1", "\u5bfc\u51fa\u9884\u652f\u989d\u5ea6-\u9519\u8bef:" + e2);
        }
        return new RestResponse("0", "\u5bfc\u51fa\u9884\u652f\u989d\u5ea6\u6210\u529f", exportUrl);
    }

    @Override
    public RestResponse<GiftBalanceExcelRespDto> excel(MultipartFile file) {
        GiftBalanceExcelRespDto respDto = new GiftBalanceExcelRespDto();
        respDto.setNum(Integer.valueOf(0));
        respDto.setSuccessNum(Integer.valueOf(0));
        respDto.setFailNum(Integer.valueOf(0));
        ImportParams importParams = new ImportParams();
        importParams.setHeadRows(1);
        importParams.setTitleRows(0);
        List giftBalanceAdvanceImportVoList = Lists.newArrayList();
        try {
            ExcelImportResult result = ExcelImportUtil.importExcelMore((InputStream)file.getInputStream(), GiftBalanceAdvanceImportExportVo.class, (ImportParams)importParams);
            giftBalanceAdvanceImportVoList = result.getList();
            if (CollectionUtils.isEmpty((Collection)giftBalanceAdvanceImportVoList)) {
                throw new BizException("\u65e0\u6cd5\u8bfb\u53d6 Excel \u4e2d\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u7b26\u5408\u6a21\u677f\u683c\u5f0f\u8981\u6c42");
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw new BizException("\u65e0\u6cd5\u8bfb\u53d6 Excel \u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u7c7b\u578b");
        }
        BalanceQueryReqDto reqDto = new BalanceQueryReqDto();
        reqDto.setPageNum(1);
        reqDto.setPageSize(Integer.MAX_VALUE);
        PageInfo<BalanceListRespDto> pageInfo = this.giftBalanceService.queryPage(reqDto);
        logger.info("\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f\u7ed3\u679c: {}", pageInfo);
        Map<Object, Object> customerRespDtoMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
            customerRespDtoMap = pageInfo.getList().stream().collect(Collectors.toMap(e -> e.getCustomerCode(), e -> e));
        }
        logger.info("\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f\u5904\u7406\u540e\u7ed3\u679c: {}", (Object)customerRespDtoMap);
        ArrayList successList = Lists.newArrayList();
        ArrayList errorList = Lists.newArrayList();
        SimpleDateFormat sdf = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.ENGLISH);
        for (GiftBalanceAdvanceImportExportVo vo : giftBalanceAdvanceImportVoList) {
            BalanceAdvanceAddReqDto addReqDto = new BalanceAdvanceAddReqDto();
            BalanceListRespDto customerRespDto = (BalanceListRespDto)customerRespDtoMap.get(vo.getCustomerCode());
            logger.info("\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f\u5faa\u73af: {}, {}", (Object)vo, (Object)customerRespDto);
            StringBuilder errorMsg = new StringBuilder();
            if (Objects.isNull(customerRespDto) || customerRespDto.getCustomerId() == null) {
                errorMsg.append("\u3010\u5ba2\u6237\u7f16\u53f7\u3011\u4e0d\u5b58\u5728\uff1b \r\n");
            } else {
                addReqDto.setCustomerId(customerRespDto.getCustomerId());
            }
            if (vo.getAdvanceAmount() == null || !NumberFormatUtils.numberCheck(vo.getAdvanceAmount().toString(), 0, 2, 0)) {
                errorMsg.append("\u3010\u9884\u652f\u989d\u5ea6\u3011\u5fc5\u987b\u4e3a\u6574\u6570\u6216\u4e24\u4f4d\u5c0f\u6570 \u5982\uff1a100, 100.1, 100.12\uff1b \r\n");
            } else {
                addReqDto.setAdvanceAmount(vo.getAdvanceAmount());
            }
            try {
                if (StringUtils.isNotEmpty((CharSequence)vo.getAdvanceGrantTime())) {
                    addReqDto.setAdvanceModeEnum(AdvanceModeEnum.FIXED_TIME);
                    addReqDto.setAdvanceGrantTime(sdf.parse(vo.getAdvanceGrantTime()));
                    Date now = new Date();
                    logger.info("\u3010\u989d\u5ea6\u53d1\u653e\u65f6\u95f4\u3011\u53d1\u653e\u65f6\u95f4{}, \u5f53\u524d\u65f6\u95f4{}", (Object)addReqDto.getAdvanceGrantTime().getTime(), (Object)now.getTime());
                    if (addReqDto.getAdvanceGrantTime().getTime() < now.getTime()) {
                        errorMsg.append("\u3010\u989d\u5ea6\u53d1\u653e\u65f6\u95f4\u3011\u4e0d\u80fd\u5728\u5f53\u524d\u65f6\u95f4\u4e4b\u524d\uff1b \r\n");
                    }
                } else {
                    addReqDto.setAdvanceModeEnum(AdvanceModeEnum.IMMEDIATELY);
                }
            }
            catch (ParseException e3) {
                errorMsg.append("\u3010\u989d\u5ea6\u53d1\u653e\u65f6\u95f4\u3011\u65e5\u671f\u683c\u5f0f\u9519\u8bef\uff1b \r\n");
            }
            SendBackEnum sendBack = SendBackEnum.fromName((String)vo.getSendBack());
            if (sendBack == null) {
                errorMsg.append("\u3010\u662f\u5426\u9700\u8981\u5f52\u8fd8\u3011\u5fc5\u586b\uff1b \r\n");
            } else {
                addReqDto.setSendBackEnum(sendBack);
            }
            if (sendBack != null && SendBackEnum.YES.getCode().equals(sendBack.getCode()) && StringUtils.isNotEmpty((CharSequence)vo.getAdvanceSendBackTime())) {
                try {
                    Date advanceSendBackTime = sdf.parse(vo.getAdvanceSendBackTime());
                    addReqDto.setAdvanceSendBackTime(advanceSendBackTime);
                    logger.info("\u3010\u989d\u5ea6\u53d1\u653e\u65f6\u95f4\u3011{}, \u3010\u989d\u5ea6\u5f52\u8fd8\u65f6\u95f4\u3011{}", addReqDto.getAdvanceGrantTime() == null ? "" : Long.valueOf(addReqDto.getAdvanceGrantTime().getTime()), (Object)addReqDto.getAdvanceSendBackTime().getTime());
                    if (addReqDto.getAdvanceGrantTime() != null && addReqDto.getAdvanceGrantTime().getTime() > addReqDto.getAdvanceSendBackTime().getTime()) {
                        errorMsg.append("\u3010\u53d1\u653e\u65f6\u95f4\u3011\u4e0d\u53ef\u4ee5\u5927\u4e8e\u5f52\u8fd8\u65f6\u95f4\uff1b \r\n");
                    }
                }
                catch (ParseException e4) {
                    errorMsg.append("\u3010\u989d\u5ea6\u5f52\u8fd8\u65f6\u95f4\u3011\u65e5\u671f\u683c\u5f0f\u9519\u8bef\uff1b \r\n");
                }
            } else if (sendBack != null && SendBackEnum.YES.getCode().equals(sendBack.getCode()) && StringUtils.isEmpty((CharSequence)vo.getAdvanceSendBackTime())) {
                errorMsg.append("\u3010\u662f\u5426\u9700\u8981\u5f52\u8fd8\u3011\u4e3a\uff08\u662f\uff09\u65f6\u3010\u989d\u5ea6\u5f52\u8fd8\u65f6\u95f4\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff1b \r\n");
            }
            if (StringUtils.isNotEmpty((CharSequence)errorMsg)) {
                errorList.add(this.excelErrorMsg(vo, errorMsg.toString()));
                continue;
            }
            this.add(addReqDto);
            successList.add(vo);
        }
        if (CollectionUtils.isNotEmpty((Collection)errorList)) {
            respDto.setFailNum(Integer.valueOf(errorList.size()));
            String excelName = "cube/\u989d\u5ea6\u8d26\u6237\u5931\u8d25\u4fe1\u606f-\u8ba2\u5355\u660e\u7ec6Excel-" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss");
            try {
                String exportUrl = EasyPoiExportUtil.getExportUrl((List)errorList, GiftBalanceAdvanceImportExportVo.class, null, (String)excelName, (String)"xls");
                respDto.setErrorFile(exportUrl);
            }
            catch (Exception e5) {
                logger.error("\u5bfc\u5165\u989d\u5ea6\u8d26\u6237-\u9519\u8bef: {}", (Object)e5.toString());
                return new RestResponse("-1", "\u5bfc\u5165\u989d\u5ea6\u8d26\u6237-\u9519\u8bef:" + e5);
            }
        }
        respDto.setNum(Integer.valueOf(giftBalanceAdvanceImportVoList.size()));
        respDto.setSuccessNum(Integer.valueOf(successList.size()));
        return new RestResponse((Object)respDto);
    }

    @Override
    public boolean isExist(Long id) {
        return this.giftBalanceAdvanceDas.selectByPrimaryKey(id) != null;
    }

    private BalanceDetailRespDto getBalanceDetailRespDto(GiftBalanceAdvanceEo eo) {
        BalanceQueryReqDto balanceQueryReqDto = new BalanceQueryReqDto();
        balanceQueryReqDto.setCustomerId(eo.getCustomerId());
        return this.giftBalanceService.queryByCustomerId(balanceQueryReqDto);
    }

    private GiftBalanceAdvanceImportExportVo excelErrorMsg(GiftBalanceAdvanceImportExportVo vo, String errorMsg) {
        vo.setErrorMsg(errorMsg);
        return vo;
    }
}

