/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.rebate.biz.gift.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.BalanceFreezeAddReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.BalanceFreezeModifyReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.BalanceFreezeQueryReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.response.balance.BalanceFreezeListRespDto;
import com.dtyunxi.yundt.cube.center.rebate.biz.gift.service.ICommonService;
import com.dtyunxi.yundt.cube.center.rebate.biz.gift.service.IGiftBalanceFreezeService;
import com.dtyunxi.yundt.cube.center.rebate.biz.gift.utils.BeanUtils;
import com.dtyunxi.yundt.cube.center.rebate.dao.eo.gift.GiftBalanceFreezeEo;
import com.dtyunxi.yundt.cube.center.rebate.dao.gift.das.GiftBalanceFreezeDas;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class GiftBalanceFreezeServiceImpl
implements IGiftBalanceFreezeService {
    private static final Logger logger = LoggerFactory.getLogger(GiftBalanceFreezeServiceImpl.class);
    @Resource
    private GiftBalanceFreezeDas giftBalanceFreezeDas;
    @Resource
    private IContext context;
    @Resource
    private ICommonService commonService;

    @Override
    public PageInfo<BalanceFreezeListRespDto> queryPage(BalanceFreezeQueryReqDto reqDto) {
        PageHelper.startPage((int)reqDto.getPageNum(), (int)reqDto.getPageSize());
        List<Long> customerIds = this.commonService.queryCustomerIdsByCurrentUser(this.context.userId(), 2);
        logger.info("\u51bb\u7ed3\u989d\u5ea6\u5217\u8868", (Object)JSONObject.toJSONString((Object)reqDto));
        List respDtoList = this.giftBalanceFreezeDas.queryPage(reqDto, customerIds, this.context.tenantId(), this.context.instanceId());
        return new PageInfo(respDtoList);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void add(BalanceFreezeAddReqDto addReqDto) {
        logger.info("\u65b0\u589e\u51bb\u7ed3\u989d\u5ea6", (Object)JSONObject.toJSONString((Object)addReqDto));
        GiftBalanceFreezeEo eo = new GiftBalanceFreezeEo();
        BeanUtils.copyProperties(addReqDto, eo);
        eo.setFreezeType(addReqDto.getFreezeTypeEnum().getCode());
        eo.setStatus(addReqDto.getStatusEnum().getCode());
        this.giftBalanceFreezeDas.insert((BaseEo)eo);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void modifyUnFreeze(BalanceFreezeModifyReqDto modifyReqDto) {
        logger.info("\u89e3\u51bb\u51bb\u7ed3\u989d\u5ea6", (Object)JSONObject.toJSONString((Object)modifyReqDto));
        this.giftBalanceFreezeDas.modifyUnFreeze(modifyReqDto);
    }

    @Override
    public List<GiftBalanceFreezeEo> queryByOrderNo(String orderNo) {
        GiftBalanceFreezeEo queryEo = GiftBalanceFreezeEo.newInstance();
        queryEo.setBusinessNo(orderNo);
        List list = this.giftBalanceFreezeDas.select((BaseEo)queryEo);
        return list;
    }
}

