/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.rebate.biz.gift.service.impl;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.URLUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.mj.biz.commons.utils.EasyPoiExportUtil;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerSearchReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.BaseRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.constant.BalanceAssert;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.constant.CommonConstants;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.constant.GiftBalanceAdjustTypeEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.constant.GivePriceTypeEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.constant.GiveTypeEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.constant.IncomeExpenditureEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.constant.SwitchEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.constant.TradeTypeEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.enums.BalanceExceptionEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.enums.FreezeStatusEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.AdjustGiftBalanceReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.BalanceConfigReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.BalanceQueryReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.BalanceRelModifyReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.BalanceStatementAddReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.BalanceStatementQueryReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.ExcelAdjustReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.GiftBalanceAddReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.GiftBalanceModifyReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.GiftBalancePayReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.GiftBalanceReturnReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.GiftBalanceSettingQueryReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.GiftBalanceSettingReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.ItemSkuListQueryReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.response.balance.BalanceConfigRespDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.response.balance.BalanceDetailRespDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.response.balance.BalanceListRespDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.response.balance.GiftBalanceCountRespDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.response.balance.GiftBalanceExcelRespDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.response.balance.GiftBalanceGroupRespDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.response.balance.GiftBalancePayRespDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.response.balance.GiftBalanceRespDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.response.balance.GiftBalanceSettingRepsDto;
import com.dtyunxi.yundt.cube.center.rebate.biz.gift.service.ICommonService;
import com.dtyunxi.yundt.cube.center.rebate.biz.gift.service.IGiftBalanceFreezeService;
import com.dtyunxi.yundt.cube.center.rebate.biz.gift.service.IGiftBalanceRecordService;
import com.dtyunxi.yundt.cube.center.rebate.biz.gift.service.IGiftBalanceService;
import com.dtyunxi.yundt.cube.center.rebate.biz.gift.service.IGiftBalanceStatementService;
import com.dtyunxi.yundt.cube.center.rebate.biz.gift.service.IGiftConfigService;
import com.dtyunxi.yundt.cube.center.rebate.biz.gift.utils.BeanUtils;
import com.dtyunxi.yundt.cube.center.rebate.biz.gift.utils.RandomBalanceCodeUtil;
import com.dtyunxi.yundt.cube.center.rebate.biz.gift.vo.AdjustBalanceVo;
import com.dtyunxi.yundt.cube.center.rebate.biz.gift.vo.GiftBalanceExportVo;
import com.dtyunxi.yundt.cube.center.rebate.biz.gift.vo.GiftBalanceImportExportVo;
import com.dtyunxi.yundt.cube.center.rebate.dao.eo.gift.GiftBalanceEo;
import com.dtyunxi.yundt.cube.center.rebate.dao.eo.gift.GiftBalanceFreezeEo;
import com.dtyunxi.yundt.cube.center.rebate.dao.eo.gift.GiftBalanceStatementEo;
import com.dtyunxi.yundt.cube.center.rebate.dao.eo.gift.StdGiftBalanceStatementEo;
import com.dtyunxi.yundt.cube.center.rebate.dao.gift.das.GiftBalanceDas;
import com.dtyunxi.yundt.cube.center.rebate.dao.gift.das.GiftBalanceFreezeDas;
import com.dtyunxi.yundt.cube.center.rebate.dao.gift.das.GiftBalanceStatementDas;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class GiftBalanceServiceImpl
implements IGiftBalanceService {
    private static final Logger logger = LoggerFactory.getLogger(GiftBalanceServiceImpl.class);
    @Resource
    private GiftBalanceDas giftBalanceDas;
    @Resource
    private IGiftConfigService giftConfigService;
    @Resource
    private IGiftBalanceStatementService giftBalanceStatementService;
    @Resource
    private IGiftBalanceRecordService giftBalanceRecordService;
    @Resource
    private IGiftBalanceFreezeService giftBalanceFreezeService;
    @Resource
    private IContext context;
    @Resource
    private IOrganizationQueryApi organizationQueryApi;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private GiftBalanceStatementDas giftBalanceStatementDas;
    @Resource
    private ICommonService commonService;
    @Autowired
    private GiftBalanceFreezeDas giftBalanceFreezeDas;
    @Resource
    private ILockService lockService;

    @Override
    public void setting(GiftBalanceSettingReqDto settingReqDto) {
        logger.info("\u8d60\u9001\u989d\u5ea6\u8bbe\u7f6e {}", (Object)settingReqDto);
        GiftBalanceEo giftBalanceEo = new GiftBalanceEo();
        BeanUtils.copyProperties(settingReqDto, giftBalanceEo);
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.eq((String)"id", (Object)settingReqDto.getId()));
        giftBalanceEo.setSqlFilters(sqlFilters);
        if (settingReqDto.getGiveFlagEnum() != null) {
            giftBalanceEo.setGiveFlag(settingReqDto.getGiveFlagEnum().getCode());
        }
        if (settingReqDto.getGivePriceTypeEnum() != null) {
            giftBalanceEo.setGivePriceType(settingReqDto.getGivePriceTypeEnum().getCode());
        }
        if (settingReqDto.getGiveTypeEnum() != null) {
            giftBalanceEo.setGiveType(settingReqDto.getGiveTypeEnum().getCode());
        }
        this.giftBalanceDas.updateSelectiveSqlFilter((BaseEo)giftBalanceEo);
    }

    @Override
    public PageInfo<BalanceListRespDto> queryPage(BalanceQueryReqDto reqDto) {
        PageHelper.startPage((int)reqDto.getPageNum(), (int)reqDto.getPageSize());
        if (ObjectUtil.isEmpty((Object)reqDto.getOrganizationId())) {
            Long userId = reqDto.getUserId();
            Long orgId = (Long)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryOrgIdByUserId(userId == null ? this.context.userId() : userId));
            reqDto.setOrganizationId(orgId);
        }
        logger.info("\u67e5\u8be2\u989d\u5ea6\u8d26\u6237 {}", (Object)reqDto);
        List balanceListRespDtoList = this.giftBalanceDas.queryPage(reqDto, null, this.context.tenantId(), this.context.instanceId());
        return new PageInfo(balanceListRespDtoList);
    }

    @Override
    public GiftBalanceSettingRepsDto querySetting(GiftBalanceSettingQueryReqDto queryReqDto) {
        logger.info("\u67e5\u8be2\u989d\u5ea6\u8d26\u6237 {}", (Object)queryReqDto);
        GiftBalanceEo giftBalanceEo = new GiftBalanceEo();
        giftBalanceEo.setId(queryReqDto.getId());
        giftBalanceEo = (GiftBalanceEo)this.giftBalanceDas.selectOne((BaseEo)giftBalanceEo);
        GiftBalanceSettingRepsDto repsDto = new GiftBalanceSettingRepsDto();
        CubeBeanUtils.copyProperties((Object)repsDto, (Object)giftBalanceEo, (String[])new String[0]);
        return repsDto;
    }

    @Override
    public void add(GiftBalanceAddReqDto addReqDto) {
        logger.info("\u65b0\u589e\u989d\u5ea6\u8d26\u6237 {}", (Object)addReqDto);
        GiftBalanceEo giftBalanceEo = new GiftBalanceEo();
        giftBalanceEo.setCustomerId(addReqDto.getCustomerId());
        GiftBalanceEo oldEo = (GiftBalanceEo)this.giftBalanceDas.selectOne((BaseEo)giftBalanceEo);
        if (oldEo != null) {
            oldEo.setOrganizationId(addReqDto.getOrganizationId());
            oldEo.setCustomerCode(addReqDto.getCustomerCode());
            oldEo.setCustomerName(addReqDto.getCustomerName());
            this.giftBalanceDas.update((BaseEo)oldEo);
            return;
        }
        CubeBeanUtils.copyProperties((Object)giftBalanceEo, (Object)addReqDto, (String[])new String[0]);
        giftBalanceEo.setBalance(BigDecimal.ZERO);
        giftBalanceEo.setFreezeBalance(BigDecimal.ZERO);
        giftBalanceEo.setUsableBalance(BigDecimal.ZERO);
        giftBalanceEo.setGiveProportion(BigDecimal.ZERO);
        giftBalanceEo.setQuantityScaleAmount(BigDecimal.ZERO);
        giftBalanceEo.setQuantityScaleSum(BigDecimal.ZERO);
        giftBalanceEo.setInstanceId(CommonConstants.INSTANCE_ID);
        giftBalanceEo.setTenantId(CommonConstants.TENANT_ID);
        this.giftBalanceDas.insert((BaseEo)giftBalanceEo);
    }

    @Override
    public GiftBalancePayRespDto useBalance(GiftBalancePayReqDto reqDto) {
        return null;
    }

    @Override
    public GiftBalancePayRespDto returnBalance(GiftBalanceReturnReqDto reqDto) {
        return null;
    }

    @Override
    public BalanceDetailRespDto queryByCustomerId(BalanceQueryReqDto balanceQueryReqDto) {
        logger.info("\u67e5\u8be2\u989d\u5ea6\u8d26\u6237 {}", (Object)balanceQueryReqDto);
        GiftBalanceEo giftBalanceEo = new GiftBalanceEo();
        giftBalanceEo.setCustomerId(balanceQueryReqDto.getCustomerId());
        giftBalanceEo = (GiftBalanceEo)this.giftBalanceDas.selectOne((BaseEo)giftBalanceEo);
        BalanceDetailRespDto repsDto = new BalanceDetailRespDto();
        CubeBeanUtils.copyProperties((Object)repsDto, (Object)giftBalanceEo, (String[])new String[0]);
        return repsDto;
    }

    @Override
    public RestResponse<Void> modify(GiftBalanceModifyReqDto modifyReqDto) {
        logger.info("\u4fee\u6539\u989d\u5ea6\u8d26\u6237 {}", (Object)modifyReqDto);
        return this.giftBalanceDas.modify(modifyReqDto);
    }

    @Override
    public BalanceConfigRespDto queryBalanceConfig(BalanceConfigReqDto reqDto) {
        BalanceConfigRespDto balanceConfigRespDto = new BalanceConfigRespDto();
        BalanceQueryReqDto balanceQueryReqDto = new BalanceQueryReqDto();
        balanceQueryReqDto.setCustomerId(reqDto.getCustomerId());
        balanceConfigRespDto.setBalanceDetailRespDto(this.queryByCustomerId(balanceQueryReqDto));
        balanceConfigRespDto.setGiftConfigBaseRespDto(this.giftConfigService.queryBase());
        ItemSkuListQueryReqDto itemSkuListQueryReqDto = new ItemSkuListQueryReqDto();
        BeanUtils.copyProperties(reqDto, itemSkuListQueryReqDto);
        balanceConfigRespDto.setItemSkuListRespDtoList(this.giftConfigService.getSkuListByCustomerId(itemSkuListQueryReqDto));
        return balanceConfigRespDto;
    }

    @Override
    public GiftBalanceGroupRespDto queryGiftBalanceByOrganizationId() {
        GiftBalanceGroupRespDto result = new GiftBalanceGroupRespDto();
        result.setTotalAmount(BigDecimal.ZERO);
        List customers = (List)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryCustomerIdsByUserId(this.context.userId()));
        logger.info("\u5ba2\u6237id\uff1a{}", (Object)customers);
        List customerRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryListByCustomerIds(customers));
        Map<Long, CustomerRespDto> customerHashMap = customerRespDtoList.stream().collect(Collectors.toMap(BaseRespDto::getId, item -> item, (oldVal, newVal) -> newVal));
        List merchantIds = customerRespDtoList.stream().map(CustomerRespDto::getMerchantId).collect(Collectors.toList());
        CustomerSearchReqDto searchReqDto = new CustomerSearchReqDto();
        searchReqDto.setOrgInfoIds(merchantIds);
        RestResponse merchantResponse = this.customerExtQueryApi.queryByList(JSON.toJSONString((Object)searchReqDto));
        List merchantList = (List)RestResponseHelper.extractData((RestResponse)merchantResponse);
        Map<Long, CustomerRespDto> merchantHashMap = merchantList.stream().collect(Collectors.toMap(CustomerRespDto::getOrgInfoId, item -> item, (oldVal, newVal) -> newVal));
        List giftBalanceList = this.giftBalanceDas.selectListByCustomerIds(customers);
        if (CollectionUtils.isEmpty((Collection)giftBalanceList)) {
            return result;
        }
        giftBalanceList.forEach(balanceRespDto -> {
            CustomerRespDto merchantDto;
            CustomerRespDto customerRespDto = (CustomerRespDto)customerHashMap.get(balanceRespDto.getCustomerId());
            if (customerRespDto != null && (merchantDto = (CustomerRespDto)merchantHashMap.get(customerRespDto.getMerchantId())) != null) {
                balanceRespDto.setMerchantId(merchantDto.getOrgInfoId());
                balanceRespDto.setMerchantName(merchantDto.getName());
            }
        });
        BigDecimal totalAmount = giftBalanceList.stream().map(GiftBalanceRespDto::getUsableBalance).reduce(BigDecimal.ZERO, BigDecimal::add);
        result.setTotalAmount(totalAmount);
        result.setGiftBalanceList(giftBalanceList);
        return result;
    }

    @Override
    public GiftBalanceCountRespDto countGiftBalanceStatement(BalanceStatementQueryReqDto reqDto) {
        GiftBalanceCountRespDto giftBalanceCountRespDto = new GiftBalanceCountRespDto();
        GiftBalanceStatementEo giftBalanceStatementEo = new GiftBalanceStatementEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)giftBalanceStatementEo);
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.ge((String)"create_time", (Object)reqDto.getTradeTimeStart()));
        sqlFilters.add(SqlFilter.le((String)"create_time", (Object)reqDto.getTradeTimeEnd()));
        giftBalanceStatementEo.setSqlFilters(sqlFilters);
        List giftBalanceStatementEos = this.giftBalanceStatementDas.select((BaseEo)giftBalanceStatementEo);
        if (CollectionUtils.isNotEmpty((Collection)giftBalanceStatementEos)) {
            BigDecimal income = giftBalanceStatementEos.stream().filter(bean -> {
                if ("1" == bean.getIncomeExpenditure()) {
                    return bean.getBalance().compareTo(BigDecimal.ZERO) > 0;
                }
                return false;
            }).map(StdGiftBalanceStatementEo::getBalance).reduce(BigDecimal.ZERO, BigDecimal::add);
            giftBalanceCountRespDto.setIncome(income == null ? BigDecimal.ZERO : income);
            BigDecimal expend = giftBalanceStatementEos.stream().filter(bean -> {
                if ("2" == bean.getIncomeExpenditure()) {
                    return bean.getBalance().compareTo(BigDecimal.ZERO) > 0;
                }
                return false;
            }).map(StdGiftBalanceStatementEo::getBalance).reduce(BigDecimal.ZERO, BigDecimal::add);
            giftBalanceCountRespDto.setExpend(expend == null ? BigDecimal.ZERO : expend);
        }
        return giftBalanceCountRespDto;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public RestResponse<Void> modifyBalanceRel(BalanceRelModifyReqDto balanceRelModifyReqDto) {
        logger.info("\u63d0\u4ea4\u8ba2\u5355\u5bf9\u514d\u8d39\u8d60\u54c1\u989d\u5ea6\u7684\u64cd\u4f5c {}", (Object)JSONObject.toJSONString((Object)balanceRelModifyReqDto));
        if (balanceRelModifyReqDto.getGiftBalanceModifyReqDto() != null) {
            this.modify(balanceRelModifyReqDto.getGiftBalanceModifyReqDto());
        }
        if (CollectionUtils.isNotEmpty((Collection)balanceRelModifyReqDto.getBalanceStatementAddReqDtoList())) {
            this.giftBalanceStatementService.addList(balanceRelModifyReqDto.getBalanceStatementAddReqDtoList());
        }
        if (CollectionUtils.isNotEmpty((Collection)balanceRelModifyReqDto.getBalanceRecordAddReqDtoList())) {
            this.giftBalanceRecordService.addList(balanceRelModifyReqDto.getBalanceRecordAddReqDtoList());
        }
        if (balanceRelModifyReqDto.getBalanceFreezeAddReqDto() != null) {
            this.giftBalanceFreezeService.add(balanceRelModifyReqDto.getBalanceFreezeAddReqDto());
        }
        if (balanceRelModifyReqDto.getBalanceFreezeModifyReqDto() != null) {
            this.giftBalanceFreezeService.modifyUnFreeze(balanceRelModifyReqDto.getBalanceFreezeModifyReqDto());
        }
        return RestResponse.VOID;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> release(String orderNo) {
        List<GiftBalanceFreezeEo> list = this.giftBalanceFreezeService.queryByOrderNo(orderNo);
        if (CollectionUtils.isNotEmpty(list)) {
            GiftBalanceModifyReqDto giftBalanceModifyReqDto = null;
            for (GiftBalanceFreezeEo giftBalanceFreezeEo : list) {
                if (!FreezeStatusEnum.FREEZEING.getCode().equals(giftBalanceFreezeEo.getStatus())) continue;
                GiftBalanceFreezeEo updateEo = new GiftBalanceFreezeEo();
                updateEo.setId(giftBalanceFreezeEo.getId());
                updateEo.setUnFreezeTime(new Date());
                updateEo.setStatus("02");
                this.giftBalanceFreezeDas.updateSelective((BaseEo)updateEo);
                giftBalanceModifyReqDto = new GiftBalanceModifyReqDto();
                giftBalanceModifyReqDto.setCustomerId(giftBalanceFreezeEo.getCustomerId());
                giftBalanceModifyReqDto.setUsableBalance(giftBalanceFreezeEo.getFreezeAmount());
                giftBalanceModifyReqDto.setFreezeBalance(giftBalanceFreezeEo.getFreezeAmount().negate());
                this.modify(giftBalanceModifyReqDto);
            }
        }
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<GiftBalanceExcelRespDto> excel(MultipartFile file) {
        GiftBalanceExcelRespDto respDto = new GiftBalanceExcelRespDto();
        respDto.setNum(Integer.valueOf(0));
        respDto.setSuccessNum(Integer.valueOf(0));
        respDto.setFailNum(Integer.valueOf(0));
        ImportParams importParams = new ImportParams();
        importParams.setHeadRows(1);
        importParams.setTitleRows(0);
        List giftBalanceImportVoList = new ArrayList();
        try {
            ExcelImportResult result = ExcelImportUtil.importExcelMore((InputStream)file.getInputStream(), GiftBalanceImportExportVo.class, (ImportParams)importParams);
            giftBalanceImportVoList = result.getList();
            if (CollectionUtils.isEmpty(giftBalanceImportVoList)) {
                throw new BizException("\u65e0\u6cd5\u8bfb\u53d6 Excel \u4e2d\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u7b26\u5408\u6a21\u677f\u683c\u5f0f\u8981\u6c42");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BizException("\u65e0\u6cd5\u8bfb\u53d6 Excel \u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u7c7b\u578b");
        }
        ArrayList successList = Lists.newArrayList();
        ArrayList errorList = Lists.newArrayList();
        for (GiftBalanceImportExportVo vo : giftBalanceImportVoList) {
            StringBuilder errorMsg = new StringBuilder();
            BalanceQueryReqDto reqDto = new BalanceQueryReqDto();
            reqDto.setCustomerCode(vo.getCustomerCode());
            PageInfo<BalanceListRespDto> pageInfo = this.queryPage(reqDto);
            GiftBalanceEo giftBalanceEo = null;
            if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
                giftBalanceEo = new GiftBalanceEo();
                CubeBeanUtils.copyProperties((Object)giftBalanceEo, pageInfo.getList().get(0), (String[])new String[0]);
            }
            if (Objects.nonNull(giftBalanceEo)) {
                if (StringUtils.isNotBlank((CharSequence)vo.getGiveFlagName())) {
                    if (SwitchEnum.ON.getName().equals(vo.getGiveFlagName())) {
                        giftBalanceEo.setGiveFlag(SwitchEnum.ON.getCode());
                    } else {
                        giftBalanceEo.setGiveFlag(SwitchEnum.OFF.getCode());
                    }
                } else {
                    errorMsg.append("\u514d\u8d39\u8d60\u54c1\u5f00\u5173\u9519\u8bef");
                }
                if (StringUtils.isNotBlank((CharSequence)vo.getGiveTypeName())) {
                    String giveType = GiveTypeEnum.nameToCode((String)vo.getGiveTypeName());
                    if (StringUtils.isBlank((CharSequence)giveType)) {
                        errorMsg.append("\u8d60\u9001\u7c7b\u578b\u683c\u5f0f\u9519\u8bef");
                    }
                    giftBalanceEo.setGiveType(giveType);
                }
                if (StringUtils.isNotBlank((CharSequence)vo.getGivePriceTypeName())) {
                    String givePriceType = GivePriceTypeEnum.nameToCode((String)vo.getGivePriceTypeName());
                    if (StringUtils.isBlank((CharSequence)givePriceType)) {
                        errorMsg.append("\u91d1\u989d\u7c7b\u578b\u683c\u5f0f\u9519\u8bef");
                    }
                    giftBalanceEo.setGivePriceType(givePriceType);
                }
                if (vo.getGiveProportion() != null) {
                    if (vo.getGiveProportion().intValue() > 100 || vo.getGiveProportion().intValue() < 0) {
                        errorMsg.append("\u8d60\u9001\u6bd4\u4f8b\u683c\u5f0f\u9519\u8bef");
                    }
                    giftBalanceEo.setGiveProportion(vo.getGiveProportion());
                }
                if (giftBalanceEo.getGiveType().equals(GiveTypeEnum.PROPORTION.getCode())) {
                    if (vo.getQuantityScaleSum() == null) {
                        errorMsg.append("a\u6570\u91cf\u6362\u7b97\u91d1\u989d\u6bd4\u4f8b\uff08a\uff1ab\uff09\u683c\u5f0f\u9519\u8bef");
                    }
                    giftBalanceEo.setQuantityScaleSum(vo.getQuantityScaleSum());
                    if (vo.getQuantityScaleAmount() == null) {
                        errorMsg.append("b\u6570\u91cf\u6362\u7b97\u91d1\u989d\u6bd4\u4f8b\uff08a\uff1ab\uff09\u683c\u5f0f\u9519\u8bef");
                    }
                    giftBalanceEo.setQuantityScaleAmount(vo.getQuantityScaleAmount());
                }
                if (vo.getBalance() != null) {
                    giftBalanceEo.setBalance(giftBalanceEo.getBalance().add(vo.getBalance()));
                    giftBalanceEo.setUsableBalance(giftBalanceEo.getUsableBalance().add(vo.getBalance()));
                }
                if (StringUtils.isBlank((CharSequence)errorMsg)) {
                    logger.info("\u66f4\u65b0\u8d60\u54c1\u989d\u5ea6\u4fe1\u606f:{}", (Object)JSONObject.toJSONString((Object)giftBalanceEo));
                    int result = this.giftBalanceDas.updateSelective((BaseEo)giftBalanceEo);
                    if (Objects.nonNull(vo.getBalance()) && BigDecimal.ZERO.compareTo(vo.getBalance()) != 0) {
                        BalanceStatementAddReqDto addReqDto = new BalanceStatementAddReqDto();
                        addReqDto.setCustomerId(giftBalanceEo.getCustomerId());
                        addReqDto.setBalance(giftBalanceEo.getBalance());
                        addReqDto.setTradeTypeEnum(TradeTypeEnum.MANUAL_IMPORT);
                        addReqDto.setTradeAmount(vo.getBalance());
                        addReqDto.setIncomeExpenditureEnum(vo.getBalance().compareTo(BigDecimal.ZERO) == 1 ? IncomeExpenditureEnum.INCOME : IncomeExpenditureEnum.EXPENDITURE);
                        this.giftBalanceStatementService.add(addReqDto);
                        logger.info("\u589e\u52a0\u8d60\u54c1\u989d\u5ea6\u6d41\u6c34:{}", (Object)JSONObject.toJSONString((Object)addReqDto));
                    }
                    successList.add(vo);
                    continue;
                }
                errorList.add(this.excelErrorMsg(vo, errorMsg.toString()));
                continue;
            }
            errorList.add(this.excelErrorMsg(vo, "\u5ba2\u6237\u7f16\u53f7\u9519\u8bef"));
        }
        if (CollectionUtils.isNotEmpty((Collection)errorList)) {
            respDto.setFailNum(Integer.valueOf(errorList.size()));
            String excelName = "cube/\u989d\u5ea6\u8d26\u6237\u5931\u8d25\u4fe1\u606f-\u8ba2\u5355\u660e\u7ec6Excel-" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss");
            try {
                String exportUrl = EasyPoiExportUtil.getExportUrl((List)errorList, GiftBalanceImportExportVo.class, null, (String)excelName, (String)"xls");
                respDto.setErrorFile(exportUrl);
            }
            catch (Exception e) {
                logger.error("\u5bfc\u51fa\u5546\u54c1\u8be6\u60c5-\u9519\u8bef:{}", (Object)e.toString());
                return new RestResponse("-1", "\u5bfc\u51fa\u5546\u54c1\u8be6\u60c5-\u9519\u8bef:" + e);
            }
        }
        respDto.setNum(Integer.valueOf(giftBalanceImportVoList.size()));
        respDto.setSuccessNum(Integer.valueOf(successList.size()));
        return new RestResponse((Object)respDto);
    }

    @Override
    public RestResponse<Object> exportGiftBalance(BalanceQueryReqDto reqDto) {
        PageInfo<BalanceListRespDto> pageInfo = this.queryPage(reqDto);
        try {
            if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
                String exportUrl;
                List list = pageInfo.getList();
                ArrayList rList = Lists.newArrayList();
                for (BalanceListRespDto balance : list) {
                    GiftBalanceExportVo giftBalanceExportVo = new GiftBalanceExportVo();
                    giftBalanceExportVo.setCustomerCode(balance.getCustomerCode());
                    giftBalanceExportVo.setCustomerName(balance.getCustomerName());
                    giftBalanceExportVo.setBalance(balance.getBalance());
                    giftBalanceExportVo.setFreezeBalance(balance.getFreezeBalance());
                    giftBalanceExportVo.setUsableBalance(balance.getUsableBalance());
                    String giveFlagName = StringUtils.isNotEmpty((CharSequence)balance.getGiveFlag()) ? (balance.getGiveFlag().equals(SwitchEnum.ON.getCode()) ? SwitchEnum.ON.getName() : SwitchEnum.OFF.getName()) : null;
                    giftBalanceExportVo.setGiveFlag(giveFlagName);
                    giftBalanceExportVo.setGiveType(GiveTypeEnum.toName((String)balance.getGiveType()));
                    giftBalanceExportVo.setGivePriceType(GivePriceTypeEnum.toName((String)balance.getGivePriceType()));
                    giftBalanceExportVo.setGiveProportion(balance.getGiveProportion());
                    if (balance.getQuantityScaleAmount() != null && balance.getQuantityScaleSum() != null) {
                        giftBalanceExportVo.setQuantityScale(balance.getQuantityScaleAmount().toString() + ":" + balance.getQuantityScaleSum().toString());
                    }
                    rList.add(giftBalanceExportVo);
                }
                String excelName = "cube/\u989d\u5ea6\u8d26\u6237-\u8ba2\u5355\u660e\u7ec6Excel-" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss");
                try {
                    exportUrl = EasyPoiExportUtil.getExportUrl((List)rList, GiftBalanceExportVo.class, null, (String)excelName, (String)"xls");
                }
                catch (Exception e) {
                    logger.error("\u5bfc\u51fa\u989d\u5ea6\u8d26\u6237-\u9519\u8bef:{}", (Object)e.toString());
                    return new RestResponse("-1", "\u5bfc\u51fa\u989d\u5ea6\u8d26\u6237-\u9519\u8bef:" + e);
                }
                return new RestResponse("0", "\u5bfc\u51fa\u989d\u5ea6\u8d26\u6237\u6210\u529f", (Object)exportUrl);
            }
            return new RestResponse("-1", "\u5bfc\u51fa\u989d\u5ea6\u8d26\u6237,\u6570\u636e\u4e3a\u7a7a", null);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return new RestResponse("-1", "\u5bfc\u51fa\u5931\u8d25", null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public void adjustGiftBalance(AdjustGiftBalanceReqDto adjustGiftBalanceReqDto) {
        logger.info("[\u624b\u5de5\u8c03\u6574]\u514d\u8d39\u8d60\u54c1\u989d\u5ea6\u8d26\u6237\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)adjustGiftBalanceReqDto));
        GiftBalanceEo giftBalanceEo = (GiftBalanceEo)this.giftBalanceDas.selectByPrimaryKey(adjustGiftBalanceReqDto.getId());
        BalanceAssert.notNull((Object)giftBalanceEo, (BalanceExceptionEnum)BalanceExceptionEnum.DATA_NOT_EXIST, (String[])new String[]{"\u514d\u8d39\u8d60\u54c1\u989d\u5ea6"});
        Mutex lock = this.lockService.lock(this.getClass().getSimpleName(), adjustGiftBalanceReqDto.getId().toString(), 1500, 1500, TimeUnit.MILLISECONDS);
        try {
            giftBalanceEo = (GiftBalanceEo)this.giftBalanceDas.selectByPrimaryKey(adjustGiftBalanceReqDto.getId());
            BigDecimal adjustAmount = adjustGiftBalanceReqDto.getAdjustAmount();
            String incomeExpenditure = IncomeExpenditureEnum.INCOME.getCode();
            if (GiftBalanceAdjustTypeEnum.DECR.getType().equals(adjustGiftBalanceReqDto.getAdjustType())) {
                adjustAmount = adjustAmount.negate();
                incomeExpenditure = IncomeExpenditureEnum.EXPENDITURE.getCode();
            }
            BigDecimal newBalance = giftBalanceEo.getBalance().add(adjustAmount);
            BigDecimal newUsableBalance = giftBalanceEo.getUsableBalance().add(adjustAmount);
            GiftBalanceEo updateEo = new GiftBalanceEo();
            updateEo.setId(giftBalanceEo.getId());
            updateEo.setBalance(newBalance);
            updateEo.setUsableBalance(newUsableBalance);
            this.giftBalanceDas.updateSelective((BaseEo)updateEo);
            GiftBalanceStatementEo giftBalanceStatementEo = new GiftBalanceStatementEo();
            giftBalanceStatementEo.setCustomerId(giftBalanceEo.getCustomerId());
            giftBalanceStatementEo.setTradeTime(new Date());
            giftBalanceStatementEo.setTradeType(TradeTypeEnum.MANUAL_ADJUST.getCode());
            giftBalanceStatementEo.setTradeAmount(adjustGiftBalanceReqDto.getAdjustAmount());
            giftBalanceStatementEo.setIncomeExpenditure(incomeExpenditure);
            giftBalanceStatementEo.setBalance(newBalance);
            giftBalanceStatementEo.setBusinessNo("");
            giftBalanceStatementEo.setTradeNo(RandomBalanceCodeUtil.getDataToNumber(6));
            giftBalanceStatementEo.setRemark(adjustGiftBalanceReqDto.getAdjustRemark());
            this.giftBalanceStatementDas.insert((BaseEo)giftBalanceStatementEo);
        }
        catch (Exception e) {
            logger.info("[\u624b\u5de5\u8c03\u6574]\u514d\u8d39\u8d60\u54c1\u989d\u5ea6\u5931\u8d25\uff1a{}", (Throwable)e);
        }
        finally {
            this.lockService.unlock(lock);
        }
    }

    private GiftBalanceImportExportVo excelErrorMsg(GiftBalanceImportExportVo vo, String errorMsg) {
        vo.setErrorMsg(errorMsg);
        return vo;
    }

    @Override
    public RestResponse<GiftBalanceExcelRespDto> excelAdjust(ExcelAdjustReqDto excelAdjustReqDto) {
        GiftBalanceExcelRespDto respDto = new GiftBalanceExcelRespDto();
        respDto.setNum(Integer.valueOf(0));
        respDto.setSuccessNum(Integer.valueOf(0));
        respDto.setFailNum(Integer.valueOf(0));
        ImportParams importParams = new ImportParams();
        importParams.setHeadRows(1);
        importParams.setTitleRows(0);
        List adjustBalanceVos = new ArrayList();
        try {
            ExcelImportResult result = ExcelImportUtil.importExcelMore((InputStream)URLUtil.getStream((URL)URLUtil.url((String)excelAdjustReqDto.getUrl())), AdjustBalanceVo.class, (ImportParams)importParams);
            adjustBalanceVos = result.getList();
            if (CollectionUtils.isEmpty(adjustBalanceVos)) {
                throw new BizException("\u65e0\u6cd5\u8bfb\u53d6 Excel \u4e2d\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u7b26\u5408\u6a21\u677f\u683c\u5f0f\u8981\u6c42");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BizException("\u65e0\u6cd5\u8bfb\u53d6 Excel \u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u7c7b\u578b");
        }
        ArrayList successList = Lists.newArrayList();
        ArrayList errorList = Lists.newArrayList();
        for (AdjustBalanceVo vo : adjustBalanceVos) {
            StringBuilder errorMsg = new StringBuilder();
            if (StringUtils.isBlank((CharSequence)vo.getCustomerCode())) {
                errorList.add(this.excelAdjustErrorMsg(vo, "\u5ba2\u6237\u7f16\u53f7\u4e3a\u7a7a"));
                continue;
            }
            GiftBalanceEo giftBalanceEo = new GiftBalanceEo();
            giftBalanceEo.setCustomerCode(vo.getCustomerCode());
            giftBalanceEo.setOrganizationId(excelAdjustReqDto.getOrganizationId());
            giftBalanceEo = (GiftBalanceEo)this.giftBalanceDas.selectOne((BaseEo)giftBalanceEo);
            if (giftBalanceEo == null) {
                errorList.add(this.excelAdjustErrorMsg(vo, "\u5ba2\u6237\u7f16\u53f7\u9519\u8bef"));
                continue;
            }
            if (StringUtils.isBlank((CharSequence)vo.getAmount())) {
                errorList.add(this.excelAdjustErrorMsg(vo, "\u514d\u8d39\u8d60\u54c1\u989d\u5ea6\u9519\u8bef"));
                continue;
            }
            if (!NumberUtil.isNumber((CharSequence)vo.getAmount())) {
                errorList.add(this.excelAdjustErrorMsg(vo, "\u514d\u8d39\u8d60\u54c1\u989d\u5ea6\u5fc5\u987b\u4e3a\u6570\u5b57"));
                continue;
            }
            BigDecimal giftBalance = new BigDecimal(vo.getAmount());
            if (giftBalance.compareTo(BigDecimal.ZERO) == 0) {
                errorList.add(this.excelAdjustErrorMsg(vo, "\u514d\u8d39\u8d60\u54c1\u989d\u5ea6\u4e0d\u80fd\u4e3a0"));
                continue;
            }
            if (giftBalance.stripTrailingZeros().scale() > 2) {
                errorList.add(this.excelAdjustErrorMsg(vo, "\u514d\u8d39\u8d60\u54c1\u989d\u5ea6\u4e0d\u80fd\u5927\u4e8e\u4e24\u4f4d\u5c0f\u6570"));
                continue;
            }
            if (StringUtils.isBlank((CharSequence)errorMsg)) {
                Integer adjustType = 1;
                if (giftBalance.compareTo(BigDecimal.ZERO) < 0) {
                    adjustType = 2;
                }
                AdjustGiftBalanceReqDto adjustGiftBalanceReqDto = new AdjustGiftBalanceReqDto();
                adjustGiftBalanceReqDto.setAdjustAmount(giftBalance.abs());
                adjustGiftBalanceReqDto.setAdjustType(adjustType);
                adjustGiftBalanceReqDto.setId(giftBalanceEo.getId());
                adjustGiftBalanceReqDto.setCustomerCode(giftBalanceEo.getCustomerCode());
                this.adjustGiftBalance(adjustGiftBalanceReqDto);
                successList.add(vo);
                continue;
            }
            errorList.add(this.excelAdjustErrorMsg(vo, errorMsg.toString()));
        }
        if (CollectionUtils.isNotEmpty((Collection)errorList)) {
            respDto.setFailNum(Integer.valueOf(errorList.size()));
            String excelName = "cube/\u514d\u8d39\u8d60\u54c1\u989d\u5ea6\u8c03\u6574\u5bfc\u5165\u9519\u8bef\u4fe1\u606f-" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss");
            try {
                String exportUrl = EasyPoiExportUtil.getExportUrl((List)errorList, AdjustBalanceVo.class, null, (String)excelName, (String)"xls");
                respDto.setErrorFile(exportUrl);
            }
            catch (Exception e) {
                logger.error("\u514d\u8d39\u8d60\u54c1\u989d\u5ea6\u8c03\u6574\u5bfc\u5165-\u9519\u8bef:{}", (Object)e.toString());
                return new RestResponse("-1", "\u514d\u8d39\u8d60\u54c1\u989d\u5ea6\u8c03\u6574\u5bfc\u5165-\u9519\u8bef:" + e);
            }
        }
        respDto.setNum(Integer.valueOf(adjustBalanceVos.size()));
        respDto.setSuccessNum(Integer.valueOf(successList.size()));
        return new RestResponse((Object)respDto);
    }

    public static void main(String[] args) {
        System.out.println(!NumberUtil.isNumber((CharSequence)"-10"));
    }

    private AdjustBalanceVo excelAdjustErrorMsg(AdjustBalanceVo vo, String errorMsg) {
        vo.setErrorMsg(errorMsg);
        return vo;
    }
}

