/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.rebate.biz.gift.service.impl;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.bean.ObjectHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.mj.biz.commons.utils.EasyPoiExportUtil;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemBusTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.BrandRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemOnShelfRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IBrandQueryApi;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.constant.GiftConfigTypeEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.constant.GiftExcludeEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.GiftConfigBaseReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.GiftConfigExcludeReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.ItemSkuListQueryReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.response.balance.GiftBalanceExcelRespDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.response.balance.GiftConfigBaseRespDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.response.balance.ItemSkuListRespDto;
import com.dtyunxi.yundt.cube.center.rebate.biz.gift.service.IGiftConfigService;
import com.dtyunxi.yundt.cube.center.rebate.biz.gift.utils.OrganizationUtils;
import com.dtyunxi.yundt.cube.center.rebate.biz.gift.vo.GiftConfigExcludeItemImportExportVo;
import com.dtyunxi.yundt.cube.center.rebate.dao.eo.gift.GiftConfigEo;
import com.dtyunxi.yundt.cube.center.rebate.dao.eo.gift.GiftConfigItemExcludeEo;
import com.dtyunxi.yundt.cube.center.rebate.dao.eo.gift.StdGiftConfigItemExcludeEo;
import com.dtyunxi.yundt.cube.center.rebate.dao.gift.das.GiftConfigDas;
import com.dtyunxi.yundt.cube.center.rebate.dao.gift.das.GiftConfigItemExcludeDas;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopExtQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.api.dto.request.ItemSkuExcludeReqDto;
import com.yx.tcbj.center.api.query.IItemCenterQueryApi;
import com.yx.tcbj.center.api.query.IItemExtQueryApi;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class GiftConfigServiceImpl
implements IGiftConfigService {
    private static final Logger logger = LoggerFactory.getLogger(GiftConfigServiceImpl.class);
    @Resource
    private GiftConfigDas giftConfigDas;
    @Resource
    private GiftConfigItemExcludeDas giftConfigItemExcludeDas;
    @Resource
    private OrganizationUtils organizationUtils;
    @Resource
    private IContext context;
    @Resource
    private IItemCenterQueryApi itemCenterQueryApi;
    @Autowired
    private IBrandQueryApi brandQueryApi;
    @Autowired
    private IShopQueryApi shopQueryApi;
    @Autowired
    private IShopExtQueryApi shopExtQueryApi;
    @Resource
    private IItemExtQueryApi itemExtQueryApi;

    @Override
    public void addBase(GiftConfigBaseReqDto baseReqDto) {
        logger.info("\u65b0\u589e\u514d\u8d39\u8d60\u54c1\u914d\u7f6e {}", (Object)baseReqDto);
        GiftConfigEo giftConfigEo = new GiftConfigEo();
        giftConfigEo.setOrganizationId(this.organizationUtils.getCurUserOrgId());
        GiftConfigEo oldGiftConfigEo = (GiftConfigEo)this.giftConfigDas.selectOne((BaseEo)giftConfigEo);
        if (oldGiftConfigEo != null) {
            giftConfigEo.setId(oldGiftConfigEo.getId());
        } else {
            giftConfigEo.setId(baseReqDto.getId());
        }
        giftConfigEo.setType(baseReqDto.getConfigTypeEnum().getCode());
        giftConfigEo.setRebateRanges(StringUtils.join((Iterable)baseReqDto.getRebateRangeList(), (String)"\uff0c"));
        OrganizationDto organizationDto = this.organizationUtils.getCurUserOrg();
        if (organizationDto != null) {
            giftConfigEo.setOrganizationId(organizationDto.getId());
        }
        if (giftConfigEo.getId() != null) {
            this.giftConfigDas.update((BaseEo)giftConfigEo);
            return;
        }
        this.giftConfigDas.insert((BaseEo)giftConfigEo);
    }

    @Override
    public GiftConfigBaseRespDto queryBase() {
        logger.info("\u67e5\u8be2\u514d\u8d39\u8d60\u54c1\u914d\u7f6e ");
        GiftConfigBaseRespDto baseRespDto = new GiftConfigBaseRespDto();
        GiftConfigEo giftConfigEo = new GiftConfigEo();
        giftConfigEo.setOrganizationId(this.organizationUtils.getCurUserOrgId());
        GiftConfigEo oldGiftConfigEo = (GiftConfigEo)this.giftConfigDas.selectOne((BaseEo)giftConfigEo);
        if (oldGiftConfigEo != null) {
            baseRespDto.setGiftConfigTypeEnum(GiftConfigTypeEnum.fromCode((String)oldGiftConfigEo.getType()));
            baseRespDto.setRebateRangeList(Arrays.asList(oldGiftConfigEo.getRebateRanges().split(",")));
        }
        return baseRespDto;
    }

    @Override
    public void exclude(GiftConfigExcludeReqDto excludeReqDto) {
        logger.info("\u5546\u54c1\u6392\u9664 {}", (Object)excludeReqDto);
        GiftConfigItemExcludeEo giftConfigItemExcludeEo = new GiftConfigItemExcludeEo();
        giftConfigItemExcludeEo.setSkuId(excludeReqDto.getSkuId());
        giftConfigItemExcludeEo.setOrganizationId(this.organizationUtils.getCurUserOrgId());
        if (excludeReqDto.getAction().equals(0)) {
            this.giftConfigItemExcludeDas.deleteByExample((BaseEo)giftConfigItemExcludeEo);
        } else {
            this.giftConfigItemExcludeDas.insert((BaseEo)giftConfigItemExcludeEo);
        }
    }

    @Override
    public void batchExclude(List<GiftConfigExcludeReqDto> excludeReqDtoList) {
        if (CollectionUtils.isEmpty(excludeReqDtoList)) {
            throw new BizException("\u5546\u54c1\u4fe1\u606f\u4e3a\u7a7a\uff0c\u5904\u7406\u5931\u8d25\uff0c\u8bf7\u9009\u62e9\u5546\u54c1");
        }
        for (GiftConfigExcludeReqDto excludeReqDto : excludeReqDtoList) {
            if (excludeReqDto.getSkuId() == null) {
                throw new BizException("\u64cd\u4f5c\u5931\u8d25\uff0cSKU ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            this.exclude(excludeReqDto);
        }
    }

    @Override
    public PageInfo<ItemSkuListRespDto> getSkuList(ItemSkuListQueryReqDto itemSkuListQueryReqDto, Integer pageNum, Integer pageSize) {
        RestResponse pageInfoRestResponse;
        PageInfo itemOnShelfRespDtoPageInfo;
        logger.info("\u5546\u54c1\u6392\u9664\u5217\u8868 {}, {} , {} ", new Object[]{JSONObject.toJSONString((Object)itemSkuListQueryReqDto), pageNum, pageNum});
        ItemSkuExcludeReqDto itemSkuExcludeReqDto = new ItemSkuExcludeReqDto();
        ArrayList<Long> ids = new ArrayList<Long>();
        if (null != itemSkuListQueryReqDto.getDirId()) {
            ids.add(itemSkuListQueryReqDto.getDirId());
        }
        ArrayList<Long> backDirIds = new ArrayList<Long>();
        if (null != itemSkuListQueryReqDto.getBackDirId()) {
            backDirIds.add(itemSkuListQueryReqDto.getBackDirId());
        }
        itemSkuExcludeReqDto.setOutSkuIds(itemSkuListQueryReqDto.getOutSkuIds());
        itemSkuExcludeReqDto.setDirIds(ids);
        itemSkuExcludeReqDto.setBackDirIds(backDirIds);
        itemSkuExcludeReqDto.setInstanceId(this.context.instanceId());
        itemSkuExcludeReqDto.setPageNum(pageNum);
        itemSkuExcludeReqDto.setPageSize(pageSize);
        itemSkuExcludeReqDto.setSkuCode(itemSkuListQueryReqDto.getSkuCode());
        itemSkuExcludeReqDto.setItemCode(itemSkuListQueryReqDto.getItemCode());
        itemSkuExcludeReqDto.setItemCodes(itemSkuListQueryReqDto.getItemCodes());
        itemSkuExcludeReqDto.setItemName(itemSkuListQueryReqDto.getItemName());
        itemSkuExcludeReqDto.setTenantId(this.context.tenantId());
        itemSkuExcludeReqDto.setShopId(itemSkuListQueryReqDto.getShopId());
        itemSkuExcludeReqDto.setOrgId(this.organizationUtils.getCurUserOrgId());
        itemSkuExcludeReqDto.setBrandId(StringUtils.isNumeric((CharSequence)itemSkuListQueryReqDto.getBrandId()) ? Long.valueOf(itemSkuListQueryReqDto.getBrandId()) : null);
        if (null != itemSkuListQueryReqDto.getBusType()) {
            itemSkuExcludeReqDto.setBusType(itemSkuListQueryReqDto.getBusType());
        } else {
            itemSkuExcludeReqDto.setBusType(ItemBusTypeEnum.ORDINARY.getType());
        }
        List<Long> excludeSkuIds = this.getItemExcludeSkuIds();
        if (itemSkuListQueryReqDto.getGiftExclude() != null) {
            if (itemSkuListQueryReqDto.getGiftExclude() == 0) {
                itemSkuExcludeReqDto.setOutSkuIds(excludeSkuIds);
            } else if (itemSkuListQueryReqDto.getGiftExclude() == 1) {
                if (CollectionUtils.isEmpty(excludeSkuIds)) {
                    return new PageInfo();
                }
                itemSkuExcludeReqDto.setSkuIds(excludeSkuIds);
            }
        }
        if (Objects.isNull(itemOnShelfRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)(pageInfoRestResponse = this.itemCenterQueryApi.findItemSkuExclude(itemSkuExcludeReqDto)))) || CollectionUtils.isEmpty((Collection)itemOnShelfRespDtoPageInfo.getList())) {
            return new PageInfo();
        }
        Set brandIds = itemOnShelfRespDtoPageInfo.getList().stream().map(ItemOnShelfRespDto::getBrandId).filter(Objects::nonNull).collect(Collectors.toSet());
        List brandRespDtos = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(brandIds)) {
            brandRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.brandQueryApi.queryByIds(StringUtils.join(brandIds, (String)",")));
        }
        Map<Long, BrandRespDto> brandMap = brandRespDtos.stream().collect(Collectors.toMap(e -> e.getId(), e -> e, (e1, e2) -> e1));
        List itemSkuListRespDtos = itemOnShelfRespDtoPageInfo.getList().stream().map(bean -> {
            ItemSkuListRespDto itemSkuListRespDto = new ItemSkuListRespDto();
            BeanUtils.copyProperties((Object)bean, (Object)itemSkuListRespDto);
            itemSkuListRespDto.setId(null);
            itemSkuListRespDto.setItemNum(Long.valueOf(Objects.nonNull(itemSkuListRespDto.getWholesaleLimitMin()) ? itemSkuListRespDto.getWholesaleLimitMin() : 1L));
            Map skuAttr = (Map)ObjectHelper.Json2Bean((String)itemSkuListRespDto.getAttr(), Map.class);
            if (null != skuAttr) {
                String skuDesc = StringUtils.join(skuAttr.values(), (String)" ");
                itemSkuListRespDto.setSkuName(skuDesc);
            } else {
                itemSkuListRespDto.setSkuName("");
            }
            if (excludeSkuIds.contains(bean.getSkuId())) {
                itemSkuListRespDto.setGiftExclude(GiftExcludeEnum.EXCLUDE.getCode());
            }
            if (brandMap.containsKey(bean.getBrandId())) {
                BrandRespDto brandRespDto = (BrandRespDto)brandMap.get(bean.getBrandId());
                itemSkuListRespDto.setBrandName(brandRespDto.getName());
            }
            if (!"1".equals(itemSkuListRespDto.getSubType())) {
                itemSkuListRespDto.setGiftExclude(GiftExcludeEnum.EXCLUDE.getCode());
            }
            return itemSkuListRespDto;
        }).collect(Collectors.toList());
        PageInfo result = new PageInfo();
        CubeBeanUtils.copyProperties((Object)result, (Object)itemOnShelfRespDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        result.setList(itemSkuListRespDtos);
        return result;
    }

    @Override
    public List<ItemSkuListRespDto> getSkuListByCustomerId(ItemSkuListQueryReqDto itemSkuListQueryReqDto) {
        PageInfo<ItemSkuListRespDto> page = this.getSkuList(itemSkuListQueryReqDto, 0, Integer.MAX_VALUE);
        List<ItemSkuListRespDto> list = page.getList().stream().filter(itemSkuListRespDto -> GiftExcludeEnum.EXCLUDE.getCode().equals(itemSkuListRespDto.getGiftExclude())).collect(Collectors.toList());
        return list;
    }

    @Override
    public GiftConfigBaseRespDto queryByOrganizationId(Long organizationId) {
        GiftConfigBaseRespDto baseRespDto = new GiftConfigBaseRespDto();
        GiftConfigEo giftConfigEo = new GiftConfigEo();
        giftConfigEo.setOrganizationId(organizationId);
        GiftConfigEo oldGiftConfigEo = (GiftConfigEo)this.giftConfigDas.selectOne((BaseEo)giftConfigEo);
        if (oldGiftConfigEo != null) {
            baseRespDto.setGiftConfigTypeEnum(GiftConfigTypeEnum.fromCode((String)oldGiftConfigEo.getType()));
            baseRespDto.setRebateRangeList(Arrays.asList(oldGiftConfigEo.getRebateRanges().split(",")));
        }
        return baseRespDto;
    }

    @Override
    public Set<Long> getExcludeSkuList(List<Long> skuList, Long orgId) {
        if (orgId == null || CollectionUtils.isEmpty(skuList)) {
            return new HashSet<Long>();
        }
        GiftConfigItemExcludeEo giftConfigItemExcludeEo = new GiftConfigItemExcludeEo();
        giftConfigItemExcludeEo.setOrganizationId(orgId);
        ArrayList sqlFilters = Lists.newArrayList();
        sqlFilters.add(SqlFilter.in((String)"sku_id", skuList));
        giftConfigItemExcludeEo.setSqlFilters((List)sqlFilters);
        List itemExcludeList = this.giftConfigItemExcludeDas.select((BaseEo)giftConfigItemExcludeEo);
        Set<Long> res = itemExcludeList.stream().map(StdGiftConfigItemExcludeEo::getSkuId).collect(Collectors.toSet());
        return res;
    }

    private List<Long> getItemExcludeSkuIds() {
        GiftConfigItemExcludeEo giftConfigItemExcludeEo = new GiftConfigItemExcludeEo();
        giftConfigItemExcludeEo.setOrganizationId(this.organizationUtils.getCurUserOrgId());
        List itemExcludeList = this.giftConfigItemExcludeDas.select((BaseEo)giftConfigItemExcludeEo);
        ArrayList<Long> excludeSkuIds = new ArrayList<Long>();
        if (CollectionUtils.isNotEmpty((Collection)itemExcludeList)) {
            for (GiftConfigItemExcludeEo c : itemExcludeList) {
                excludeSkuIds.add(c.getSkuId());
            }
        }
        return excludeSkuIds;
    }

    @Override
    public RestResponse<GiftBalanceExcelRespDto> excel(MultipartFile file) {
        GiftBalanceExcelRespDto respDto = new GiftBalanceExcelRespDto();
        respDto.setNum(Integer.valueOf(0));
        respDto.setSuccessNum(Integer.valueOf(0));
        respDto.setFailNum(Integer.valueOf(0));
        ImportParams importParams = new ImportParams();
        importParams.setHeadRows(1);
        importParams.setTitleRows(0);
        List giftImportVoList = Lists.newArrayList();
        try {
            ExcelImportResult result = ExcelImportUtil.importExcelMore((InputStream)file.getInputStream(), GiftConfigExcludeItemImportExportVo.class, (ImportParams)importParams);
            giftImportVoList = result.getList();
            if (CollectionUtils.isEmpty((Collection)giftImportVoList)) {
                throw new BizException("\u65e0\u6cd5\u8bfb\u53d6Excel\u5185\u5bb9\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u590d\u5408\u6a21\u677f\u683c\u5f0f\u8981\u6c42\u3002");
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw new BizException("\u65e0\u6cd5\u8bfb\u53d6Excel\u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u7c7b\u578b");
        }
        ArrayList<GiftConfigItemExcludeEo> successList = new ArrayList<GiftConfigItemExcludeEo>();
        ArrayList<GiftConfigExcludeItemImportExportVo> failList = new ArrayList<GiftConfigExcludeItemImportExportVo>();
        ItemSkuListQueryReqDto itemSkuListQueryReqDto = new ItemSkuListQueryReqDto();
        itemSkuListQueryReqDto.setGiftExclude(GiftExcludeEnum.ALL.getCode());
        PageInfo<ItemSkuListRespDto> itemSkuPages = this.getSkuList(itemSkuListQueryReqDto, 1, 10000);
        Map<String, ItemSkuListRespDto> itemSkuMaps = itemSkuPages.getList().stream().collect(Collectors.toMap(ItemSkuListRespDto::getItemCode, e -> e));
        HashSet<String> itemCodeSet = new HashSet<String>();
        Long curOrgId = this.organizationUtils.getCurUserOrgId();
        for (GiftConfigExcludeItemImportExportVo item : giftImportVoList) {
            if (StringUtils.isNotBlank((CharSequence)item.getErrorMsg())) {
                item.setErrorMsg(null);
            }
            if (StringUtils.isBlank((CharSequence)item.getItemCode())) {
                item.setErrorMsg("\u5546\u54c1\u7f16\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            } else if (itemCodeSet.contains(item.getItemCode())) {
                item.setErrorMsg("\u5546\u54c1\u7f16\u7801\u4e0e\u5176\u4ed6\u884c\u91cd\u590d\uff0c\u5df2\u81ea\u52a8\u5ffd\u7565\u8fc7\u6ee4");
            } else {
                itemCodeSet.add(item.getItemCode());
                if (itemSkuMaps.get(item.getItemCode()) != null) {
                    ItemSkuListRespDto itemSkuListRespDto = itemSkuMaps.get(item.getItemCode());
                    if (GiftExcludeEnum.EXCLUDE.getCode().equals(itemSkuListRespDto.getGiftExclude())) {
                        item.setErrorMsg("\u8be5\u5546\u54c1\u7f16\u7801\u7684\u5546\u54c1\u5df2\u6392\u9664\uff0c\u4e0d\u9700\u91cd\u590d\u6392\u9664\uff0c\u5df2\u81ea\u52a8\u5ffd\u7565\u8fc7\u6ee4");
                    } else {
                        GiftConfigItemExcludeEo giftConfigItemExcludeEo = new GiftConfigItemExcludeEo();
                        giftConfigItemExcludeEo.setSkuId(itemSkuListRespDto.getSkuId());
                        giftConfigItemExcludeEo.setOrganizationId(curOrgId);
                        successList.add(giftConfigItemExcludeEo);
                    }
                } else {
                    item.setErrorMsg("\u5546\u54c1\u7f16\u7801\u4e0d\u5b58\u5728\u6216\u5546\u54c1\u672a\u4e0a\u67b6\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u8fdb\u884c\u6392\u9664");
                }
            }
            if (!StringUtils.isNotBlank((CharSequence)item.getErrorMsg())) continue;
            failList.add(item);
        }
        if (CollectionUtils.isNotEmpty(successList)) {
            this.giftConfigItemExcludeDas.insertBatch(successList);
        }
        respDto.setFailNum(Integer.valueOf(failList.size()));
        if (CollectionUtils.isNotEmpty(failList)) {
            String excelName = "cube/\u5546\u54c1\u6392\u9664\u914d\u7f6e\u4fe1\u606f-\u5546\u54c1\u6392\u9664\u5931\u8d25\u660e\u7ec6Excel-" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss");
            try {
                String exportUrl = EasyPoiExportUtil.getExportUrl(failList, GiftConfigExcludeItemImportExportVo.class, null, (String)excelName, (String)"xlsx");
                respDto.setErrorFile(exportUrl);
            }
            catch (Exception e3) {
                logger.error("\u5bfc\u51fa\u5546\u54c1\u8be6\u60c5-\u9519\u8bef:{}", (Object)e3.toString());
                return new RestResponse("-1", "\u5bfc\u51fa\u5546\u54c1\u8be6\u60c5-\u9519\u8bef:" + e3);
            }
        }
        respDto.setNum(Integer.valueOf(giftImportVoList.size()));
        respDto.setSuccessNum(Integer.valueOf(successList.size()));
        return new RestResponse((Object)respDto);
    }
}

