package com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.request.CommanderAppletConfigCreateReqDto;
import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.request.CommanderAppletConfigUpdateReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

/**
 * 团长小程序参数配置Api
 * @author 周颠
 * @since 1.0.0
 */
@Api(tags = {"会员中心：团长小程序参数配置"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-biz-member-api-commander-ICommanderAppletConfigApi",
        name = "${bundle.commander.center.member.api.name:yundt-cube-center-member}", path = "/v1/commander-applet-config", url = "${bundle.commander.center.member.api:}")
public interface ICommanderAppletConfigApi {

    /**
     * 新增团长小程序参数配置
     * @param createReqDto
     * @return
     */
    @PostMapping
    @ApiOperation(value = "新增团长小程序参数配置", notes = "新增团长小程序参数配置")
    RestResponse<Long> addCommanderAppletConfig(@RequestBody @Valid CommanderAppletConfigCreateReqDto createReqDto);

    /**
     * 编辑团长小程序参数配置
     * @param id
     * @param updateReqDto
     * @return
     */
    @PutMapping("/{id}")
    @ApiOperation(value = "编辑团长小程序参数配置", notes = "编辑团长小程序参数配置")
    RestResponse<Void> modifyCommanderAppletConfig(@PathVariable("id") Long id, @RequestBody @Valid CommanderAppletConfigUpdateReqDto updateReqDto);

    /**
     * 删除团长小程序参数配置
     * @param id
     * @return
     */
    @DeleteMapping("/{id}")
    @ApiOperation(value = "删除团长小程序参数配置", notes = "删除团长小程序参数配置")
    RestResponse<Void> deleteCommanderAppletConfig(@PathVariable("id") Long id);
}