package com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.request.CommanderCycleRecordCreateReqDto;
import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.request.CommanderCycleRecordUpdateReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

/**
 * 团长周期数据统计记录Api
 * @author 周颠
 * @since 1.0.0
 */
@Api(tags = {"会员中心：团长周期数据统计记录"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-biz-member-api-commander-ICommanderCycleRecordApi",
        name = "${bundle.commander.center.member.api.name:yundt-cube-center-member}", path = "/v1/commander-cycle-record", url = "${bundle.commander.center.member.api:}")
public interface ICommanderCycleRecordApi {

    /**
     * 新增团长周期数据统计记录
     * @param createReqDto
     * @return
     */
    @PostMapping
    @ApiOperation(value = "新增团长周期数据统计记录", notes = "新增团长周期数据统计记录")
    RestResponse<Long> addCommanderCycleRecord(@RequestBody @Valid CommanderCycleRecordCreateReqDto createReqDto);

    /**
     * 编辑团长周期数据统计记录
     * @param id
     * @param updateReqDto
     * @return
     */
    @PutMapping("/{id}")
    @ApiOperation(value = "编辑团长周期数据统计记录", notes = "编辑团长周期数据统计记录")
    RestResponse<Void> modifyCommanderCycleRecord(@PathVariable("id") Long id, @RequestBody @Valid CommanderCycleRecordUpdateReqDto updateReqDto);

    /**
     * 删除团长周期数据统计记录
     * @param id
     * @return
     */
    @DeleteMapping("/{id}")
    @ApiOperation(value = "删除团长周期数据统计记录", notes = "删除团长周期数据统计记录")
    RestResponse<Void> deleteCommanderCycleRecord(@PathVariable("id") Long id);

    @PostMapping("/repairStatisticsDataByCommanderId")
    @ApiOperation(value = "修复周期数据统计记录", notes = "修复周期数据统计记录")
    RestResponse<Void> repairStatisticsDataByCommanderId(@RequestParam Long commanderId);
}