package com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.request.CommanderInfoCreateReqDto;
import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.request.CommanderInfoUpdateReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

/**
 * 团长信息Api
 * @author 周颠
 * @since 1.0.0
 */
@Api(tags = {"会员中心：团长信息"})
@FeignClient(contextId="com-dtyunxi-yundt-imkt-cube-bundle-commander-center-member-api-ICommanderInfoApi",
        name = "${bundle.commander.center.member.api.name:yundt-cube-center-member}", path = "/v1/commander-info", url = "${bundle.commander.center.member.api:}")
public interface ICommanderInfoApi {

    /**
     * 新增团长信息
     * @param createReqDto
     * @return
     */
    @Capability(capabilityCode = "member.commander.commander-info")
    @PostMapping
    @ApiOperation(value = "新增团长信息", notes = "新增团长信息")
    RestResponse<Long> addCommanderInfo(@RequestBody @Valid CommanderInfoCreateReqDto createReqDto);

    /**
     * 编辑团长信息
     * @param id
     * @param updateReqDto
     * @return
     */
    @Capability(capabilityCode = "member.commander.commander-info")
    @PutMapping("/{id}")
    @ApiOperation(value = "编辑团长信息", notes = "编辑团长信息")
    RestResponse<Void> modifyCommanderInfo(@PathVariable("id") Long id, @RequestBody @Valid CommanderInfoUpdateReqDto updateReqDto);

    /**
     * 删除团长信息
     * @param id
     * @return
     */
    @Capability(capabilityCode = "member.commander.commander-info")
    @DeleteMapping("/{id}")
    @ApiOperation(value = "删除团长信息", notes = "删除团长信息")
    RestResponse<Void> deleteCommanderInfo(@PathVariable("id") Long id);

    /**
     * 批量修改分销类型
     * @return
     */
    @Capability(capabilityCode = "member.commander.commander-info")
    @PostMapping("/modifyCommanderType")
    @ApiOperation(value = "批量修改分销类型", notes = "批量修改分销类型")
    RestResponse modifyCommanderType(@RequestBody CommanderInfoUpdateReqDto updateReqDto);


    /**
     * 批量修改分销类型
     * @return
     */
    @Capability(capabilityCode = "member.commander.commander-info")
    @PostMapping("/test/initData")
    @ApiOperation(value = "测试初始化数据", notes = "测试初始化数据")
    RestResponse test(@RequestBody List<Long> commanderIds);
}