package com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.request.CommanderOrderGoodsRecordCreateReqDto;
import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.request.CommanderOrderGoodsRecordUpdateReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

/**
 * 团长订单商品信息记录Api
 * @author 周颠
 * @since 1.0.0
 */
@Api(tags = {"会员中心：团长订单商品信息记录"})
@FeignClient(contextId="com-dtyunxi-yundt-imkt-cube-bundle-commander-center-member-api-ICommanderOrderGoodsRecordApi",
        name = "${bundle.commander.center.member.api.name:yundt-cube-center-member}", path = "/v1/commander-order-goods-record", url = "${bundle.commander.center.member.api:}")
public interface ICommanderOrderGoodsRecordApi {

    /**
     * 新增团长订单商品信息记录
     * @param createReqDto
     * @return
     */
    @Capability(capabilityCode = "member.commander.commander-order-goods-record")
    @PostMapping
    @ApiOperation(value = "新增团长订单商品信息记录", notes = "新增团长订单商品信息记录")
    RestResponse<Long> addCommanderOrderGoodsRecord(@RequestBody @Valid CommanderOrderGoodsRecordCreateReqDto createReqDto);

    /**
     * 编辑团长订单商品信息记录
     * @param id
     * @param updateReqDto
     * @return
     */
    @Capability(capabilityCode = "member.commander.commander-order-goods-record")
    @PutMapping("/{id}")
    @ApiOperation(value = "编辑团长订单商品信息记录", notes = "编辑团长订单商品信息记录")
    RestResponse<Void> modifyCommanderOrderGoodsRecord(@PathVariable("id") Long id, @RequestBody @Valid CommanderOrderGoodsRecordUpdateReqDto updateReqDto);

    /**
     * 删除团长订单商品信息记录
     * @param id
     * @return
     */
    @Capability(capabilityCode = "member.commander.commander-order-goods-record")
    @DeleteMapping("/{id}")
    @ApiOperation(value = "删除团长订单商品信息记录", notes = "删除团长订单商品信息记录")
    RestResponse<Void> deleteCommanderOrderGoodsRecord(@PathVariable("id") Long id);
}