package com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.request.CommanderOrderProsessorReqDto;
import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.request.CommanderOrderRecordCreateReqDto;
import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.request.CommanderOrderRecordUpdateReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

/**
 * 团长订单记录Api
 * @author 周颠
 * @since 1.0.0
 */
@Api(tags = {"会员中心：团长订单记录"})
@FeignClient(contextId="com-dtyunxi-yundt-imkt-cube-bundle-commander-center-member-api-ICommanderOrderRecordApi",
        name = "${bundle.commander.center.member.api.name:yundt-cube-center-member}", path = "/v1/commander-order-record", url = "${bundle.commander.center.member.api:}")
public interface ICommanderOrderRecordApi {

    /**
     * 新增团长订单记录
     * @param createReqDto
     * @return
     */
    @Capability(capabilityCode = "member.commander.commander-order-record")
    @PostMapping
    @ApiOperation(value = "新增团长订单记录", notes = "新增团长订单记录")
    RestResponse<Long> addCommanderOrderRecord(@RequestBody @Valid CommanderOrderRecordCreateReqDto createReqDto);

    /**
     * 编辑团长订单记录
     * @param id
     * @param updateReqDto
     * @return
     */
    @Capability(capabilityCode = "member.commander.commander-order-record")
    @PutMapping("/{id}")
    @ApiOperation(value = "编辑团长订单记录", notes = "编辑团长订单记录")
    RestResponse<Void> modifyCommanderOrderRecord(@PathVariable("id") Long id, @RequestBody @Valid CommanderOrderRecordUpdateReqDto updateReqDto);

    /**
     * 删除团长订单记录
     * @param id
     * @return
     */
    @Capability(capabilityCode = "member.commander.commander-order-record")
    @DeleteMapping("/{id}")
    @ApiOperation(value = "删除团长订单记录", notes = "删除团长订单记录")
    RestResponse<Void> deleteCommanderOrderRecord(@PathVariable("id") Long id);

    /**
     * 同步订单测试接口
     * @param reqDto
     * @return
     */
    @Capability(capabilityCode = "member.commander.commander-order-record")
    @PostMapping("/synchronizeOrder")
    @ApiOperation(value = "同步订单测试接口", notes = "同步订单测试接口")
    RestResponse<Void> synchronizeOrder(@RequestBody @Valid CommanderOrderProsessorReqDto reqDto);
}