package com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.request.CommanderOrderRelationReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
 * 分销员（直接间接）客户订单记录服务接口
 *
 * @author erduo
 * @since 2021-05-13
 */
@Api(tags = {"分销员（直接间接）客户订单记录服务"})
@FeignClient(name = "${bundle.commander.center.member.api.name:yundt-cube-center-member}", path = "/v1/commanderOrderRelation", url = "${bundle.commander.center.member.api:}")
public interface ICommanderOrderRelationApi {

    /**
     * 新增分销员（直接间接）客户订单记录
     *
     * @param addReqDto 分销员（直接间接）客户订单记录请求对象
     * @return 处理结果
     */
    @PostMapping("")
    @ApiOperation(value = "新增分销员（直接间接）客户订单记录", notes = "新增分销员（直接间接）客户订单记录")
    RestResponse<Long> addCommanderOrderRelation(@RequestBody CommanderOrderRelationReqDto addReqDto);

    /**
     * 修改分销员（直接间接）客户订单记录
     *
     * @param modifyReqDto 分销员（直接间接）客户订单记录请求对象
     * @return 处理结果
     */
    @PutMapping("")
    @ApiOperation(value = "修改分销员（直接间接）客户订单记录", notes = "修改分销员（直接间接）客户订单记录")
    RestResponse<Void> modifyCommanderOrderRelation(@RequestBody CommanderOrderRelationReqDto modifyReqDto);

    /**
     * 删除分销员（直接间接）客户订单记录
     *
     * @param ids        分销员（直接间接）客户订单记录删除数据ID
     * @param instanceId 实例ID
     * @return 处理结果
     */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除分销员（直接间接）客户订单记录", notes = "删除分销员（直接间接）客户订单记录")
    RestResponse<Void> removeCommanderOrderRelation(@PathVariable("ids") String ids, @RequestParam("instanceId") Long instanceId);
}
